/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import java.io.StringWriter;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.classfile.ConstantPool;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.descriptor.FieldType;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class LocalVariable {
    private ConstantPool constantPool;
    private short startPC;
    private short length;
    private short nameIndex;
    private short descriptorIndex;
    private short index;
    private FieldType fieldDescriptor;

    LocalVariable(ClassFileDataInputStream classFileDataInputStream, ConstantPool constantPool) throws IOException {
        this.constantPool = constantPool;
        this.initialize(classFileDataInputStream);
    }

    void initialize(ClassFileDataInputStream classFileDataInputStream) throws IOException {
        this.startPC = classFileDataInputStream.readU2();
        this.length = classFileDataInputStream.readU2();
        this.nameIndex = classFileDataInputStream.readU2();
        this.descriptorIndex = classFileDataInputStream.readU2();
        this.index = classFileDataInputStream.readU2();
    }

    public String displayString() {
        StringWriter stringWriter = new StringWriter(1000);
        IndentingPrintWriter indentingPrintWriter = new IndentingPrintWriter(stringWriter);
        this.displayStringOn(indentingPrintWriter);
        return stringWriter.toString();
    }

    public void displayStringOn(IndentingPrintWriter indentingPrintWriter) {
        this.getFieldDescriptor().printDeclarationOn(indentingPrintWriter);
        indentingPrintWriter.print(' ');
        indentingPrintWriter.println(this.name());
        indentingPrintWriter.indent();
        indentingPrintWriter.print("PC start: ");
        indentingPrintWriter.print(this.startPC);
        indentingPrintWriter.print(" length: ");
        indentingPrintWriter.println(this.length);
        indentingPrintWriter.undent();
    }

    public boolean isNamed(String string) {
        return this.name().equals(string);
    }

    public String name() {
        return this.constantPool.getUTF8String(this.nameIndex);
    }

    public String descriptor() {
        return this.constantPool.getUTF8String(this.descriptorIndex);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
        this.getFieldDescriptor().accept(visitor);
    }

    public FieldType getFieldDescriptor() {
        if (this.fieldDescriptor == null) {
            this.fieldDescriptor = FieldType.createFieldType(this.descriptor());
        }
        return this.fieldDescriptor;
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public short getStartPC() {
        return this.startPC;
    }

    public short getLength() {
        return this.length;
    }

    public short getNameIndex() {
        return this.nameIndex;
    }

    public short getDescriptorIndex() {
        return this.descriptorIndex;
    }

    public short getIndex() {
        return this.index;
    }

    public String toString() {
        return ClassTools.shortClassNameForObject(this) + '(' + this.name() + ')';
    }
}

