/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import org.eclipse.persistence.tools.workbench.utility.classfile.Attribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.AttributePool;
import org.eclipse.persistence.tools.workbench.utility.classfile.LocalVariableType;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class LocalVariableTypeTableAttribute
extends Attribute {
    private short count;
    private LocalVariableType[] localVariableTypes;

    public LocalVariableTypeTableAttribute(ClassFileDataInputStream classFileDataInputStream, short s, AttributePool attributePool) throws IOException {
        super(classFileDataInputStream, s, attributePool);
    }

    void initializeInfo(ClassFileDataInputStream classFileDataInputStream) throws IOException {
        short s = this.count = classFileDataInputStream.readU2();
        LocalVariableType[] localVariableTypeArray = this.localVariableTypes = new LocalVariableType[s];
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            localVariableTypeArray[s2] = new LocalVariableType(classFileDataInputStream, this.constantPool());
        }
    }

    public void displayNameOn(IndentingPrintWriter indentingPrintWriter) {
        super.displayNameOn(indentingPrintWriter);
        indentingPrintWriter.print(" (count: ");
        indentingPrintWriter.print(this.count);
        indentingPrintWriter.print(")");
    }

    void displayInfoStringOn(IndentingPrintWriter indentingPrintWriter) {
        short s = this.count;
        LocalVariableType[] localVariableTypeArray = this.localVariableTypes;
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            indentingPrintWriter.print(s2);
            indentingPrintWriter.print(": ");
            localVariableTypeArray[s2].displayStringOn(indentingPrintWriter);
        }
    }

    public String localVariableTypeName(short s) {
        return this.localVariableTypes[s].name();
    }

    public LocalVariableType localVariableTypeNamed(String string) {
        short s = this.count;
        LocalVariableType[] localVariableTypeArray = this.localVariableTypes;
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            LocalVariableType localVariableType = localVariableTypeArray[s2];
            if (!localVariableType.isNamed(string)) continue;
            return localVariableType;
        }
        return null;
    }

    public String[] localVariableTypeNames() {
        short s = this.count;
        if (s == 0) {
            return EMPTY_STRING_ARRAY;
        }
        String[] stringArray = new String[s];
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            stringArray[s2] = this.localVariableTypeName(s2);
        }
        return stringArray;
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
        short s = this.count;
        LocalVariableType[] localVariableTypeArray = this.localVariableTypes;
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            localVariableTypeArray[s2].accept(visitor);
        }
    }

    public short getCount() {
        return this.count;
    }

    public LocalVariableType[] getLocalVariableTypes() {
        return this.localVariableTypes;
    }

    public LocalVariableType getLocalVariableType(short s) {
        return this.localVariableTypes[s];
    }

    void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.count);
        stringBuffer.append(" local variable type(s)");
    }
}

