/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import java.io.PrintWriter;
import org.eclipse.persistence.tools.workbench.utility.classfile.Constant;
import org.eclipse.persistence.tools.workbench.utility.classfile.ConstantPool;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class StringConstant
extends Constant {
    private short stringIndex;

    StringConstant(ConstantPool constantPool, byte by, ClassFileDataInputStream classFileDataInputStream) throws IOException {
        super(constantPool, by, classFileDataInputStream);
    }

    void initialize(ClassFileDataInputStream classFileDataInputStream) throws IOException {
        this.stringIndex = classFileDataInputStream.readU2();
    }

    public void displayStringOn(IndentingPrintWriter indentingPrintWriter) {
        super.displayStringOn(indentingPrintWriter);
        indentingPrintWriter.print(" string: ");
        indentingPrintWriter.println(this.string());
    }

    public String description() {
        return "String";
    }

    public void printFieldInitializationClauseOn(PrintWriter printWriter) {
        printWriter.print('\"');
        printWriter.print(this.string());
        printWriter.print('\"');
    }

    public String string() {
        return this.utf8String(this.stringIndex);
    }

    public short getStringIndex() {
        return this.stringIndex;
    }

    public Object value() {
        return this.string();
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

