/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.diff;

import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.persistence.tools.workbench.utility.diff.Diff;
import org.eclipse.persistence.tools.workbench.utility.diff.Differentiator;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class CompositeDiff
implements Diff {
    private final Object object1;
    private final Object object2;
    private final Diff[] diffs;
    private final Differentiator differentiator;

    public CompositeDiff(Object object, Object object2, Diff[] diffArray, Differentiator differentiator) {
        this.object1 = object;
        this.object2 = object2;
        this.diffs = diffArray;
        this.differentiator = differentiator;
    }

    public Object getObject1() {
        return this.object1;
    }

    public Object getObject2() {
        return this.object2;
    }

    public boolean identical() {
        return !this.different();
    }

    public boolean different() {
        int n = this.diffs.length;
        while (n-- > 0) {
            if (!this.diffs[n].different()) continue;
            return true;
        }
        return false;
    }

    public Differentiator getDifferentiator() {
        return this.differentiator;
    }

    public String getDescription() {
        if (this.identical()) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        IndentingPrintWriter indentingPrintWriter = new IndentingPrintWriter((Writer)stringWriter, "    ");
        this.appendHeader(indentingPrintWriter);
        indentingPrintWriter.indent();
        this.appendDescription(indentingPrintWriter);
        indentingPrintWriter.undent();
        return ((Object)stringWriter).toString();
    }

    protected void appendHeader(IndentingPrintWriter indentingPrintWriter) {
        indentingPrintWriter.print("Objects are different:");
        indentingPrintWriter.println();
        indentingPrintWriter.print("object 1: ");
        indentingPrintWriter.print(this.object1);
        indentingPrintWriter.println();
        indentingPrintWriter.print("object 2: ");
        indentingPrintWriter.print(this.object2);
        indentingPrintWriter.println();
    }

    public void appendDescription(IndentingPrintWriter indentingPrintWriter) {
        int n = this.diffs.length;
        for (int i = 0; i < n; ++i) {
            this.diffs[i].appendDescription(indentingPrintWriter);
        }
    }

    public Diff[] getDiffs() {
        return this.diffs;
    }

    public Diff getDiff(int n) {
        return this.diffs[n];
    }

    public String toString() {
        return this.identical() ? "<no difference>" : this.getDescription();
    }
}

