/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.diff;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.Counter;
import org.eclipse.persistence.tools.workbench.utility.diff.CollectionAdapter;
import org.eclipse.persistence.tools.workbench.utility.diff.ContainerDiff;
import org.eclipse.persistence.tools.workbench.utility.diff.Diff;
import org.eclipse.persistence.tools.workbench.utility.diff.Differentiator;
import org.eclipse.persistence.tools.workbench.utility.diff.EqualityDifferentiator;
import org.eclipse.persistence.tools.workbench.utility.diff.MapAdapter;
import org.eclipse.persistence.tools.workbench.utility.diff.MapEntryDifferentiator;
import org.eclipse.persistence.tools.workbench.utility.diff.NullDiff;
import org.eclipse.persistence.tools.workbench.utility.diff.SimpleDiff;
import org.eclipse.persistence.tools.workbench.utility.diff.UnorderedArrayAdapter;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class ContainerDifferentiator
implements Differentiator {
    private Adapter adapter;
    private Differentiator elementDifferentiator;

    public static ContainerDifferentiator forCollections() {
        return new ContainerDifferentiator(CollectionAdapter.instance());
    }

    public static ContainerDifferentiator forCollections(Differentiator differentiator) {
        return new ContainerDifferentiator(CollectionAdapter.instance(), differentiator);
    }

    public static ContainerDifferentiator forArrays() {
        return new ContainerDifferentiator(UnorderedArrayAdapter.instance());
    }

    public static ContainerDifferentiator forArrays(Differentiator differentiator) {
        return new ContainerDifferentiator(UnorderedArrayAdapter.instance(), differentiator);
    }

    public static ContainerDifferentiator forMaps() {
        return new ContainerDifferentiator(MapAdapter.instance(), new MapEntryDifferentiator());
    }

    public static ContainerDifferentiator forMaps(Differentiator differentiator, Differentiator differentiator2) {
        return new ContainerDifferentiator(MapAdapter.instance(), new MapEntryDifferentiator(differentiator, differentiator2));
    }

    public static ContainerDifferentiator forMaps(Differentiator differentiator) {
        return new ContainerDifferentiator(MapAdapter.instance(), differentiator);
    }

    public ContainerDifferentiator() {
        this(Adapter.INVALID_INSTANCE);
    }

    public ContainerDifferentiator(Differentiator differentiator) {
        this(Adapter.INVALID_INSTANCE, differentiator);
    }

    public ContainerDifferentiator(Adapter adapter) {
        this(adapter, EqualityDifferentiator.instance());
    }

    public ContainerDifferentiator(Adapter adapter, Differentiator differentiator) {
        this.adapter = adapter;
        this.elementDifferentiator = differentiator;
    }

    public Diff diff(Object object, Object object2) {
        return this.diff(object, object2, true);
    }

    public Diff keyDiff(Object object, Object object2) {
        return this.diff(object, object2, false);
    }

    private Diff diff(Object object, Object object2, boolean bl) {
        int n;
        Counter counter;
        if (object == object2) {
            return new NullDiff(object, object2, this);
        }
        if (this.diffIsFatal(object, object2)) {
            return new SimpleDiff(object, object2, this.fatalDescriptionTitle(), this);
        }
        Map map = this.buildCounters(object);
        Map map2 = this.buildCounters(object2);
        ArrayList arrayList = new ArrayList();
        ArrayList<Diff> arrayList2 = new ArrayList<Diff>();
        for (Map.Entry object3 : map.entrySet()) {
            Object k = object3.getKey();
            counter = (Counter)object3.getValue();
            int n2 = counter.count();
            while (n2-- > 0) {
                n = 0;
                Iterator iterator = map2.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    Object k2 = entry.getKey();
                    Diff diff = this.elementDifferentiator.keyDiff(k, k2);
                    if (!diff.identical()) continue;
                    n = 1;
                    Counter counter2 = (Counter)entry.getValue();
                    counter2.decrement();
                    if (counter2.count() == 0) {
                        iterator.remove();
                    }
                    if (bl) {
                        arrayList2.add(this.elementDifferentiator.diff(k, k2));
                        break;
                    }
                    arrayList2.add(diff);
                    break;
                }
                if (n != 0) continue;
                arrayList.add(k);
            }
        }
        ArrayList arrayList3 = new ArrayList();
        for (Map.Entry entry : map2.entrySet()) {
            counter = entry.getKey();
            Counter counter3 = (Counter)entry.getValue();
            n = counter3.count();
            while (n-- > 0) {
                arrayList3.add(counter);
            }
        }
        return new ContainerDiff(this.containerClass(), object, object2, arrayList2.toArray(new Diff[arrayList2.size()]), arrayList.toArray(), arrayList3.toArray(), this);
    }

    private Map buildCounters(Object object) {
        IdentityHashMap identityHashMap = new IdentityHashMap(this.size(object));
        Iterator iterator = this.iterator(object);
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Counter counter = (Counter)identityHashMap.get(e);
            if (counter == null) {
                counter = new Counter();
                identityHashMap.put(e, counter);
            }
            counter.increment();
        }
        return identityHashMap;
    }

    private String fatalDescriptionTitle() {
        return "The two " + ClassTools.shortNameFor(this.containerClass()) + "s cannot be compared";
    }

    public boolean comparesValueObjects() {
        return false;
    }

    public Differentiator getElementDifferentiator() {
        return this.elementDifferentiator;
    }

    public void setElementDifferentiator(Differentiator differentiator) {
        this.elementDifferentiator = differentiator;
    }

    protected boolean diffIsFatal(Object object, Object object2) {
        return this.adapter.diffIsFatal(object, object2);
    }

    protected Class containerClass() {
        return this.adapter.containerClass();
    }

    protected int size(Object object) {
        return this.adapter.size(object);
    }

    protected Iterator iterator(Object object) {
        return this.adapter.iterator(object);
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.elementDifferentiator);
    }

    public static interface Adapter {
        public static final Adapter INVALID_INSTANCE = new Adapter(){

            public boolean diffIsFatal(Object object, Object object2) {
                throw new UnsupportedOperationException();
            }

            public Class containerClass() {
                throw new UnsupportedOperationException();
            }

            public int size(Object object) {
                throw new UnsupportedOperationException();
            }

            public Iterator iterator(Object object) {
                throw new UnsupportedOperationException();
            }

            public String toString() {
                return "InvalidAdapter";
            }
        };

        public boolean diffIsFatal(Object var1, Object var2);

        public Class containerClass();

        public int size(Object var1);

        public Iterator iterator(Object var1);
    }
}

