/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.events;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeNotifier;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.StateChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.StateChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.TreeChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.TreeChangeListener;

public final class AWTChangeNotifier
implements ChangeNotifier,
Serializable {
    private static ChangeNotifier INSTANCE;
    private static final long serialVersionUID = 1L;

    public static synchronized ChangeNotifier instance() {
        if (INSTANCE == null) {
            INSTANCE = new AWTChangeNotifier();
        }
        return INSTANCE;
    }

    private AWTChangeNotifier() {
    }

    public void stateChanged(final StateChangeListener stateChangeListener, final StateChangeEvent stateChangeEvent) {
        if (EventQueue.isDispatchThread()) {
            stateChangeListener.stateChanged(stateChangeEvent);
        } else {
            this.invoke(new Runnable(){

                public void run() {
                    stateChangeListener.stateChanged(stateChangeEvent);
                }

                public String toString() {
                    return "stateChanged";
                }
            });
        }
    }

    public void propertyChange(final PropertyChangeListener propertyChangeListener, final PropertyChangeEvent propertyChangeEvent) {
        if (EventQueue.isDispatchThread()) {
            propertyChangeListener.propertyChange(propertyChangeEvent);
        } else {
            this.invoke(new Runnable(){

                public void run() {
                    propertyChangeListener.propertyChange(propertyChangeEvent);
                }

                public String toString() {
                    return "propertyChange";
                }
            });
        }
    }

    public void itemsAdded(final CollectionChangeListener collectionChangeListener, final CollectionChangeEvent collectionChangeEvent) {
        if (EventQueue.isDispatchThread()) {
            collectionChangeListener.itemsAdded(collectionChangeEvent);
        } else {
            this.invoke(new Runnable(){

                public void run() {
                    collectionChangeListener.itemsAdded(collectionChangeEvent);
                }

                public String toString() {
                    return "itemsAdded (Collection)";
                }
            });
        }
    }

    public void itemsRemoved(final CollectionChangeListener collectionChangeListener, final CollectionChangeEvent collectionChangeEvent) {
        if (EventQueue.isDispatchThread()) {
            collectionChangeListener.itemsRemoved(collectionChangeEvent);
        } else {
            this.invoke(new Runnable(){

                public void run() {
                    collectionChangeListener.itemsRemoved(collectionChangeEvent);
                }

                public String toString() {
                    return "itemsRemoved (Collection)";
                }
            });
        }
    }

    public void collectionChanged(final CollectionChangeListener collectionChangeListener, final CollectionChangeEvent collectionChangeEvent) {
        if (EventQueue.isDispatchThread()) {
            collectionChangeListener.collectionChanged(collectionChangeEvent);
        } else {
            this.invoke(new Runnable(){

                public void run() {
                    collectionChangeListener.collectionChanged(collectionChangeEvent);
                }

                public String toString() {
                    return "collectionChanged";
                }
            });
        }
    }

    public void itemsAdded(final ListChangeListener listChangeListener, final ListChangeEvent listChangeEvent) {
        if (EventQueue.isDispatchThread()) {
            listChangeListener.itemsAdded(listChangeEvent);
        } else {
            this.invoke(new Runnable(){

                public void run() {
                    listChangeListener.itemsAdded(listChangeEvent);
                }

                public String toString() {
                    return "itemsAdded (List)";
                }
            });
        }
    }

    public void itemsRemoved(final ListChangeListener listChangeListener, final ListChangeEvent listChangeEvent) {
        if (EventQueue.isDispatchThread()) {
            listChangeListener.itemsRemoved(listChangeEvent);
        } else {
            this.invoke(new Runnable(){

                public void run() {
                    listChangeListener.itemsRemoved(listChangeEvent);
                }

                public String toString() {
                    return "itemsRemoved (List)";
                }
            });
        }
    }

    public void itemsReplaced(final ListChangeListener listChangeListener, final ListChangeEvent listChangeEvent) {
        if (EventQueue.isDispatchThread()) {
            listChangeListener.itemsReplaced(listChangeEvent);
        } else {
            this.invoke(new Runnable(){

                public void run() {
                    listChangeListener.itemsReplaced(listChangeEvent);
                }

                public String toString() {
                    return "itemsReplaced (List)";
                }
            });
        }
    }

    public void listChanged(final ListChangeListener listChangeListener, final ListChangeEvent listChangeEvent) {
        if (EventQueue.isDispatchThread()) {
            listChangeListener.listChanged(listChangeEvent);
        } else {
            this.invoke(new Runnable(){

                public void run() {
                    listChangeListener.listChanged(listChangeEvent);
                }

                public String toString() {
                    return "listChanged";
                }
            });
        }
    }

    public void nodeAdded(final TreeChangeListener treeChangeListener, final TreeChangeEvent treeChangeEvent) {
        if (EventQueue.isDispatchThread()) {
            treeChangeListener.nodeAdded(treeChangeEvent);
        } else {
            this.invoke(new Runnable(){

                public void run() {
                    treeChangeListener.nodeAdded(treeChangeEvent);
                }

                public String toString() {
                    return "nodeAdded";
                }
            });
        }
    }

    public void nodeRemoved(final TreeChangeListener treeChangeListener, final TreeChangeEvent treeChangeEvent) {
        if (EventQueue.isDispatchThread()) {
            treeChangeListener.nodeRemoved(treeChangeEvent);
        } else {
            this.invoke(new Runnable(){

                public void run() {
                    treeChangeListener.nodeRemoved(treeChangeEvent);
                }

                public String toString() {
                    return "nodeRemoved";
                }
            });
        }
    }

    public void treeChanged(final TreeChangeListener treeChangeListener, final TreeChangeEvent treeChangeEvent) {
        if (EventQueue.isDispatchThread()) {
            treeChangeListener.treeChanged(treeChangeEvent);
        } else {
            this.invoke(new Runnable(){

                public void run() {
                    treeChangeListener.treeChanged(treeChangeEvent);
                }

                public String toString() {
                    return "treeChanged";
                }
            });
        }
    }

    private void invoke(Runnable runnable) {
        EventQueue.invokeLater(runnable);
    }

    private Object readResolve() {
        return AWTChangeNotifier.instance();
    }
}

