/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.events;

import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.ReadOnlyIterator;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class CollectionChangeEvent
extends EventObject {
    private String collectionName;
    private Collection items;
    private static final long serialVersionUID = 1L;

    public CollectionChangeEvent(Object object) {
        super(object);
    }

    public CollectionChangeEvent(Object object, String string) {
        this(object);
        this.collectionName = string;
    }

    public CollectionChangeEvent(Object object, String string, Collection collection) {
        super(object);
        this.collectionName = string;
        this.items = collection;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public Iterator items() {
        if (this.items == null) {
            return NullIterator.instance();
        }
        return new ReadOnlyIterator(this.items);
    }

    public int size() {
        if (this.items == null) {
            return 0;
        }
        return this.items.size();
    }

    public CollectionChangeEvent cloneWithSource(Object object) {
        return new CollectionChangeEvent(object, this.collectionName, this.items);
    }

    public CollectionChangeEvent cloneWithSource(Object object, String string) {
        return new CollectionChangeEvent(object, string, this.items);
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.collectionName);
    }
}

