/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public class ArrayIterator
implements Iterator {
    Object[] array;
    int nextIndex;
    private int maxIndex;

    public ArrayIterator(Object[] objectArray) {
        this(objectArray, 0, objectArray.length);
    }

    public ArrayIterator(Object[] objectArray, int n, int n2) {
        if (n < 0 || n > objectArray.length) {
            throw new IllegalArgumentException("start: " + n);
        }
        if (n2 < 0 || n2 > objectArray.length - n) {
            throw new IllegalArgumentException("length: " + n2);
        }
        this.array = objectArray;
        this.nextIndex = n;
        this.maxIndex = n + n2;
    }

    public boolean hasNext() {
        return this.nextIndex < this.maxIndex;
    }

    public Object next() {
        if (this.hasNext()) {
            return this.array[this.nextIndex++];
        }
        throw new NoSuchElementException();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return ClassTools.shortClassNameForObject(this) + '(' + CollectionTools.list(this.array) + ')';
    }
}

