/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;

public class FilteringIterator
implements Iterator {
    private Iterator nestedIterator;
    private Filter filter;
    private Object next;
    private static final Object START = new Object();
    private static final Object END = new Object();

    public FilteringIterator(Iterator iterator) {
        this(iterator, Filter.NULL_INSTANCE);
    }

    public FilteringIterator(Iterator iterator, Filter filter) {
        this.nestedIterator = iterator;
        this.filter = filter;
        this.next = START;
    }

    public boolean hasNext() {
        if (this.next == START) {
            this.loadNext();
        }
        return this.next != END;
    }

    public Object next() {
        if (this.next == START) {
            this.loadNext();
        }
        if (this.next == END) {
            throw new NoSuchElementException();
        }
        Object object = this.next;
        this.loadNext();
        return object;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void loadNext() {
        this.next = END;
        while (this.nestedIterator.hasNext() && this.next == END) {
            this.next = this.nestedIterator.next();
            if (this.accept(this.next)) continue;
            this.next = END;
        }
    }

    protected boolean accept(Object object) {
        return this.filter.accept(object);
    }

    public String toString() {
        return ClassTools.shortClassNameForObject(this) + '(' + this.nestedIterator + ')';
    }
}

