/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.iterators;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.SingleElementIterator;

public class GraphIterator
implements Iterator {
    private Collection iterators;
    private Set visitedNeighbors;
    private MisterRogers misterRogers;
    private Iterator currentIterator;
    private static final Iterator END_ITERATOR = NullIterator.instance();
    private Object nextNeighbor;
    private static final Object END_NEIGHBOR = new Object();

    public GraphIterator(Iterator iterator) {
        this(iterator, MisterRogers.NULL_INSTANCE);
    }

    public GraphIterator(Object object) {
        this(object, MisterRogers.NULL_INSTANCE);
    }

    public GraphIterator(Object object, MisterRogers misterRogers) {
        this(new SingleElementIterator(object), misterRogers);
    }

    public GraphIterator(Iterator iterator, MisterRogers misterRogers) {
        this.currentIterator = iterator;
        this.iterators = new LinkedList();
        this.misterRogers = misterRogers;
        this.visitedNeighbors = new HashSet();
        this.loadNextNeighbor();
    }

    private void loadNextNeighbor() {
        if (this.currentIterator == END_ITERATOR) {
            this.nextNeighbor = END_NEIGHBOR;
        } else if (this.currentIterator.hasNext()) {
            Object e = this.currentIterator.next();
            if (this.visitedNeighbors.contains(e)) {
                this.loadNextNeighbor();
            } else {
                this.nextNeighbor = e;
                this.visitedNeighbors.add(e);
                this.iterators.add(this.neighbors(e));
            }
        } else {
            Iterator iterator = this.iterators.iterator();
            while (!this.currentIterator.hasNext() && iterator.hasNext()) {
                this.currentIterator = (Iterator)iterator.next();
                iterator.remove();
            }
            if (!this.currentIterator.hasNext()) {
                this.currentIterator = END_ITERATOR;
            }
            this.loadNextNeighbor();
        }
    }

    public boolean hasNext() {
        return this.nextNeighbor != END_NEIGHBOR;
    }

    public Object next() {
        if (this.nextNeighbor == END_NEIGHBOR) {
            throw new NoSuchElementException();
        }
        Object object = this.nextNeighbor;
        this.loadNextNeighbor();
        return object;
    }

    public void remove() {
        throw new UnsupportedOperationException("remove()");
    }

    protected Iterator neighbors(Object object) {
        return this.misterRogers.neighbors(object);
    }

    public String toString() {
        return ClassTools.shortClassNameForObject(this) + '(' + this.currentIterator + ')';
    }

    public static interface MisterRogers {
        public static final MisterRogers NULL_INSTANCE = new MisterRogers(){

            public Iterator neighbors(Object object) {
                return NullIterator.instance();
            }

            public String toString() {
                return super.toString() + "(Hello, neighbor.)";
            }
        };

        public Iterator neighbors(Object var1);
    }
}

