/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.string;

import org.eclipse.persistence.tools.workbench.utility.string.PartialStringComparator;
import org.eclipse.persistence.tools.workbench.utility.string.PartialStringComparatorEngine;
import org.eclipse.persistence.tools.workbench.utility.string.StringHolder;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class ExhaustivePartialStringComparatorEngine
implements PartialStringComparatorEngine {
    private final PartialStringComparator partialStringComparator;

    public ExhaustivePartialStringComparatorEngine(PartialStringComparator partialStringComparator) {
        this.partialStringComparator = partialStringComparator;
    }

    public PartialStringComparatorEngine.StringHolderPair[] match(StringHolder[] stringHolderArray, StringHolder[] stringHolderArray2) {
        PartialStringComparatorEngine.StringHolderPair[] stringHolderPairArray = this.buildStringHolderPairs(stringHolderArray, stringHolderArray2);
        this.calculateScores((InternalStringHolderPair[])stringHolderPairArray, stringHolderArray2);
        this.setString2((InternalStringHolderPair[])stringHolderPairArray, stringHolderArray2);
        return stringHolderPairArray;
    }

    private InternalStringHolderPair[] buildStringHolderPairs(StringHolder[] stringHolderArray, StringHolder[] stringHolderArray2) {
        int n;
        int n2 = stringHolderArray.length;
        int n3 = stringHolderArray2.length;
        int n4 = Math.max(n2, n3);
        InternalStringHolderPair[] internalStringHolderPairArray = new InternalStringHolderPair[n4];
        for (n = 0; n < n2; ++n) {
            internalStringHolderPairArray[n] = new SimpleInternalStringHolderPair(stringHolderArray[n], n3);
        }
        if (n2 < n3) {
            for (n = n2; n < n3; ++n) {
                internalStringHolderPairArray[n] = new NullInternalStringHolderPair();
            }
        }
        return internalStringHolderPairArray;
    }

    private void calculateScores(InternalStringHolderPair[] internalStringHolderPairArray, StringHolder[] stringHolderArray) {
        PartialStringComparator partialStringComparator = this.partialStringComparator;
        int n = internalStringHolderPairArray.length;
        while (n-- > 0) {
            internalStringHolderPairArray[n].calculateScores(partialStringComparator, stringHolderArray);
        }
    }

    private void setString2(InternalStringHolderPair[] internalStringHolderPairArray, StringHolder[] stringHolderArray) {
        int n = internalStringHolderPairArray.length;
        InternalStringHolderPair[] internalStringHolderPairArray2 = new InternalStringHolderPair[n];
        System.arraycopy(internalStringHolderPairArray, 0, internalStringHolderPairArray2, 0, n);
        int n2 = stringHolderArray.length;
        StringHolder[] stringHolderArray2 = new StringHolder[n2];
        System.arraycopy(stringHolderArray, 0, stringHolderArray2, 0, n2);
        int n3 = n2;
        while (n3-- > 0) {
            double d = -2.0;
            int n4 = -1;
            int n5 = n;
            while (n5-- > 0) {
                double d2;
                InternalStringHolderPair internalStringHolderPair = internalStringHolderPairArray2[n5];
                if (internalStringHolderPair == null || !((d2 = internalStringHolderPair.maxScore()) > d)) continue;
                d = d2;
                n4 = n5;
            }
            n5 = internalStringHolderPairArray2[n4].setStringHolder2(stringHolderArray2);
            stringHolderArray2[n5] = null;
            internalStringHolderPairArray2[n4] = null;
            int n6 = n;
            while (n6-- > 0) {
                InternalStringHolderPair internalStringHolderPair = internalStringHolderPairArray2[n6];
                if (internalStringHolderPair == null) continue;
                internalStringHolderPair.clearStringHolder2(n5);
            }
        }
        n3 = n;
        while (n3-- > n2) {
            int n7 = n;
            while (n7-- > 0) {
                InternalStringHolderPair internalStringHolderPair = internalStringHolderPairArray2[n7];
                if (internalStringHolderPair == null) continue;
                internalStringHolderPair.setStringHolder2(null);
            }
        }
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.partialStringComparator);
    }

    private static class SimpleInternalStringHolderPair
    implements InternalStringHolderPair {
        private final StringHolder stringHolder1;
        private StringHolder stringHolder2;
        private double score;
        private double[] scores;
        private double maxScore;
        private int maxScoreIndex;

        SimpleInternalStringHolderPair(StringHolder stringHolder, int n) {
            this.stringHolder1 = stringHolder;
            this.score = -1.0;
            this.scores = new double[n];
            this.maxScore = -1.0;
            this.maxScoreIndex = -1;
        }

        public StringHolder getStringHolder1() {
            return this.stringHolder1;
        }

        public StringHolder getStringHolder2() {
            return this.stringHolder2;
        }

        public double getScore() {
            return this.score;
        }

        public void calculateScores(PartialStringComparator partialStringComparator, StringHolder[] stringHolderArray) {
            String string = this.stringHolder1.getString();
            double[] dArray = this.scores;
            double d = this.maxScore;
            int n = this.maxScoreIndex;
            int n2 = stringHolderArray.length;
            while (n2-- > 0) {
                double d2;
                dArray[n2] = d2 = partialStringComparator.compare(string, stringHolderArray[n2].getString());
                if (!(d2 > d)) continue;
                d = d2;
                n = n2;
            }
            this.maxScore = d;
            this.maxScoreIndex = n;
        }

        public double maxScore() {
            if (this.maxScore == -1.0) {
                this.recalculateMaxScoreAndIndex();
            }
            return this.maxScore;
        }

        private void recalculateMaxScoreAndIndex() {
            double[] dArray = this.scores;
            double d = this.maxScore;
            int n = this.maxScoreIndex;
            int n2 = dArray.length;
            while (n2-- > 0) {
                double d2 = dArray[n2];
                if (!(d2 > d)) continue;
                d = d2;
                n = n2;
            }
            this.maxScore = d;
            this.maxScoreIndex = n;
        }

        public int setStringHolder2(StringHolder[] stringHolderArray) {
            int n = this.maxScoreIndex;
            if (stringHolderArray == null) {
                this.stringHolder2 = null;
                this.score = 0.0;
            } else {
                this.stringHolder2 = stringHolderArray[n];
                this.score = this.scores[n];
            }
            this.scores = null;
            this.maxScore = 0.0;
            this.maxScoreIndex = -1;
            return n;
        }

        public void clearStringHolder2(int n) {
            this.scores[n] = -1.0;
            this.maxScore = -1.0;
            this.maxScoreIndex = -1;
        }

        public int compareTo(Object object) {
            return DEFAULT_COMPARATOR.compare(this, object);
        }

        public String toString() {
            return StringTools.buildToStringFor(this, this.additionalInfo());
        }

        private String additionalInfo() {
            StringBuffer stringBuffer = new StringBuffer(200);
            stringBuffer.append("\"");
            stringBuffer.append(this.stringHolder1.getString());
            stringBuffer.append("\" vs. ");
            if (this.stringHolder2 == null) {
                stringBuffer.append("<null>");
            } else {
                stringBuffer.append('\"');
                stringBuffer.append(this.stringHolder2.getString());
                stringBuffer.append('\"');
            }
            stringBuffer.append(" => ");
            stringBuffer.append(this.score);
            return stringBuffer.toString();
        }
    }

    private static class NullInternalStringHolderPair
    implements InternalStringHolderPair {
        private StringHolder stringHolder2;

        private NullInternalStringHolderPair() {
        }

        public StringHolder getStringHolder1() {
            return null;
        }

        public StringHolder getStringHolder2() {
            return this.stringHolder2;
        }

        public double getScore() {
            return 0.0;
        }

        public void calculateScores(PartialStringComparator partialStringComparator, StringHolder[] stringHolderArray) {
        }

        public double maxScore() {
            return -1.0;
        }

        public int setStringHolder2(StringHolder[] stringHolderArray) {
            int n = stringHolderArray.length;
            while (n-- > 0) {
                if (stringHolderArray[n] == null) continue;
                this.stringHolder2 = stringHolderArray[n];
                return n;
            }
            throw new IllegalStateException("'stringHolders2' is empty");
        }

        public void clearStringHolder2(int n) {
        }

        public int compareTo(Object object) {
            return DEFAULT_COMPARATOR.compare(this, object);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(100);
            StringTools.buildSimpleToStringOn(this, stringBuffer);
            stringBuffer.append(" (");
            stringBuffer.append("<null> vs. ");
            if (this.stringHolder2 == null) {
                stringBuffer.append("<null>");
            } else {
                stringBuffer.append('\"');
                stringBuffer.append(this.stringHolder2.getString());
                stringBuffer.append('\"');
            }
            stringBuffer.append(" => 0");
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
    }

    private static interface InternalStringHolderPair
    extends PartialStringComparatorEngine.StringHolderPair {
        public void calculateScores(PartialStringComparator var1, StringHolder[] var2);

        public double maxScore();

        public int setStringHolder2(StringHolder[] var1);

        public void clearStringHolder2(int var1);
    }
}

