/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.string;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public final class XMLStringEncoder {
    private final char[] chars;
    private final char maxChar;

    public XMLStringEncoder(char[] cArray) {
        if (cArray == null) {
            throw new NullPointerException();
        }
        this.chars = CollectionTools.contains(cArray, '&') ? cArray : CollectionTools.add(cArray, '&');
        this.maxChar = this.calculateMaxInvalidFileNameChar();
    }

    private char calculateMaxInvalidFileNameChar() {
        char[] cArray = this.chars;
        char c = '\u0000';
        int n = cArray.length;
        while (n-- > 0) {
            char c2 = cArray[n];
            if (c >= c2) continue;
            c = c2;
        }
        return c;
    }

    public String encode(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n + 20);
        for (int i = 0; i < n; ++i) {
            this.appendCharacterTo(string.charAt(i), stringBuffer);
        }
        return stringBuffer.toString();
    }

    public String decode(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        StringBuffer stringBuffer2 = new StringBuffer();
        this.decodeTo(new StringReader(string), stringBuffer, stringBuffer2);
        return stringBuffer.toString();
    }

    private void appendCharacterTo(char c, StringBuffer stringBuffer) {
        if (this.charIsToBeEncoded(c)) {
            this.appendCharacterReferenceTo(c, stringBuffer);
        } else {
            stringBuffer.append(c);
        }
    }

    private boolean charIsToBeEncoded(char c) {
        return c <= this.maxChar && CollectionTools.contains(this.chars, c);
    }

    private void appendCharacterReferenceTo(char c, StringBuffer stringBuffer) {
        stringBuffer.append("&#x");
        stringBuffer.append(Integer.toString(c, 16));
        stringBuffer.append(';');
    }

    private void decodeTo(Reader reader, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        try {
            this.decodeToUnhandled(reader, stringBuffer, stringBuffer2);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private void decodeToUnhandled(Reader reader, StringBuffer stringBuffer, StringBuffer stringBuffer2) throws IOException {
        int n = reader.read();
        while (n != -1) {
            if (n == 38) {
                this.decodeCharacterReferenceTo(reader, stringBuffer, stringBuffer2);
            } else {
                stringBuffer.append((char)n);
            }
            n = reader.read();
        }
        reader.close();
    }

    private void decodeCharacterReferenceTo(Reader reader, StringBuffer stringBuffer, StringBuffer stringBuffer2) throws IOException {
        int n = reader.read();
        this.checkChar(n, 35);
        n = reader.read();
        this.checkChar(n, 120);
        stringBuffer2.setLength(0);
        n = reader.read();
        while (n != 59) {
            this.checkEndOfStream(n);
            stringBuffer2.append((char)n);
            n = reader.read();
        }
        String string = stringBuffer2.toString();
        if (string.length() == 0) {
            throw new IllegalStateException("missing numeric string");
        }
        stringBuffer.append((char)Integer.parseInt(string, 16));
    }

    private void checkChar(int n, int n2) {
        this.checkEndOfStream(n);
        if (n != n2) {
            throw new IllegalStateException("expected '" + (char)n2 + "', but encountered '" + (char)n + "'");
        }
    }

    private void checkEndOfStream(int n) {
        if (n == -1) {
            throw new IllegalStateException("unexpected end of string");
        }
    }
}

