/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.xr;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.persistence.mappings.foundation.AbstractTransformationMapping;
import org.eclipse.persistence.mappings.transformers.AttributeTransformer;
import org.eclipse.persistence.mappings.transformers.FieldTransformer;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.sessions.Record;
import org.eclipse.persistence.sessions.Session;

public class QNameTransformer
implements AttributeTransformer,
FieldTransformer {
    public static final Map<String, QName> SCHEMA_QNAMES = new HashMap<String, QName>(){
        {
            this.put("any", XMLConstants.ANY_QNAME);
            this.put("anySimpleType", XMLConstants.ANY_SIMPLE_TYPE_QNAME);
            this.put("base64Binary", XMLConstants.BASE_64_BINARY_QNAME);
            this.put("boolean", XMLConstants.BOOLEAN_QNAME);
            this.put("byte", XMLConstants.BYTE_QNAME);
            this.put("date", XMLConstants.DATE_QNAME);
            this.put("dateTime", XMLConstants.DATE_TIME_QNAME);
            this.put("decimal", XMLConstants.DECIMAL_QNAME);
            this.put("double", XMLConstants.DOUBLE_QNAME);
            this.put("float", XMLConstants.FLOAT_QNAME);
            this.put("hexBinary", XMLConstants.HEX_BINARY_QNAME);
            this.put("int", XMLConstants.INT_QNAME);
            this.put("integer", XMLConstants.INTEGER_QNAME);
            this.put("long", XMLConstants.LONG_QNAME);
            this.put("QName", XMLConstants.QNAME_QNAME);
            this.put("short", XMLConstants.SHORT_QNAME);
            this.put("string", XMLConstants.STRING_QNAME);
            this.put("time", XMLConstants.TIME_QNAME);
            this.put("unsignedByte", XMLConstants.UNSIGNED_BYTE_QNAME);
            this.put("unsignedInt", XMLConstants.UNSIGNED_INT_QNAME);
            this.put("unsignedShort", XMLConstants.UNSIGNED_SHORT_QNAME);
            this.put("swaRef", XMLConstants.SWA_REF_QNAME);
        }
    };
    private static final char COLON = ':';
    private static final String DEFAULT_NAMESPACE_PREFIX = "";
    AbstractTransformationMapping transformationMapping;
    private NamespaceResolver namespaceResolver;
    private String xPath;

    public QNameTransformer(String string) {
        this.xPath = string;
    }

    public void initialize(AbstractTransformationMapping abstractTransformationMapping) {
        this.transformationMapping = abstractTransformationMapping;
        this.namespaceResolver = ((XMLDescriptor)abstractTransformationMapping.getDescriptor()).getNamespaceResolver();
    }

    public Object buildAttributeValue(Record record, Object object, Session session) {
        if (null == record) {
            return null;
        }
        String string = (String)record.get((Object)this.xPath);
        if (null == string) {
            return null;
        }
        QName qName = null;
        int n = string.lastIndexOf(58);
        if (n > -1) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            String string4 = ((XMLRecord)record).resolveNamespacePrefix(string2);
            if ("http://www.w3.org/2001/XMLSchema".equals(string4)) {
                qName = SCHEMA_QNAMES.get(string3);
                if (qName == null) {
                    qName = new QName("http://www.w3.org/2001/XMLSchema", string3, string2 == null ? DEFAULT_NAMESPACE_PREFIX : string2);
                }
            } else {
                qName = new QName(string4 == null ? DEFAULT_NAMESPACE_PREFIX : string4, string3, string2 == null ? DEFAULT_NAMESPACE_PREFIX : string2);
            }
            return qName;
        }
        String string5 = ((XMLRecord)record).resolveNamespacePrefix(DEFAULT_NAMESPACE_PREFIX);
        qName = new QName(string5, string);
        return qName;
    }

    public Object buildFieldValue(Object object, String string, Session session) {
        if (null == object) {
            return null;
        }
        QName qName = (QName)this.transformationMapping.getAttributeValueFromObject(object);
        if (null == qName.getNamespaceURI()) {
            return qName.getLocalPart();
        }
        String string2 = qName.getNamespaceURI();
        String string3 = this.namespaceResolver.resolveNamespaceURI(string2);
        if (null == string3) {
            return qName.getLocalPart();
        }
        return string3 + ':' + qName.getLocalPart();
    }
}

