/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.xr;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.platform.xml.XMLPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    static final int[] chartype = new int[256];
    static final int FWHITESPACE = 1;
    static final int FDIGIT = 2;
    static final int FLETTER = 4;
    static final int FMISCNAME = 8;
    static final int FSTARTNAME = 16;
    public static final QName SXF_QNAME;
    public static final Map<QName, Class<?>> SCHEMA_2_CLASS;
    public static XMLPlatform XML_PLATFORM;
    public static Document TEMP_DOC;
    public static final String DEFAULT_ATTACHMENT_MIMETYPE = "application/octet-stream";
    public static final String WEB_INF_DIR = "WEB-INF/";
    public static final String WSDL_DIR = "wsdl/";
    public static final String[] META_INF_PATHS;
    public static final String DBWS_SERVICE_XML = "eclipselink-dbws.xml";
    public static final String DBWS_OR_LABEL = "dbws-or";
    public static final String DBWS_OX_LABEL = "dbws-ox";
    public static final String DBWS_OR_XML = "eclipselink-dbws-or.xml";
    public static final String DBWS_OX_XML = "eclipselink-dbws-ox.xml";
    public static final String DBWS_SCHEMA_XML = "eclipselink-dbws-schema.xsd";
    public static final String DBWS_WSDL = "eclipselink-dbws.wsdl";
    public static final String DBWS_SESSIONS_XML = "eclipselink-dbws-sessions.xml";
    public static final String DBWS_OR_SESSION_NAME_SUFFIX = "dbws-or-session";
    public static final String DBWS_OX_SESSION_NAME_SUFFIX = "dbws-ox-session";
    public static final String TARGET_NAMESPACE_PREFIX = "ns1";
    public static final String SERVICE_NAMESPACE_PREFIX = "srvc";
    public static final String SERVICE_SUFFIX = "Service";

    public static String sqlToXmlName(String string) {
        int n = string.length();
        if (n == 0) {
            return string;
        }
        String string2 = new String();
        int n2 = 1;
        char c = string.charAt(0);
        if (c == ':') {
            string2 = string2 + "_x003A_";
        } else if (n >= 2 && string.substring(0, 2).equals("_x")) {
            string2 = string2 + "_x005F_";
        } else if (c >= '\ud800' && c < '\udc00') {
            if (n > 1) {
                string2 = string2 + Util.hexEscape(c << 16 | string.charAt(1) & 0xFFFF);
                n2 = 2;
            } else {
                string2 = string2 + Util.hexEscape(c);
            }
        } else {
            string2 = Util.isFirstNameChar(c) ? string2 + c : string2 + Util.hexEscape(c);
        }
        for (int i = n2; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c2 >= '\ud800' && c2 < '\udc00') {
                if (i + 1 < n) {
                    string2 = string2 + Util.hexEscape(c2 << 16 | string.charAt(i + 1) & 0xFFFF);
                    ++i;
                    continue;
                }
                string2 = string2 + Util.hexEscape(c2);
                continue;
            }
            string2 = !Util.isNameChar(c2) ? string2 + Util.hexEscape(c2) : string2 + c2;
        }
        return string2;
    }

    public static String xmlToSqlName(String string) {
        String string2 = new String();
        int n = string.length();
        boolean bl = false;
        String string3 = null;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (bl) {
                if (c >= 'A' && c <= 'F' || c >= '0' && c <= '9') {
                    string3 = string3 + c;
                    continue;
                }
                if (c == '_') {
                    int n2;
                    bl = false;
                    if (string3 != null && (n2 = string3.length()) > 4) {
                        char c2 = (char)Integer.parseInt(string3.substring(0, n2 - 4), 16);
                        char c3 = (char)Integer.parseInt(string3.substring(n2 - 4), 16);
                        string2 = string2 + c2;
                        string2 = string2 + c3;
                        continue;
                    }
                    int n3 = Integer.parseInt(string3, 16);
                    if (n3 == 65535) continue;
                    string2 = string2 + (char)n3;
                    continue;
                }
                string2 = string2 + "_x" + string3 + c;
                bl = false;
                continue;
            }
            if (c == '_' && i + 1 < n && string.charAt(i + 1) == 'x') {
                bl = true;
                string3 = new String();
                ++i;
                continue;
            }
            string2 = string2 + c;
        }
        return string2;
    }

    public static String hexEscape(char c) {
        String string = Integer.toHexString(c);
        switch (string.length()) {
            case 1: {
                string = "_x000" + string.toUpperCase(Locale.US) + "_";
                break;
            }
            case 2: {
                string = "_x00" + string.toUpperCase(Locale.US) + "_";
                break;
            }
            case 3: {
                string = "_x0" + string.toUpperCase(Locale.US) + "_";
                break;
            }
            case 4: {
                string = "_x" + string.toUpperCase(Locale.US) + "_";
            }
        }
        return string;
    }

    public static String hexEscape(int n) {
        String string = Integer.toHexString(n);
        switch (string.length()) {
            case 1: 
            case 5: {
                string = "_x000" + string.toUpperCase(Locale.US) + "_";
                break;
            }
            case 2: 
            case 6: {
                string = "_x00" + string.toUpperCase(Locale.US) + "_";
                break;
            }
            case 3: 
            case 7: {
                string = "_x0" + string.toUpperCase(Locale.US) + "_";
                break;
            }
            case 4: 
            case 8: {
                string = "_x" + string.toUpperCase(Locale.US) + "_";
            }
        }
        return string;
    }

    public static boolean isNameChar(char c) {
        boolean bl;
        if (c < '\u0100') {
            bl = (chartype[c] & 0xE) != 0;
        } else if (c >= '\u2180' && c <= '\u2182' || c >= '\u3041' && c <= '\u3094' || c >= '\u30a1' && c <= '\u30fa' || c >= '\u3105' && c <= '\u312c' || c >= '\uac00' && c <= '\ud7a3' || c >= '\u0e47' && c <= '\u0e4e') {
            bl = true;
        } else if (c == '\u02ff' || c == '\u0346' || c == '\u0362' || c == '\u0487' || c == '\u05a2' || c == '\u05ba' || c == '\u05be' || c == '\u05c0' || c == '\u05c3' || c == '\u0653' || c == '\u06b8' || c == '\u06b9' || c == '\u06e9' || c == '\u06ee' || c == '\u0904' || c == '\u093b' || c == '\u094e' || c == '\u0955' || c == '\u0964' || c == '\u0984' || c == '\u09c5' || c == '\u09c9' || c == '\u09ce' || c == '\u09d8' || c == '\u09e4' || c == '\u0a03' || c == '\u0a3d' || c == '\u0a46' || c == '\u0a49' || c == '\u0a4e' || c == '\u0a80' || c == '\u0a84' || c == '\u0abb' || c == '\u0ac6' || c == '\u0aca' || c == '\u0ace' || c == '\u0b04' || c == '\u0b3b' || c == '\u0b44' || c == '\u0b4a' || c == '\u0b4e' || c == '\u0b58' || c == '\u0b84' || c == '\u0bc3' || c == '\u0bc9' || c == '\u0bd6' || c == '\u0c0d' || c == '\u0c45' || c == '\u0c49' || c == '\u0c54' || c == '\u0c81' || c == '\u0c84' || c == '\u0cc5' || c == '\u0cc9' || c == '\u0cd4' || c == '\u0cd7' || c == '\u0d04' || c == '\u0d45' || c == '\u0d49' || c == '\u0d4e' || c == '\u0d58' || c == '\u0e3f' || c == '\u0e3b' || c == '\u0e4f' || c == '\u0eba' || c == '\u0ebe' || c == '\u0ece' || c == '\u0f1a' || c == '\u0f36' || c == '\u0f38' || c == '\u0f3b' || c == '\u0f3a' || c == '\u0f70' || c == '\u0f85' || c == '\u0f8c' || c == '\u0f96' || c == '\u0f98' || c == '\u0fb0' || c == '\u0fb8' || c == '\u0fba' || c == '\u20dd' || c == '\u20e2' || c == '\u3030' || c == '\u309b' || c == '\u066a' || c == '\u06fa' || c == '\u0970' || c == '\u09f2' || c == '\u0af0' || c == '\u0b70' || c == '\u0c65' || c == '\u0ce5' || c == '\u0cf0' || c == '\u0d70' || c == '\u0e5a' || c == '\u0eda' || c == '\u0f2a' || c == '\u02d2' || c == '\u03fe' || c == '\u065f' || c == '\u0e5c' || c == '\u0c04') {
            bl = false;
        } else {
            bl = Character.isLetter(c) || Character.isDigit(c) || c == '-' || c == '_' || c == '.';
            bl = true;
        }
        return bl;
    }

    public static boolean isFirstNameChar(char c) {
        boolean bl = c < '\u0100' ? (chartype[c] & 0x14) != 0 : (c >= '\u2180' && c <= '\u2182' || c == '\u3007' || c >= '\u3021' && c <= '\u3029' || c >= '\u3041' && c <= '\u3094' || c >= '\u30a1' && c <= '\u30fa' || c >= '\u3105' && c <= '\u312c' || c >= '\uac00' && c <= '\ud7a3' ? true : (c == '\u1101' || c == '\u1104' || c == '\u1108' || c == '\u110a' || c == '\u110d' || c == '\u113b' || c == '\u1141' || c == '\u114d' || c == '\u114f' || c == '\u1151' || c == '\u1156' || c == '\u1162' || c == '\u1164' || c == '\u1166' || c == '\u116b' || c == '\u116f' || c == '\u1174' || c == '\u119f' || c == '\u11ac' || c == '\u11b6' || c == '\u11b9' || c == '\u11bb' || c == '\u11c3' || c == '\u11f1' || c == '\u0132' || c == '\u0133' || c == '\u013f' || c == '\u0140' || c == '\u0149' || c == '\u017f' || c == '\u01c4' || c == '\u01cc' || c == '\u01f1' || c == '\u01f3' || c == '\u0e46' || c == '\u113f' || c == '\u01f6' || c == '\u01f9' || c == '\u0230' || c == '\u03d7' || c == '\u03dd' || c == '\u03e1' || c == '\u040d' || c == '\u0450' || c == '\u045d' || c == '\u04ec' || c == '\u04ed' || c == '\u06b8' || c == '\u06bf' || c == '\u06cf' || c == '\u0e2f' || c == '\u0eaf' || c == '\u0f6a' || c == '\u4cff' || c == '\u212f' || c == '\u0587' ? false : Character.isLetter(c) || c == '_'));
        return bl;
    }

    public static Class<?> getClassFromJDBCType(String string, DatabasePlatform databasePlatform) {
        Class clazz = (Class)databasePlatform.getClassTypes().get(string);
        if (clazz == null) {
            return ClassConstants.Object_Class;
        }
        return clazz;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            char c = (char)i;
            Util.chartype[i] = 0;
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') {
                Util.chartype[i] = 1;
            }
            if (Character.isLetter(c)) {
                int n = i;
                chartype[n] = chartype[n] | 4;
            }
            if (!Character.isDigit(c)) continue;
            int n = i;
            chartype[n] = chartype[n] | 2;
        }
        chartype[46] = chartype[46] | 8;
        chartype[45] = chartype[45] | 8;
        chartype[95] = chartype[95] | 0x18;
        chartype[183] = chartype[183] | 8;
        SXF_QNAME = new QName("", "simple-xml-format");
        SCHEMA_2_CLASS = new HashMap<QName, Class<?>>(){
            {
                this.put(XMLConstants.ANY_SIMPLE_TYPE_QNAME, ClassConstants.Object_Class);
                this.put(XMLConstants.BASE_64_BINARY_QNAME, ClassConstants.APBYTE);
                this.put(XMLConstants.BOOLEAN_QNAME, ClassConstants.BOOLEAN);
                this.put(XMLConstants.BYTE_QNAME, ClassConstants.BYTE);
                this.put(XMLConstants.DATE_QNAME, ClassConstants.CALENDAR);
                this.put(XMLConstants.DATE_TIME_QNAME, ClassConstants.CALENDAR);
                this.put(XMLConstants.DECIMAL_QNAME, ClassConstants.BIGDECIMAL);
                this.put(XMLConstants.DOUBLE_QNAME, ClassConstants.DOUBLE);
                this.put(XMLConstants.DURATION_QNAME, ClassConstants.STRING);
                this.put(XMLConstants.FLOAT_QNAME, ClassConstants.FLOAT);
                this.put(XMLConstants.G_YEAR_MONTH_QNAME, ClassConstants.STRING);
                this.put(XMLConstants.G_YEAR_QNAME, ClassConstants.STRING);
                this.put(XMLConstants.G_MONTH_QNAME, ClassConstants.STRING);
                this.put(XMLConstants.G_MONTH_DAY_QNAME, ClassConstants.STRING);
                this.put(XMLConstants.G_DAY_QNAME, ClassConstants.STRING);
                this.put(XMLConstants.HEX_BINARY_QNAME, ClassConstants.APBYTE);
                this.put(XMLConstants.INT_QNAME, ClassConstants.INTEGER);
                this.put(XMLConstants.INTEGER_QNAME, ClassConstants.BIGINTEGER);
                this.put(XMLConstants.LONG_QNAME, ClassConstants.LONG);
                this.put(XMLConstants.QNAME_QNAME, QName.class);
                this.put(XMLConstants.SHORT_QNAME, ClassConstants.SHORT);
                this.put(XMLConstants.STRING_QNAME, ClassConstants.STRING);
                this.put(XMLConstants.TIME_QNAME, ClassConstants.CALENDAR);
                this.put(XMLConstants.UNSIGNED_BYTE_QNAME, ClassConstants.SHORT);
                this.put(XMLConstants.UNSIGNED_INT_QNAME, ClassConstants.LONG);
                this.put(XMLConstants.UNSIGNED_SHORT_QNAME, ClassConstants.INTEGER);
            }
        };
        XML_PLATFORM = XMLPlatformFactory.getInstance().getXMLPlatform();
        TEMP_DOC = XML_PLATFORM.createDocument();
        META_INF_PATHS = new String[]{"META-INF/", "/META-INF/"};
    }
}

