/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.MappedById;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.PrimaryKeyJoinColumns;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.indirection.IndirectionPolicy;
import org.eclipse.persistence.internal.indirection.WeavedObjectBasicIndirectionPolicy;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.RelationshipAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnsMetadata;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectAccessor
extends RelationshipAccessor {
    private Boolean m_id;
    private Boolean m_isOptional;
    private List<PrimaryKeyJoinColumnMetadata> m_primaryKeyJoinColumns = new ArrayList<PrimaryKeyJoinColumnMetadata>();
    private String m_mappedById;

    protected ObjectAccessor(String string) {
        super(string);
    }

    protected ObjectAccessor(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject, ClassAccessor classAccessor) {
        super(annotation, metadataAccessibleObject, classAccessor);
        this.m_isOptional = annotation == null ? true : (Boolean)MetadataHelper.invokeMethod("optional", annotation);
        if (this.isAnnotationPresent(PrimaryKeyJoinColumns.class)) {
            for (Annotation annotation2 : (Annotation[])MetadataHelper.invokeMethod("value", this.getAnnotation(PrimaryKeyJoinColumns.class))) {
                this.m_primaryKeyJoinColumns.add(new PrimaryKeyJoinColumnMetadata(annotation2, metadataAccessibleObject));
            }
        }
        if (this.isAnnotationPresent(PrimaryKeyJoinColumn.class)) {
            this.m_primaryKeyJoinColumns.add(new PrimaryKeyJoinColumnMetadata((Annotation)this.getAnnotation(PrimaryKeyJoinColumn.class), metadataAccessibleObject));
        }
        if (this.isAnnotationPresent(MappedById.class)) {
            this.m_mappedById = (String)MetadataHelper.invokeMethod("value", annotation);
        }
        this.m_id = this.isAnnotationPresent(Id.class);
    }

    @Override
    public Enum getDefaultFetchType() {
        return FetchType.valueOf((String)"EAGER");
    }

    public Boolean getId() {
        return this.m_id;
    }

    public String getMappedById() {
        return this.m_mappedById;
    }

    public Boolean getOptional() {
        return this.m_isOptional;
    }

    public List<PrimaryKeyJoinColumnMetadata> getPrimaryKeyJoinColumns() {
        return this.m_primaryKeyJoinColumns;
    }

    @Override
    public Class getReferenceClass() {
        if (this.m_referenceClass == null) {
            this.m_referenceClass = this.getTargetEntity();
            if (this.m_referenceClass == Void.TYPE) {
                this.m_referenceClass = super.getReferenceClass();
                this.getLogger().logConfigMessage(this.getLoggingContext(), this.getAnnotatedElement(), (Object)this.m_referenceClass);
            }
        }
        return this.m_referenceClass;
    }

    protected Class getSimplePKType() {
        MetadataDescriptor metadataDescriptor = this.getReferenceDescriptor();
        ClassAccessor classAccessor = metadataDescriptor.getClassAccessor();
        if (classAccessor.hasDerivedId()) {
            return ((ObjectAccessor)metadataDescriptor.getAccessorFor(metadataDescriptor.getIdAttributeName())).getSimplePKType();
        }
        return metadataDescriptor.getAccessorFor(metadataDescriptor.getIdAttributeName()).getRawClass();
    }

    protected OneToOneMapping initOneToOneMapping() {
        OneToOneMapping oneToOneMapping = new OneToOneMapping();
        oneToOneMapping.setIsReadOnly(false);
        oneToOneMapping.setIsPrivateOwned(this.isPrivateOwned());
        oneToOneMapping.setJoinFetch(this.getMappingJoinFetchType(this.getJoinFetch()));
        oneToOneMapping.setIsOptional(this.isOptional());
        oneToOneMapping.setAttributeName(this.getAttributeName());
        oneToOneMapping.setReferenceClassName(this.getReferenceClassName());
        oneToOneMapping.setIsIDMapping(this.isDerivedId());
        this.processIndirection((ObjectReferenceMapping)oneToOneMapping);
        this.setAccessorMethods((DatabaseMapping)oneToOneMapping);
        this.processCascadeTypes((ForeignReferenceMapping)oneToOneMapping);
        this.processReturnInsertAndUpdate();
        return oneToOneMapping;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject metadataAccessibleObject) {
        super.initXMLObject(metadataAccessibleObject);
        this.initXMLObjects(this.m_primaryKeyJoinColumns, metadataAccessibleObject);
    }

    @Override
    public boolean isDerivedId() {
        return this.m_id != null && this.m_id != false;
    }

    public boolean isOneToOnePrimaryKeyRelationship() {
        return this.isOneToOne() && !this.m_primaryKeyJoinColumns.isEmpty();
    }

    public boolean isOptional() {
        return this.m_isOptional != null && this.m_isOptional != false;
    }

    protected void processIndirection(ObjectReferenceMapping objectReferenceMapping) {
        boolean bl = this.usesIndirection();
        if (bl && !this.getProject().isWeavingEnabled() && !ClassConstants.PersistenceWeavedLazy_Class.isAssignableFrom(this.getDescriptor().getJavaClass())) {
            bl = false;
        }
        if (bl && this.usesPropertyAccess(this.getDescriptor())) {
            objectReferenceMapping.setIndirectionPolicy((IndirectionPolicy)new WeavedObjectBasicIndirectionPolicy(this.getSetMethodName()));
        } else {
            objectReferenceMapping.setUsesIndirection(bl);
        }
        objectReferenceMapping.setIsLazy(this.isLazy());
    }

    public void processKey(HashSet<ClassAccessor> hashSet, HashSet<ClassAccessor> hashSet2) {
        Object object;
        MetadataDescriptor metadataDescriptor = this.getReferenceDescriptor();
        ClassAccessor classAccessor = metadataDescriptor.getClassAccessor();
        if (!hashSet2.contains(classAccessor)) {
            classAccessor.processDerivedIDs(hashSet, hashSet2);
        }
        this.processRelationship();
        String string = this.getAttributeName();
        String string2 = metadataDescriptor.getPKClassName();
        if (string2 != null) {
            object = this.getDescriptor().getPKClassName();
            if (object == null) {
                throw ValidationException.invalidCompositePKSpecification((Class)this.getJavaClass(), (String)object);
            }
            if (!((String)object).equals(string2)) {
                this.getOwningDescriptor().validatePKClassId(string, metadataDescriptor.getPKClass());
            } else {
                this.getOwningDescriptor().getPKClassIDs().clear();
            }
        } else {
            object = null;
            object = classAccessor.hasDerivedId() ? ((ObjectAccessor)metadataDescriptor.getAccessorFor(metadataDescriptor.getIdAttributeName())).getSimplePKType() : metadataDescriptor.getAccessorFor(metadataDescriptor.getIdAttributeName()).getRawClass();
            this.getOwningDescriptor().validatePKClassId(string, (Type)object);
        }
        this.getOwningDescriptor().addIdAttributeName(string);
        object = (ObjectReferenceMapping)this.getMapping();
        for (DatabaseField databaseField : object.getForeignKeyFields()) {
            this.getOwningDescriptor().addPrimaryKeyField(databaseField);
        }
    }

    protected void processOneToOnePrimaryKeyRelationship(OneToOneMapping oneToOneMapping) {
        MetadataDescriptor metadataDescriptor = this.getReferenceDescriptor();
        List<PrimaryKeyJoinColumnMetadata> list = this.processPrimaryKeyJoinColumns(new PrimaryKeyJoinColumnsMetadata(this.getPrimaryKeyJoinColumns()));
        for (PrimaryKeyJoinColumnMetadata primaryKeyJoinColumnMetadata : list) {
            DatabaseField databaseField = primaryKeyJoinColumnMetadata.getPrimaryKeyField();
            databaseField.setName(this.getName(databaseField, metadataDescriptor.getPrimaryKeyFieldName(), "metadata_default_pk_column"));
            databaseField.setTable(metadataDescriptor.getPrimaryTable());
            DatabaseField databaseField2 = primaryKeyJoinColumnMetadata.getForeignKeyField();
            databaseField2.setName(this.getName(databaseField2, this.getDescriptor().getPrimaryKeyFieldName(), "metadata_default_fk_column"));
            databaseField2.setTable(this.getDescriptor().getPrimaryTable());
            oneToOneMapping.addForeignKeyField(databaseField2, databaseField);
            oneToOneMapping.setIsReadOnly(true);
        }
    }

    protected void processOwningMappingKeys(OneToOneMapping oneToOneMapping) {
        if (this.isOneToOnePrimaryKeyRelationship()) {
            this.processOneToOnePrimaryKeyRelationship(oneToOneMapping);
        } else {
            String string = this.getReferenceDescriptor().getPrimaryKeyFieldName();
            String string2 = this.getUpperCaseAttributeName() + "_" + string;
            this.processOneToOneForeignKeyRelationship(oneToOneMapping, this.getJoinColumns(this.getJoinColumns(), this.getReferenceDescriptor()), string, this.getReferenceDatabaseTable(), string2, this.getDescriptor().getPrimaryTable());
        }
    }

    public void setId(Boolean bl) {
        this.m_id = bl;
    }

    public void setMappedById(String string) {
        this.m_mappedById = string;
    }

    public void setOptional(Boolean bl) {
        this.m_isOptional = bl;
    }

    public void setPrimaryKeyJoinColumns(List<PrimaryKeyJoinColumnMetadata> list) {
        this.m_primaryKeyJoinColumns = list;
    }
}

