/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.databaseaccess;

import java.io.StringWriter;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.databaseaccess.BatchWritingMechanism;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.ModifyQuery;

public class DynamicSQLBatchWritingMechanism
extends BatchWritingMechanism {
    protected ArrayList sqlStrings;
    protected long batchSize;

    public DynamicSQLBatchWritingMechanism(DatabaseAccessor databaseAccessor) {
        this.databaseAccessor = databaseAccessor;
        this.sqlStrings = new ArrayList(10);
        this.batchSize = 0L;
    }

    public void appendCall(AbstractSession abstractSession, DatabaseCall databaseCall) {
        if (databaseCall != null) {
            this.cacheQueryTimeout(abstractSession, databaseCall);
        }
        if (!databaseCall.hasParameters()) {
            if (this.databaseAccessor.getLogin().getPlatform().getMaxBatchWritingSize() == DatabasePlatform.DEFAULT_PARAMETERIZED_MAX_BATCH_WRITING_SIZE) {
                this.databaseAccessor.getLogin().getPlatform().setMaxBatchWritingSize(DatabasePlatform.DEFAULT_MAX_BATCH_WRITING_SIZE);
            }
            if (this.batchSize + (long)databaseCall.getSQLString().length() > (long)this.databaseAccessor.getLogin().getPlatform().getMaxBatchWritingSize()) {
                this.executeBatchedStatements(abstractSession);
            }
            this.sqlStrings.add(databaseCall.getSQLString());
            this.batchSize += (long)databaseCall.getSQLString().length();
            if (((ModifyQuery)databaseCall.getQuery()).forceBatchStatementExecution()) {
                this.executeBatchedStatements(abstractSession);
            }
        } else {
            this.executeBatchedStatements(abstractSession);
            this.switchMechanisms(abstractSession, databaseCall);
        }
    }

    public void clear() {
        this.sqlStrings.clear();
        this.batchSize = 0L;
        this.clearCacheQueryTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeBatchedStatements(AbstractSession abstractSession) {
        Object object;
        if (this.sqlStrings.isEmpty()) {
            return;
        }
        abstractSession.log(2, "sql", "begin_batch_statements", null, this.databaseAccessor);
        if (abstractSession.shouldLog(3, "sql")) {
            object = this.sqlStrings.iterator();
            while (object.hasNext()) {
                abstractSession.log(3, "sql", (String)object.next(), null, this.databaseAccessor, false);
            }
        }
        abstractSession.log(2, "sql", "end_batch_statements", null, this.databaseAccessor);
        try {
            ++this.databaseAccessor.writeStatementsCount;
            this.databaseAccessor.incrementCallCount(abstractSession);
            if (!abstractSession.getPlatform().usesJDBCBatchWriting()) {
                object = this.prepareBatchStatement(abstractSession);
                this.databaseAccessor.executeBatchedStatement((PreparedStatement)object, abstractSession);
            } else {
                object = this.prepareJDK12BatchStatement(abstractSession);
                this.databaseAccessor.executeJDK12BatchStatement((Statement)object, null, abstractSession, false);
            }
        }
        finally {
            this.clear();
        }
    }

    protected void switchMechanisms(AbstractSession abstractSession, DatabaseCall databaseCall) {
        this.databaseAccessor.setActiveBatchWritingMechanismToParameterizedSQL();
        this.databaseAccessor.getActiveBatchWritingMechanism().appendCall(abstractSession, databaseCall);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PreparedStatement prepareBatchStatement(AbstractSession abstractSession) throws DatabaseException {
        PreparedStatement preparedStatement = null;
        boolean bl = false;
        StringWriter stringWriter = new StringWriter();
        org.eclipse.persistence.platform.database.DatabasePlatform databasePlatform = abstractSession.getPlatform();
        stringWriter.write(databasePlatform.getBatchBeginString());
        Iterator iterator = this.sqlStrings.iterator();
        while (iterator.hasNext()) {
            if (bl) {
                stringWriter.write(databasePlatform.getBatchDelimiterString());
            }
            stringWriter.write((String)iterator.next());
            bl = true;
        }
        stringWriter.write(databasePlatform.getBatchDelimiterString());
        stringWriter.write(databasePlatform.getBatchEndString());
        try {
            abstractSession.startOperationProfile("sql prepare", null, Integer.MAX_VALUE);
            try {
                preparedStatement = this.databaseAccessor.getConnection().prepareStatement(stringWriter.toString());
            }
            finally {
                abstractSession.endOperationProfile("sql prepare", null, Integer.MAX_VALUE);
            }
        }
        catch (SQLException sQLException) {
            DatabaseException databaseException = this.databaseAccessor.processExceptionForCommError(abstractSession, sQLException, null);
            try {
                this.databaseAccessor.closeStatement(preparedStatement, abstractSession, null);
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            if (databaseException == null) {
                throw DatabaseException.sqlException(sQLException, this.databaseAccessor, abstractSession, false);
            }
            throw databaseException;
        }
        catch (RuntimeException runtimeException) {
            try {
                this.databaseAccessor.closeStatement(preparedStatement, abstractSession, null);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw runtimeException;
        }
        return preparedStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Statement prepareJDK12BatchStatement(AbstractSession abstractSession) throws DatabaseException {
        Statement statement = null;
        try {
            abstractSession.startOperationProfile("sql prepare", null, Integer.MAX_VALUE);
            try {
                statement = this.databaseAccessor.getConnection().createStatement();
                Iterator iterator = this.sqlStrings.iterator();
                while (iterator.hasNext()) {
                    statement.addBatch((String)iterator.next());
                }
                if (this.queryTimeoutCache > 0) {
                    statement.setQueryTimeout(this.queryTimeoutCache);
                }
            }
            finally {
                abstractSession.endOperationProfile("sql prepare", null, Integer.MAX_VALUE);
            }
        }
        catch (SQLException sQLException) {
            DatabaseException databaseException = this.databaseAccessor.processExceptionForCommError(abstractSession, sQLException, null);
            try {
                this.databaseAccessor.closeStatement(statement, abstractSession, null);
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            if (databaseException == null) {
                throw DatabaseException.sqlException(sQLException, this.databaseAccessor, abstractSession, false);
            }
            throw databaseException;
        }
        catch (RuntimeException runtimeException) {
            try {
                this.databaseAccessor.closeStatement(statement, abstractSession, null);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw runtimeException;
        }
        return statement;
    }
}

