/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.descriptors;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.annotations.IdValidation;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.FetchGroupManager;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.descriptors.changetracking.ObjectChangePolicy;
import org.eclipse.persistence.exceptions.ConcurrencyException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.DeferredLockManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.indirection.ProxyIndirectionPolicy;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.AggregateObjectChangeSet;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.AggregateMapping;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.mappings.foundation.AbstractTransformationMapping;
import org.eclipse.persistence.mappings.querykeys.DirectQueryKey;
import org.eclipse.persistence.mappings.querykeys.QueryKey;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.QueryByExamplePolicy;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.ObjectCopyingPolicy;
import org.eclipse.persistence.sessions.remote.RemoteSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectBuilder
implements Cloneable,
Serializable {
    protected ClassDescriptor descriptor;
    protected Map<String, DatabaseMapping> mappingsByAttribute;
    protected Map<DatabaseField, DatabaseMapping> mappingsByField = new HashMap<DatabaseField, DatabaseMapping>(20);
    protected Map<DatabaseField, List<DatabaseMapping>> readOnlyMappingsByField = new HashMap<DatabaseField, List<DatabaseMapping>>(10);
    protected Map<DatabaseField, DatabaseField> fieldsMap;
    protected List<DatabaseMapping> primaryKeyMappings;
    protected List<Class> primaryKeyClassifications;
    protected transient List<DatabaseMapping> nonPrimaryKeyMappings;
    protected transient Expression primaryKeyExpression;
    protected List<DatabaseMapping> joinedAttributes;
    protected List<DatabaseMapping> cloningMappings;
    protected List<DatabaseMapping> eagerMappings;
    protected List<DatabaseMapping> relationshipMappings;
    protected boolean isSimple;
    protected boolean hasWrapperPolicy;
    protected AbstractDirectMapping sequenceMapping;

    public ObjectBuilder(ClassDescriptor classDescriptor) {
        this.mappingsByAttribute = new HashMap<String, DatabaseMapping>(20);
        this.fieldsMap = new HashMap<DatabaseField, DatabaseField>(20);
        this.primaryKeyMappings = new ArrayList<DatabaseMapping>(5);
        this.nonPrimaryKeyMappings = new ArrayList<DatabaseMapping>(10);
        this.cloningMappings = new ArrayList<DatabaseMapping>(10);
        this.eagerMappings = new ArrayList<DatabaseMapping>(5);
        this.relationshipMappings = new ArrayList<DatabaseMapping>(5);
        this.descriptor = classDescriptor;
    }

    public AbstractRecord createRecord(AbstractSession abstractSession) {
        return new DatabaseRecord();
    }

    public AbstractRecord createRecord(int n, AbstractSession abstractSession) {
        return new DatabaseRecord(n);
    }

    protected AbstractRecord createRecordForPKExtraction(int n, AbstractSession abstractSession) {
        return this.createRecord(n, abstractSession);
    }

    public void addPrimaryKeyForNonDefaultTable(AbstractRecord abstractRecord) {
        this.addPrimaryKeyForNonDefaultTable(abstractRecord, null, null);
    }

    public void addPrimaryKeyForNonDefaultTable(AbstractRecord abstractRecord, Object object, AbstractSession abstractSession) {
        if (!this.descriptor.hasMultipleTables()) {
            return;
        }
        Vector<DatabaseTable> vector = this.descriptor.getTables();
        int n = vector.size();
        for (int i = 1; i < n; ++i) {
            DatabaseTable databaseTable = (DatabaseTable)vector.get(i);
            Map<DatabaseField, DatabaseField> map = this.descriptor.getAdditionalTablePrimaryKeyFields().get(databaseTable);
            if (map == null) continue;
            Iterator<DatabaseField> iterator = map.keySet().iterator();
            Iterator<DatabaseField> iterator2 = map.values().iterator();
            while (iterator.hasNext()) {
                DatabaseField databaseField = iterator.next();
                DatabaseField databaseField2 = iterator2.next();
                Object object2 = abstractRecord.get(databaseField);
                if (object2 == null && !abstractRecord.containsKey(databaseField)) {
                    if (object != null) {
                        DatabaseMapping databaseMapping = this.getMappingForField(databaseField2);
                        if (databaseMapping == null) {
                            throw DescriptorException.missingMappingForField(databaseField2, this.descriptor);
                        }
                        databaseMapping.writeFromObjectIntoRow(object, abstractRecord, abstractSession);
                    }
                    abstractRecord.put(databaseField, abstractRecord.get(databaseField2));
                    continue;
                }
                abstractRecord.put(databaseField2, object2);
            }
        }
    }

    public void clearPrimaryKey(Object object) {
        if (object instanceof PersistenceEntity) {
            ((PersistenceEntity)object)._persistence_setPKVector(null);
            ((PersistenceEntity)object)._persistence_setCacheKey(null);
        }
    }

    public void assignReturnRow(Object object, AbstractSession abstractSession, AbstractRecord abstractRecord) throws DatabaseException {
        abstractSession.log(1, "query", "assign_return_row", abstractRecord);
        ReadObjectQuery readObjectQuery = new ReadObjectQuery();
        readObjectQuery.setSession(abstractSession);
        HashSet hashSet = null;
        int n = abstractRecord.size();
        if (n > 1) {
            hashSet = new HashSet(n);
        }
        Vector vector = abstractRecord.getFields();
        for (int i = 0; i < n; ++i) {
            DatabaseField databaseField = (DatabaseField)vector.get(i);
            this.assignReturnValueForField(object, readObjectQuery, abstractRecord, databaseField, hashSet);
        }
    }

    public void assignReturnValueForField(Object object, ReadObjectQuery readObjectQuery, AbstractRecord abstractRecord, DatabaseField databaseField, Collection collection) {
        List<DatabaseMapping> list;
        DatabaseMapping databaseMapping = this.getMappingForField(databaseField);
        if (databaseMapping != null) {
            this.assignReturnValueToMapping(object, readObjectQuery, abstractRecord, databaseField, databaseMapping, collection);
        }
        if ((list = this.getReadOnlyMappingsForField(databaseField)) != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                databaseMapping = list.get(i);
                this.assignReturnValueToMapping(object, readObjectQuery, abstractRecord, databaseField, databaseMapping, collection);
            }
        }
    }

    protected void assignReturnValueToMapping(Object object, ReadObjectQuery readObjectQuery, AbstractRecord abstractRecord, DatabaseField databaseField, DatabaseMapping databaseMapping, Collection collection) {
        if (collection != null && collection.contains(databaseMapping)) {
            return;
        }
        if (databaseMapping.isDirectToFieldMapping()) {
            databaseMapping.readFromRowIntoObject(abstractRecord, null, object, readObjectQuery, readObjectQuery.getSession());
        } else if (databaseMapping.isAggregateObjectMapping()) {
            ((AggregateObjectMapping)databaseMapping).readFromReturnRowIntoObject(abstractRecord, object, readObjectQuery, collection);
        } else if (databaseMapping.isTransformationMapping()) {
            ((AbstractTransformationMapping)databaseMapping).readFromReturnRowIntoObject(abstractRecord, object, readObjectQuery, collection);
        } else {
            readObjectQuery.getSession().log(1, "query", "field_for_unsupported_mapping_returned", databaseField, this.descriptor);
        }
    }

    public Object assignSequenceNumber(Object object, AbstractSession abstractSession) throws DatabaseException {
        DatabaseField databaseField = this.descriptor.getSequenceNumberField();
        Object object2 = null;
        object2 = this.sequenceMapping != null ? this.sequenceMapping.getAttributeValueFromObject(object) : this.getBaseValueForField(databaseField, object);
        if (object2 != null && !Helper.isEquivalentToNull(object2)) {
            return null;
        }
        Object object3 = abstractSession.getSequencing().getNextValue(this.descriptor.getJavaClass());
        if (object3 == null) {
            return null;
        }
        abstractSession.log(1, "sequencing", "assign_sequence", object3, object);
        Object object4 = null;
        if (this.sequenceMapping != null) {
            object4 = this.sequenceMapping.getAttributeValue(object3, abstractSession);
            this.sequenceMapping.setAttributeValueInObject(object, object4);
        } else {
            AbstractRecord abstractRecord = this.createRecord(1, abstractSession);
            abstractRecord.put(databaseField, object3);
            ReadObjectQuery readObjectQuery = new ReadObjectQuery();
            readObjectQuery.setSession(abstractSession);
            DatabaseMapping databaseMapping = this.getBaseMappingForField(databaseField);
            Object object5 = this.getParentObjectForField(databaseField, object);
            object4 = databaseMapping.readFromRowIntoObject(abstractRecord, null, object5, readObjectQuery, abstractSession);
        }
        this.clearPrimaryKey(object);
        return object4;
    }

    public void buildAttributesIntoObject(Object object, AbstractRecord abstractRecord, ObjectBuildingQuery objectBuildingQuery, JoinedAttributeManager joinedAttributeManager, boolean bl) throws DatabaseException {
        AbstractSession abstractSession = objectBuildingQuery.getSession().getExecutionSession(objectBuildingQuery);
        Vector<DatabaseMapping> vector = this.descriptor.getMappings();
        boolean bl2 = objectBuildingQuery.shouldReadAllMappings();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            DatabaseMapping databaseMapping = (DatabaseMapping)vector.get(i);
            if (!bl2 && !objectBuildingQuery.shouldReadMapping(databaseMapping)) continue;
            databaseMapping.readFromRowIntoObject(abstractRecord, joinedAttributeManager, object, objectBuildingQuery, abstractSession);
        }
        if (this.descriptor.getEventManager().hasAnyEventListeners()) {
            DescriptorEvent descriptorEvent = new DescriptorEvent(object);
            descriptorEvent.setQuery(objectBuildingQuery);
            descriptorEvent.setSession(objectBuildingQuery.getSession());
            descriptorEvent.setRecord(abstractRecord);
            if (bl) {
                descriptorEvent.setEventCode(9);
            } else {
                descriptorEvent.setEventCode(8);
            }
            this.descriptor.getEventManager().executeEvent(descriptorEvent);
        }
    }

    public Object buildBackupClone(Object object, UnitOfWorkImpl unitOfWorkImpl) {
        ClassDescriptor classDescriptor = this.descriptor;
        Object object2 = classDescriptor.getCopyPolicy().buildClone(object, unitOfWorkImpl);
        List<DatabaseMapping> list = this.getCloningMappings();
        int n = list.size();
        if (classDescriptor.hasFetchGroupManager() && classDescriptor.getFetchGroupManager().isPartialObject(object)) {
            FetchGroupManager fetchGroupManager = classDescriptor.getFetchGroupManager();
            for (int i = 0; i < n; ++i) {
                DatabaseMapping databaseMapping = list.get(i);
                if (!fetchGroupManager.isAttributeFetched(object, databaseMapping.getAttributeName())) continue;
                databaseMapping.buildBackupClone(object, object2, unitOfWorkImpl);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                list.get(i).buildBackupClone(object, object2, unitOfWorkImpl);
            }
        }
        return object2;
    }

    public Expression buildDeleteExpression(DatabaseTable databaseTable, AbstractRecord abstractRecord) {
        if (this.descriptor.usesOptimisticLocking() && this.descriptor.getTables().firstElement().equals(databaseTable)) {
            return this.descriptor.getOptimisticLockingPolicy().buildDeleteExpression(databaseTable, this.primaryKeyExpression, abstractRecord);
        }
        return this.buildPrimaryKeyExpression(databaseTable);
    }

    public Expression buildExpressionFromExample(Object object, QueryByExamplePolicy queryByExamplePolicy, Expression expression, Map map, AbstractSession abstractSession) {
        if (map.containsKey(object)) {
            return null;
        }
        map.put(object, object);
        Expression expression2 = null;
        Vector<DatabaseMapping> vector = this.descriptor.getMappings();
        for (int i = 0; i < vector.size(); ++i) {
            DatabaseMapping databaseMapping = (DatabaseMapping)vector.get(i);
            expression2 = expression2 == null ? databaseMapping.buildExpression(object, queryByExamplePolicy, expression, map, abstractSession) : expression2.and(databaseMapping.buildExpression(object, queryByExamplePolicy, expression, map, abstractSession));
        }
        return expression2;
    }

    public Object buildNewInstance() {
        return this.descriptor.getInstantiationPolicy().buildNewInstance();
    }

    public Object buildObject(ObjectLevelReadQuery objectLevelReadQuery, AbstractRecord abstractRecord) throws DatabaseException, QueryException {
        JoinedAttributeManager joinedAttributeManager = null;
        if (objectLevelReadQuery.hasJoining()) {
            joinedAttributeManager = objectLevelReadQuery.getJoinedAttributeManager();
        }
        return this.buildObject(objectLevelReadQuery, abstractRecord, joinedAttributeManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object buildObject(ObjectBuildingQuery objectBuildingQuery, AbstractRecord abstractRecord, JoinedAttributeManager joinedAttributeManager) throws DatabaseException, QueryException {
        Object object;
        AbstractSession abstractSession = objectBuildingQuery.getSession();
        abstractSession.startOperationProfile("object building", objectBuildingQuery, Integer.MAX_VALUE);
        Vector vector = this.extractPrimaryKeyFromRow(abstractRecord, abstractSession);
        if (vector == null && !objectBuildingQuery.hasPartialAttributeExpressions() && !this.descriptor.isAggregateCollectionDescriptor()) {
            abstractSession.endOperationProfile("object building", objectBuildingQuery, Integer.MAX_VALUE);
            if (objectBuildingQuery.shouldBuildNullForNullPk()) {
                return null;
            }
            throw QueryException.nullPrimaryKeyInBuildingObject(objectBuildingQuery, abstractRecord);
        }
        ClassDescriptor classDescriptor = this.descriptor;
        if (classDescriptor.hasInheritance() && classDescriptor.getInheritancePolicy().shouldReadSubclasses()) {
            object = classDescriptor.getInheritancePolicy().classFromRow(abstractRecord, abstractSession);
            if ((classDescriptor = classDescriptor.getInheritancePolicy().getDescriptor((Class)object)) == null && objectBuildingQuery.hasPartialAttributeExpressions()) {
                classDescriptor = this.descriptor;
            }
            if (classDescriptor == null) {
                abstractSession.endOperationProfile("object building", objectBuildingQuery, Integer.MAX_VALUE);
                throw QueryException.noDescriptorForClassFromInheritancePolicy(objectBuildingQuery, (Class)object);
            }
        }
        object = null;
        try {
            if (abstractSession.isUnitOfWork()) {
                object = this.buildObjectInUnitOfWork(objectBuildingQuery, joinedAttributeManager, abstractRecord, (UnitOfWorkImpl)abstractSession, vector, classDescriptor);
            } else {
                object = this.buildObject(objectBuildingQuery, abstractRecord, abstractSession, vector, classDescriptor, joinedAttributeManager);
                if (objectBuildingQuery.shouldCacheQueryResults()) {
                    objectBuildingQuery.cacheResult(object);
                }
                if (objectBuildingQuery.shouldUseWrapperPolicy()) {
                    object = classDescriptor.getObjectBuilder().wrapObject(object, abstractSession);
                }
            }
        }
        finally {
            abstractSession.endOperationProfile("object building", objectBuildingQuery, Integer.MAX_VALUE);
        }
        return object;
    }

    public void instantiateEagerMappings(Object object, AbstractSession abstractSession) {
        List<DatabaseMapping> list = this.getEagerMappings();
        if (!list.isEmpty()) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                DatabaseMapping databaseMapping = list.get(i);
                databaseMapping.instantiateAttribute(object, abstractSession);
            }
        }
    }

    protected Object buildObjectInUnitOfWork(ObjectBuildingQuery objectBuildingQuery, JoinedAttributeManager joinedAttributeManager, AbstractRecord abstractRecord, UnitOfWorkImpl unitOfWorkImpl, Vector vector, ClassDescriptor classDescriptor) throws DatabaseException, QueryException {
        if (!classDescriptor.shouldUseSessionCacheInUnitOfWorkEarlyTransaction() && (unitOfWorkImpl.hasCommitManager() && unitOfWorkImpl.getCommitManager().isActive() || unitOfWorkImpl.wasTransactionBegunPrematurely() || classDescriptor.shouldIsolateObjectsInUnitOfWork()) && !unitOfWorkImpl.isClassReadOnly(classDescriptor.getJavaClass(), classDescriptor)) {
            return classDescriptor.getObjectBuilder().buildWorkingCopyCloneFromRow(objectBuildingQuery, joinedAttributeManager, abstractRecord, unitOfWorkImpl, vector);
        }
        return this.buildWorkingCopyCloneNormally(objectBuildingQuery, abstractRecord, unitOfWorkImpl, vector, classDescriptor, joinedAttributeManager);
    }

    protected Object buildWorkingCopyCloneNormally(ObjectBuildingQuery objectBuildingQuery, AbstractRecord abstractRecord, UnitOfWorkImpl unitOfWorkImpl, Vector vector, ClassDescriptor classDescriptor, JoinedAttributeManager joinedAttributeManager) throws DatabaseException, QueryException {
        AbstractSession abstractSession = unitOfWorkImpl.getParentIdentityMapSession(objectBuildingQuery);
        Object object = null;
        Object object2 = null;
        objectBuildingQuery.setSession(abstractSession);
        if (abstractSession.isUnitOfWork()) {
            object = this.buildObjectInUnitOfWork(objectBuildingQuery, joinedAttributeManager, abstractRecord, (UnitOfWorkImpl)abstractSession, vector, classDescriptor);
        } else {
            object = this.buildObject(objectBuildingQuery, abstractRecord, abstractSession, vector, classDescriptor, joinedAttributeManager);
            if (objectBuildingQuery.shouldCacheQueryResults()) {
                objectBuildingQuery.cacheResult(object);
            }
        }
        objectBuildingQuery.setSession(unitOfWorkImpl);
        object2 = unitOfWorkImpl.shouldCascadeCloneToJoinedRelationship() ? objectBuildingQuery.registerIndividualResult(object, unitOfWorkImpl, joinedAttributeManager) : objectBuildingQuery.registerIndividualResult(object, unitOfWorkImpl, null);
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object buildObject(ObjectBuildingQuery objectBuildingQuery, AbstractRecord abstractRecord, AbstractSession abstractSession, Vector vector, ClassDescriptor classDescriptor, JoinedAttributeManager joinedAttributeManager) throws DatabaseException, QueryException {
        Object object = null;
        CacheKey cacheKey = null;
        boolean bl = true;
        try {
            int n;
            if (objectBuildingQuery.shouldMaintainCache()) {
                if (DeferredLockManager.SHOULD_USE_DEFERRED_LOCKS && (classDescriptor.shouldAcquireCascadedLocks() || joinedAttributeManager != null)) {
                    cacheKey = abstractSession.getIdentityMapAccessorInstance().acquireDeferredLock(vector, classDescriptor.getJavaClass(), classDescriptor);
                    object = cacheKey.getObject();
                    for (n = 0; object == null && n < 1000 && cacheKey.getMutex().getActiveThread() != Thread.currentThread(); ++n) {
                        cacheKey.releaseDeferredLock();
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        cacheKey = abstractSession.getIdentityMapAccessorInstance().acquireDeferredLock(vector, classDescriptor.getJavaClass(), classDescriptor);
                        object = cacheKey.getObject();
                    }
                    if (n == 1000) {
                        throw ConcurrencyException.maxTriesLockOnBuildObjectExceded(cacheKey.getMutex().getActiveThread(), Thread.currentThread());
                    }
                } else {
                    cacheKey = abstractSession.getIdentityMapAccessorInstance().acquireLock(vector, classDescriptor.getJavaClass(), classDescriptor);
                    object = cacheKey.getObject();
                }
            }
            if (object == null) {
                bl = false;
                object = objectBuildingQuery.isReadObjectQuery() && ((ReadObjectQuery)objectBuildingQuery).shouldLoadResultIntoSelectionObject() ? ((ReadObjectQuery)objectBuildingQuery).getSelectionObject() : classDescriptor.getObjectBuilder().buildNewInstance();
                if (objectBuildingQuery.shouldMaintainCache()) {
                    cacheKey.setObject(object);
                    this.copyQueryInfoToCacheKey(cacheKey, objectBuildingQuery, abstractRecord, abstractSession, classDescriptor);
                }
                classDescriptor.getObjectBuilder().buildAttributesIntoObject(object, abstractRecord, objectBuildingQuery, joinedAttributeManager, false);
                if (objectBuildingQuery.shouldMaintainCache() && objectBuildingQuery.getFetchGroup() != null && classDescriptor.hasFetchGroupManager()) {
                    classDescriptor.getFetchGroupManager().setObjectFetchGroup(object, objectBuildingQuery.getFetchGroup(), abstractSession);
                }
                if (object instanceof PersistenceEntity) {
                    ((PersistenceEntity)object)._persistence_setCacheKey(cacheKey);
                    ((PersistenceEntity)object)._persistence_setPKVector(vector);
                }
            } else {
                if (objectBuildingQuery.isReadObjectQuery() && ((ReadObjectQuery)objectBuildingQuery).shouldLoadResultIntoSelectionObject()) {
                    this.copyInto(object, ((ReadObjectQuery)objectBuildingQuery).getSelectionObject());
                    object = ((ReadObjectQuery)objectBuildingQuery).getSelectionObject();
                }
                n = classDescriptor.getCacheInvalidationPolicy().isInvalidated(cacheKey, objectBuildingQuery.getExecutionTime());
                if (cacheKey.getMutex().getActiveThread() == Thread.currentThread() && (objectBuildingQuery.shouldRefreshIdentityMapResult() || classDescriptor.shouldAlwaysRefreshCache() || n != 0) && cacheKey.getLastUpdatedQueryId() != objectBuildingQuery.getQueryId() && !cacheKey.getMutex().isLockedByMergeManager()) {
                    if (classDescriptor.hasFetchGroupManager() && classDescriptor.getFetchGroupManager().isPartialObject(object)) {
                        bl = false;
                        this.revertFetchGroupData(object, classDescriptor, cacheKey, objectBuildingQuery, joinedAttributeManager, abstractRecord, abstractSession);
                    } else {
                        boolean bl2 = true;
                        if (classDescriptor.usesOptimisticLocking()) {
                            OptimisticLockingPolicy optimisticLockingPolicy = classDescriptor.getOptimisticLockingPolicy();
                            Object object2 = optimisticLockingPolicy.getValueToPutInCache(abstractRecord, abstractSession);
                            if (classDescriptor.shouldOnlyRefreshCacheIfNewerVersion() && !(bl2 = optimisticLockingPolicy.isNewerVersion(abstractRecord, object, vector, abstractSession))) {
                                cacheKey.setReadTime(objectBuildingQuery.getExecutionTime());
                            }
                            if (bl2) {
                                cacheKey.setWriteLockValue(object2);
                            }
                        }
                        if (bl2) {
                            bl = false;
                            cacheKey.setLastUpdatedQueryId(objectBuildingQuery.getQueryId());
                            classDescriptor.getObjectBuilder().buildAttributesIntoObject(object, abstractRecord, objectBuildingQuery, joinedAttributeManager, true);
                            cacheKey.setReadTime(objectBuildingQuery.getExecutionTime());
                        }
                    }
                } else if (classDescriptor.hasFetchGroupManager() && classDescriptor.getFetchGroupManager().isPartialObject(object) && !classDescriptor.getFetchGroupManager().isObjectValidForFetchGroup(object, objectBuildingQuery.getFetchGroup())) {
                    bl = false;
                    classDescriptor.getFetchGroupManager().unionFetchGroupIntoObject(object, objectBuildingQuery.getFetchGroup(), abstractSession);
                    classDescriptor.getObjectBuilder().buildAttributesIntoObject(object, abstractRecord, objectBuildingQuery, joinedAttributeManager, false);
                } else if (joinedAttributeManager != null && joinedAttributeManager.hasJoinedAttributeExpressions()) {
                    List<Expression> list = joinedAttributeManager.getJoinedAttributeExpressions();
                    int n2 = list.size();
                    for (int i = 0; i < n2; ++i) {
                        QueryKeyExpression queryKeyExpression = (QueryKeyExpression)list.get(i);
                        if (!queryKeyExpression.getBaseExpression().isExpressionBuilder()) continue;
                        DatabaseMapping databaseMapping = this.getMappingForAttributeName(queryKeyExpression.getName());
                        if (databaseMapping == null) {
                            throw ValidationException.missingMappingForAttribute(classDescriptor, queryKeyExpression.getName(), this.toString());
                        }
                        Object object3 = databaseMapping.getAttributeValueFromObject(object);
                        if (object3 == null || !databaseMapping.isForeignReferenceMapping() || !((ForeignReferenceMapping)databaseMapping).usesIndirection() || ((ForeignReferenceMapping)databaseMapping).getIndirectionPolicy().objectIsInstantiated(object3)) continue;
                        databaseMapping.readFromRowIntoObject(abstractRecord, joinedAttributeManager, object, objectBuildingQuery, objectBuildingQuery.getExecutionSession());
                    }
                } else if (objectBuildingQuery.isReadAllQuery() && ((ReadAllQuery)objectBuildingQuery).hasBatchReadAttributes()) {
                    Vector vector2 = ((ReadAllQuery)objectBuildingQuery).getBatchReadAttributeExpressions();
                    int n3 = vector2.size();
                    for (int i = 0; i < n3; ++i) {
                        QueryKeyExpression queryKeyExpression = (QueryKeyExpression)vector2.get(i);
                        if (!queryKeyExpression.getBaseExpression().isExpressionBuilder()) continue;
                        DatabaseMapping databaseMapping = this.getMappingForAttributeName(queryKeyExpression.getName());
                        if (databaseMapping == null) {
                            throw ValidationException.missingMappingForAttribute(classDescriptor, queryKeyExpression.getName(), this.toString());
                        }
                        Object object4 = databaseMapping.getAttributeValueFromObject(object);
                        if (object4 == null || !databaseMapping.isForeignReferenceMapping() || !((ForeignReferenceMapping)databaseMapping).usesIndirection() || ((ForeignReferenceMapping)databaseMapping).getIndirectionPolicy().objectIsInstantiated(object4)) continue;
                        databaseMapping.readFromRowIntoObject(abstractRecord, joinedAttributeManager, object, objectBuildingQuery, objectBuildingQuery.getExecutionSession());
                    }
                }
            }
        }
        finally {
            if (objectBuildingQuery.shouldMaintainCache() && cacheKey != null) {
                if (cacheKey.getObject() != null) {
                    cacheKey.updateAccess();
                }
                if (DeferredLockManager.SHOULD_USE_DEFERRED_LOCKS && (classDescriptor.shouldAcquireCascadedLocks() || joinedAttributeManager != null)) {
                    cacheKey.releaseDeferredLock();
                } else {
                    cacheKey.release();
                }
            }
        }
        if (!bl) {
            classDescriptor.getObjectBuilder().instantiateEagerMappings(object, abstractSession);
        }
        return object;
    }

    private void revertFetchGroupData(Object object, ClassDescriptor classDescriptor, CacheKey cacheKey, ObjectBuildingQuery objectBuildingQuery, JoinedAttributeManager joinedAttributeManager, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        classDescriptor.getFetchGroupManager().reset(object);
        classDescriptor.getFetchGroupManager().setObjectFetchGroup(object, objectBuildingQuery.getFetchGroup(), abstractSession);
        classDescriptor.getObjectBuilder().buildAttributesIntoObject(object, abstractRecord, objectBuildingQuery, joinedAttributeManager, false);
        classDescriptor.getFetchGroupManager().setRefreshOnFetchGroupToObject(object, objectBuildingQuery.shouldRefreshIdentityMapResult() || classDescriptor.shouldAlwaysRefreshCache());
        cacheKey.setLastUpdatedQueryId(objectBuildingQuery.getQueryId());
        if (classDescriptor.usesOptimisticLocking()) {
            OptimisticLockingPolicy optimisticLockingPolicy = classDescriptor.getOptimisticLockingPolicy();
            cacheKey.setWriteLockValue(optimisticLockingPolicy.getValueToPutInCache(abstractRecord, abstractSession));
        }
        cacheKey.setReadTime(objectBuildingQuery.getExecutionTime());
        cacheKey.setInvalidationState(0);
    }

    public Object buildObjectsInto(ReadAllQuery readAllQuery, List list, Object object) throws DatabaseException {
        AbstractSession abstractSession = readAllQuery.getSession();
        int n = list.size();
        JoinedAttributeManager joinedAttributeManager = null;
        if (readAllQuery.hasJoining()) {
            joinedAttributeManager = readAllQuery.getJoinedAttributeManager();
        }
        ContainerPolicy containerPolicy = readAllQuery.getContainerPolicy();
        for (int i = 0; i < n; ++i) {
            AbstractRecord abstractRecord = (AbstractRecord)list.get(i);
            if (abstractRecord == null) continue;
            Object object2 = this.buildObject(readAllQuery, abstractRecord, joinedAttributeManager);
            containerPolicy.addInto(object2, object, abstractSession, abstractRecord, readAllQuery);
        }
        return object;
    }

    public Expression buildPrimaryKeyExpression(DatabaseTable databaseTable) throws DescriptorException {
        if (this.descriptor.getTables().firstElement().equals(databaseTable)) {
            return this.getPrimaryKeyExpression();
        }
        Map<DatabaseField, DatabaseField> map = this.descriptor.getAdditionalTablePrimaryKeyFields().get(databaseTable);
        if (map == null) {
            throw DescriptorException.multipleTablePrimaryKeyNotSpecified(this.descriptor);
        }
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        Expression expression = null;
        for (DatabaseField databaseField : map.values()) {
            expression = expressionBuilder.getField(databaseField).equal(expressionBuilder.getParameter(databaseField)).and(expression);
        }
        return expression;
    }

    public Expression buildPrimaryKeyExpressionFromKeys(Vector vector, AbstractSession abstractSession) {
        Expression expression = null;
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        List<DatabaseField> list = this.descriptor.getPrimaryKeyFields();
        for (int i = 0; i < list.size(); ++i) {
            Object e = vector.get(i);
            DatabaseField databaseField = list.get(i);
            if (e == null) continue;
            Expression expression2 = ((Expression)expressionBuilder).getField(databaseField).equal(e);
            expression = expression2.and(expression);
        }
        return expression;
    }

    public Expression buildPrimaryKeyExpressionFromObject(Object object, AbstractSession abstractSession) {
        return this.buildPrimaryKeyExpressionFromKeys(this.extractPrimaryKeyFromObject(object, abstractSession), abstractSession);
    }

    public AbstractRecord buildRow(Object object, AbstractSession abstractSession) {
        return this.buildRow(this.createRecord(abstractSession), object, abstractSession);
    }

    public AbstractRecord buildRow(AbstractRecord abstractRecord, Object object, AbstractSession abstractSession) {
        Vector<DatabaseMapping> vector = this.descriptor.getMappings();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            DatabaseMapping databaseMapping = (DatabaseMapping)vector.get(i);
            databaseMapping.writeFromObjectIntoRow(object, abstractRecord, abstractSession);
        }
        if (this.descriptor.hasInheritance()) {
            this.descriptor.getInheritancePolicy().addClassIndicatorFieldToRow(abstractRecord);
        }
        if (this.descriptor.hasMultipleTables() && !this.descriptor.isAggregateDescriptor()) {
            this.addPrimaryKeyForNonDefaultTable(abstractRecord, object, abstractSession);
        }
        return abstractRecord;
    }

    public AbstractRecord buildRowForShallowInsert(Object object, AbstractSession abstractSession) {
        return this.buildRowForShallowInsert(this.createRecord(abstractSession), object, abstractSession);
    }

    public AbstractRecord buildRowForShallowInsert(AbstractRecord abstractRecord, Object object, AbstractSession abstractSession) {
        Vector<DatabaseMapping> vector = this.descriptor.getMappings();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            DatabaseMapping databaseMapping = (DatabaseMapping)vector.get(i);
            databaseMapping.writeFromObjectIntoRowForShallowInsert(object, abstractRecord, abstractSession);
        }
        if (this.descriptor.hasInheritance()) {
            this.descriptor.getInheritancePolicy().addClassIndicatorFieldToRow(abstractRecord);
        }
        if (!this.descriptor.isAggregateDescriptor()) {
            this.addPrimaryKeyForNonDefaultTable(abstractRecord, object, abstractSession);
        }
        return abstractRecord;
    }

    public AbstractRecord buildRowWithChangeSet(AbstractRecord abstractRecord, ObjectChangeSet objectChangeSet, AbstractSession abstractSession) {
        Vector vector = objectChangeSet.getChanges();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ChangeRecord changeRecord = (ChangeRecord)vector.get(i);
            DatabaseMapping databaseMapping = changeRecord.getMapping();
            databaseMapping.writeFromObjectIntoRowWithChangeRecord(changeRecord, abstractRecord, abstractSession);
        }
        if (this.descriptor.hasInheritance()) {
            this.descriptor.getInheritancePolicy().addClassIndicatorFieldToRow(abstractRecord);
        }
        return abstractRecord;
    }

    public AbstractRecord buildRowForTranslation(Object object, AbstractSession abstractSession) {
        AbstractRecord abstractRecord = this.createRecord(abstractSession);
        List<DatabaseMapping> list = this.getPrimaryKeyMappings();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            DatabaseMapping databaseMapping = list.get(i);
            if (databaseMapping == null) continue;
            databaseMapping.writeFromObjectIntoRow(object, abstractRecord, abstractSession);
        }
        if (this.descriptor.hasMultipleTables()) {
            this.addPrimaryKeyForNonDefaultTable(abstractRecord, object, abstractSession);
        }
        return abstractRecord;
    }

    public AbstractRecord buildRowForUpdate(WriteObjectQuery writeObjectQuery) {
        AbstractRecord abstractRecord = this.createRecord(writeObjectQuery.getSession());
        return this.buildRowForUpdate(abstractRecord, writeObjectQuery);
    }

    public AbstractRecord buildRowForUpdate(AbstractRecord abstractRecord, WriteObjectQuery writeObjectQuery) {
        for (DatabaseMapping databaseMapping : this.getNonPrimaryKeyMappings()) {
            databaseMapping.writeFromObjectIntoRowForUpdate(writeObjectQuery, abstractRecord);
        }
        if (this.descriptor.hasInheritance() && this.descriptor.isAggregateDescriptor() && writeObjectQuery.getObject() != null) {
            if (writeObjectQuery.getBackupClone() == null) {
                this.descriptor.getInheritancePolicy().addClassIndicatorFieldToRow(abstractRecord);
            } else if (!writeObjectQuery.getObject().getClass().equals(writeObjectQuery.getBackupClone().getClass())) {
                this.descriptor.getInheritancePolicy().addClassIndicatorFieldToRow(abstractRecord);
            }
        }
        return abstractRecord;
    }

    public AbstractRecord buildRowForUpdateWithChangeSet(WriteObjectQuery writeObjectQuery) {
        AbstractRecord abstractRecord = this.createRecord(writeObjectQuery.getSession());
        AbstractSession abstractSession = writeObjectQuery.getSession();
        Vector vector = writeObjectQuery.getObjectChangeSet().getChanges();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ChangeRecord changeRecord = (ChangeRecord)vector.get(i);
            DatabaseMapping databaseMapping = changeRecord.getMapping();
            databaseMapping.writeFromObjectIntoRowWithChangeRecord(changeRecord, abstractRecord, abstractSession);
        }
        return abstractRecord;
    }

    public AbstractRecord buildRowForWhereClause(ObjectLevelModifyQuery objectLevelModifyQuery) {
        AbstractRecord abstractRecord = this.createRecord(objectLevelModifyQuery.getSession());
        for (DatabaseMapping databaseMapping : this.descriptor.getMappings()) {
            databaseMapping.writeFromObjectIntoRowForWhereClause(objectLevelModifyQuery, abstractRecord);
        }
        if (!this.descriptor.isAggregateDescriptor()) {
            this.addPrimaryKeyForNonDefaultTable(abstractRecord);
        }
        return abstractRecord;
    }

    public AbstractRecord buildRowFromPrimaryKeyValues(Vector vector, AbstractSession abstractSession) {
        AbstractRecord abstractRecord = this.createRecord(vector.size(), abstractSession);
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            DatabaseField databaseField = this.descriptor.getPrimaryKeyFields().get(i);
            Object object = vector.elementAt(i);
            object = abstractSession.getPlatform(this.descriptor.getJavaClass()).getConversionManager().convertObject(object, databaseField.getType());
            abstractRecord.put(databaseField, object);
        }
        return abstractRecord;
    }

    public AbstractRecord buildTemplateInsertRow(AbstractSession abstractSession) {
        AbstractRecord abstractRecord = this.createRecord(abstractSession);
        this.buildTemplateInsertRow(abstractSession, abstractRecord);
        return abstractRecord;
    }

    public void buildTemplateInsertRow(AbstractSession abstractSession, AbstractRecord abstractRecord) {
        for (DatabaseMapping databaseMapping : this.descriptor.getMappings()) {
            databaseMapping.writeInsertFieldsIntoRow(abstractRecord, abstractSession);
        }
        if (this.descriptor.hasInheritance()) {
            this.descriptor.getInheritancePolicy().addClassIndicatorFieldToInsertRow(abstractRecord);
        }
        if (!this.descriptor.isAggregateDescriptor()) {
            this.addPrimaryKeyForNonDefaultTable(abstractRecord);
        }
        if (this.descriptor.usesOptimisticLocking()) {
            this.descriptor.getOptimisticLockingPolicy().addLockFieldsToUpdateRow(abstractRecord, abstractSession);
        }
        this.trimFieldsForInsert(abstractSession, abstractRecord);
    }

    public void trimFieldsForInsert(AbstractSession abstractSession, AbstractRecord abstractRecord) {
        ClassDescriptor classDescriptor = this.descriptor;
        if (classDescriptor.usesSequenceNumbers() && classDescriptor.getSequence().shouldAcquireValueAfterInsert()) {
            abstractRecord.remove(classDescriptor.getSequenceNumberField());
        }
        if (classDescriptor.hasReturningPolicy()) {
            classDescriptor.getReturningPolicy().trimModifyRowForInsert(abstractRecord);
        }
    }

    public AbstractRecord buildTemplateUpdateRow(AbstractSession abstractSession) {
        AbstractRecord abstractRecord = this.createRecord(abstractSession);
        for (DatabaseMapping databaseMapping : this.getNonPrimaryKeyMappings()) {
            databaseMapping.writeUpdateFieldsIntoRow(abstractRecord, abstractSession);
        }
        if (this.descriptor.usesOptimisticLocking()) {
            this.descriptor.getOptimisticLockingPolicy().addLockFieldsToUpdateRow(abstractRecord, abstractSession);
        }
        return abstractRecord;
    }

    public Expression buildUpdateExpression(DatabaseTable databaseTable, AbstractRecord abstractRecord, AbstractRecord abstractRecord2) {
        Expression expression = this.buildPrimaryKeyExpression(databaseTable);
        if (this.descriptor.usesOptimisticLocking()) {
            return this.descriptor.getOptimisticLockingPolicy().buildUpdateExpression(databaseTable, expression, abstractRecord, abstractRecord2);
        }
        return expression;
    }

    public void buildPrimaryKeyAttributesIntoObject(Object object, AbstractRecord abstractRecord, ObjectBuildingQuery objectBuildingQuery) throws DatabaseException, QueryException {
        AbstractSession abstractSession = objectBuildingQuery.getSession().getExecutionSession(objectBuildingQuery);
        List<DatabaseMapping> list = this.getPrimaryKeyMappings();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            DatabaseMapping databaseMapping = list.get(i);
            databaseMapping.buildShallowOriginalFromRow(abstractRecord, object, null, objectBuildingQuery, abstractSession);
        }
    }

    public void buildAttributesIntoShallowObject(Object object, AbstractRecord abstractRecord, ObjectBuildingQuery objectBuildingQuery) throws DatabaseException, QueryException {
        AbstractSession abstractSession = objectBuildingQuery.getSession().getExecutionSession(objectBuildingQuery);
        List<DatabaseMapping> list = this.getPrimaryKeyMappings();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            DatabaseMapping databaseMapping = list.get(i);
            if (databaseMapping.isDirectToFieldMapping()) continue;
            databaseMapping.buildShallowOriginalFromRow(abstractRecord, object, null, objectBuildingQuery, abstractSession);
        }
        Vector<DatabaseMapping> vector = this.descriptor.getMappings();
        n = vector.size();
        for (int i = 0; i < n; ++i) {
            DatabaseMapping databaseMapping = (DatabaseMapping)vector.get(i);
            if (!databaseMapping.isDirectToFieldMapping()) continue;
            databaseMapping.buildShallowOriginalFromRow(abstractRecord, object, null, objectBuildingQuery, abstractSession);
        }
    }

    public void buildAttributesIntoWorkingCopyClone(Object object, ObjectBuildingQuery objectBuildingQuery, JoinedAttributeManager joinedAttributeManager, AbstractRecord abstractRecord, UnitOfWorkImpl unitOfWorkImpl, boolean bl) throws DatabaseException, QueryException {
        boolean bl2 = objectBuildingQuery.shouldReadAllMappings();
        Vector<DatabaseMapping> vector = this.descriptor.getMappings();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            DatabaseMapping databaseMapping = (DatabaseMapping)vector.get(i);
            if (!bl2 && !objectBuildingQuery.shouldReadMapping(databaseMapping)) continue;
            databaseMapping.buildCloneFromRow(abstractRecord, joinedAttributeManager, object, objectBuildingQuery, unitOfWorkImpl, unitOfWorkImpl);
        }
        if (this.descriptor.getEventManager().hasAnyEventListeners()) {
            DescriptorEvent descriptorEvent = new DescriptorEvent(object);
            descriptorEvent.setQuery(objectBuildingQuery);
            descriptorEvent.setSession(unitOfWorkImpl);
            descriptorEvent.setRecord(abstractRecord);
            if (bl) {
                descriptorEvent.setEventCode(9);
            } else {
                descriptorEvent.setEventCode(8);
                this.descriptor.getEventManager().executeEvent(descriptorEvent);
                descriptorEvent.setOriginalObject(object);
                descriptorEvent.setEventCode(10);
            }
            this.descriptor.getEventManager().executeEvent(descriptorEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object buildWorkingCopyCloneFromRow(ObjectBuildingQuery objectBuildingQuery, JoinedAttributeManager joinedAttributeManager, AbstractRecord abstractRecord, UnitOfWorkImpl unitOfWorkImpl, Vector vector) throws DatabaseException, QueryException {
        AbstractSession abstractSession = unitOfWorkImpl.getParentIdentityMapSession(objectBuildingQuery);
        ClassDescriptor classDescriptor = this.descriptor;
        CacheKey cacheKey = unitOfWorkImpl.getIdentityMapAccessorInstance().getIdentityMapManager().acquireLock(vector, classDescriptor.getJavaClass(), false, classDescriptor);
        Object object = cacheKey.getObject();
        try {
            Object object2;
            boolean bl;
            boolean bl2 = object != null;
            boolean bl3 = bl = objectBuildingQuery.shouldRefreshIdentityMapResult() || objectBuildingQuery.isLockQuery() && (!bl2 || !objectBuildingQuery.isClonePessimisticLocked(object, unitOfWorkImpl));
            if (bl2 && classDescriptor.hasFetchGroupManager() && classDescriptor.getFetchGroupManager().isPartialObject(object) && !classDescriptor.getFetchGroupManager().isObjectValidForFetchGroup(object, objectBuildingQuery.getFetchGroup())) {
                bl = true;
            }
            if (bl2 && !bl) {
                Object object3 = object;
                return object3;
            }
            boolean bl4 = false;
            boolean bl5 = classDescriptor.shouldIsolateObjectsInUnitOfWork() || classDescriptor.shouldIsolateObjectsInUnitOfWorkEarlyTransaction() && unitOfWorkImpl.wasTransactionBegunPrematurely();
            Object object4 = null;
            if (!(bl || bl5 || unitOfWorkImpl.shouldReadFromDB() || (object2 = abstractSession.getIdentityMapAccessorInstance().getCacheKeyForObject(vector, classDescriptor.getJavaClass(), classDescriptor)) == null)) {
                object4 = ((CacheKey)object2).getObject();
                bl4 = object4 != null;
                boolean bl6 = bl = bl4 && (classDescriptor.shouldAlwaysRefreshCache() || classDescriptor.getCacheInvalidationPolicy().isInvalidated((CacheKey)object2, objectBuildingQuery.getExecutionTime()));
                if (bl4 && !bl) {
                    Object object5 = unitOfWorkImpl.cloneAndRegisterObject(object4, (CacheKey)object2, cacheKey, classDescriptor);
                    return object5;
                }
            }
            if (!bl2) {
                if (bl4) {
                    object = this.instantiateWorkingCopyClone(object4, unitOfWorkImpl);
                    unitOfWorkImpl.getCloneToOriginals().put(object, object4);
                } else {
                    object = this.instantiateWorkingCopyCloneFromRow(abstractRecord, objectBuildingQuery, vector, unitOfWorkImpl);
                }
                cacheKey.setObject(object);
                unitOfWorkImpl.getCloneMapping().put(object, object);
            }
            if (bl2 && cacheKey.getLastUpdatedQueryId() >= objectBuildingQuery.getQueryId()) {
                object2 = object;
                return object2;
            }
            this.copyQueryInfoToCacheKey(cacheKey, objectBuildingQuery, abstractRecord, unitOfWorkImpl, classDescriptor);
            object2 = classDescriptor.getObjectChangePolicy();
            if (!bl2) {
                object2.setChangeListener(object, unitOfWorkImpl, classDescriptor);
            }
            object2.dissableEventProcessing(object);
            if (bl && this.descriptor.hasFetchGroupManager()) {
                this.descriptor.getFetchGroupManager().setObjectFetchGroup(object, objectBuildingQuery.getFetchGroup(), unitOfWorkImpl);
            }
            this.buildAttributesIntoWorkingCopyClone(object, objectBuildingQuery, joinedAttributeManager, abstractRecord, unitOfWorkImpl, bl2);
            if (!bl && this.descriptor.hasFetchGroupManager()) {
                this.descriptor.getFetchGroupManager().setObjectFetchGroup(object, objectBuildingQuery.getFetchGroup(), unitOfWorkImpl);
            }
            Object object6 = object2.buildBackupClone(object, this, unitOfWorkImpl);
            if (bl2) {
                object2.clearChanges(object, unitOfWorkImpl, classDescriptor);
            }
            object2.enableEventProcessing(object);
            unitOfWorkImpl.getCloneMapping().put(object, object6);
            objectBuildingQuery.recordCloneForPessimisticLocking(object, unitOfWorkImpl);
            if (object instanceof PersistenceEntity) {
                ((PersistenceEntity)object)._persistence_setPKVector(vector);
            }
        }
        finally {
            cacheKey.release();
        }
        this.instantiateEagerMappings(object, unitOfWorkImpl);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object buildWorkingCopyCloneFromResultSet(ObjectBuildingQuery objectBuildingQuery, JoinedAttributeManager joinedAttributeManager, ResultSet resultSet, UnitOfWorkImpl unitOfWorkImpl, DatabaseAccessor databaseAccessor, ResultSetMetaData resultSetMetaData, DatabasePlatform databasePlatform) throws DatabaseException, QueryException {
        ClassDescriptor classDescriptor = this.descriptor;
        Object object = this.getPrimaryKeyMappings().get(0).valueFromResultSet(resultSet, objectBuildingQuery, unitOfWorkImpl, databaseAccessor, resultSetMetaData, 1, databasePlatform);
        Vector<Object> vector = new Vector<Object>(1);
        vector.add(object);
        CacheKey cacheKey = unitOfWorkImpl.getIdentityMapAccessorInstance().getIdentityMapManager().acquireLock(vector, classDescriptor.getJavaClass(), false, classDescriptor);
        Object object2 = cacheKey.getObject();
        try {
            if (object2 != null) {
                Object object3 = object2;
                return object3;
            }
            object2 = classDescriptor.getCopyPolicy().buildWorkingCopyCloneFromPrimaryKeyObject(object, objectBuildingQuery, unitOfWorkImpl);
            cacheKey.setObject(object2);
            unitOfWorkImpl.getCloneMapping().put(object2, object2);
            ObjectChangePolicy objectChangePolicy = classDescriptor.getObjectChangePolicy();
            objectChangePolicy.setChangeListener(object2, unitOfWorkImpl, classDescriptor);
            Vector<DatabaseMapping> vector2 = classDescriptor.getMappings();
            int n = vector2.size();
            for (int i = 0; i < n; ++i) {
                DatabaseMapping databaseMapping = (DatabaseMapping)vector2.get(i);
                databaseMapping.readFromResultSetIntoObject(resultSet, object2, objectBuildingQuery, unitOfWorkImpl, databaseAccessor, resultSetMetaData, i + 1, databasePlatform);
            }
            objectBuildingQuery.recordCloneForPessimisticLocking(object2, unitOfWorkImpl);
            if (object2 instanceof PersistenceEntity) {
                ((PersistenceEntity)object2)._persistence_setPKVector(vector);
            }
        }
        finally {
            cacheKey.release();
        }
        return object2;
    }

    public Object clone() {
        ObjectBuilder objectBuilder = null;
        try {
            objectBuilder = (ObjectBuilder)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
        objectBuilder.setMappingsByAttribute(new HashMap<String, DatabaseMapping>(this.getMappingsByAttribute()));
        objectBuilder.setMappingsByField(new HashMap<DatabaseField, DatabaseMapping>(this.getMappingsByField()));
        objectBuilder.setFieldsMap(new HashMap<DatabaseField, DatabaseField>(this.getFieldsMap()));
        objectBuilder.setReadOnlyMappingsByField(new HashMap<DatabaseField, List<DatabaseMapping>>(this.getReadOnlyMappingsByField()));
        objectBuilder.setPrimaryKeyMappings(new ArrayList<DatabaseMapping>(this.getPrimaryKeyMappings()));
        objectBuilder.setNonPrimaryKeyMappings(new ArrayList<DatabaseMapping>(this.getNonPrimaryKeyMappings()));
        objectBuilder.cloningMappings = new ArrayList<DatabaseMapping>(this.cloningMappings);
        objectBuilder.eagerMappings = new ArrayList<DatabaseMapping>(this.eagerMappings);
        objectBuilder.relationshipMappings = new ArrayList<DatabaseMapping>(this.relationshipMappings);
        return objectBuilder;
    }

    public void cascadePerformRemove(Object object, UnitOfWorkImpl unitOfWorkImpl, Map map) {
        ObjectBuilder objectBuilder = this.descriptor.getObjectBuilder();
        if (!objectBuilder.isSimple()) {
            List<DatabaseMapping> list = objectBuilder.getRelationshipMappings();
            for (int i = 0; i < list.size(); ++i) {
                DatabaseMapping databaseMapping = list.get(i);
                databaseMapping.cascadePerformRemoveIfRequired(object, unitOfWorkImpl, map);
            }
        }
    }

    public void cascadePerformRemovePrivateOwnedObjectFromChangeSet(Object object, UnitOfWorkImpl unitOfWorkImpl, Map map) {
        ObjectBuilder objectBuilder = this.descriptor.getObjectBuilder();
        if (object != null && !objectBuilder.isSimple()) {
            for (DatabaseMapping databaseMapping : objectBuilder.getRelationshipMappings()) {
                if (!databaseMapping.isPrivateOwned()) continue;
                databaseMapping.cascadePerformRemovePrivateOwnedObjectFromChangeSetIfRequired(object, unitOfWorkImpl, map);
            }
        }
    }

    public void cascadeDiscoverAndPersistUnregisteredNewObjects(Object object, Map map, Map map2, Map map3, UnitOfWorkImpl unitOfWorkImpl) {
        block4: {
            ObjectBuilder objectBuilder = this.descriptor.getObjectBuilder();
            if (objectBuilder.isSimple()) break block4;
            List<DatabaseMapping> list = objectBuilder.getRelationshipMappings();
            int n = list.size();
            FetchGroupManager fetchGroupManager = this.descriptor.getFetchGroupManager();
            if (fetchGroupManager != null && fetchGroupManager.isPartialObject(object)) {
                for (int i = 0; i < n; ++i) {
                    DatabaseMapping databaseMapping = list.get(i);
                    if (!fetchGroupManager.isAttributeFetched(object, databaseMapping.getAttributeName())) continue;
                    databaseMapping.cascadeDiscoverAndPersistUnregisteredNewObjects(object, map, map2, map3, unitOfWorkImpl);
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    DatabaseMapping databaseMapping = list.get(i);
                    databaseMapping.cascadeDiscoverAndPersistUnregisteredNewObjects(object, map, map2, map3, unitOfWorkImpl);
                }
            }
        }
    }

    public void cascadeRegisterNewForCreate(Object object, UnitOfWorkImpl unitOfWorkImpl, Map map) {
        block4: {
            ObjectBuilder objectBuilder = this.descriptor.getObjectBuilder();
            if (objectBuilder.isSimple()) break block4;
            List<DatabaseMapping> list = objectBuilder.getRelationshipMappings();
            int n = list.size();
            FetchGroupManager fetchGroupManager = this.descriptor.getFetchGroupManager();
            if (fetchGroupManager != null && fetchGroupManager.isPartialObject(object)) {
                for (int i = 0; i < n; ++i) {
                    DatabaseMapping databaseMapping = list.get(i);
                    if (!fetchGroupManager.isAttributeFetched(object, databaseMapping.getAttributeName())) continue;
                    databaseMapping.cascadeRegisterNewIfRequired(object, unitOfWorkImpl, map);
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    DatabaseMapping databaseMapping = list.get(i);
                    databaseMapping.cascadeRegisterNewIfRequired(object, unitOfWorkImpl, map);
                }
            }
        }
    }

    public ObjectChangeSet compareForChange(Object object, Object object2, UnitOfWorkChangeSet unitOfWorkChangeSet, AbstractSession abstractSession) {
        return this.descriptor.getObjectChangePolicy().calculateChanges(object, object2, object2 == null, unitOfWorkChangeSet, (UnitOfWorkImpl)abstractSession, this.descriptor, true);
    }

    public boolean compareObjects(Object object, Object object2, AbstractSession abstractSession) {
        Vector<DatabaseMapping> vector = this.descriptor.getMappings();
        for (int i = 0; i < vector.size(); ++i) {
            DatabaseMapping databaseMapping = (DatabaseMapping)vector.get(i);
            if (databaseMapping.compareObjects(object, object2, abstractSession)) continue;
            Object object3 = databaseMapping.getAttributeValueFromObject(object);
            Object object4 = databaseMapping.getAttributeValueFromObject(object2);
            abstractSession.log(1, "query", "compare_failed", databaseMapping, object3, object4);
            return false;
        }
        return true;
    }

    public void copyInto(Object object, Object object2, boolean bl) {
        Vector<DatabaseMapping> vector = this.descriptor.getMappings();
        for (int i = 0; i < vector.size(); ++i) {
            DatabaseMapping databaseMapping = (DatabaseMapping)vector.get(i);
            Object object3 = null;
            object3 = bl && databaseMapping.isForeignReferenceMapping() ? ((ForeignReferenceMapping)databaseMapping).getAttributeValueWithClonedValueHolders(object) : databaseMapping.getAttributeValueFromObject(object);
            databaseMapping.setAttributeValueInObject(object2, object3);
        }
    }

    public void copyInto(Object object, Object object2) {
        this.copyInto(object, object2, false);
    }

    public Object copyObject(Object object, ObjectCopyingPolicy objectCopyingPolicy) {
        int n;
        Object object2 = objectCopyingPolicy.getCopies().get(object);
        if (object2 != null) {
            return object2;
        }
        object2 = this.instantiateClone(object, objectCopyingPolicy.getSession());
        objectCopyingPolicy.getCopies().put(object, object2);
        List<DatabaseMapping> list = this.getCloningMappings();
        int n2 = list.size();
        for (n = 0; n < n2; ++n) {
            list.get(n).buildCopy(object2, object, objectCopyingPolicy);
        }
        if (objectCopyingPolicy.shouldResetPrimaryKey() && !this.descriptor.isDescriptorTypeAggregate()) {
            int n3;
            n = 0;
            List<DatabaseMapping> list2 = this.getPrimaryKeyMappings();
            n2 = list2.size();
            for (n3 = 0; n3 < n2; ++n3) {
                if (!list2.get(n3).isOneToOneMapping()) continue;
                n = 1;
            }
            if (n == 0) {
                for (n3 = 0; n3 < n2; ++n3) {
                    DatabaseMapping databaseMapping = list2.get(n3);
                    if (databaseMapping.isDirectToFieldMapping()) {
                        Object object3 = ((AbstractDirectMapping)databaseMapping).getAttributeValue(null, objectCopyingPolicy.getSession());
                        databaseMapping.setAttributeValueInObject(object2, object3);
                        continue;
                    }
                    if (!databaseMapping.isTransformationMapping()) continue;
                    databaseMapping.setAttributeValueInObject(object2, null);
                }
            }
        }
        if (this.descriptor.getEventManager().hasAnyEventListeners()) {
            DescriptorEvent descriptorEvent = new DescriptorEvent(object2);
            descriptorEvent.setSession(objectCopyingPolicy.getSession());
            descriptorEvent.setOriginalObject(object);
            descriptorEvent.setEventCode(10);
            this.descriptor.getEventManager().executeEvent(descriptorEvent);
        }
        return object2;
    }

    public ObjectChangeSet createObjectChangeSet(Object object, UnitOfWorkChangeSet unitOfWorkChangeSet, AbstractSession abstractSession) {
        boolean bl = ((UnitOfWorkImpl)abstractSession).isObjectNew(object);
        return this.createObjectChangeSet(object, unitOfWorkChangeSet, bl, abstractSession);
    }

    public ObjectChangeSet createObjectChangeSet(Object object, UnitOfWorkChangeSet unitOfWorkChangeSet, boolean bl, AbstractSession abstractSession) {
        return this.createObjectChangeSet(object, unitOfWorkChangeSet, bl, false, abstractSession);
    }

    public ObjectChangeSet createObjectChangeSet(Object object, UnitOfWorkChangeSet unitOfWorkChangeSet, boolean bl, boolean bl2, AbstractSession abstractSession) {
        Vector vector;
        ObjectChangeSet objectChangeSet = (ObjectChangeSet)unitOfWorkChangeSet.getObjectChangeSetForClone(object);
        if (objectChangeSet == null) {
            objectChangeSet = this.descriptor.isAggregateDescriptor() ? new AggregateObjectChangeSet(new Vector(0), this.descriptor.getJavaClass(), object, unitOfWorkChangeSet, bl) : new ObjectChangeSet(this.extractPrimaryKeyFromObject(object, abstractSession, true), this.descriptor.getJavaClass(), object, unitOfWorkChangeSet, bl);
            objectChangeSet.setIsAggregate(this.descriptor.isDescriptorTypeAggregate());
            unitOfWorkChangeSet.addObjectChangeSetForIdentity(objectChangeSet, object);
        } else if (bl2 && !objectChangeSet.isAggregate() && (vector = this.extractPrimaryKeyFromObject(object, abstractSession, true)) != null) {
            objectChangeSet.setCacheKey(new CacheKey(vector));
        }
        return objectChangeSet;
    }

    public void createPrimaryKeyExpression(AbstractSession abstractSession) {
        Expression expression = null;
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        List<DatabaseField> list = this.descriptor.getPrimaryKeyFields();
        for (int i = 0; i < list.size(); ++i) {
            DatabaseField databaseField = list.get(i);
            Expression expression2 = ((Expression)expressionBuilder).getField(databaseField);
            Expression expression3 = expressionBuilder.getParameter(databaseField);
            Expression expression4 = expression2.equal(expression3);
            expression = expression == null ? expression4 : expression.and(expression4);
        }
        this.setPrimaryKeyExpression(expression);
    }

    public Vector extractPrimaryKeyFromExpression(boolean bl, Expression expression, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        AbstractRecord abstractRecord2 = this.createRecord(this.getPrimaryKeyMappings().size(), abstractSession);
        expression.getBuilder().setSession(abstractSession.getRootSession(null));
        boolean bl2 = expression.extractPrimaryKeyValues(bl, this.descriptor, abstractRecord2, abstractRecord);
        if (bl && !bl2) {
            return null;
        }
        if (abstractRecord2.size() != this.descriptor.getPrimaryKeyFields().size()) {
            return null;
        }
        return this.extractPrimaryKeyFromRow(abstractRecord2, abstractSession);
    }

    public Vector extractPrimaryKeyFromObject(Object object, AbstractSession abstractSession) {
        return this.extractPrimaryKeyFromObject(object, abstractSession, false);
    }

    public Vector extractPrimaryKeyFromObject(Object object, AbstractSession abstractSession, boolean bl) {
        Cloneable cloneable;
        boolean bl2 = object instanceof PersistenceEntity;
        if (bl2 && (cloneable = ((PersistenceEntity)object)._persistence_getPKVector()) != null) {
            return cloneable;
        }
        cloneable = this.descriptor;
        boolean bl3 = false;
        if (((ClassDescriptor)cloneable).hasInheritance() && object.getClass() != ((ClassDescriptor)cloneable).getJavaClass() && !object.getClass().getSuperclass().equals(((ClassDescriptor)cloneable).getJavaClass())) {
            return abstractSession.getDescriptor(object).getObjectBuilder().extractPrimaryKeyFromObject(object, abstractSession, bl);
        }
        IdValidation idValidation = ((ClassDescriptor)cloneable).getIdValidation();
        List<DatabaseField> list = ((ClassDescriptor)cloneable).getPrimaryKeyFields();
        NonSynchronizedVector nonSynchronizedVector = new NonSynchronizedVector(list.size());
        List<DatabaseMapping> list2 = this.getPrimaryKeyMappings();
        int n = list2.size();
        if (((ClassDescriptor)cloneable).hasSimplePrimaryKey()) {
            for (int i = 0; i < n; ++i) {
                AbstractDirectMapping abstractDirectMapping = (AbstractDirectMapping)list2.get(i);
                Object object2 = abstractDirectMapping.valueFromObject(object, list.get(i), abstractSession);
                if (idValidation != IdValidation.NONE && (object2 == null || idValidation == IdValidation.ZERO && Helper.isEquivalentToNull(object2))) {
                    if (bl) {
                        return null;
                    }
                    bl3 = true;
                }
                ((Vector)nonSynchronizedVector).add(object2);
            }
        } else {
            Cloneable cloneable2;
            AbstractRecord abstractRecord = this.createRecordForPKExtraction(n, abstractSession);
            for (int i = 0; i < n; ++i) {
                cloneable2 = list2.get(i);
                if (cloneable2 == null) continue;
                ((DatabaseMapping)cloneable2).writeFromObjectIntoRow(object, abstractRecord, abstractSession);
            }
            List<Class> list3 = this.getPrimaryKeyClassifications();
            cloneable2 = abstractSession.getPlatform(object.getClass());
            for (int i = 0; i < n; ++i) {
                Class clazz = list3.get(i);
                Object object3 = abstractRecord.get(list.get(i));
                if (idValidation != IdValidation.NONE && (object3 == null || idValidation == IdValidation.ZERO && Helper.isEquivalentToNull(object3))) {
                    if (bl) {
                        return null;
                    }
                    bl3 = true;
                }
                ((Vector)nonSynchronizedVector).add(cloneable2.convertObject(object3, clazz));
            }
        }
        if (bl2 && !bl3) {
            ((PersistenceEntity)object)._persistence_setPKVector(nonSynchronizedVector);
        }
        return nonSynchronizedVector;
    }

    public Vector extractPrimaryKeyFromRow(AbstractRecord abstractRecord, AbstractSession abstractSession) {
        List<DatabaseField> list = this.descriptor.getPrimaryKeyFields();
        List<Class> list2 = this.getPrimaryKeyClassifications();
        int n = list.size();
        NonSynchronizedVector nonSynchronizedVector = new NonSynchronizedVector(n);
        for (int i = 0; i < n; ++i) {
            DatabaseField databaseField = list.get(i);
            Class clazz = list2.get(i);
            Object object = abstractRecord.get(databaseField);
            if (object != null) {
                if (object.getClass() != clazz) {
                    object = abstractSession.getPlatform(this.descriptor.getJavaClass()).convertObject(object, clazz);
                }
            } else {
                return null;
            }
            ((Vector)nonSynchronizedVector).addElement(object);
        }
        return nonSynchronizedVector;
    }

    public AbstractRecord extractPrimaryKeyRowFromExpression(Expression expression, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        AbstractRecord abstractRecord2 = this.createRecord(this.getPrimaryKeyMappings().size(), abstractSession);
        expression.getBuilder().setSession(abstractSession.getRootSession(null));
        boolean bl = expression.extractPrimaryKeyValues(true, this.descriptor, abstractRecord2, abstractRecord);
        if (!bl) {
            return null;
        }
        if (abstractRecord2.size() != this.descriptor.getPrimaryKeyFields().size()) {
            return null;
        }
        return abstractRecord2;
    }

    public AbstractRecord extractPrimaryKeyRowFromObject(Object object, AbstractSession abstractSession) {
        AbstractRecord abstractRecord = this.createRecord(this.getPrimaryKeyMappings().size(), abstractSession);
        for (int i = 0; i < this.getPrimaryKeyMappings().size(); ++i) {
            this.getPrimaryKeyMappings().get(i).writeFromObjectIntoRow(object, abstractRecord, abstractSession);
        }
        if (this.descriptor.hasSimplePrimaryKey()) {
            return abstractRecord;
        }
        AbstractRecord abstractRecord2 = this.createRecord(this.getPrimaryKeyMappings().size(), abstractSession);
        List<DatabaseField> list = this.descriptor.getPrimaryKeyFields();
        for (int i = 0; i < list.size(); ++i) {
            Class clazz = this.getPrimaryKeyClassifications().get(i);
            DatabaseField databaseField = list.get(i);
            Object object2 = abstractRecord.get(databaseField);
            abstractRecord2.put(databaseField, abstractSession.getPlatform(object.getClass()).convertObject(object2, clazz));
        }
        return abstractRecord2;
    }

    public Object extractValueFromObjectForField(Object object, DatabaseField databaseField, AbstractSession abstractSession) throws DescriptorException {
        ClassDescriptor classDescriptor = null;
        if (this.descriptor.hasInheritance() && object.getClass() != this.descriptor.getJavaClass() && (classDescriptor = abstractSession.getDescriptor(object)).getJavaClass() != this.descriptor.getJavaClass()) {
            if (classDescriptor.isAggregateCollectionDescriptor()) {
                classDescriptor = this.descriptor.getInheritancePolicy().getDescriptor(classDescriptor.getJavaClass());
            }
            return classDescriptor.getObjectBuilder().extractValueFromObjectForField(object, databaseField, abstractSession);
        }
        DatabaseMapping databaseMapping = this.getMappingForField(databaseField);
        if (databaseMapping == null) {
            throw DescriptorException.missingMappingForField(databaseField, this.descriptor);
        }
        return databaseMapping.valueFromObject(object, databaseField, abstractSession);
    }

    public void fixObjectReferences(Object object, Map map, Map map2, ObjectLevelReadQuery objectLevelReadQuery, RemoteSession remoteSession) {
        ObjectBuilder objectBuilder = this.descriptor.getObjectBuilder();
        if (!objectBuilder.isSimple()) {
            List<DatabaseMapping> list = objectBuilder.getRelationshipMappings();
            for (int i = 0; i < list.size(); ++i) {
                list.get(i).fixObjectReferences(object, map, map2, objectLevelReadQuery, remoteSession);
            }
        }
    }

    public DatabaseMapping getBaseMappingForField(DatabaseField databaseField) {
        DatabaseMapping databaseMapping = this.getMappingForField(databaseField);
        while (databaseMapping.isAggregateObjectMapping()) {
            databaseMapping = ((AggregateObjectMapping)databaseMapping).getReferenceDescriptor().getObjectBuilder().getMappingForField(databaseField);
        }
        return databaseMapping;
    }

    public Object getBaseValueForField(DatabaseField databaseField, Object object) {
        Object object2 = object;
        DatabaseMapping databaseMapping = this.getMappingForField(databaseField);
        while (databaseMapping.isAggregateObjectMapping()) {
            object2 = databaseMapping.getAttributeValueFromObject(object2);
            databaseMapping = ((AggregateMapping)databaseMapping).getReferenceDescriptor().getObjectBuilder().getMappingForField(databaseField);
        }
        return databaseMapping.getAttributeValueFromObject(object2);
    }

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Class getFieldClassification(DatabaseField databaseField) throws DescriptorException {
        DatabaseMapping databaseMapping = this.getMappingForField(databaseField);
        if (databaseMapping == null) {
            return null;
        }
        return databaseMapping.getFieldClassification(databaseField);
    }

    public DatabaseField getFieldForQueryKeyName(String string) {
        QueryKey queryKey = this.descriptor.getQueryKeyNamed(string);
        if (queryKey == null) {
            DatabaseMapping databaseMapping = this.getMappingForAttributeName(string);
            if (databaseMapping == null) {
                return null;
            }
            if (databaseMapping.getFields().isEmpty()) {
                return null;
            }
            return databaseMapping.getFields().get(0);
        }
        if (queryKey.isDirectQueryKey()) {
            return ((DirectQueryKey)queryKey).getField();
        }
        return null;
    }

    public Map<DatabaseField, DatabaseField> getFieldsMap() {
        return this.fieldsMap;
    }

    protected void setFieldsMap(Map map) {
        this.fieldsMap = map;
    }

    public List<DatabaseMapping> getCloningMappings() {
        return this.cloningMappings;
    }

    public boolean isSimple() {
        return this.isSimple;
    }

    public List<DatabaseMapping> getRelationshipMappings() {
        return this.relationshipMappings;
    }

    public List<DatabaseMapping> getEagerMappings() {
        return this.eagerMappings;
    }

    public List<DatabaseMapping> getJoinedAttributes() {
        return this.joinedAttributes;
    }

    public AbstractDirectMapping getSequenceMapping() {
        return this.sequenceMapping;
    }

    public void setSequenceMapping(AbstractDirectMapping abstractDirectMapping) {
        this.sequenceMapping = abstractDirectMapping;
    }

    public boolean hasJoinedAttributes() {
        return this.joinedAttributes != null;
    }

    public DatabaseMapping getMappingForAttributeName(String string) {
        return this.getMappingsByAttribute().get(string);
    }

    public DatabaseMapping getMappingForField(DatabaseField databaseField) {
        return this.getMappingsByField().get(databaseField);
    }

    public List<DatabaseMapping> getReadOnlyMappingsForField(DatabaseField databaseField) {
        return this.getReadOnlyMappingsByField().get(databaseField);
    }

    protected Map<String, DatabaseMapping> getMappingsByAttribute() {
        return this.mappingsByAttribute;
    }

    public Map<DatabaseField, DatabaseMapping> getMappingsByField() {
        return this.mappingsByField;
    }

    public Map<DatabaseField, List<DatabaseMapping>> getReadOnlyMappingsByField() {
        return this.readOnlyMappingsByField;
    }

    protected List<DatabaseMapping> getNonPrimaryKeyMappings() {
        return this.nonPrimaryKeyMappings;
    }

    public Object getParentObjectForField(DatabaseField databaseField, Object object) {
        Object object2 = object;
        DatabaseMapping databaseMapping = this.getMappingForField(databaseField);
        while (databaseMapping.isAggregateObjectMapping()) {
            object2 = databaseMapping.getAttributeValueFromObject(object2);
            databaseMapping = ((AggregateMapping)databaseMapping).getReferenceDescriptor().getObjectBuilder().getMappingForField(databaseField);
        }
        return object2;
    }

    public List<Class> getPrimaryKeyClassifications() {
        if (this.primaryKeyClassifications == null) {
            List<DatabaseField> list = this.descriptor.getPrimaryKeyFields();
            ArrayList<Class> arrayList = new ArrayList<Class>(list.size());
            for (int i = 0; i < list.size(); ++i) {
                DatabaseMapping databaseMapping = this.getPrimaryKeyMappings().get(i);
                DatabaseField databaseField = list.get(i);
                if (databaseMapping != null) {
                    arrayList.add(Helper.getObjectClass(databaseMapping.getFieldClassification(databaseField)));
                } else {
                    arrayList.add(null);
                }
                this.primaryKeyClassifications = arrayList;
            }
        }
        return this.primaryKeyClassifications;
    }

    public Expression getPrimaryKeyExpression() {
        return this.primaryKeyExpression;
    }

    public List<DatabaseMapping> getPrimaryKeyMappings() {
        return this.primaryKeyMappings;
    }

    public DatabaseField getTargetFieldForQueryKeyName(String string) {
        DatabaseMapping databaseMapping = this.getMappingForAttributeName(string);
        if (databaseMapping != null && databaseMapping.isDirectToFieldMapping()) {
            return ((AbstractDirectMapping)databaseMapping).getField();
        }
        QueryKey queryKey = this.descriptor.getQueryKeyNamed(string);
        if (queryKey != null && queryKey.isDirectQueryKey()) {
            return ((DirectQueryKey)queryKey).getField();
        }
        return null;
    }

    public void initialize(AbstractSession abstractSession) throws DescriptorException {
        this.getMappingsByField().clear();
        this.getReadOnlyMappingsByField().clear();
        this.getMappingsByAttribute().clear();
        this.getCloningMappings().clear();
        this.getEagerMappings().clear();
        this.getRelationshipMappings().clear();
        Object object = this.descriptor.getMappings().elements();
        while (object.hasMoreElements()) {
            DatabaseMapping databaseMapping = object.nextElement();
            if (!databaseMapping.isWriteOnly()) {
                this.getMappingsByAttribute().put(databaseMapping.getAttributeName(), databaseMapping);
            }
            if (databaseMapping.isCloningRequired()) {
                this.getCloningMappings().add(databaseMapping);
            }
            if (databaseMapping.isForeignReferenceMapping() && ((ForeignReferenceMapping)databaseMapping).usesIndirection() && !databaseMapping.isLazy()) {
                this.getEagerMappings().add(databaseMapping);
            }
            if (!databaseMapping.isDirectToFieldMapping()) {
                this.getRelationshipMappings().add(databaseMapping);
            }
            for (DatabaseField databaseField : databaseMapping.getFields()) {
                Object object2;
                if (databaseMapping.isReadOnly()) {
                    object2 = this.getReadOnlyMappingsByField().get(databaseField);
                    if (object2 == null) {
                        object2 = new ArrayList<DatabaseMapping>();
                        this.getReadOnlyMappingsByField().put(databaseField, (List<DatabaseMapping>)object2);
                    }
                    object2.add(databaseMapping);
                    continue;
                }
                if (databaseMapping.isAggregateObjectMapping()) {
                    object2 = ((AggregateObjectMapping)databaseMapping).getReferenceDescriptor().getObjectBuilder();
                    DatabaseMapping databaseMapping2 = ((ObjectBuilder)object2).getMappingForField(databaseField);
                    if (databaseMapping2 == null) {
                        List<DatabaseMapping> list = this.getReadOnlyMappingsByField().get(databaseField);
                        if (list == null) {
                            list = new ArrayList<DatabaseMapping>();
                            this.getReadOnlyMappingsByField().put(databaseField, list);
                        }
                        list.add(databaseMapping);
                        continue;
                    }
                    this.getMappingsByField().put(databaseField, databaseMapping);
                    continue;
                }
                if (this.getMappingsByField().containsKey(databaseField)) {
                    abstractSession.getIntegrityChecker().handleError(DescriptorException.multipleWriteMappingsForField(databaseField.toString(), databaseMapping));
                    continue;
                }
                this.getMappingsByField().put(databaseField, databaseMapping);
            }
        }
        this.isSimple = this.getRelationshipMappings().isEmpty();
        this.initializePrimaryKey(abstractSession);
        this.initializeJoinedAttributes();
        if (this.descriptor.usesSequenceNumbers() && (object = this.getMappingForField(this.descriptor.getSequenceNumberField())) != null && ((DatabaseMapping)object).isDirectToFieldMapping()) {
            this.setSequenceMapping((AbstractDirectMapping)object);
        }
    }

    public void recordPrivateOwnedRemovals(Object object, UnitOfWorkImpl unitOfWorkImpl, boolean bl) {
        if (!this.descriptor.isAggregateCollectionDescriptor() && !this.descriptor.isAggregateDescriptor()) {
            if (!bl && unitOfWorkImpl.getDeletedObjects().containsKey(object)) {
                return;
            }
            unitOfWorkImpl.getDeletedObjects().put(object, object);
        }
        if (this.descriptor.hasMappingsPostCalculateChanges()) {
            for (DatabaseMapping databaseMapping : this.descriptor.getMappingsPostCalculateChanges()) {
                databaseMapping.recordPrivateOwnedRemovals(object, unitOfWorkImpl);
            }
        }
    }

    public void postInitialize(AbstractSession abstractSession) throws DescriptorException {
        this.hasWrapperPolicy = this.descriptor.hasWrapperPolicy() || abstractSession.getProject().hasProxyIndirection();
    }

    public void initializeJoinedAttributes() {
        ArrayList<DatabaseMapping> arrayList = null;
        Vector<DatabaseMapping> vector = this.descriptor.getMappings();
        for (int i = 0; i < vector.size(); ++i) {
            DatabaseMapping databaseMapping = (DatabaseMapping)vector.get(i);
            if (!databaseMapping.isForeignReferenceMapping() || !((ForeignReferenceMapping)databaseMapping).isJoinFetched()) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<DatabaseMapping>();
            }
            arrayList.add(databaseMapping);
        }
        this.joinedAttributes = arrayList;
    }

    protected void copyQueryInfoToCacheKey(CacheKey cacheKey, ObjectBuildingQuery objectBuildingQuery, AbstractRecord abstractRecord, AbstractSession abstractSession, ClassDescriptor classDescriptor) {
        cacheKey.setLastUpdatedQueryId(objectBuildingQuery.getQueryId());
        if (classDescriptor.usesOptimisticLocking()) {
            OptimisticLockingPolicy optimisticLockingPolicy = classDescriptor.getOptimisticLockingPolicy();
            Object object = optimisticLockingPolicy.getValueToPutInCache(abstractRecord, abstractSession);
            cacheKey.setWriteLockValue(object);
        }
        cacheKey.setReadTime(objectBuildingQuery.getExecutionTime());
    }

    /*
     * WARNING - void declaration
     */
    public void initializePrimaryKey(AbstractSession abstractSession) throws DescriptorException {
        void var4_11;
        int n;
        List<DatabaseField> list = this.descriptor.getPrimaryKeyFields();
        if (list.isEmpty() && this.getDescriptor().isAggregateCollectionDescriptor()) {
            DatabaseTable databaseTable = this.getDescriptor().getDefaultTable();
            for (DatabaseField databaseField : this.getDescriptor().getFields()) {
                if (!databaseField.getTable().equals(databaseTable) || !this.getMappingsByField().containsKey(databaseField)) continue;
                list.add(databaseField);
            }
            list.addAll(this.descriptor.getAdditionalAggregateCollectionKeyFields());
        }
        this.createPrimaryKeyExpression(abstractSession);
        this.getPrimaryKeyMappings().clear();
        this.getNonPrimaryKeyMappings().clear();
        for (DatabaseField databaseField : this.getMappingsByField().keySet()) {
            if (list.contains(databaseField)) continue;
            DatabaseMapping databaseMapping = this.getMappingForField(databaseField);
            if (this.getNonPrimaryKeyMappings().contains(databaseMapping)) continue;
            this.getNonPrimaryKeyMappings().add(databaseMapping);
        }
        for (n = 0; n < list.size(); ++n) {
            DatabaseField databaseField = list.get(n);
            DatabaseMapping databaseMapping = this.getMappingForField(databaseField);
            if (databaseMapping == null && !this.descriptor.isDescriptorTypeAggregate()) {
                throw DescriptorException.noMappingForPrimaryKey(databaseField, this.descriptor);
            }
            this.getPrimaryKeyMappings().add(databaseMapping);
            if (databaseMapping != null) {
                databaseMapping.setIsPrimaryKeyMapping(true);
            }
            if (!this.descriptor.hasMultipleTables() || databaseMapping == null) continue;
            for (Map<DatabaseField, DatabaseField> map : this.descriptor.getAdditionalTablePrimaryKeyFields().values()) {
                DatabaseField databaseField2 = map.get(databaseField);
                if (databaseField2 == null) continue;
                this.getMappingsByField().put(databaseField2, databaseMapping);
                if (!databaseMapping.isAggregateObjectMapping()) continue;
                ((AggregateObjectMapping)databaseMapping).addPrimaryKeyJoinField(databaseField, databaseField2);
            }
        }
        n = 1;
        boolean bl = false;
        while (var4_11 < this.getPrimaryKeyMappings().size()) {
            DatabaseMapping databaseMapping = this.getPrimaryKeyMappings().get((int)var4_11);
            if (databaseMapping == null || !databaseMapping.isDirectToFieldMapping()) {
                n = 0;
                break;
            }
            ++var4_11;
        }
        this.descriptor.setHasSimplePrimaryKey(n != 0);
    }

    public Object instantiateClone(Object object, AbstractSession abstractSession) {
        Object object2 = this.descriptor.getCopyPolicy().buildClone(object, abstractSession);
        if (object2 instanceof ChangeTracker) {
            ((ChangeTracker)object2)._persistence_setPropertyChangeListener(null);
        }
        return object2;
    }

    public Object instantiateWorkingCopyClone(Object object, AbstractSession abstractSession) {
        return this.descriptor.getCopyPolicy().buildWorkingCopyClone(object, abstractSession);
    }

    public Object instantiateWorkingCopyCloneFromRow(AbstractRecord abstractRecord, ObjectBuildingQuery objectBuildingQuery, Vector vector, UnitOfWorkImpl unitOfWorkImpl) {
        return this.descriptor.getCopyPolicy().buildWorkingCopyCloneFromRow(abstractRecord, objectBuildingQuery, vector, unitOfWorkImpl);
    }

    public boolean isPrimaryKeyMapping(DatabaseMapping databaseMapping) {
        return this.getPrimaryKeyMappings().contains(databaseMapping);
    }

    public void iterate(DescriptorIterator descriptorIterator) {
        List<DatabaseMapping> list;
        if (descriptorIterator.shouldIterateOnPrimitives()) {
            list = this.descriptor.getMappings();
        } else {
            ObjectBuilder objectBuilder = this.descriptor.getObjectBuilder();
            if (objectBuilder.isSimple()) {
                return;
            }
            list = objectBuilder.getRelationshipMappings();
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            list.get(i).iterate(descriptorIterator);
        }
    }

    public void mergeChangesIntoObject(Object object, ObjectChangeSet objectChangeSet, Object object2, MergeManager mergeManager) {
        this.mergeChangesIntoObject(object, objectChangeSet, object2, mergeManager, false);
    }

    public void mergeChangesIntoObject(Object object, ObjectChangeSet objectChangeSet, Object object2, MergeManager mergeManager, boolean bl) {
        Serializable serializable;
        if (object2 != null && objectChangeSet.isNew() && !this.descriptor.shouldUseFullChangeSetsForNewObjects()) {
            this.mergeIntoObject(object, true, object2, mergeManager, false, bl);
        } else {
            serializable = objectChangeSet.getChanges();
            int n = serializable.size();
            for (int i = 0; i < n; ++i) {
                ChangeRecord changeRecord = (ChangeRecord)serializable.get(i);
                DatabaseMapping databaseMapping = this.getMappingForAttributeName(changeRecord.getAttribute());
                databaseMapping.mergeChangesIntoObject(object, changeRecord, object2, mergeManager);
            }
        }
        if (this.descriptor.getEventManager().hasAnyEventListeners()) {
            serializable = new DescriptorEvent(object);
            ((DescriptorEvent)serializable).setSession(mergeManager.getSession());
            ((DescriptorEvent)serializable).setOriginalObject(object2);
            ((DescriptorEvent)serializable).setChangeSet(objectChangeSet);
            ((DescriptorEvent)serializable).setEventCode(11);
            this.descriptor.getEventManager().executeEvent((DescriptorEvent)serializable);
        }
    }

    public void mergeIntoObject(Object object, boolean bl, Object object2, MergeManager mergeManager) {
        this.mergeIntoObject(object, bl, object2, mergeManager, false, false);
    }

    public void mergeIntoObject(Object object, boolean bl, Object object2, MergeManager mergeManager, boolean bl2, boolean bl3) {
        Vector<DatabaseMapping> vector = this.descriptor.getMappings();
        for (int i = 0; i < vector.size(); ++i) {
            DatabaseMapping databaseMapping = (DatabaseMapping)vector.get(i);
            if (!bl2 && !bl3 || bl2 && databaseMapping.isForeignReferenceMapping() || bl3 && databaseMapping.isCloningRequired()) {
                databaseMapping.mergeIntoObject(object, bl, object2, mergeManager);
                continue;
            }
            if (!bl3 || !databaseMapping.isCloningRequired()) continue;
            databaseMapping.mergeIntoObject(object, bl, object2, mergeManager);
        }
        if (this.descriptor.getEventManager().hasAnyEventListeners()) {
            DescriptorEvent descriptorEvent = new DescriptorEvent(object);
            descriptorEvent.setSession(mergeManager.getSession());
            descriptorEvent.setOriginalObject(object2);
            descriptorEvent.setEventCode(11);
            this.descriptor.getEventManager().executeEvent(descriptorEvent);
        }
    }

    public void populateAttributesForClone(Object object, Object object2, UnitOfWorkImpl unitOfWorkImpl) {
        Object object3;
        List<DatabaseMapping> list = this.getCloningMappings();
        int n = list.size();
        if (this.descriptor.hasFetchGroupManager() && this.descriptor.getFetchGroupManager().isPartialObject(object)) {
            object3 = this.descriptor.getFetchGroupManager();
            for (int i = 0; i < n; ++i) {
                DatabaseMapping databaseMapping = list.get(i);
                if (!((FetchGroupManager)object3).isAttributeFetched(object, databaseMapping.getAttributeName())) continue;
                databaseMapping.buildClone(object, object2, unitOfWorkImpl);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                list.get(i).buildClone(object, object2, unitOfWorkImpl);
            }
        }
        if (this.descriptor.getEventManager().hasAnyEventListeners()) {
            object3 = new DescriptorEvent(object2);
            ((DescriptorEvent)object3).setSession(unitOfWorkImpl);
            ((DescriptorEvent)object3).setOriginalObject(object);
            ((DescriptorEvent)object3).setEventCode(10);
            this.descriptor.getEventManager().executeEvent((DescriptorEvent)object3);
        }
    }

    public void rehashFieldDependancies(AbstractSession abstractSession) {
        this.setMappingsByField(Helper.rehashMap(this.getMappingsByField()));
        this.setReadOnlyMappingsByField(Helper.rehashMap(this.getReadOnlyMappingsByField()));
        this.setFieldsMap(Helper.rehashMap(this.getFieldsMap()));
        this.setPrimaryKeyMappings(new ArrayList<DatabaseMapping>(2));
        this.setNonPrimaryKeyMappings(new ArrayList<DatabaseMapping>(2));
        this.initializePrimaryKey(abstractSession);
    }

    public void setDescriptor(ClassDescriptor classDescriptor) {
        this.descriptor = classDescriptor;
    }

    protected void setMappingsByAttribute(Map<String, DatabaseMapping> map) {
        this.mappingsByAttribute = map;
    }

    public void setMappingsByField(Map<DatabaseField, DatabaseMapping> map) {
        this.mappingsByField = map;
    }

    public void setReadOnlyMappingsByField(Map<DatabaseField, List<DatabaseMapping>> map) {
        this.readOnlyMappingsByField = map;
    }

    protected void setNonPrimaryKeyMappings(List<DatabaseMapping> list) {
        this.nonPrimaryKeyMappings = list;
    }

    protected void setPrimaryKeyClassifications(List<Class> list) {
        this.primaryKeyClassifications = list;
    }

    public void setPrimaryKeyExpression(Expression expression) {
        this.primaryKeyExpression = expression;
    }

    protected void setPrimaryKeyMappings(List<DatabaseMapping> list) {
        this.primaryKeyMappings = list;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "(" + this.descriptor.toString() + ")";
    }

    public Object unwrapObject(Object object, AbstractSession abstractSession) {
        ClassDescriptor classDescriptor;
        if (!this.hasWrapperPolicy) {
            return object;
        }
        if (object == null) {
            return null;
        }
        if (!this.descriptor.hasWrapperPolicy() || this.descriptor.getJavaClass() == object.getClass() || !this.descriptor.getWrapperPolicy().isWrapped(object)) {
            if (abstractSession.getProject().hasProxyIndirection()) {
                return ProxyIndirectionPolicy.getValueFromProxy(object);
            }
            return object;
        }
        if (this.descriptor.hasInheritance() && this.descriptor.getInheritancePolicy().hasChildren() && (classDescriptor = abstractSession.getDescriptor(object)) != this.descriptor) {
            return classDescriptor.getObjectBuilder().unwrapObject(object, abstractSession);
        }
        return this.descriptor.getWrapperPolicy().unwrapObject(object, abstractSession);
    }

    public void validate(AbstractSession abstractSession) throws DescriptorException {
        if (this.descriptor.usesSequenceNumbers() && this.getMappingForField(this.descriptor.getSequenceNumberField()) == null) {
            throw DescriptorException.mappingForSequenceNumberField(this.descriptor);
        }
    }

    public boolean verifyDelete(Object object, AbstractSession abstractSession) {
        Cloneable cloneable;
        Object object2;
        AbstractRecord abstractRecord = this.buildRowForTranslation(object, abstractSession);
        if (this.descriptor.getQueryManager().getReadObjectQuery() != null && this.descriptor.getQueryManager().getReadObjectQuery().isCallQuery()) {
            object2 = abstractSession.readObject(object);
            if (object2 != null) {
                return false;
            }
        } else {
            object2 = this.descriptor.getTables().elements();
            while (object2.hasMoreElements()) {
                cloneable = object2.nextElement();
                SQLSelectStatement sQLSelectStatement = new SQLSelectStatement();
                sQLSelectStatement.addTable((DatabaseTable)cloneable);
                if (cloneable == this.descriptor.getTables().firstElement()) {
                    sQLSelectStatement.setWhereClause((Expression)this.getPrimaryKeyExpression().clone());
                } else {
                    sQLSelectStatement.setWhereClause(this.buildPrimaryKeyExpression((DatabaseTable)cloneable));
                }
                DatabaseField databaseField = new DatabaseField("*");
                databaseField.setTable((DatabaseTable)cloneable);
                sQLSelectStatement.addField(databaseField);
                sQLSelectStatement.normalize(abstractSession, null);
                DataReadQuery dataReadQuery = new DataReadQuery();
                dataReadQuery.setSQLStatement(sQLSelectStatement);
                dataReadQuery.setSessionName(this.descriptor.getSessionName());
                List list = (List)abstractSession.executeQuery((DatabaseQuery)dataReadQuery, abstractRecord);
                if (list.isEmpty()) continue;
                return false;
            }
        }
        object2 = this.descriptor.getMappings().elements();
        while (object2.hasMoreElements()) {
            cloneable = object2.nextElement();
            if (((DatabaseMapping)cloneable).verifyDelete(object, abstractSession)) continue;
            return false;
        }
        return true;
    }

    public boolean hasWrapperPolicy() {
        return this.hasWrapperPolicy;
    }

    public void setHasWrapperPolicy(boolean bl) {
        this.hasWrapperPolicy = bl;
    }

    public Object wrapObject(Object object, AbstractSession abstractSession) {
        ClassDescriptor classDescriptor;
        if (!this.hasWrapperPolicy) {
            return object;
        }
        if (object == null) {
            return null;
        }
        if (!this.descriptor.hasWrapperPolicy() || this.descriptor.getWrapperPolicy().isWrapped(object)) {
            return object;
        }
        if (this.descriptor.hasInheritance() && this.descriptor.getInheritancePolicy().hasChildren() && object.getClass() != this.descriptor.getJavaClass() && (classDescriptor = abstractSession.getDescriptor(object)) != this.descriptor) {
            return classDescriptor.getObjectBuilder().wrapObject(object, abstractSession);
        }
        return this.descriptor.getWrapperPolicy().wrapObject(object, abstractSession);
    }
}

