/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityWeakHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    static final long serialVersionUID = -5176951017503351630L;
    static final int DEFAULT_INITIAL_CAPACITY = 32;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected transient WeakEntry<K, V>[] entries;
    protected transient int count = 0;
    private transient int modCount = 0;
    protected int threshold = 0;
    protected float loadFactor = 0.0f;
    protected ReferenceQueue referenceQueue;
    private transient Set keySet = null;
    private transient Set entrySet = null;
    private transient Collection values = null;
    private static EmptyHashIterator emptyHashIterator = new EmptyHashIterator();

    public IdentityWeakHashMap(int n, float f) {
        int n2;
        if (n < 0) {
            throw new IllegalArgumentException("Illegal initialCapacity: " + n);
        }
        if (n > 0x40000000) {
            n = 0x40000000;
        }
        if (f <= 0.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException("Illegal loadFactor: " + f);
        }
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        this.loadFactor = f;
        this.threshold = (int)((float)n2 * f);
        this.entries = new WeakEntry[n2];
        this.referenceQueue = new ReferenceQueue();
    }

    public IdentityWeakHashMap(int n) {
        this(n, 0.75f);
    }

    public IdentityWeakHashMap() {
        this.loadFactor = 0.75f;
        this.threshold = 24;
        this.entries = new WeakEntry[32];
        this.referenceQueue = new ReferenceQueue();
    }

    public IdentityWeakHashMap(Map map) {
        this(Math.max((int)((float)map.size() / 0.75f) + 1, 32), 0.75f);
        this.putAll(map);
    }

    @Override
    public int size() {
        this.cleanUp();
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public boolean containsValue(Object object) {
        if (object == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("null_not_supported_identityweakhashmap"));
        }
        this.cleanUp();
        WeakEntry<K, V>[] weakEntryArray = this.entries;
        int n = weakEntryArray.length;
        while (n-- > 0) {
            WeakEntry<K, V> weakEntry = weakEntryArray[n];
            while (weakEntry != null) {
                if (object.equals(weakEntry.value.get())) {
                    return true;
                }
                weakEntry = weakEntry.next;
            }
        }
        return false;
    }

    @Override
    public boolean containsKey(Object object) {
        if (object == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("null_not_supported_identityweakhashmap"));
        }
        this.cleanUp();
        WeakEntry<K, V>[] weakEntryArray = this.entries;
        int n = System.identityHashCode(object);
        int n2 = (n & Integer.MAX_VALUE) % weakEntryArray.length;
        WeakEntry<K, V> weakEntry = weakEntryArray[n2];
        while (weakEntry != null) {
            if (weakEntry.key.get() == object) {
                return true;
            }
            weakEntry = weakEntry.next;
        }
        return false;
    }

    @Override
    public V get(Object object) {
        if (object == null) {
            return null;
        }
        this.cleanUp();
        WeakEntry<K, V>[] weakEntryArray = this.entries;
        int n = System.identityHashCode(object);
        int n2 = (n & Integer.MAX_VALUE) % weakEntryArray.length;
        WeakEntry<K, V> weakEntry = weakEntryArray[n2];
        while (weakEntry != null) {
            if (weakEntry.key.get() == object) {
                return weakEntry.value.get();
            }
            weakEntry = weakEntry.next;
        }
        return null;
    }

    private void rehash() {
        int n = this.entries.length;
        WeakEntry<K, V>[] weakEntryArray = this.entries;
        int n2 = n * 2 + 1;
        WeakEntry[] weakEntryArray2 = new WeakEntry[n2];
        ++this.modCount;
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.entries = weakEntryArray2;
        int n3 = n;
        while (n3-- > 0) {
            WeakEntry<K, V> weakEntry = weakEntryArray[n3];
            while (weakEntry != null) {
                WeakEntry<K, V> weakEntry2 = weakEntry;
                weakEntry = weakEntry.next;
                int n4 = (weakEntry2.hash & Integer.MAX_VALUE) % n2;
                weakEntry2.next = weakEntryArray2[n4];
                weakEntryArray2[n4] = weakEntry2;
            }
        }
    }

    @Override
    public V put(K k, V v) {
        if (v == null || k == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("null_not_supported_identityweakhashmap"));
        }
        this.cleanUp();
        WeakEntry<K, V>[] weakEntryArray = this.entries;
        int n = System.identityHashCode(k);
        int n2 = (n & Integer.MAX_VALUE) % weakEntryArray.length;
        WeakEntry<K, V> weakEntry = weakEntryArray[n2];
        while (weakEntry != null) {
            if (weakEntry.key.get() == k) {
                EntryReference entryReference = weakEntry.value;
                weakEntry.value = k == v ? weakEntry.key : new HardEntryReference<V>(v);
                return entryReference.get();
            }
            weakEntry = weakEntry.next;
        }
        ++this.modCount;
        if (this.count >= this.threshold) {
            this.rehash();
            weakEntryArray = this.entries;
            n2 = (n & Integer.MAX_VALUE) % weakEntryArray.length;
        }
        weakEntryArray[n2] = weakEntry = new WeakEntry<K, V>(n, k, v, weakEntryArray[n2], this.referenceQueue);
        ++this.count;
        return null;
    }

    @Override
    public V remove(Object object) {
        if (object == null) {
            return null;
        }
        this.cleanUp();
        WeakEntry<K, V>[] weakEntryArray = this.entries;
        int n = System.identityHashCode(object);
        int n2 = (n & Integer.MAX_VALUE) % weakEntryArray.length;
        WeakEntry<K, V> weakEntry = weakEntryArray[n2];
        WeakEntry<K, V> weakEntry2 = null;
        while (weakEntry != null) {
            if (weakEntry.key.get() == object) {
                if (weakEntry2 != null) {
                    weakEntry2.next = weakEntry.next;
                } else {
                    weakEntryArray[n2] = weakEntry.next;
                }
                --this.count;
                return weakEntry.value.get();
            }
            weakEntry2 = weakEntry;
            weakEntry = weakEntry.next;
        }
        return null;
    }

    protected boolean removeEntry(WeakEntry weakEntry) {
        WeakEntry<K, V>[] weakEntryArray = this.entries;
        int n = (weakEntry.hash & Integer.MAX_VALUE) % weakEntryArray.length;
        WeakEntry<K, V> weakEntry2 = weakEntryArray[n];
        WeakEntry<K, V> weakEntry3 = null;
        while (weakEntry2 != null) {
            if (weakEntry2 == weakEntry) {
                ++this.modCount;
                if (weakEntry3 != null) {
                    weakEntry3.next = weakEntry2.next;
                } else {
                    weakEntryArray[n] = weakEntry2.next;
                }
                --this.count;
                weakEntry2.value = null;
                weakEntry2.next = null;
                return true;
            }
            weakEntry3 = weakEntry2;
            weakEntry2 = weakEntry2.next;
        }
        return false;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        if (map == null) {
            throw new NullPointerException();
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        if (this.count > 0) {
            ++this.modCount;
            WeakEntry<K, V>[] weakEntryArray = this.entries;
            int n = weakEntryArray.length;
            while (--n >= 0) {
                weakEntryArray[n] = null;
            }
            this.count = 0;
        }
    }

    protected void cleanUp() {
        WeakEntryReference weakEntryReference = (WeakEntryReference)this.referenceQueue.poll();
        while (weakEntryReference != null) {
            this.removeEntry(weakEntryReference.owner);
            weakEntryReference = (WeakEntryReference)this.referenceQueue.poll();
        }
    }

    @Override
    public Object clone() {
        try {
            WeakEntry<K, V>[] weakEntryArray = this.entries;
            IdentityWeakHashMap identityWeakHashMap = (IdentityWeakHashMap)super.clone();
            identityWeakHashMap.referenceQueue = new ReferenceQueue();
            identityWeakHashMap.entries = new WeakEntry[weakEntryArray.length];
            int n = weakEntryArray.length;
            while (n-- > 0) {
                identityWeakHashMap.entries[n] = weakEntryArray[n] != null ? (WeakEntry)weakEntryArray[n].clone(identityWeakHashMap.referenceQueue) : null;
            }
            identityWeakHashMap.keySet = null;
            identityWeakHashMap.entrySet = null;
            identityWeakHashMap.values = null;
            identityWeakHashMap.modCount = 0;
            return identityWeakHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet(){

                public Iterator iterator() {
                    return IdentityWeakHashMap.this.getHashIterator(COMPONENT_TYPES.KEYS);
                }

                public int size() {
                    return IdentityWeakHashMap.this.count;
                }

                public boolean contains(Object object) {
                    return IdentityWeakHashMap.this.containsKey(object);
                }

                public boolean remove(Object object) {
                    int n = IdentityWeakHashMap.this.count;
                    IdentityWeakHashMap.this.remove(object);
                    return IdentityWeakHashMap.this.count != n;
                }

                public void clear() {
                    IdentityWeakHashMap.this.clear();
                }
            };
        }
        return this.keySet;
    }

    @Override
    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(){

                public Iterator iterator() {
                    return IdentityWeakHashMap.this.getHashIterator(COMPONENT_TYPES.VALUES);
                }

                public int size() {
                    return IdentityWeakHashMap.this.count;
                }

                public boolean contains(Object object) {
                    return IdentityWeakHashMap.this.containsValue(object);
                }

                public void clear() {
                    IdentityWeakHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Override
    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet(){

                public Iterator iterator() {
                    return IdentityWeakHashMap.this.getHashIterator(COMPONENT_TYPES.ENTRIES);
                }

                public boolean contains(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Object k = entry.getKey();
                    WeakEntry<K, V>[] weakEntryArray = IdentityWeakHashMap.this.entries;
                    int n = System.identityHashCode(k);
                    int n2 = (n & Integer.MAX_VALUE) % weakEntryArray.length;
                    WeakEntry weakEntry = weakEntryArray[n2];
                    while (weakEntry != null) {
                        if (weakEntry.hash == n && weakEntry.equals(entry)) {
                            return true;
                        }
                        weakEntry = weakEntry.next;
                    }
                    return false;
                }

                public boolean remove(Object object) {
                    if (!(object instanceof WeakEntry)) {
                        return false;
                    }
                    WeakEntry weakEntry = (WeakEntry)object;
                    return IdentityWeakHashMap.this.removeEntry(weakEntry);
                }

                public int size() {
                    return IdentityWeakHashMap.this.count;
                }

                public void clear() {
                    IdentityWeakHashMap.this.clear();
                }
            };
        }
        return this.entrySet;
    }

    private Iterator getHashIterator(COMPONENT_TYPES cOMPONENT_TYPES) {
        if (this.count == 0) {
            return emptyHashIterator;
        }
        return new HashIterator(cOMPONENT_TYPES);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.entries.length);
        objectOutputStream.writeInt(this.count);
        for (int i = this.entries.length - 1; i >= 0; --i) {
            WeakEntry<K, V> weakEntry = this.entries[i];
            while (weakEntry != null) {
                objectOutputStream.writeObject(weakEntry.key.get());
                objectOutputStream.writeObject(weakEntry.value.get());
                weakEntry = weakEntry.next;
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.entries = new WeakEntry[n];
        int n2 = objectInputStream.readInt();
        for (int i = 0; i < n2; ++i) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            if (object == null || object2 == null) continue;
            this.put(object, object2);
        }
    }

    private class HashIterator
    implements Iterator {
        WeakEntry[] entries;
        int index;
        WeakEntry entry;
        WeakEntry lastReturned;
        COMPONENT_TYPES type;
        Object currentEntryRef;
        private int expectedModCount;

        HashIterator(COMPONENT_TYPES cOMPONENT_TYPES) {
            this.entries = IdentityWeakHashMap.this.entries;
            this.index = this.entries.length;
            this.entry = null;
            this.lastReturned = null;
            this.expectedModCount = IdentityWeakHashMap.this.modCount;
            this.type = cOMPONENT_TYPES;
        }

        public boolean hasNext() {
            WeakEntry weakEntry = this.entry;
            int n = this.index;
            WeakEntry<K, V>[] weakEntryArray = IdentityWeakHashMap.this.entries;
            while ((weakEntry == null || this.currentEntryRef == null) && n > 0) {
                if ((weakEntry = weakEntryArray[--n]) != null) {
                    this.currentEntryRef = weakEntry.key.get();
                    continue;
                }
                this.currentEntryRef = null;
            }
            this.entry = weakEntry;
            this.index = n;
            return weakEntry != null;
        }

        public Object next() {
            if (IdentityWeakHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            WeakEntry weakEntry = this.entry;
            int n = this.index;
            WeakEntry<K, V>[] weakEntryArray = IdentityWeakHashMap.this.entries;
            while ((weakEntry == null || this.currentEntryRef == null) && n > 0) {
                if ((weakEntry = weakEntryArray[--n]) != null) {
                    this.currentEntryRef = weakEntry.key.get();
                    continue;
                }
                this.currentEntryRef = null;
            }
            this.entry = weakEntry;
            this.index = n;
            if (weakEntry != null) {
                WeakEntry weakEntry2 = this.lastReturned = this.entry;
                this.entry = weakEntry2.next;
                this.currentEntryRef = this.entry != null ? this.entry.key.get() : null;
                return this.type == COMPONENT_TYPES.KEYS ? weakEntry2.key.get() : (this.type == COMPONENT_TYPES.VALUES ? weakEntry2.value.get() : weakEntry2);
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (IdentityWeakHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            WeakEntry<K, V>[] weakEntryArray = IdentityWeakHashMap.this.entries;
            int n = (this.lastReturned.hash & Integer.MAX_VALUE) % weakEntryArray.length;
            WeakEntry weakEntry = weakEntryArray[n];
            WeakEntry weakEntry2 = null;
            while (weakEntry != null) {
                if (weakEntry == this.lastReturned) {
                    IdentityWeakHashMap.this.modCount++;
                    ++this.expectedModCount;
                    if (weakEntry2 == null) {
                        weakEntryArray[n] = weakEntry.next;
                    } else {
                        weakEntry2.next = weakEntry.next;
                    }
                    --IdentityWeakHashMap.this.count;
                    this.lastReturned = null;
                    return;
                }
                weakEntry2 = weakEntry;
                weakEntry = weakEntry.next;
            }
            throw new ConcurrentModificationException();
        }
    }

    private static class EmptyHashIterator
    implements Iterator {
        EmptyHashIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new IllegalStateException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum COMPONENT_TYPES {
        KEYS,
        VALUES,
        ENTRIES;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class HardEntryReference<T>
    implements EntryReference {
        protected T referent;

        public HardEntryReference(T t) {
            this.referent = t;
        }

        @Override
        public T get() {
            return this.referent;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class WeakEntryReference<T>
    extends WeakReference<T>
    implements EntryReference {
        protected WeakEntry owner;
        protected boolean trashed = false;
        protected ReferenceQueue referenceQueue;

        public WeakEntryReference(T t, ReferenceQueue<? super T> referenceQueue, WeakEntry weakEntry) {
            super(t, referenceQueue);
            this.owner = weakEntry;
            this.referenceQueue = referenceQueue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface EntryReference<T> {
        public T get();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class WeakEntry<K, V>
    implements Map.Entry<K, V> {
        boolean removed = false;
        int hash;
        EntryReference<K> key;
        EntryReference<V> value;
        WeakEntry<K, V> next;

        WeakEntry(int n, K k, V v, WeakEntry<K, V> weakEntry, ReferenceQueue referenceQueue) {
            this.hash = n;
            this.key = new WeakEntryReference<K>(k, referenceQueue, this);
            this.value = k == v ? this.key : new HardEntryReference<V>(v);
            this.next = weakEntry;
        }

        protected Object clone(ReferenceQueue referenceQueue) {
            return new WeakEntry<K, V>(this.hash, this.key.get(), this.value.get(), this.next == null ? null : (WeakEntry)this.next.clone(referenceQueue), referenceQueue);
        }

        @Override
        public K getKey() {
            return this.key.get();
        }

        @Override
        public V getValue() {
            return this.value.get();
        }

        @Override
        public V setValue(V v) {
            EntryReference<V> entryReference = this.value;
            this.value = v == this.key.get() ? this.key : new HardEntryReference<V>(v);
            return entryReference.get();
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            V v = this.value.get();
            return this.key == entry.getKey() && (v == null ? entry.getValue() == null : v.equals(entry.getValue()));
        }

        @Override
        public int hashCode() {
            V v = this.value.get();
            return this.hash ^ (v == null ? 0 : v.hashCode());
        }

        public String toString() {
            return this.key.get() + "=" + this.value.get();
        }

        public boolean shouldBeIgnored() {
            return this.key.get() == null || this.value.get() == null;
        }
    }
}

