/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import java.util.Set;
import org.eclipse.persistence.exceptions.JPQLException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.jpa.parsing.FromNode;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.GroupByNode;
import org.eclipse.persistence.internal.jpa.parsing.HavingNode;
import org.eclipse.persistence.internal.jpa.parsing.ModifyNode;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.OrderByNode;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.QueryNode;
import org.eclipse.persistence.internal.jpa.parsing.SelectGenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.SelectNode;
import org.eclipse.persistence.internal.jpa.parsing.SetNode;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelperImpl;
import org.eclipse.persistence.internal.jpa.parsing.VariableNode;
import org.eclipse.persistence.internal.jpa.parsing.WhereNode;
import org.eclipse.persistence.internal.localization.ToStringLocalization;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteAllQuery;
import org.eclipse.persistence.queries.ModifyAllQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.UpdateAllQuery;

public class ParseTree {
    private ParseTreeContext context;
    private QueryNode queryNode;
    private FromNode fromNode;
    private SetNode setNode;
    private WhereNode whereNode;
    private OrderByNode orderByNode = null;
    private GroupByNode groupByNode = null;
    private HavingNode havingNode = null;
    private ClassLoader classLoader = null;
    private short distinctState = 0;
    private boolean validated = false;
    private Set unusedVariables = null;

    public DatabaseQuery createDatabaseQuery() {
        return this.queryNode == null ? null : this.queryNode.createDatabaseQuery(this.context);
    }

    public void adjustReferenceClassForQuery(DatabaseQuery databaseQuery, GenerationContext generationContext) {
        Class clazz = this.getReferenceClass(databaseQuery, generationContext);
        if (clazz != null && clazz != databaseQuery.getReferenceClass()) {
            if (databaseQuery.isObjectLevelReadQuery()) {
                ((ObjectLevelReadQuery)databaseQuery).setReferenceClass(clazz);
                generationContext.setBaseQueryClass(clazz);
                ((ObjectLevelReadQuery)databaseQuery).changeDescriptor(generationContext.getSession());
            } else if (databaseQuery.isUpdateAllQuery()) {
                ((UpdateAllQuery)databaseQuery).setReferenceClass(clazz);
            } else if (databaseQuery.isDeleteAllQuery()) {
                ((DeleteAllQuery)databaseQuery).setReferenceClass(clazz);
            }
        }
    }

    public void initBaseExpression(ObjectLevelReadQuery objectLevelReadQuery, GenerationContext generationContext) {
        String string = this.getFromNode().getFirstVariable();
        ParseTreeContext parseTreeContext = generationContext.getParseTreeContext();
        if (parseTreeContext.isRangeVariable(string)) {
            Class clazz = objectLevelReadQuery.getReferenceClass();
            ExpressionBuilder expressionBuilder = new ExpressionBuilder(clazz);
            objectLevelReadQuery.setExpressionBuilder(expressionBuilder);
            generationContext.setBaseExpression(string, expressionBuilder);
        } else {
            Node node = parseTreeContext.pathForVariable(string);
            Class clazz = this.getBaseExpressionClass(node, generationContext);
            objectLevelReadQuery.setExpressionBuilder(new ExpressionBuilder(clazz));
            objectLevelReadQuery.setReferenceClass(clazz);
            objectLevelReadQuery.changeDescriptor(generationContext.getSession());
            generationContext.setBaseQueryClass(clazz);
            generationContext.setBaseExpression(string, node.generateExpression(generationContext));
        }
    }

    public void initBaseExpression(ModifyAllQuery modifyAllQuery, GenerationContext generationContext) {
        ModifyNode modifyNode = (ModifyNode)this.getQueryNode();
        String string = modifyNode.getCanonicalAbstractSchemaIdentifier();
        Class clazz = modifyAllQuery.getReferenceClass();
        ExpressionBuilder expressionBuilder = new ExpressionBuilder(clazz);
        modifyAllQuery.setExpressionBuilder(expressionBuilder);
        generationContext.setBaseExpression(string, expressionBuilder);
    }

    private Class getBaseExpressionClass(Node node, GenerationContext generationContext) {
        ParseTreeContext parseTreeContext = generationContext.getParseTreeContext();
        Class clazz = null;
        if (node == null) {
            clazz = null;
        } else if (node.isDotNode()) {
            clazz = this.getBaseExpressionClass(node.getLeft(), generationContext);
        } else if (node.isVariableNode()) {
            String string = ((VariableNode)node).getVariableName();
            if (!parseTreeContext.isRangeVariable(string)) {
                Node node2 = parseTreeContext.pathForVariable(string);
                clazz = this.getBaseExpressionClass(node2, generationContext);
            } else {
                String string2 = parseTreeContext.schemaForVariable(string);
                if (string2 != null) {
                    clazz = parseTreeContext.classForSchemaName(string2, generationContext);
                }
            }
        }
        return clazz;
    }

    protected void validate(AbstractSession abstractSession, ClassLoader classLoader) {
        this.validate(new TypeHelperImpl(abstractSession, classLoader));
    }

    public void validate(TypeHelper typeHelper) {
        ParseTreeContext parseTreeContext = this.getContext();
        parseTreeContext.setTypeHelper(typeHelper);
        this.validate(parseTreeContext);
    }

    public void validate(ParseTreeContext parseTreeContext) {
        if (this.validated) {
            return;
        }
        this.validated = true;
        parseTreeContext.enterScope();
        if (this.fromNode != null) {
            this.fromNode.validate(parseTreeContext);
        }
        this.queryNode.validate(parseTreeContext);
        this.qualifyAttributeAccess(parseTreeContext);
        if (this.setNode != null) {
            this.setNode.validate(parseTreeContext);
        }
        if (this.whereNode != null) {
            this.whereNode.validate(parseTreeContext);
        }
        if (this.hasOrderBy()) {
            this.orderByNode.validate(parseTreeContext, (SelectNode)this.queryNode);
        }
        if (this.hasGroupBy()) {
            this.groupByNode.validate(parseTreeContext, (SelectNode)this.queryNode);
        }
        if (this.hasHaving()) {
            this.havingNode.validate(parseTreeContext, this.groupByNode);
        }
        this.unusedVariables = parseTreeContext.getUnusedVariables();
        parseTreeContext.leaveScope();
    }

    protected void qualifyAttributeAccess(ParseTreeContext parseTreeContext) {
        if ((this.queryNode.isUpdateNode() || this.queryNode.isDeleteNode()) && ((ModifyNode)this.queryNode).getAbstractSchemaIdentifier() == null) {
            if (this.setNode != null) {
                this.setNode.qualifyAttributeAccess(parseTreeContext);
            }
            if (this.whereNode != null) {
                this.whereNode.qualifyAttributeAccess(parseTreeContext);
            }
        }
    }

    public void addOrderingToQuery(ObjectLevelReadQuery objectLevelReadQuery, GenerationContext generationContext) {
        if (this.hasOrderBy()) {
            this.getOrderByNode().addOrderingToQuery(objectLevelReadQuery, generationContext);
        }
    }

    public void addGroupingToQuery(ObjectLevelReadQuery objectLevelReadQuery, GenerationContext generationContext) {
        if (this.hasGroupBy()) {
            this.getGroupByNode().addGroupingToQuery(objectLevelReadQuery, generationContext);
        }
    }

    public void addHavingToQuery(ObjectLevelReadQuery objectLevelReadQuery, GenerationContext generationContext) {
        if (this.hasHaving()) {
            this.getHavingNode().addHavingToQuery(objectLevelReadQuery, generationContext);
        }
    }

    public void addNonFetchJoinAttributes(ObjectLevelReadQuery objectLevelReadQuery, GenerationContext generationContext) {
        ParseTreeContext parseTreeContext = generationContext.getParseTreeContext();
        for (String string : this.unusedVariables) {
            Expression expression = null;
            if (!parseTreeContext.isRangeVariable(string)) {
                Node node = parseTreeContext.pathForVariable(string);
                expression = node.generateExpression(generationContext);
                objectLevelReadQuery.addNonFetchJoinedAttribute(expression);
                continue;
            }
            throw JPQLException.notYetImplemented(parseTreeContext.getQueryInfo(), "Variable [" + string + "] is defined in a range variable declaration, but not used in the rest of the query.");
        }
    }

    public void addUpdatesToQuery(UpdateAllQuery updateAllQuery, GenerationContext generationContext) {
        if (this.getSetNode() != null) {
            this.getSetNode().addUpdatesToQuery(updateAllQuery, generationContext);
        }
    }

    public void addParametersToQuery(DatabaseQuery databaseQuery) {
        if (this.context.hasParameters()) {
            TypeHelper typeHelper = this.context.getTypeHelper();
            for (String string : this.context.getParameterNames()) {
                Object object = this.context.getParameterType(string);
                Class<Object> clazz = typeHelper.getJavaClass(object);
                if (clazz == null) {
                    clazz = Object.class;
                }
                databaseQuery.addArgument(string, clazz);
            }
        }
    }

    public void applyQueryNodeToQuery(DatabaseQuery databaseQuery, GenerationContext generationContext) {
        this.getQueryNode().applyToQuery(databaseQuery, generationContext);
    }

    public GenerationContext buildContext(DatabaseQuery databaseQuery, AbstractSession abstractSession) {
        if (databaseQuery.isObjectLevelReadQuery()) {
            return this.buildContextForReadQuery(abstractSession);
        }
        if (databaseQuery.isUpdateAllQuery() || databaseQuery.isDeleteAllQuery()) {
            return new GenerationContext(this.getContext(), abstractSession, this);
        }
        return null;
    }

    public GenerationContext buildContextForReadQuery(AbstractSession abstractSession) {
        return new SelectGenerationContext(this.getContext(), abstractSession, this);
    }

    public Expression generateExpression(DatabaseQuery databaseQuery, GenerationContext generationContext) {
        Expression expression = this.getQueryNode().generateExpression(generationContext);
        if (this.getWhereNode() == null) {
            return expression;
        }
        Expression expression2 = this.getWhereNode().generateExpression(generationContext);
        expression = this.getQueryNode().generateExpression(generationContext);
        if (expression != null) {
            expression2 = expression.and(expression2);
        }
        return expression2;
    }

    public ParseTreeContext getContext() {
        return this.context;
    }

    public FromNode getFromNode() {
        return this.fromNode;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            return ConversionManager.getDefaultManager().getLoader();
        }
        return this.classLoader;
    }

    public OrderByNode getOrderByNode() {
        return this.orderByNode;
    }

    public GroupByNode getGroupByNode() {
        return this.groupByNode;
    }

    public HavingNode getHavingNode() {
        return this.havingNode;
    }

    public Class getReferenceClass(DatabaseQuery databaseQuery, GenerationContext generationContext) {
        if (this.getQueryNode() == null) {
            return null;
        }
        return this.getQueryNode().getReferenceClass(generationContext);
    }

    public QueryNode getQueryNode() {
        return this.queryNode;
    }

    public SetNode getSetNode() {
        return this.setNode;
    }

    public WhereNode getWhereNode() {
        return this.whereNode;
    }

    public short getDistinctState() {
        return this.distinctState;
    }

    public boolean hasOrderBy() {
        return this.getOrderByNode() != null;
    }

    public boolean hasGroupBy() {
        return this.getGroupByNode() != null;
    }

    public boolean hasHaving() {
        return this.getHavingNode() != null;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setContext(ParseTreeContext parseTreeContext) {
        this.context = parseTreeContext;
    }

    public void setFromNode(FromNode fromNode) {
        this.fromNode = fromNode;
    }

    public void setOrderByNode(OrderByNode orderByNode) {
        this.orderByNode = orderByNode;
    }

    public void setGroupByNode(GroupByNode groupByNode) {
        this.groupByNode = groupByNode;
    }

    public void setHavingNode(HavingNode havingNode) {
        this.havingNode = havingNode;
    }

    public void setSelectionCriteriaForQuery(DatabaseQuery databaseQuery, GenerationContext generationContext) {
        databaseQuery.setSelectionCriteria(this.generateExpression(databaseQuery, generationContext));
    }

    public void setQueryNode(QueryNode queryNode) {
        this.queryNode = queryNode;
    }

    public void setSetNode(SetNode setNode) {
        this.setNode = setNode;
    }

    public void setWhereNode(WhereNode whereNode) {
        this.whereNode = whereNode;
    }

    public void setDistinctState(short s) {
        this.distinctState = s;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getContext().toString());
        return ToStringLocalization.buildMessage("context", null) + " " + stringBuffer.toString();
    }

    public void verifySelect(DatabaseQuery databaseQuery, GenerationContext generationContext) {
        if (databaseQuery.isObjectLevelReadQuery()) {
            ((SelectNode)this.getQueryNode()).verifySelectedAlias(generationContext);
        }
    }

    public boolean usesDistinct() {
        return this.distinctState == 1;
    }
}

