/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.security;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.security.Securable;

public class SecurableObjectHolder {
    private static final String JCE_ENCRYPTION_CLASS_NAME = "org.eclipse.persistence.internal.security.JCEEncryptor";
    private String m_securableClassName;
    private Securable m_securableObject = null;

    public SecurableObjectHolder() {
        this(null);
    }

    public SecurableObjectHolder(String string) {
        this.m_securableClassName = string;
    }

    public void setEncryptionClassName(String string) {
        this.m_securableClassName = string;
    }

    public Securable getSecurableObject() {
        if (this.m_securableObject == null) {
            this.initSecurableObject();
        }
        return this.m_securableObject;
    }

    public boolean hasSecurableObject() {
        return this.m_securableObject != null;
    }

    private void initSecurableObject() {
        block7: {
            boolean bl = false;
            if (this.m_securableClassName == null) {
                bl = true;
                this.m_securableClassName = JCE_ENCRYPTION_CLASS_NAME;
            }
            try {
                ConversionManager conversionManager = ConversionManager.getDefaultManager();
                Class clazz = (Class)conversionManager.convertObject(this.m_securableClassName, Class.class);
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        this.m_securableObject = (Securable)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(clazz));
                        break block7;
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw privilegedActionException.getException();
                    }
                }
                this.m_securableObject = (Securable)PrivilegedAccessHelper.newInstanceFromClass(clazz);
            }
            catch (Throwable throwable) {
                if (bl) {
                    this.m_securableObject = new PassThroughEncryptor();
                }
                throw ValidationException.invalidEncryptionClass(this.m_securableClassName, throwable);
            }
        }
    }

    private class PassThroughEncryptor
    implements Securable {
        private PassThroughEncryptor() {
        }

        public String encryptPassword(String string) {
            return string;
        }

        public String decryptPassword(String string) {
            return string;
        }
    }
}

