/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.TimestampLockingPolicy;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.DirectToFieldChangeRecord;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.Session;

public class ObjectChangeSet
implements Serializable,
org.eclipse.persistence.sessions.changesets.ObjectChangeSet {
    protected Vector changes;
    protected Hashtable attributesToChanges;
    protected boolean shouldBeDeleted;
    protected CacheKey cacheKey;
    protected transient Class classType;
    protected String className;
    protected boolean isNew;
    protected boolean isAggregate;
    protected Object oldKey;
    protected Object newKey;
    protected UnitOfWorkChangeSet unitOfWorkChangeSet;
    protected transient OptimisticLockingPolicy optimisticLockingPolicy;
    protected Object initialWriteLockValue;
    protected Object writeLockValue;
    protected boolean isInvalid;
    protected transient Object cloneObject;
    protected boolean hasVersionChange;
    protected Boolean shouldModifyVersionField;
    protected boolean hasCmpPolicyForcedUpdate;
    protected boolean hasChangesFromCascadeLocking;
    protected transient HashSet deferredSet;
    protected int cacheSynchronizationType = 0;
    protected transient CacheKey activeCacheKey;

    public ObjectChangeSet() {
    }

    public ObjectChangeSet(Object object, UnitOfWorkChangeSet unitOfWorkChangeSet, boolean bl) {
        this.cloneObject = object;
        this.shouldBeDeleted = false;
        this.classType = object.getClass();
        this.className = this.classType.getName();
        this.unitOfWorkChangeSet = unitOfWorkChangeSet;
        this.isNew = bl;
    }

    public ObjectChangeSet(Vector vector, Class clazz, Object object, UnitOfWorkChangeSet unitOfWorkChangeSet, boolean bl) {
        this.cloneObject = object;
        this.isNew = bl;
        this.shouldBeDeleted = false;
        if (vector != null && !vector.contains(null)) {
            this.cacheKey = new CacheKey(vector);
        }
        this.classType = clazz;
        this.className = this.classType.getName();
        this.unitOfWorkChangeSet = unitOfWorkChangeSet;
        this.isAggregate = false;
    }

    public void clear() {
        this.shouldBeDeleted = false;
        this.setOldKey(null);
        this.setNewKey(null);
        this.changes = null;
        this.attributesToChanges = null;
    }

    public void addChange(ChangeRecord changeRecord) {
        if (changeRecord == null) {
            return;
        }
        String string = changeRecord.getAttribute();
        Hashtable hashtable = this.getAttributesToChanges();
        Vector vector = this.getChanges();
        ChangeRecord changeRecord2 = (ChangeRecord)hashtable.get(string);
        if (changeRecord2 != null) {
            vector.remove(changeRecord2);
        }
        vector.add(changeRecord);
        hashtable.put(string, changeRecord);
        this.dirtyUOWChangeSet();
    }

    public void deferredDetectionRequiredOn(String string) {
        this.getDeferredSet().add(string);
    }

    public boolean containsChangesFromSynchronization() {
        return this.cacheSynchronizationType == 3 || this.cacheSynchronizationType == 1;
    }

    public boolean equals(Object object) {
        if (object instanceof ObjectChangeSet) {
            return this.equals((ObjectChangeSet)object);
        }
        return false;
    }

    public boolean equals(org.eclipse.persistence.sessions.changesets.ObjectChangeSet objectChangeSet) {
        if (this == objectChangeSet) {
            return true;
        }
        if (this.getCacheKey() == null) {
            return false;
        }
        return this.getCacheKey().equals(((ObjectChangeSet)objectChangeSet).getCacheKey());
    }

    public Hashtable getAttributesToChanges() {
        if (this.attributesToChanges == null) {
            this.attributesToChanges = new Hashtable(10);
        }
        return this.attributesToChanges;
    }

    public org.eclipse.persistence.sessions.changesets.ChangeRecord getChangesForAttributeNamed(String string) {
        return (ChangeRecord)this.getAttributesToChanges().get(string);
    }

    public CacheKey getCacheKey() {
        return this.cacheKey;
    }

    public Vector getChangedAttributeNames() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.getChanges().elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(((ChangeRecord)enumeration.nextElement()).getAttribute());
        }
        return vector;
    }

    public Vector getChanges() {
        if (this.changes == null) {
            this.changes = new Vector();
        }
        return this.changes;
    }

    public Class getClassType() {
        return this.classType;
    }

    public Class getClassType(Session session) {
        if (this.classType == null) {
            this.classType = (Class)((AbstractSession)session).getDatasourcePlatform().getConversionManager().convertObject(this.getClassName(), ClassConstants.CLASS);
        }
        return this.classType;
    }

    public String getClassName() {
        return this.className;
    }

    public Object getInitialWriteLockValue() {
        return this.initialWriteLockValue;
    }

    public Object getOldKey() {
        return this.oldKey;
    }

    public Object getNewKey() {
        return this.newKey;
    }

    public Vector getPrimaryKeys() {
        if (this.getCacheKey() == null) {
            return null;
        }
        return this.getCacheKey().getKey();
    }

    public int getSynchronizationType() {
        return this.cacheSynchronizationType;
    }

    public Object getTargetVersionOfSourceObject(AbstractSession abstractSession) {
        return this.getTargetVersionOfSourceObject(abstractSession, false);
    }

    public Object getTargetVersionOfSourceObject(AbstractSession abstractSession, boolean bl) {
        Object object = null;
        ClassDescriptor classDescriptor = abstractSession.getDescriptor(this.getClassType(abstractSession));
        if (classDescriptor != null) {
            object = abstractSession.isUnitOfWork() ? (((UnitOfWorkImpl)abstractSession).getLifecycle() == 4 ? ((UnitOfWorkImpl)abstractSession).getOriginalVersionOfObjectOrNull(this.getUnitOfWorkClone(), this, classDescriptor) : this.getUnitOfWorkClone()) : abstractSession.getIdentityMapAccessorInstance().getIdentityMapManager().getFromIdentityMap(this.getPrimaryKeys(), this.getClassType(abstractSession), classDescriptor);
            if (object == null && bl) {
                ReadObjectQuery readObjectQuery = new ReadObjectQuery();
                readObjectQuery.setShouldUseWrapperPolicy(false);
                readObjectQuery.setReferenceClass(this.getClassType(abstractSession));
                readObjectQuery.setSelectionKey(this.getPrimaryKeys());
                object = abstractSession.executeQuery(readObjectQuery);
            }
        }
        return object;
    }

    public Object getUnitOfWorkClone() {
        return this.cloneObject;
    }

    public org.eclipse.persistence.sessions.changesets.UnitOfWorkChangeSet getUOWChangeSet() {
        return this.unitOfWorkChangeSet;
    }

    public Object getWriteLockValue() {
        return this.writeLockValue;
    }

    public boolean hasChangeFor(String string) {
        Enumeration enumeration = this.getChanges().elements();
        while (enumeration.hasMoreElements()) {
            if (!((ChangeRecord)enumeration.nextElement()).getAttribute().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean hasChanges() {
        return this.isNew || this.hasVersionChange || this.changes != null && !this.changes.isEmpty();
    }

    public boolean hasForcedChanges() {
        return this.shouldModifyVersionField != null || this.hasCmpPolicyForcedUpdate;
    }

    public void setShouldModifyVersionField(Boolean bl) {
        this.shouldModifyVersionField = bl;
        if (bl != null && bl.booleanValue()) {
            this.hasVersionChange = true;
        }
    }

    public Boolean shouldModifyVersionField() {
        return this.shouldModifyVersionField;
    }

    public void setHasCmpPolicyForcedUpdate(boolean bl) {
        this.hasCmpPolicyForcedUpdate = bl;
    }

    public boolean hasCmpPolicyForcedUpdate() {
        return this.hasCmpPolicyForcedUpdate;
    }

    public boolean hasForcedChangesFromCascadeLocking() {
        return this.hasChangesFromCascadeLocking;
    }

    public void setHasForcedChangesFromCascadeLocking(boolean bl) {
        this.setShouldModifyVersionField(Boolean.TRUE);
        this.hasChangesFromCascadeLocking = bl;
    }

    public int hashCode() {
        if (this.getCacheKey() == null) {
            return System.identityHashCode(this);
        }
        return this.getCacheKey().hashCode();
    }

    public boolean hasKeys() {
        return this.newKey != null || this.oldKey != null;
    }

    public boolean isAggregate() {
        return this.isAggregate;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public boolean isInvalid() {
        return this.isInvalid;
    }

    public void mergeObjectChanges(ObjectChangeSet objectChangeSet, UnitOfWorkChangeSet unitOfWorkChangeSet, UnitOfWorkChangeSet unitOfWorkChangeSet2) {
        Object object;
        if (this == objectChangeSet || this.isInvalid()) {
            return;
        }
        if (objectChangeSet.optimisticLockingPolicy != null) {
            if (this.optimisticLockingPolicy == null) {
                this.optimisticLockingPolicy = objectChangeSet.optimisticLockingPolicy;
                this.initialWriteLockValue = objectChangeSet.initialWriteLockValue;
                this.writeLockValue = objectChangeSet.writeLockValue;
            } else {
                object = this.writeLockValue;
                if (object == null) {
                    object = this.initialWriteLockValue;
                }
                if (this.optimisticLockingPolicy.compareWriteLockValues(object, objectChangeSet.initialWriteLockValue) != 0) {
                    this.isInvalid = true;
                    return;
                }
                if (objectChangeSet.writeLockValue != null) {
                    this.writeLockValue = objectChangeSet.writeLockValue;
                }
            }
        }
        object = objectChangeSet.getChanges();
        int n = object.size();
        for (int i = 0; i < n; ++i) {
            ChangeRecord changeRecord = (ChangeRecord)object.get(i);
            ChangeRecord changeRecord2 = (ChangeRecord)this.getChangesForAttributeNamed(changeRecord.getAttribute());
            if (changeRecord2 == null) {
                changeRecord.updateReferences(unitOfWorkChangeSet, unitOfWorkChangeSet2);
                changeRecord.setOwner(this);
                this.addChange(changeRecord);
                continue;
            }
            changeRecord2.mergeRecord(changeRecord, unitOfWorkChangeSet, unitOfWorkChangeSet2);
        }
        this.shouldBeDeleted = objectChangeSet.shouldBeDeleted;
        this.setOldKey(objectChangeSet.oldKey);
        this.setNewKey(objectChangeSet.newKey);
        this.hasVersionChange = objectChangeSet.hasVersionChange;
        this.shouldModifyVersionField = objectChangeSet.shouldModifyVersionField;
        this.hasCmpPolicyForcedUpdate = objectChangeSet.hasCmpPolicyForcedUpdate;
        this.hasChangesFromCascadeLocking = objectChangeSet.hasChangesFromCascadeLocking;
    }

    public void prepareChangeRecordsForSynchronization(AbstractSession abstractSession) {
        Enumeration enumeration = this.getChanges().elements();
        while (enumeration.hasMoreElements()) {
            ((ChangeRecord)enumeration.nextElement()).prepareForSynchronization(abstractSession);
        }
    }

    public void readCompleteChangeSet(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.readIdentityInformation(objectInputStream);
        this.changes = (Vector)objectInputStream.readObject();
        this.setOldKey(objectInputStream.readObject());
        this.newKey = objectInputStream.readObject();
    }

    public void readIdentityInformation(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.cacheKey = (CacheKey)objectInputStream.readObject();
        this.className = (String)objectInputStream.readObject();
        this.writeLockValue = objectInputStream.readObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.read();
        this.setSynchronizationType(n);
        this.setShouldBeDeleted(objectInputStream.readBoolean());
        this.isInvalid = objectInputStream.readBoolean();
        this.setIsNew(objectInputStream.readBoolean());
        this.setIsAggregate(objectInputStream.readBoolean());
        if (this.shouldBeDeleted || this.cacheSynchronizationType == 4 || this.cacheSynchronizationType == 2) {
            this.readIdentityInformation(objectInputStream);
        } else {
            this.readCompleteChangeSet(objectInputStream);
        }
        this.updateUOWChangeSet();
    }

    public void setCacheKey(CacheKey cacheKey) {
        this.cacheKey = cacheKey;
    }

    public void setChanges(Vector vector) {
        this.changes = vector;
        this.updateUOWChangeSet();
    }

    public void setClassType(Class clazz) {
        this.classType = clazz;
    }

    public void setClassName(String string) {
        this.className = string;
    }

    public void setIsAggregate(boolean bl) {
        this.isAggregate = bl;
    }

    protected void setIsNew(boolean bl) {
        this.isNew = bl;
    }

    public void setOldKey(Object object) {
        if (object == null || this.oldKey == null) {
            this.oldKey = object;
        }
    }

    public void setNewKey(Object object) {
        this.newKey = object;
    }

    public void setShouldBeDeleted(boolean bl) {
        this.shouldBeDeleted = bl;
    }

    public void setSynchronizationType(int n) {
        this.cacheSynchronizationType = n;
    }

    public void setUOWChangeSet(UnitOfWorkChangeSet unitOfWorkChangeSet) {
        this.unitOfWorkChangeSet = unitOfWorkChangeSet;
    }

    public void setOptimisticLockingPolicyAndInitialWriteLockValue(OptimisticLockingPolicy optimisticLockingPolicy, AbstractSession abstractSession) {
        if (optimisticLockingPolicy.supportsWriteLockValuesComparison()) {
            this.optimisticLockingPolicy = optimisticLockingPolicy;
            this.initialWriteLockValue = optimisticLockingPolicy.getWriteLockValue(this.cloneObject, this.getPrimaryKeys(), abstractSession);
        }
    }

    public void setWriteLockValue(Object object) {
        this.writeLockValue = object;
        this.hasVersionChange = true;
        this.updateUOWChangeSet();
    }

    public void setInitialWriteLockValue(Object object) {
        if (this.initialWriteLockValue == null) {
            this.initialWriteLockValue = object;
        }
    }

    public boolean shouldBeDeleted() {
        return this.shouldBeDeleted;
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.getClassName() + ")" + this.getChanges().toString();
    }

    public void updateChangeRecordForAttribute(String string, Object object) {
        ChangeRecord changeRecord = (ChangeRecord)this.getChangesForAttributeNamed(string);
        if (changeRecord != null) {
            changeRecord.updateChangeRecordWithNewValue(object);
        }
    }

    public void updateChangeRecordForAttributeWithMappedObject(String string, Object object, AbstractSession abstractSession) {
        ClassDescriptor classDescriptor;
        ObjectChangeSet objectChangeSet = (ObjectChangeSet)this.getUOWChangeSet().getObjectChangeSetForClone(object);
        if (objectChangeSet == null && (classDescriptor = abstractSession.getDescriptor(object.getClass())) != null) {
            objectChangeSet = classDescriptor.getObjectBuilder().createObjectChangeSet(object, (UnitOfWorkChangeSet)this.getUOWChangeSet(), false, abstractSession);
        }
        this.updateChangeRecordForAttribute(string, objectChangeSet);
    }

    public void updateChangeRecordForAttribute(DatabaseMapping databaseMapping, Object object, AbstractSession abstractSession) {
        String string = databaseMapping.getAttributeName();
        ChangeRecord changeRecord = (ChangeRecord)this.getChangesForAttributeNamed(string);
        if (databaseMapping.isDirectToFieldMapping()) {
            object = ((AbstractDirectMapping)databaseMapping).getAttributeValue(object, abstractSession);
        }
        if (changeRecord != null) {
            changeRecord.updateChangeRecordWithNewValue(object);
        } else if (databaseMapping.isDirectToFieldMapping()) {
            changeRecord = new DirectToFieldChangeRecord(this);
            changeRecord.setAttribute(string);
            changeRecord.setMapping(databaseMapping);
            ((DirectToFieldChangeRecord)changeRecord).setNewValue(object);
            this.addChange(changeRecord);
        }
    }

    public void updateReferences(UnitOfWorkChangeSet unitOfWorkChangeSet, UnitOfWorkChangeSet unitOfWorkChangeSet2) {
        for (int i = 0; i < this.getChanges().size(); ++i) {
            ChangeRecord changeRecord = (ChangeRecord)this.getChanges().get(i);
            changeRecord.updateReferences(unitOfWorkChangeSet, unitOfWorkChangeSet2);
            changeRecord.setOwner(this);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.write(this.cacheSynchronizationType);
        objectOutputStream.writeBoolean(this.shouldBeDeleted);
        objectOutputStream.writeBoolean(this.isInvalid);
        objectOutputStream.writeBoolean(this.isNew);
        objectOutputStream.writeBoolean(this.isAggregate);
        if (this.shouldBeDeleted || this.cacheSynchronizationType == 4 || this.cacheSynchronizationType == 2) {
            this.writeIdentityInformation(objectOutputStream);
        } else {
            this.writeCompleteChangeSet(objectOutputStream);
        }
    }

    public void writeIdentityInformation(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.cacheKey);
        objectOutputStream.writeObject(this.className);
        objectOutputStream.writeObject(this.writeLockValue);
    }

    public void writeCompleteChangeSet(ObjectOutputStream objectOutputStream) throws IOException {
        AbstractSession abstractSession;
        if (this.isNew && (this.changes == null || this.changes.isEmpty()) && (abstractSession = this.unitOfWorkChangeSet.getSession()) != null) {
            ClassDescriptor classDescriptor = abstractSession.getDescriptor(this.cloneObject);
            Vector<DatabaseMapping> vector = classDescriptor.getMappings();
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                DatabaseMapping databaseMapping = (DatabaseMapping)vector.get(i);
                this.addChange(databaseMapping.compareForChange(this.cloneObject, this.cloneObject, this, abstractSession));
            }
        }
        this.writeIdentityInformation(objectOutputStream);
        objectOutputStream.writeObject(this.changes);
        objectOutputStream.writeObject(this.oldKey);
        objectOutputStream.writeObject(this.newKey);
    }

    public void setPrimaryKeys(Vector vector) {
        if (vector == null) {
            return;
        }
        if (this.getCacheKey() == null) {
            this.setCacheKey(new CacheKey(vector));
        } else {
            this.getCacheKey().setKey(vector);
        }
    }

    public HashSet getDeferredSet() {
        if (this.deferredSet == null) {
            this.deferredSet = new HashSet();
        }
        return this.deferredSet;
    }

    public boolean hasDeferredAttributes() {
        return this.deferredSet != null && !this.deferredSet.isEmpty();
    }

    protected void dirtyUOWChangeSet() {
        UnitOfWorkChangeSet unitOfWorkChangeSet = (UnitOfWorkChangeSet)this.getUOWChangeSet();
        if (unitOfWorkChangeSet != null) {
            unitOfWorkChangeSet.setHasChanges(true);
        }
    }

    protected void updateUOWChangeSet() {
        if (this.getUOWChangeSet() != null) {
            ((UnitOfWorkChangeSet)this.getUOWChangeSet()).setHasChanges(this.hasChanges());
        }
    }

    protected void rebuildWriteLockValueFromUserFormat(ClassDescriptor classDescriptor, AbstractSession abstractSession) {
        if (classDescriptor.getOptimisticLockingPolicy() instanceof TimestampLockingPolicy) {
            this.writeLockValue = abstractSession.getPlatform(classDescriptor.getJavaClass()).getConversionManager().convertObject(this.writeLockValue, ClassConstants.JavaSqlTimestamp_Class);
        } else if (classDescriptor.getOptimisticLockingPolicy() instanceof VersionLockingPolicy) {
            this.writeLockValue = abstractSession.getPlatform(classDescriptor.getJavaClass()).getConversionManager().convertObject(this.writeLockValue, ClassConstants.BIGDECIMAL);
        }
    }

    public void removeChange(String string) {
        org.eclipse.persistence.sessions.changesets.ChangeRecord changeRecord = this.getChangesForAttributeNamed(string);
        if (changeRecord != null) {
            this.getChanges().remove(changeRecord);
            this.attributesToChanges.remove(string);
        }
    }

    protected void removeFromIdentityMap(AbstractSession abstractSession) {
        abstractSession.getIdentityMapAccessor().removeFromIdentityMap(this.getPrimaryKeys(), this.getClassType(abstractSession));
    }

    public boolean shouldInvalidateObject(Object object, AbstractSession abstractSession) {
        if (this.optimisticLockingPolicy == null) {
            return false;
        }
        if (abstractSession.isRemoteSession()) {
            return false;
        }
        if (this.isInvalid()) {
            return true;
        }
        Object object2 = this.optimisticLockingPolicy.getWriteLockValue(object, this.getPrimaryKeys(), abstractSession);
        if (this.initialWriteLockValue == null) {
            return this.hasChanges();
        }
        return object2 != null && this.optimisticLockingPolicy.compareWriteLockValues(this.initialWriteLockValue, object2) != 0;
    }

    public CacheKey getActiveCacheKey() {
        return this.activeCacheKey;
    }

    public void setActiveCacheKey(CacheKey cacheKey) {
        this.activeCacheKey = cacheKey;
    }
}

