/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.changetracking.AttributeChangeTrackingPolicy;
import org.eclipse.persistence.descriptors.invalidation.CacheInvalidationPolicy;
import org.eclipse.persistence.exceptions.CommunicationException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.DatasourceAccessor;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.descriptors.CascadeLockingPolicy;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConcurrencyManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.IdentityHashSet;
import org.eclipse.persistence.internal.helper.IdentityWeakHashMap;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.IdentityMapManager;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.localization.LoggingLocalization;
import org.eclipse.persistence.internal.sequencing.Sequencing;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.CommitManager;
import org.eclipse.persistence.internal.sessions.IsolatedClientSession;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkIdentityMapAccessor;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.platform.server.ServerPlatform;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.DoesExistQuery;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.queries.ModifyAllQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.Record;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.coordination.Command;
import org.eclipse.persistence.sessions.coordination.MergeChangeSetCommand;
import org.eclipse.persistence.sessions.factories.ReferenceMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitOfWorkImpl
extends AbstractSession
implements UnitOfWork {
    protected transient Map cloneToOriginals;
    protected transient AbstractSession parent;
    protected Map cloneMapping;
    protected Map newObjectsCloneToOriginal;
    protected Map newObjectsOriginalToClone;
    protected Map deletedObjects;
    protected Map allClones;
    protected Map objectsDeletedDuringCommit;
    protected Map removedObjects;
    protected Map unregisteredNewObjects;
    protected Map unregisteredNewObjectsInParent;
    protected Map unregisteredExistingObjects;
    protected Map newObjectsInParentOriginalToClone;
    protected Map privateOwnedObjects;
    protected Map newObjectsInParent;
    protected Map newAggregates;
    protected UnitOfWorkChangeSet unitOfWorkChangeSet;
    protected UnitOfWorkImpl containerUnitOfWork;
    protected Map containerBeans;
    protected Map pessimisticLockedObjects;
    protected MergeManager lastUsedMergeManager;
    protected Map batchReadObjects;
    protected Set readOnlyClasses;
    protected boolean wasTransactionBegunPrematurely;
    protected boolean shouldNewObjectsBeCached;
    protected boolean shouldPerformDeletesFirst;
    protected int shouldThrowConformExceptions;
    protected int validationLevel;
    public static final int None = 0;
    public static final int Partial = 1;
    public static final int Full = 2;
    protected int lifecycle;
    public static final int Birth = 0;
    public static final int CommitPending = 1;
    public static final int CommitTransactionPending = 2;
    public static final int WriteChangesFailed = 3;
    public static final int MergePending = 4;
    public static final int Death = 5;
    public static final int AfterExternalTransactionRolledBack = 6;
    public static final int DO_NOT_THROW_CONFORM_EXCEPTIONS = 0;
    public static final int THROW_ALL_CONFORM_EXCEPTIONS = 1;
    public static final String LOCK_QUERIES_PROPERTY = "LockQueriesProperties";
    protected static boolean SmartMerge = false;
    protected Map optimisticReadLockObjects;
    public static final String ReadLockOnly = "no update";
    public static final String ReadLockUpdateVersion = "update version";
    protected List modifyAllQueries;
    protected List deferredModifyAllQueries;
    protected int cloneDepth;
    protected Map objectsLockedForClone;
    protected Object transaction;
    protected boolean shouldCheckWriteLock;
    protected boolean resumeOnTransactionCompletion;
    protected boolean shouldDiscoverNewObjects;
    protected boolean wasNonObjectLevelModifyQueryExecuted;
    protected boolean shouldCascadeCloneToJoinedRelationship;
    protected boolean isNestedUnitOfWork;
    protected boolean shouldValidateExistence;
    protected ReferenceMode referenceMode;
    protected IdentityHashSet changeTrackedHardList;
    protected Map unregisteredDeletedObjectsCloneToBackupAndOriginal;
    protected boolean preDeleteComplete = false;
    protected Map<DatabaseMapping, List<Object>> deletedPrivateOwnedObjects;

    public UnitOfWorkImpl(AbstractSession abstractSession, ReferenceMode referenceMode) {
        this.isLoggingOff = abstractSession.isLoggingOff();
        this.referenceMode = referenceMode;
        this.shouldDiscoverNewObjects = true;
        this.name = abstractSession.getName();
        this.parent = abstractSession;
        this.project = abstractSession.getProject();
        this.profiler = abstractSession.getProfiler();
        this.isInProfile = abstractSession.isInProfile;
        this.sessionLog = abstractSession.getSessionLog();
        this.eventManager = abstractSession.getEventManager().clone(this);
        this.exceptionHandler = abstractSession.getExceptionHandler();
        this.pessimisticLockTimeoutDefault = abstractSession.getPessimisticLockTimeoutDefault();
        this.queryTimeoutDefault = abstractSession.getQueryTimeoutDefault();
        this.setReadOnlyClasses(abstractSession.copyReadOnlyClasses());
        this.validationLevel = 1;
        this.shouldThrowConformExceptions = 0;
        this.lifecycle = 0;
        this.shouldCheckWriteLock = abstractSession.getDatasourceLogin().shouldSynchronizedReadOnWrite() || abstractSession.getDatasourceLogin().shouldSynchronizeWrites();
        this.isNestedUnitOfWork = abstractSession.isUnitOfWork();
        this.eventManager.postAcquireUnitOfWork();
        this.incrementProfile("UnitOfWork");
    }

    @Override
    public Session acquireHistoricalSession(AsOfClause asOfClause) throws ValidationException {
        throw ValidationException.cannotAcquireHistoricalSession();
    }

    @Override
    public UnitOfWorkImpl acquireUnitOfWork() {
        UnitOfWorkImpl unitOfWorkImpl = super.acquireUnitOfWork();
        unitOfWorkImpl.discoverAllUnregisteredNewObjectsInParent();
        return unitOfWorkImpl;
    }

    public void addDeletedPrivateOwnedObjects(DatabaseMapping databaseMapping, Object object) {
        List<Object> list;
        if (this.deletedPrivateOwnedObjects == null) {
            this.deletedPrivateOwnedObjects = new IdentityHashMap<DatabaseMapping, List<Object>>();
        }
        if ((list = this.deletedPrivateOwnedObjects.get(databaseMapping)) == null) {
            list = new ArrayList<Object>();
            this.deletedPrivateOwnedObjects.put(databaseMapping, list);
        }
        list.add(object);
    }

    public void addNewAggregate(Object object) {
        this.getNewAggregates().put(object, object);
    }

    public void addObjectDeletedDuringCommit(Object object, ClassDescriptor classDescriptor) {
        this.getObjectsDeletedDuringCommit().put(object, this.keyFromObject(object, classDescriptor));
        ((UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet()).addDeletedObject(object, this);
    }

    @Override
    public void addReadOnlyClass(Class clazz) throws ValidationException {
        if (!this.canChangeReadOnlySet()) {
            throw ValidationException.cannotModifyReadOnlyClassesSetAfterUsingUnitOfWork();
        }
        this.getReadOnlyClasses().add(clazz);
        ClassDescriptor classDescriptor = this.getDescriptor(clazz);
        if (classDescriptor.hasInheritance()) {
            Enumeration enumeration = classDescriptor.getInheritancePolicy().getChildDescriptors().elements();
            while (enumeration.hasMoreElements()) {
                ClassDescriptor classDescriptor2 = (ClassDescriptor)enumeration.nextElement();
                this.addReadOnlyClass(classDescriptor2.getJavaClass());
            }
        }
    }

    @Override
    public void addReadOnlyClasses(Collection collection) {
        for (Class clazz : collection) {
            this.addReadOnlyClass(clazz);
        }
    }

    public void addRemovedObject(Object object) {
        this.getRemovedObjects().put(object, object);
    }

    @Override
    public void assignSequenceNumber(Object object) throws DatabaseException {
        ClassDescriptor classDescriptor = this.getDescriptor(object);
        Object object2 = classDescriptor.getObjectBuilder().unwrapObject(object, this);
        this.assignSequenceNumber(object2, classDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object assignSequenceNumber(Object object, ClassDescriptor classDescriptor) throws DatabaseException {
        Object object2 = null;
        if (classDescriptor.usesSequenceNumbers() && !classDescriptor.getSequence().shouldAcquireValueAfterInsert()) {
            this.startOperationProfile("assign sequence");
            ObjectBuilder objectBuilder = classDescriptor.getObjectBuilder();
            try {
                object2 = objectBuilder.assignSequenceNumber(object, this);
            }
            catch (RuntimeException runtimeException) {
                this.handleException(runtimeException);
            }
            finally {
                this.endOperationProfile("assign sequence");
            }
        }
        return object2;
    }

    @Override
    public void assignSequenceNumbers() throws DatabaseException {
        this.discoverAllUnregisteredNewObjects();
        if (this.hasUnregisteredNewObjects()) {
            this.assignSequenceNumbers(this.getUnregisteredNewObjects());
        }
        if (this.hasNewObjects()) {
            this.assignSequenceNumbers(this.getNewObjectsCloneToOriginal());
        }
    }

    protected void assignSequenceNumbers(Map map) throws DatabaseException {
        Sequencing sequencing = this.getSequencing();
        if (sequencing == null) {
            return;
        }
        int n = sequencing.whenShouldAcquireValueForAll();
        if (n == 1) {
            return;
        }
        boolean bl = n == -1;
        this.startOperationProfile("assign sequence");
        for (Object k : map.keySet()) {
            ClassDescriptor classDescriptor = this.getDescriptor(k);
            if (!classDescriptor.usesSequenceNumbers() || !bl && classDescriptor.getSequence().shouldAcquireValueAfterInsert()) continue;
            classDescriptor.getObjectBuilder().assignSequenceNumber(k, this);
        }
        this.endOperationProfile("assign sequence");
    }

    @Override
    public void beginEarlyTransaction() throws DatabaseException {
        this.beginTransaction();
        this.setWasTransactionBegunPrematurely(true);
    }

    @Override
    public void beginTransaction() throws DatabaseException {
        this.getParent().beginTransaction();
    }

    public Object buildOriginal(Object object) {
        ClassDescriptor classDescriptor = this.getDescriptor(object);
        ObjectBuilder objectBuilder = classDescriptor.getObjectBuilder();
        Object object2 = objectBuilder.instantiateClone(object, this);
        if (this.checkIfAlreadyRegistered(object, classDescriptor) != null) {
            this.getCloneToOriginals().put(object, object2);
            return object2;
        }
        Object object3 = objectBuilder.instantiateClone(object, this);
        this.getCloneMapping().put(object, object3);
        this.getNewObjectsCloneToOriginal().put(object, object2);
        this.getNewObjectsOriginalToClone().put(object2, object);
        return object2;
    }

    public UnitOfWorkChangeSet calculateChanges(Map map, UnitOfWorkChangeSet unitOfWorkChangeSet, boolean bl) {
        Serializable serializable;
        Object object222;
        this.getEventManager().preCalculateUnitOfWorkChangeSet();
        if (bl && this.hasNewObjects()) {
            this.assignSequenceNumbers(this.newObjectsCloneToOriginal);
        }
        Iterator iterator = map.keySet().iterator();
        IdentityHashMap<Object, Object> identityHashMap = new IdentityHashMap<Object, Object>();
        IdentityHashMap<Object, Object> identityHashMap2 = new IdentityHashMap<Object, Object>();
        while (iterator.hasNext()) {
            object222 = iterator.next();
            ClassDescriptor object5 = this.getDescriptor(object222);
            boolean bl2 = this.isObjectNew(object222);
            if (bl2 || object5.getObjectChangePolicy().shouldCompareExistingObjectForChange(object222, this, object5)) {
                Object object = null;
                object = bl2 ? object5.getObjectChangePolicy().calculateChangesForNewObject(object222, unitOfWorkChangeSet, this, object5, true) : object5.getObjectChangePolicy().calculateChangesForExistingObject(object222, unitOfWorkChangeSet, this, object5, true);
                if (object != null) {
                    unitOfWorkChangeSet.addObjectChangeSet((ObjectChangeSet)object, this, true);
                    identityHashMap.put(object222, object222);
                    if (!((ObjectChangeSet)object).hasChanges() || ((ObjectChangeSet)object).hasForcedChangesFromCascadeLocking()) continue;
                    if (object5.hasCascadeLockingPolicies()) {
                        Object object2 = object5.getCascadeLockingPolicies().elements();
                        while (object2.hasMoreElements()) {
                            ((CascadeLockingPolicy)object2.nextElement()).lockNotifyParent(object222, unitOfWorkChangeSet, this);
                        }
                        continue;
                    }
                    if (!object5.usesOptimisticLocking() || !object5.getOptimisticLockingPolicy().isCascaded()) continue;
                    ((ObjectChangeSet)object).setHasForcedChangesFromCascadeLocking(true);
                    continue;
                }
                identityHashMap2.put(object222, object222);
                continue;
            }
            identityHashMap2.put(object222, object222);
        }
        if (this.hasDeletedObjects() && !this.isNestedUnitOfWork()) {
            for (Object object222 : ((IdentityHashMap)((IdentityHashMap)this.deletedObjects).clone()).keySet()) {
                this.getDescriptor(object222).getObjectBuilder().recordPrivateOwnedRemovals(object222, this, true);
            }
        }
        if (this.deletedPrivateOwnedObjects != null && !this.isNestedUnitOfWork()) {
            for (Map.Entry entry : this.deletedPrivateOwnedObjects.entrySet()) {
                DatabaseMapping databaseMapping = (DatabaseMapping)entry.getKey();
                for (Object object2 : (List)entry.getValue()) {
                    databaseMapping.getReferenceDescriptor().getObjectBuilder().recordPrivateOwnedRemovals(object2, this, false);
                }
            }
            this.deletedPrivateOwnedObjects.clear();
        }
        if (this.project.hasMappingsPostCalculateChangesOnDeleted() && this.hasDeletedObjects()) {
            for (Object e : this.getDeletedObjects().keySet()) {
                ClassDescriptor classDescriptor = this.getDescriptor(e);
                if (!classDescriptor.hasMappingsPostCalculateChangesOnDeleted()) continue;
                int n = classDescriptor.getMappingsPostCalculateChangesOnDeleted().size();
                for (int i = 0; i < n; ++i) {
                    serializable = classDescriptor.getMappingsPostCalculateChangesOnDeleted().get(i);
                    serializable.postCalculateChangesOnDeleted(e, unitOfWorkChangeSet, this);
                }
            }
        }
        if (this.shouldDiscoverNewObjects) {
            object222 = new IdentityHashMap();
            IdentityHashMap identityHashMap3 = new IdentityHashMap(2);
            this.discoverUnregisteredNewObjects(identityHashMap, (Map)object222, identityHashMap3, identityHashMap2);
            this.setUnregisteredExistingObjects(identityHashMap3);
            this.setUnregisteredNewObjects((Map)object222);
            if (bl) {
                this.assignSequenceNumbers((Map)object222);
            }
            for (Object v : object222.values()) {
                ClassDescriptor classDescriptor = this.getDescriptor(v);
                serializable = classDescriptor.getObjectChangePolicy().calculateChangesForNewObject(v, unitOfWorkChangeSet, this, classDescriptor, true);
                unitOfWorkChangeSet.addObjectChangeSet((ObjectChangeSet)serializable, this, true);
            }
        }
        if (this.hasPrivateOwnedObjects()) {
            object222 = new IdentityHashMap();
            for (Set set : this.getPrivateOwnedObjects().values()) {
                for (Object e : set) {
                    this.performRemovePrivateOwnedObjectFromChangeSet(e, (Map)object222);
                }
            }
        }
        this.eventManager.postCalculateUnitOfWorkChangeSet(unitOfWorkChangeSet);
        return unitOfWorkChangeSet;
    }

    protected boolean canChangeReadOnlySet() {
        return !this.hasCloneMapping() && !this.hasDeletedObjects();
    }

    public boolean checkForUnregisteredExistingObject(Object object) {
        ClassDescriptor classDescriptor = this.getDescriptor(object.getClass());
        Vector vector = classDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, this, true);
        if (vector == null) {
            return false;
        }
        DoesExistQuery doesExistQuery = classDescriptor.getQueryManager().getDoesExistQuery();
        doesExistQuery = (DoesExistQuery)doesExistQuery.clone();
        doesExistQuery.setObject(object);
        doesExistQuery.setPrimaryKey(vector);
        doesExistQuery.setDescriptor(classDescriptor);
        doesExistQuery.setIsExecutionClone(true);
        return (Boolean)this.executeQuery(doesExistQuery);
    }

    public Object checkExistence(Object object) {
        ClassDescriptor classDescriptor = this.getDescriptor(object.getClass());
        Vector vector = classDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, this, true);
        if (vector == null) {
            return null;
        }
        DoesExistQuery doesExistQuery = classDescriptor.getQueryManager().getDoesExistQuery();
        Boolean bl = (Boolean)doesExistQuery.checkEarlyReturn(object, vector, this, null);
        if (bl == null) {
            doesExistQuery = (DoesExistQuery)doesExistQuery.clone();
            doesExistQuery.setObject(object);
            doesExistQuery.setPrimaryKey(vector);
            doesExistQuery.setDescriptor(classDescriptor);
            doesExistQuery.setIsExecutionClone(true);
            bl = (boolean)((Boolean)this.executeQuery(doesExistQuery));
        }
        if (bl.booleanValue()) {
            Object object2 = this.getIdentityMapAccessorInstance().getFromIdentityMap(vector, object.getClass(), classDescriptor);
            if (object2 != null) {
                if (this.shouldPerformFullValidation() && object2 != object && this.getParent().getIdentityMapAccessorInstance().getFromIdentityMap(vector, object.getClass(), classDescriptor) != object) {
                    throw ValidationException.wrongObjectRegistered(object, object2);
                }
                if (!this.isObjectDeleted(object2)) {
                    return object2;
                }
            }
            CacheKey cacheKey = new CacheKey(vector);
            cacheKey.setReadTime(System.currentTimeMillis());
            return this.cloneAndRegisterObject(object, cacheKey, classDescriptor);
        }
        return null;
    }

    public Object checkIfAlreadyRegistered(Object object, ClassDescriptor classDescriptor) {
        if (this.isClassReadOnly(object.getClass(), classDescriptor)) {
            return null;
        }
        Object v = this.getCloneMapping().get(object);
        if (v != null) {
            return object;
        }
        if (this.hasNewObjects() && (v = this.getNewObjectsOriginalToClone().get(object)) != null) {
            return v;
        }
        if (this.isNestedUnitOfWork()) {
            if (this.hasNewObjectsInParentOriginalToClone()) {
                v = this.getNewObjectsInParentOriginalToClone().get(object);
            }
            if (v != null) {
                return v;
            }
        }
        return null;
    }

    protected Object cloneAndRegisterNewObject(Object object) {
        ClassDescriptor classDescriptor = this.getDescriptor(object);
        if (this.isNestedUnitOfWork() && classDescriptor.getObjectChangePolicy() instanceof AttributeChangeTrackingPolicy) {
            throw ValidationException.nestedUOWNotSupportedForAttributeTracking();
        }
        ObjectBuilder objectBuilder = classDescriptor.getObjectBuilder();
        Object object2 = objectBuilder.instantiateWorkingCopyClone(object, this);
        this.getNewObjectsOriginalToClone().put(object, object2);
        this.getCloneMapping().put(object2, object2);
        objectBuilder.populateAttributesForClone(object, object2, this);
        this.registerNewObjectClone(object2, object, classDescriptor);
        Object object3 = classDescriptor.getObjectChangePolicy().buildBackupClone(object2, objectBuilder, this);
        this.getCloneMapping().put(object2, object3);
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object cloneAndRegisterObject(Object object, CacheKey cacheKey, ClassDescriptor classDescriptor) {
        CacheKey cacheKey2 = this.getIdentityMapAccessorInstance().acquireLock(cacheKey.getKey(), object.getClass(), classDescriptor);
        try {
            Object object2 = this.cloneAndRegisterObject(object, cacheKey, cacheKey2, classDescriptor);
            return object2;
        }
        finally {
            cacheKey2.release();
        }
    }

    public void checkInvalidObject(Object object, CacheKey cacheKey, ClassDescriptor classDescriptor) {
        CacheInvalidationPolicy cacheInvalidationPolicy;
        if (!this.isNestedUnitOfWork() && cacheKey.getObject() != null && (cacheInvalidationPolicy = classDescriptor.getCacheInvalidationPolicy()).shouldRefreshInvalidObjectsInUnitOfWork() && cacheInvalidationPolicy.isInvalidated(cacheKey)) {
            ReadObjectQuery readObjectQuery = new ReadObjectQuery();
            readObjectQuery.setReferenceClass(object.getClass());
            readObjectQuery.setSelectionKey(cacheKey.getKey());
            readObjectQuery.refreshIdentityMapResult();
            readObjectQuery.setIsExecutionClone(true);
            this.parent.executeQuery(readObjectQuery);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object cloneAndRegisterObject(Object object, CacheKey cacheKey, CacheKey cacheKey2, ClassDescriptor classDescriptor) {
        ClassDescriptor classDescriptor2 = classDescriptor;
        if (object.getClass() != classDescriptor.getJavaClass()) {
            classDescriptor2 = this.getDescriptor(object);
        }
        if (this.isNestedUnitOfWork() && classDescriptor2.getObjectChangePolicy().isAttributeChangeTrackingPolicy()) {
            throw ValidationException.nestedUOWNotSupportedForAttributeTracking();
        }
        ObjectBuilder objectBuilder = classDescriptor2.getObjectBuilder();
        Object object2 = null;
        boolean bl = this.shouldCheckWriteLock && this.getParent().getIdentityMapAccessorInstance().acquireWriteLock();
        boolean bl2 = false;
        if (bl) {
            this.checkInvalidObject(object, cacheKey, classDescriptor);
        } else if (this.objectsLockedForClone == null) {
            if (classDescriptor2.shouldAcquireCascadedLocks()) {
                this.objectsLockedForClone = this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().acquireLocksForClone(object, classDescriptor2, cacheKey, this.getParent(), this);
            } else {
                this.checkInvalidObject(object, cacheKey, classDescriptor);
                cacheKey.acquireReadLock();
            }
            bl2 = true;
        }
        try {
            object2 = objectBuilder.instantiateWorkingCopyClone(object, this);
            if (object2 instanceof PersistenceEntity) {
                ((PersistenceEntity)object2)._persistence_setPKVector(cacheKey.getKey());
            }
            this.getCloneMapping().put(object2, object2);
            if (this.isNestedUnitOfWork() && this.isCloneNewObjectFromParent(object)) {
                this.getNewObjectsInParentOriginalToClone().put(object, object2);
            }
            this.getCloneToOriginals().put(object2, object);
            this.populateAndRegisterObject(object, object2, cacheKey2, cacheKey, classDescriptor2);
            if (classDescriptor2.hasFetchGroupManager()) {
                classDescriptor2.getFetchGroupManager().copyFetchGroupInto(object, object2, this);
            }
        }
        finally {
            if (bl) {
                this.getParent().getIdentityMapAccessorInstance().releaseWriteLock();
            } else if (bl2) {
                if (this.objectsLockedForClone == null) {
                    cacheKey.releaseReadLock();
                } else {
                    Iterator iterator = this.objectsLockedForClone.values().iterator();
                    while (iterator.hasNext()) {
                        ((CacheKey)iterator.next()).releaseReadLock();
                    }
                    this.objectsLockedForClone = null;
                }
            }
        }
        classDescriptor2.getObjectBuilder().instantiateEagerMappings(object2, this);
        return object2;
    }

    public Map collectAndPrepareObjectsForNestedMerge() {
        this.discoverAllUnregisteredNewObjectsInParent();
        return new IdentityHashMap(this.getCloneMapping());
    }

    @Override
    public void commit() throws DatabaseException, OptimisticLockException {
        if (!this.isActive()) {
            throw ValidationException.cannotCommitUOWAgain();
        }
        if (this.isAfterWriteChangesFailed()) {
            throw ValidationException.unitOfWorkAfterWriteChangesFailed("commit");
        }
        if (!this.isNestedUnitOfWork() && this.isSynchronized()) {
            if (this.getParent().wasJTSTransactionInternallyStarted()) {
                this.commitInternallyStartedExternalTransaction();
            }
            return;
        }
        if (this.getLifecycle() == 2) {
            this.commitAfterWriteChanges();
            return;
        }
        this.log(2, "transaction", "begin_unit_of_work_commit");
        this.getEventManager().preCommitUnitOfWork();
        this.setLifecycle(1);
        if (this.isNestedUnitOfWork()) {
            this.commitNestedUnitOfWork();
        } else {
            this.commitRootUnitOfWork();
        }
        this.getEventManager().postCommitUnitOfWork();
        this.log(2, "transaction", "end_unit_of_work_commit");
        this.release();
    }

    @Override
    public void commitAndResume() throws DatabaseException, OptimisticLockException {
        if (!this.isActive()) {
            throw ValidationException.cannotCommitUOWAgain();
        }
        if (this.isAfterWriteChangesFailed()) {
            throw ValidationException.unitOfWorkAfterWriteChangesFailed("commit");
        }
        if (!this.isNestedUnitOfWork() && this.isSynchronized()) {
            throw ValidationException.cannotCommitAndResumeSynchronizedUOW(this);
        }
        if (this.getLifecycle() == 2) {
            this.commitAndResumeAfterWriteChanges();
            return;
        }
        this.log(2, "transaction", "begin_unit_of_work_commit");
        this.getEventManager().preCommitUnitOfWork();
        this.setLifecycle(1);
        if (this.getParent().isUnitOfWork()) {
            this.commitNestedUnitOfWork();
        } else {
            this.commitRootUnitOfWork();
        }
        this.getEventManager().postCommitUnitOfWork();
        this.log(2, "transaction", "end_unit_of_work_commit");
        this.log(2, "transaction", "resume_unit_of_work");
        this.synchronizeAndResume();
        this.getEventManager().postResumeUnitOfWork();
    }

    public void commitAndResumeWithPreBuiltChangeSet(UnitOfWorkChangeSet unitOfWorkChangeSet) throws DatabaseException, OptimisticLockException {
        if (!this.isNestedUnitOfWork() && this.isSynchronized()) {
            if (this.getParent().wasJTSTransactionInternallyStarted()) {
                this.commitInternallyStartedExternalTransaction();
            }
            return;
        }
        this.log(2, "transaction", "begin_unit_of_work_commit");
        this.getEventManager().preCommitUnitOfWork();
        this.setLifecycle(1);
        if (this.getParent().isUnitOfWork()) {
            this.commitNestedUnitOfWork();
        } else {
            this.commitRootUnitOfWorkWithPreBuiltChangeSet(unitOfWorkChangeSet);
        }
        this.getEventManager().postCommitUnitOfWork();
        this.log(2, "transaction", "end_unit_of_work_commit");
        this.log(2, "transaction", "resume_unit_of_work");
        this.synchronizeAndResume();
        this.getEventManager().postResumeUnitOfWork();
    }

    @Override
    public void commitAndResumeOnFailure() throws DatabaseException, OptimisticLockException {
        IdentityMapManager identityMapManager = (IdentityMapManager)this.getIdentityMapAccessorInstance().getIdentityMapManager().clone();
        try {
            this.commitAndResume();
        }
        catch (RuntimeException runtimeException) {
            this.setUnitOfWorkChangeSet(null);
            this.getIdentityMapAccessorInstance().setIdentityMapManager(identityMapManager);
            this.log(2, "transaction", "resuming_unit_of_work_from_failure");
            throw runtimeException;
        }
    }

    protected void commitAfterWriteChanges() {
        this.commitTransactionAfterWriteChanges();
        this.mergeClonesAfterCompletion();
        this.setDead();
        this.release();
    }

    protected void commitAndResumeAfterWriteChanges() {
        this.commitTransactionAfterWriteChanges();
        this.mergeClonesAfterCompletion();
        this.log(2, "transaction", "resume_unit_of_work");
        this.synchronizeAndResume();
        this.getEventManager().postResumeUnitOfWork();
    }

    protected boolean commitInternallyStartedExternalTransaction() {
        boolean bl = false;
        if (!this.getParent().isInTransaction() || this.wasTransactionBegunPrematurely() && this.getParent().getTransactionMutex().getDepth() == 1) {
            bl = this.getParent().commitExternalTransaction();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commitNestedUnitOfWork() {
        this.getParent().getIdentityMapAccessorInstance().acquireWriteLock();
        try {
            if (this.getUnitOfWorkChangeSet() == null) {
                this.setUnitOfWorkChangeSet(new UnitOfWorkChangeSet(this));
            }
            this.unitOfWorkChangeSet = this.calculateChanges(this.collectAndPrepareObjectsForNestedMerge(), (UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet(), false);
            this.allClones = null;
            this.mergeChangesIntoParent();
            if (this.hasDeletedObjects()) {
                for (Object object : this.getDeletedObjects().keySet()) {
                    Object object2 = this.getOriginalVersionOfObject(object);
                    if (object2 != null && ((UnitOfWorkImpl)this.getParent()).getNewObjectsCloneToOriginal().containsKey(object2)) {
                        ((UnitOfWorkImpl)this.getParent()).unregisterObject(object2);
                        continue;
                    }
                    ((UnitOfWorkImpl)this.getParent()).getDeletedObjects().put(object2, this.keyFromObject(object2));
                }
            }
            if (this.hasRemovedObjects()) {
                Iterator<Object> iterator = this.getRemovedObjects().values().iterator();
                while (iterator.hasNext()) {
                    ((UnitOfWorkImpl)this.getParent()).getCloneMapping().remove(iterator.next());
                }
            }
        }
        finally {
            this.getParent().getIdentityMapAccessorInstance().releaseWriteLock();
        }
    }

    public void commitRootUnitOfWork() throws DatabaseException, OptimisticLockException {
        this.commitToDatabaseWithChangeSet(true);
        this.mergeChangesIntoParent();
        this.changeTrackedHardList = null;
    }

    public void commitRootUnitOfWorkWithPreBuiltChangeSet(UnitOfWorkChangeSet unitOfWorkChangeSet) throws DatabaseException, OptimisticLockException {
        this.commitToDatabaseWithPreBuiltChangeSet(unitOfWorkChangeSet, true);
        this.mergeChangesIntoParent();
    }

    protected void commitToDatabase(boolean bl) {
        block24: {
            try {
                if (this.wasTransactionBegunPrematurely()) {
                    this.setWasTransactionBegunPrematurely(false);
                } else {
                    this.beginTransaction();
                }
                if (bl) {
                    this.setWasNonObjectLevelModifyQueryExecuted(false);
                }
                this.preDeleteComplete = false;
                Vector<Object> vector = null;
                if (this.hasDeletedObjects()) {
                    vector = new Vector<Object>(this.getDeletedObjects().size());
                    for (Object object : this.getDeletedObjects().keySet()) {
                        ClassDescriptor classDescriptor = this.getDescriptor(object);
                        if (classDescriptor.hasPreDeleteMappings()) {
                            for (DatabaseMapping databaseMapping : classDescriptor.getPreDeleteMappings()) {
                                DeleteObjectQuery deleteObjectQuery = classDescriptor.getQueryManager().getDeleteQuery();
                                if (deleteObjectQuery == null) {
                                    deleteObjectQuery = new DeleteObjectQuery();
                                    deleteObjectQuery.setDescriptor(classDescriptor);
                                } else {
                                    deleteObjectQuery.checkPrepare(this, deleteObjectQuery.getTranslationRow());
                                    deleteObjectQuery = (DeleteObjectQuery)deleteObjectQuery.clone();
                                }
                                deleteObjectQuery.setIsExecutionClone(true);
                                deleteObjectQuery.setTranslationRow(new DatabaseRecord());
                                deleteObjectQuery.setObject(object);
                                deleteObjectQuery.setSession(this);
                                databaseMapping.earlyPreDelete(deleteObjectQuery);
                            }
                        }
                        vector.addElement(object);
                    }
                    this.preDeleteComplete = true;
                }
                if (this.shouldPerformDeletesFirst) {
                    if (this.hasDeletedObjects()) {
                        this.getCommitManager().deleteAllObjects(vector);
                        Iterator iterator = this.getObjectsDeletedDuringCommit().keySet().iterator();
                        while (iterator.hasNext()) {
                            Object object;
                            object = (ObjectChangeSet)this.unitOfWorkChangeSet.getObjectChangeSetForClone(iterator.next());
                            if (object == null) continue;
                            ((ObjectChangeSet)object).clear();
                        }
                    }
                    super.writeAllObjectsWithChangeSet(this.unitOfWorkChangeSet);
                    this.issueModifyAllQueryList();
                } else {
                    super.writeAllObjectsWithChangeSet(this.unitOfWorkChangeSet);
                    if (this.hasDeletedObjects()) {
                        this.getCommitManager().deleteAllObjects(vector);
                    }
                    this.issueModifyAllQueryList();
                }
                this.getEventManager().prepareUnitOfWork();
                if (bl) {
                    try {
                        if (this.getDatasourceLogin().shouldSynchronizeObjectLevelReadWriteDatabase()) {
                            this.setMergeManager(new MergeManager(this));
                            this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().acquireRequiredLocks(this.getMergeManager(), (UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet());
                        }
                        this.commitTransaction();
                        break block24;
                    }
                    catch (RuntimeException runtimeException) {
                        if (this.getDatasourceLogin().shouldSynchronizeObjectLevelReadWriteDatabase() && this.getMergeManager() != null) {
                            this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().releaseAllAcquiredLocks(this.getMergeManager());
                            this.setMergeManager(null);
                        }
                        throw runtimeException;
                    }
                    catch (Error error) {
                        if (this.getDatasourceLogin().shouldSynchronizeObjectLevelReadWriteDatabase() && this.getMergeManager() != null) {
                            this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().releaseAllAcquiredLocks(this.getMergeManager());
                            this.setMergeManager(null);
                        }
                        throw error;
                    }
                }
                this.setWasTransactionBegunPrematurely(true);
            }
            catch (RuntimeException runtimeException) {
                this.copyStatementsCountIntoProperties();
                this.rollbackTransaction(bl);
                if (this.hasExceptionHandler()) {
                    this.getExceptionHandler().handleException(runtimeException);
                }
                throw runtimeException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commitToDatabaseWithChangeSet(boolean bl) throws DatabaseException, OptimisticLockException {
        block13: {
            try {
                boolean bl2;
                this.startOperationProfile("UnitOfWorkCommits");
                boolean bl3 = bl2 = this.unitOfWorkChangeSet != null || this.hasCloneMapping() || this.hasDeletedObjects() || this.hasModifyAllQueries() || this.hasDeferredModifyAllQueries();
                if (bl2) {
                    try {
                        if (this.unitOfWorkChangeSet == null) {
                            this.unitOfWorkChangeSet = new UnitOfWorkChangeSet(this);
                        }
                        this.calculateChanges(this.cloneMap(this.getCloneMapping()), this.unitOfWorkChangeSet, true);
                        this.getCommitManager().setIsActive(true);
                    }
                    catch (RuntimeException runtimeException) {
                        this.copyStatementsCountIntoProperties();
                        throw runtimeException;
                    }
                    bl2 = this.hasModifications();
                }
                if (bl2) {
                    this.commitToDatabase(bl);
                    break block13;
                }
                try {
                    if (this.wasTransactionBegunPrematurely() && bl) {
                        this.setWasTransactionBegunPrematurely(false);
                        this.setWasNonObjectLevelModifyQueryExecuted(false);
                        this.commitTransaction();
                    }
                    this.getCommitManager().setIsActive(false);
                }
                catch (RuntimeException runtimeException) {
                    this.copyStatementsCountIntoProperties();
                    throw runtimeException;
                }
            }
            catch (RuntimeException runtimeException) {
                this.handleException(runtimeException);
            }
            finally {
                this.endOperationProfile("UnitOfWorkCommits");
            }
        }
    }

    protected void commitToDatabaseWithPreBuiltChangeSet(UnitOfWorkChangeSet unitOfWorkChangeSet, boolean bl) throws DatabaseException, OptimisticLockException {
        try {
            unitOfWorkChangeSet.setIsChangeSetFromOutsideUOW(true);
            this.getCommitManager().setIsActive(true);
            this.setUnitOfWorkChangeSet(unitOfWorkChangeSet);
            this.commitToDatabase(bl);
            unitOfWorkChangeSet.setIsChangeSetFromOutsideUOW(false);
        }
        catch (RuntimeException runtimeException) {
            this.handleException(runtimeException);
        }
    }

    @Override
    public void commitTransaction() throws DatabaseException {
        this.getParent().commitTransaction();
    }

    protected void commitTransactionAfterWriteChanges() {
        this.setWasNonObjectLevelModifyQueryExecuted(false);
        if (this.hasModifications() || this.wasTransactionBegunPrematurely()) {
            try {
                this.setWasTransactionBegunPrematurely(false);
                if (this.getDatasourceLogin().shouldSynchronizeObjectLevelReadWriteDatabase() && this.getUnitOfWorkChangeSet() != null) {
                    this.setMergeManager(new MergeManager(this));
                    this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().acquireRequiredLocks(this.getMergeManager(), (UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet());
                }
                this.commitTransaction();
            }
            catch (RuntimeException runtimeException) {
                if (this.getDatasourceLogin().shouldSynchronizeObjectLevelReadWriteDatabase() && this.getMergeManager() != null) {
                    this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().releaseAllAcquiredLocks(this.getMergeManager());
                    this.setMergeManager(null);
                }
                this.rollbackTransaction();
                this.release();
                this.handleException(runtimeException);
            }
            catch (Error error) {
                if (this.getDatasourceLogin().shouldSynchronizeObjectLevelReadWriteDatabase() && this.getMergeManager() != null) {
                    this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().releaseAllAcquiredLocks(this.getMergeManager());
                    this.setMergeManager(null);
                }
                throw error;
            }
        }
    }

    @Override
    public Vector copyReadOnlyClasses() {
        return new Vector(this.getReadOnlyClasses());
    }

    @Override
    public Object deepMergeClone(Object object) {
        return this.mergeClone(object, 3);
    }

    @Override
    public Object deepRevertObject(Object object) {
        return this.revertObject(object, 3);
    }

    @Override
    public void deepUnregisterObject(Object object) {
        this.unregisterObject(object, 3);
    }

    @Override
    public void deleteAllObjects(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.deleteObject(enumeration.nextElement());
        }
    }

    protected void discoverAllUnregisteredNewObjects() {
        IdentityHashMap identityHashMap = new IdentityHashMap();
        IdentityHashMap identityHashMap2 = new IdentityHashMap();
        IdentityHashMap identityHashMap3 = new IdentityHashMap();
        this.discoverUnregisteredNewObjects(new IdentityHashMap(this.getCloneMapping()), identityHashMap2, identityHashMap3, identityHashMap);
        this.setUnregisteredNewObjects(identityHashMap2);
        this.setUnregisteredExistingObjects(identityHashMap3);
    }

    protected void discoverAllUnregisteredNewObjectsInParent() {
        if (this.isNestedUnitOfWork()) {
            IdentityHashMap identityHashMap = new IdentityHashMap();
            IdentityHashMap identityHashMap2 = new IdentityHashMap();
            UnitOfWorkImpl unitOfWorkImpl = (UnitOfWorkImpl)this.getParent();
            unitOfWorkImpl.discoverUnregisteredNewObjects(((UnitOfWorkImpl)this.getParent()).getCloneMapping(), identityHashMap2, new IdentityHashMap(), identityHashMap);
            this.setUnregisteredNewObjectsInParent(identityHashMap2);
        }
    }

    public void discoverUnregisteredNewObjects(Map map, final Map map2, final Map map3, Map map4) {
        DescriptorIterator descriptorIterator = new DescriptorIterator(){

            public void iterate(Object object) {
                if (UnitOfWorkImpl.this.isClassReadOnly(object.getClass(), this.getCurrentDescriptor())) {
                    this.setShouldBreak(true);
                    return;
                }
                if (UnitOfWorkImpl.isSmartMerge() && UnitOfWorkImpl.this.isOriginalNewObject(object)) {
                    return;
                }
                if (!UnitOfWorkImpl.this.isObjectRegistered(object)) {
                    if (UnitOfWorkImpl.this.shouldPerformNoValidation()) {
                        if (UnitOfWorkImpl.this.checkForUnregisteredExistingObject(object)) {
                            map3.put(object, object);
                            this.setShouldBreak(true);
                            return;
                        }
                    } else {
                        UnitOfWorkImpl.this.getBackupClone(object, this.getCurrentDescriptor());
                    }
                    map2.put(object, object);
                }
            }

            public void iterateReferenceObjectForMapping(Object object, DatabaseMapping databaseMapping) {
                super.iterateReferenceObjectForMapping(object, databaseMapping);
                if (UnitOfWorkImpl.this.hasPrivateOwnedObjects()) {
                    UnitOfWorkImpl.this.removePrivateOwnedObject(databaseMapping, object);
                }
            }
        };
        this.setUnregisteredExistingObjects(map3);
        descriptorIterator.setVisitedObjects(map4);
        descriptorIterator.setResult(map2);
        descriptorIterator.setSession(this);
        descriptorIterator.setShouldIterateOverWrappedObjects(false);
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            descriptorIterator.startIterationOn(iterator.next());
        }
    }

    @Override
    public void dontPerformValidation() {
        this.setValidationLevel(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object executeCall(Call call, AbstractRecord abstractRecord, DatabaseQuery databaseQuery) throws DatabaseException {
        Accessor accessor = databaseQuery.getSessionName() == null ? databaseQuery.getSession().getAccessor(databaseQuery.getReferenceClass()) : databaseQuery.getSession().getAccessor(databaseQuery.getSessionName());
        databaseQuery.setAccessor(accessor);
        try {
            Object object = databaseQuery.getAccessor().executeCall(call, abstractRecord, this);
            return object;
        }
        finally {
            if (call.isFinished()) {
                databaseQuery.setAccessor(null);
            }
        }
    }

    @Override
    public void forceUpdateToVersionField(Object object, boolean bl) {
        ClassDescriptor classDescriptor = this.getDescriptor(object);
        if (classDescriptor == null) {
            throw DescriptorException.missingDescriptor(object.getClass().toString());
        }
        this.getOptimisticReadLockObjects().put(classDescriptor.getObjectBuilder().unwrapObject(object, this), bl);
    }

    @Override
    public Accessor getAccessor() {
        return this.getParent().getAccessor();
    }

    @Override
    public CommitManager getCommitManager() {
        if (this.commitManager == null) {
            this.commitManager = new CommitManager(this);
            this.commitManager.setCommitOrder(this.getParent().getCommitManager().getCommitOrder());
        }
        return this.commitManager;
    }

    @Override
    public Accessor getAccessor(Class clazz) {
        return this.getParent().getAccessor(clazz);
    }

    @Override
    public Accessor getAccessor(String string) {
        return this.getParent().getAccessor(string);
    }

    @Override
    public UnitOfWork getActiveUnitOfWork() {
        return this.getParent().getActiveUnitOfWork();
    }

    public Vector getAllFromNewObjects(Expression expression, Class clazz, AbstractRecord abstractRecord, int n) {
        if (this.shouldNewObjectsBeCached() && expression != null) {
            return new Vector(1);
        }
        if (!this.hasNewObjects()) {
            return new Vector(1);
        }
        Vector vector = new Vector();
        for (Object v : this.getNewObjectsOriginalToClone().values()) {
            if (!clazz.isInstance(v)) continue;
            if (expression == null) {
                vector.addElement(v);
                continue;
            }
            if (!expression.doesConform(v, this, abstractRecord, n)) continue;
            vector.addElement(v);
        }
        return vector;
    }

    public Object getBackupClone(Object object) throws QueryException {
        return this.getBackupClone(object, null);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getBackupClone(Object object, ClassDescriptor classDescriptor) throws QueryException {
        void var3_6;
        Object v = this.getCloneMapping().get(object);
        if (v != null) {
            return v;
        }
        if (this.isObjectRegistered(object)) {
            return this.getCloneMapping().get(object);
        }
        if (classDescriptor == null) {
            classDescriptor = this.getDescriptor(object);
        }
        Vector vector = this.keyFromObject(object, classDescriptor);
        if (this.getParent().getIdentityMapAccessorInstance().containsObjectInIdentityMap(vector, object.getClass(), classDescriptor)) {
            if (this.getUnregisteredNewObjects().get(object) != null && this.isMergePending()) {
                return classDescriptor.getObjectBuilder().buildNewInstance();
            }
            if (!this.hasObjectsDeletedDuringCommit() || !this.getObjectsDeletedDuringCommit().containsKey(object)) throw QueryException.backupCloneIsOriginalFromParent(object);
            throw QueryException.backupCloneIsDeleted(object);
        }
        if (this.hasNewObjects() && this.getNewObjectsOriginalToClone().containsKey(object)) {
            if (!UnitOfWorkImpl.isSmartMerge()) throw QueryException.backupCloneIsOriginalFromSelf(object);
            Object v2 = this.getCloneMapping().get(this.getNewObjectsOriginalToClone().get(object));
            return var3_6;
        } else {
            Object object2 = classDescriptor.getObjectBuilder().buildNewInstance();
        }
        return var3_6;
    }

    public Object getBackupCloneForCommit(Object object, ClassDescriptor classDescriptor) {
        Object object2 = this.getBackupClone(object, classDescriptor);
        if (this.isCloneNewObject(object)) {
            if (classDescriptor != null) {
                return classDescriptor.getObjectBuilder().buildNewInstance();
            }
            return this.getDescriptor(object).getObjectBuilder().buildNewInstance();
        }
        return object2;
    }

    public Object getBackupCloneForCommit(Object object) {
        Object object2 = this.getBackupClone(object);
        if (this.isCloneNewObject(object)) {
            return this.getDescriptor(object).getObjectBuilder().buildNewInstance();
        }
        return object2;
    }

    @Override
    public org.eclipse.persistence.sessions.changesets.UnitOfWorkChangeSet getCurrentChanges() {
        Map map = this.collectAndPrepareObjectsForNestedMerge();
        return this.calculateChanges(map, new UnitOfWorkChangeSet(this), false);
    }

    @Override
    public AbstractSession getParentIdentityMapSession(DatabaseQuery databaseQuery, boolean bl, boolean bl2) {
        if (bl && !bl2) {
            return this;
        }
        return this.getParent().getParentIdentityMapSession(databaseQuery, true, bl2);
    }

    @Override
    public AbstractSession getExecutionSession(DatabaseQuery databaseQuery) {
        return this.getParent().getExecutionSession(databaseQuery);
    }

    public Map getCloneMapping() {
        if (this.cloneMapping == null) {
            this.cloneMapping = this.createMap();
        }
        return this.cloneMapping;
    }

    protected boolean hasCloneMapping() {
        return this.cloneMapping != null && !this.cloneMapping.isEmpty();
    }

    public Map getCloneToOriginals() {
        if (this.cloneToOriginals == null) {
            this.cloneToOriginals = this.createMap();
        }
        return this.cloneToOriginals;
    }

    protected boolean hasCloneToOriginals() {
        return this.cloneToOriginals != null && !this.cloneToOriginals.isEmpty();
    }

    public Map getContainerBeans() {
        if (this.containerBeans == null) {
            this.containerBeans = new IdentityHashMap();
        }
        return this.containerBeans;
    }

    public boolean hasContainerBeans() {
        return this.containerBeans != null && !this.containerBeans.isEmpty();
    }

    public boolean hasUnregisteredNewObjects() {
        return this.unregisteredNewObjects != null && !this.unregisteredNewObjects.isEmpty();
    }

    public boolean hasNewObjects() {
        return this.newObjectsOriginalToClone != null && !this.newObjectsOriginalToClone.isEmpty();
    }

    public UnitOfWorkImpl getContainerUnitOfWork() {
        if (this.containerUnitOfWork == null) {
            this.containerUnitOfWork = this.getParent().acquireNonSynchronizedUnitOfWork(ReferenceMode.WEAK);
        }
        return this.containerUnitOfWork;
    }

    @Override
    public Vector getDefaultReadOnlyClasses() {
        return this.getParent().getDefaultReadOnlyClasses();
    }

    public Map getDeletedObjects() {
        if (this.deletedObjects == null) {
            this.deletedObjects = new IdentityHashMap();
        }
        return this.deletedObjects;
    }

    public boolean hasDeletedObjects() {
        return this.deletedObjects != null && !this.deletedObjects.isEmpty();
    }

    public int getLifecycle() {
        return this.lifecycle;
    }

    public MergeManager getMergeManager() {
        return this.lastUsedMergeManager;
    }

    public Map getNewAggregates() {
        if (this.newAggregates == null) {
            this.newAggregates = new IdentityHashMap();
        }
        return this.newAggregates;
    }

    public synchronized Map getNewObjectsCloneToOriginal() {
        if (this.newObjectsCloneToOriginal == null) {
            this.newObjectsCloneToOriginal = new IdentityHashMap();
        }
        return this.newObjectsCloneToOriginal;
    }

    public Map getNewObjectsInParentOriginalToClone() {
        if (this.newObjectsInParentOriginalToClone == null) {
            this.newObjectsInParentOriginalToClone = new IdentityHashMap();
        }
        return this.newObjectsInParentOriginalToClone;
    }

    protected boolean hasNewObjectsInParentOriginalToClone() {
        return this.newObjectsInParentOriginalToClone != null && !this.newObjectsInParentOriginalToClone.isEmpty();
    }

    private Map<DatabaseMapping, Set> getPrivateOwnedObjects() {
        if (this.privateOwnedObjects == null) {
            this.privateOwnedObjects = new IdentityHashMap();
        }
        return this.privateOwnedObjects;
    }

    public boolean hasPrivateOwnedObjects() {
        return this.privateOwnedObjects != null && !this.privateOwnedObjects.isEmpty();
    }

    public boolean hasOptimisticReadLockObjects() {
        return this.optimisticReadLockObjects != null && !this.optimisticReadLockObjects.isEmpty();
    }

    public synchronized Map getNewObjectsOriginalToClone() {
        if (this.newObjectsOriginalToClone == null) {
            this.newObjectsOriginalToClone = new IdentityHashMap();
        }
        return this.newObjectsOriginalToClone;
    }

    @Override
    public Sequencing getSequencing() {
        return this.getParent().getSequencing();
    }

    @Override
    public ServerPlatform getServerPlatform() {
        return this.getParent().getServerPlatform();
    }

    @Override
    public String getSessionTypeString() {
        return "UnitOfWork";
    }

    public void afterExternalTransactionRollback() {
        this.getParent().setWasJTSTransactionInternallyStarted(false);
        this.setLifecycle(6);
        if (this.getMergeManager() != null && this.getMergeManager().getAcquiredLocks() != null && !this.getMergeManager().getAcquiredLocks().isEmpty()) {
            this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().releaseAllAcquiredLocks(this.getMergeManager());
            this.setMergeManager(null);
        }
    }

    @Override
    public void releaseJTSConnection() {
        this.getParent().releaseJTSConnection();
    }

    public Object getObjectFromNewObjects(Class clazz, Vector vector) {
        if (!this.hasNewObjects()) {
            return null;
        }
        ObjectBuilder objectBuilder = this.getDescriptor(clazz).getObjectBuilder();
        for (Object v : this.getNewObjectsOriginalToClone().values()) {
            Vector vector2;
            if (!clazz.isInstance(v) || !new CacheKey(vector2 = objectBuilder.extractPrimaryKeyFromObject(v, this)).equals(new CacheKey(vector))) continue;
            return v;
        }
        return null;
    }

    public Object getObjectFromNewObjects(Expression expression, Class clazz, AbstractRecord abstractRecord, int n) {
        if (!this.hasNewObjects()) {
            return null;
        }
        for (Object v : this.getNewObjectsOriginalToClone().values()) {
            if (!clazz.isInstance(v)) continue;
            if (expression == null) {
                return v;
            }
            if (!expression.doesConform(v, this, abstractRecord, n)) continue;
            return v;
        }
        return null;
    }

    public Map getObjectsDeletedDuringCommit() {
        if (this.objectsDeletedDuringCommit == null) {
            this.objectsDeletedDuringCommit = new IdentityHashMap();
        }
        return this.objectsDeletedDuringCommit;
    }

    protected boolean hasObjectsDeletedDuringCommit() {
        return this.objectsDeletedDuringCommit != null && !this.objectsDeletedDuringCommit.isEmpty();
    }

    public Map getOptimisticReadLockObjects() {
        if (this.optimisticReadLockObjects == null) {
            this.optimisticReadLockObjects = new HashMap(2);
        }
        return this.optimisticReadLockObjects;
    }

    public Object getOriginalVersionOfNewObject(Object object) {
        if (!this.hasNewObjects()) {
            return null;
        }
        return this.getNewObjectsCloneToOriginal().get(object);
    }

    @Override
    public Object getOriginalVersionOfObject(Object object) {
        if (object == null) {
            return null;
        }
        ClassDescriptor classDescriptor = this.getDescriptor(object);
        ObjectBuilder objectBuilder = classDescriptor.getObjectBuilder();
        Object object2 = objectBuilder.unwrapObject(object, this);
        Object object3 = this.getObjectFromSharedCacheForMerge(object2, objectBuilder, classDescriptor);
        if (object3 == null) {
            object3 = this.getOriginalVersionOfNewObject(object2);
        }
        if (object3 == null) {
            if (this.isClassReadOnly(object2.getClass(), classDescriptor)) {
                return object2;
            }
            if (this.hasCloneToOriginals()) {
                object3 = this.getCloneToOriginals().get(object);
            }
        }
        if (object3 == null) {
            object3 = this.buildOriginal(object2);
        }
        return object3;
    }

    public Object getOriginalVersionOfObjectOrNull(Object object, ObjectChangeSet objectChangeSet, ClassDescriptor classDescriptor) {
        if (object == null) {
            return null;
        }
        Object object2 = null;
        CacheKey cacheKey = null;
        if (objectChangeSet != null && (cacheKey = objectChangeSet.getActiveCacheKey()) != null && (object2 = cacheKey.getObject()) != null) {
            return object2;
        }
        ObjectBuilder objectBuilder = classDescriptor.getObjectBuilder();
        Object object3 = objectBuilder.unwrapObject(object, this);
        if (cacheKey == null) {
            object2 = this.getObjectFromSharedCacheForMerge(object3, objectBuilder, classDescriptor);
        }
        if (object2 == null) {
            object2 = this.getOriginalVersionOfNewObject(object3);
        }
        if (object2 == null) {
            if (this.isClassReadOnly(object3.getClass(), classDescriptor)) {
                return object3;
            }
            if (this.hasCloneToOriginals()) {
                object2 = this.getCloneToOriginals().get(object);
            }
        }
        return object2;
    }

    public Object getOriginalVersionOfObjectOrNull(Object object, ClassDescriptor classDescriptor) {
        if (object == null) {
            return null;
        }
        ObjectBuilder objectBuilder = classDescriptor.getObjectBuilder();
        Object object2 = objectBuilder.unwrapObject(object, this);
        Vector vector = objectBuilder.extractPrimaryKeyFromObject(object2, this);
        Object object3 = this.getParent().getIdentityMapAccessorInstance().getFromIdentityMap(vector, object2.getClass(), classDescriptor);
        if (object3 == null) {
            object3 = this.getOriginalVersionOfNewObject(object2);
        }
        if (object3 == null) {
            if (this.isClassReadOnly(object2.getClass(), classDescriptor)) {
                return object2;
            }
            if (this.hasCloneToOriginals()) {
                object3 = this.getCloneToOriginals().get(object);
            }
        }
        return object3;
    }

    @Override
    public AbstractSession getParent() {
        return this.parent;
    }

    @Override
    public Object getProperty(String string) {
        Object object = super.getProperties().get(string);
        if (object == null) {
            object = this.getParent().getProperty(string);
        }
        return object;
    }

    @Override
    public Platform getPlatform(Class clazz) {
        return this.getParent().getPlatform(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getObjectFromSharedCacheForMerge(Object object, ObjectBuilder objectBuilder, ClassDescriptor classDescriptor) {
        Object object2 = null;
        Vector vector = objectBuilder.extractPrimaryKeyFromObject(object, this);
        if (this.lastUsedMergeManager == null) {
            return this.getParent().getIdentityMapAccessorInstance().getFromIdentityMap(vector, object.getClass(), classDescriptor);
        }
        CacheKey cacheKey = this.getParent().getIdentityMapAccessorInstance().getCacheKeyForObject(vector, object.getClass(), classDescriptor);
        if (cacheKey != null) {
            if (cacheKey.acquireReadLockNoWait()) {
                object2 = cacheKey.getObject();
                cacheKey.releaseReadLock();
            } else {
                if (!this.getMergeManager().isTransitionedToDeferredLocks()) {
                    this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().transitionToDeferredLocks(this.getMergeManager());
                }
                cacheKey.acquireDeferredLock();
                object2 = cacheKey.getObject();
                if (object2 == null) {
                    ConcurrencyManager concurrencyManager = cacheKey.getMutex();
                    synchronized (concurrencyManager) {
                        if (cacheKey.isAcquired()) {
                            try {
                                cacheKey.getMutex().wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        object2 = cacheKey.getObject();
                    }
                }
                cacheKey.releaseDeferredLock();
            }
        }
        return object2;
    }

    public int getShouldThrowConformExceptions() {
        return this.shouldThrowConformExceptions;
    }

    @Override
    public DatabaseQuery getQuery(String string, Vector vector) {
        DatabaseQuery databaseQuery = super.getQuery(string, vector);
        if (databaseQuery == null) {
            databaseQuery = this.getParent().getQuery(string, vector);
        }
        return databaseQuery;
    }

    @Override
    public DatabaseQuery getQuery(String string) {
        DatabaseQuery databaseQuery = super.getQuery(string);
        if (databaseQuery == null) {
            databaseQuery = this.getParent().getQuery(string);
        }
        return databaseQuery;
    }

    @Override
    public Set getReadOnlyClasses() {
        if (this.readOnlyClasses == null) {
            this.readOnlyClasses = new HashSet();
        }
        return this.readOnlyClasses;
    }

    protected Map getRemovedObjects() {
        if (this.removedObjects == null) {
            this.removedObjects = new IdentityHashMap();
        }
        return this.removedObjects;
    }

    protected boolean hasRemovedObjects() {
        return this.removedObjects != null && !this.removedObjects.isEmpty();
    }

    protected boolean hasModifyAllQueries() {
        return this.modifyAllQueries != null && !this.modifyAllQueries.isEmpty();
    }

    protected boolean hasDeferredModifyAllQueries() {
        return this.deferredModifyAllQueries != null && !this.deferredModifyAllQueries.isEmpty();
    }

    public int getState() {
        return this.lifecycle;
    }

    public Object getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Object object) {
        this.transaction = object;
    }

    @Override
    public org.eclipse.persistence.sessions.changesets.UnitOfWorkChangeSet getUnitOfWorkChangeSet() {
        return this.unitOfWorkChangeSet;
    }

    public Map getUnregisteredExistingObjects() {
        if (this.unregisteredExistingObjects == null) {
            this.unregisteredExistingObjects = new IdentityHashMap();
        }
        return this.unregisteredExistingObjects;
    }

    protected Map getUnregisteredNewObjects() {
        if (this.unregisteredNewObjects == null) {
            this.unregisteredNewObjects = new IdentityHashMap();
        }
        return this.unregisteredNewObjects;
    }

    protected Map getUnregisteredNewObjectsInParent() {
        if (this.unregisteredNewObjectsInParent == null) {
            this.unregisteredNewObjectsInParent = new IdentityHashMap();
        }
        return this.unregisteredNewObjectsInParent;
    }

    @Override
    public int getValidationLevel() {
        return this.validationLevel;
    }

    @Override
    public boolean hasChanges() {
        if (this.hasNewObjects()) {
            return true;
        }
        if (this.hasDeletedObjects()) {
            return true;
        }
        IdentityHashMap identityHashMap = new IdentityHashMap(this.getCloneMapping());
        UnitOfWorkChangeSet unitOfWorkChangeSet = this.calculateChanges(identityHashMap, new UnitOfWorkChangeSet(this), false);
        return unitOfWorkChangeSet.hasChanges();
    }

    protected boolean hasModifications() {
        return this.unitOfWorkChangeSet != null && (this.unitOfWorkChangeSet.hasChanges() || ((UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet()).hasForcedChanges()) || this.hasDeletedObjects() || this.hasModifyAllQueries() || this.hasDeferredModifyAllQueries();
    }

    @Override
    public void initializeIdentityMapAccessor() {
        this.identityMapAccessor = new UnitOfWorkIdentityMapAccessor(this, new IdentityMapManager(this));
    }

    @Override
    public Object internalExecuteQuery(DatabaseQuery databaseQuery, AbstractRecord abstractRecord) throws DatabaseException, QueryException {
        return databaseQuery.executeInUnitOfWork(this, abstractRecord);
    }

    public Object internalRegisterObject(Object object, ClassDescriptor classDescriptor) {
        if (object == null) {
            return null;
        }
        if (classDescriptor.isDescriptorTypeAggregate()) {
            throw ValidationException.cannotRegisterAggregateObjectInUnitOfWork(object.getClass());
        }
        Object object2 = this.checkIfAlreadyRegistered(object, classDescriptor);
        if (object2 == null) {
            UnitOfWorkImpl unitOfWorkImpl;
            if (this.isNestedUnitOfWork() && ((unitOfWorkImpl = (UnitOfWorkImpl)this.getParent()).isObjectRegistered(object) || this.isUnregisteredNewObjectInParent(object))) {
                Vector vector = classDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, this);
                object2 = this.isCloneNewObjectFromParent(object) || this.isUnregisteredNewObjectInParent(object) ? this.cloneAndRegisterObject(object, new CacheKey(vector), new CacheKey(vector), classDescriptor) : this.getIdentityMapAccessorInstance().getFromIdentityMap(vector, classDescriptor.getJavaClass(), classDescriptor);
                return object2;
            }
            object2 = this.checkExistence(object);
            if (object2 == null) {
                object2 = this.cloneAndRegisterNewObject(object);
            }
        }
        return object2;
    }

    @Override
    public boolean isActive() {
        return !this.isDead();
    }

    @Override
    public boolean isClassReadOnly(Class clazz, ClassDescriptor classDescriptor) {
        if (classDescriptor != null && classDescriptor.shouldBeReadOnly()) {
            return true;
        }
        return clazz != null && this.readOnlyClasses != null && this.readOnlyClasses.contains(clazz);
    }

    public boolean isCloneNewObjectFromParent(Object object) {
        if (this.getParent().isUnitOfWork()) {
            if (((UnitOfWorkImpl)this.getParent()).isCloneNewObject(object)) {
                return true;
            }
            if (((UnitOfWorkImpl)this.getParent()).isObjectRegistered(object)) {
                object = ((UnitOfWorkImpl)this.getParent()).getCloneToOriginals().get(object);
            }
            return ((UnitOfWorkImpl)this.getParent()).isCloneNewObjectFromParent(object);
        }
        return false;
    }

    public boolean isCloneNewObject(Object object) {
        return this.newObjectsCloneToOriginal != null && this.newObjectsCloneToOriginal.containsKey(object);
    }

    public boolean isCommitPending() {
        return this.getLifecycle() == 1;
    }

    public boolean isDead() {
        return this.getLifecycle() == 5;
    }

    @Override
    public boolean isInTransaction() {
        return this.getParent().isInTransaction();
    }

    public boolean isMergePending() {
        return this.getLifecycle() == 4;
    }

    public boolean isAfterWriteChangesButBeforeCommit() {
        return this.getLifecycle() == 2 || this.getLifecycle() == 3;
    }

    protected boolean isAfterWriteChangesFailed() {
        return this.getLifecycle() == 3;
    }

    @Override
    public boolean isNestedUnitOfWork() {
        return this.isNestedUnitOfWork;
    }

    public boolean isNewObjectInParent(Object object) {
        Object var2_2 = null;
        if (this.hasCloneToOriginals()) {
            var2_2 = this.getCloneToOriginals().get(object);
        }
        if (var2_2 != null) {
            return ((UnitOfWorkImpl)this.getParent()).getNewObjectsCloneToOriginal().containsKey(var2_2);
        }
        return false;
    }

    public boolean isObjectDeleted(Object object) {
        boolean bl;
        boolean bl2 = bl = this.deletedObjects != null && this.deletedObjects.containsKey(object);
        if (this.parent.isUnitOfWork()) {
            return bl || ((UnitOfWorkImpl)this.getParent()).isObjectDeleted(object);
        }
        return bl;
    }

    public boolean isObjectNew(Object object) {
        return this.isCloneNewObject(object) || !this.isObjectRegistered(object) && !this.isClassReadOnly(object.getClass(), null) && !this.isUnregisteredExistingObject(object);
    }

    public boolean isUnregisteredExistingObject(Object object) {
        return this.unregisteredExistingObjects != null && this.unregisteredExistingObjects.containsKey(object);
    }

    @Override
    public boolean isObjectRegistered(Object object) {
        if (this.getCloneMapping().containsKey(object)) {
            return true;
        }
        if (UnitOfWorkImpl.isSmartMerge()) {
            ClassDescriptor classDescriptor = this.getDescriptor(object);
            if (this.getParent().getIdentityMapAccessorInstance().containsObjectInIdentityMap(this.keyFromObject(object, classDescriptor), object.getClass(), classDescriptor)) {
                this.mergeCloneWithReferences(object);
                return true;
            }
        }
        return false;
    }

    public boolean isOriginalNewObject(Object object) {
        return this.newObjectsOriginalToClone != null && this.newObjectsOriginalToClone.containsKey(object) || this.newAggregates != null && this.newAggregates.containsKey(object);
    }

    public static boolean isSmartMerge() {
        return SmartMerge;
    }

    public void issueSQLbeforeCompletion() {
        this.issueSQLbeforeCompletion(true);
    }

    public void issueSQLbeforeCompletion(boolean bl) {
        if (this.getLifecycle() == 2) {
            this.commitTransactionAfterWriteChanges();
            return;
        }
        this.mergeBmpAndWsEntities();
        this.log(2, "transaction", "begin_unit_of_work_commit");
        this.getEventManager().preCommitUnitOfWork();
        this.setLifecycle(1);
        this.commitToDatabaseWithChangeSet(bl);
    }

    protected void issueModifyAllQueryList() {
        if (this.deferredModifyAllQueries != null) {
            for (int i = 0; i < this.deferredModifyAllQueries.size(); ++i) {
                Object[] objectArray = (Object[])this.deferredModifyAllQueries.get(i);
                ModifyAllQuery modifyAllQuery = (ModifyAllQuery)objectArray[0];
                AbstractRecord abstractRecord = (AbstractRecord)objectArray[1];
                this.getParent().executeQuery((DatabaseQuery)modifyAllQuery, abstractRecord);
            }
        }
    }

    @Override
    public boolean isUnitOfWork() {
        return true;
    }

    public boolean isUnregisteredNewObjectInParent(Object object) {
        return this.getUnregisteredNewObjectsInParent().containsKey(object);
    }

    protected void mergeBmpAndWsEntities() {
        if (this.hasContainerBeans()) {
            Iterator iterator = this.getContainerBeans().keySet().iterator();
            while (iterator.hasNext()) {
                this.mergeCloneWithReferences(iterator.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mergeChangesIntoParent() {
        block27: {
            UnitOfWorkChangeSet unitOfWorkChangeSet = (UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet();
            if (unitOfWorkChangeSet == null) {
                return;
            }
            if (this.hasModifications()) {
                this.setPendingMerge();
                this.startOperationProfile("merge");
                this.getParent().getIdentityMapAccessorInstance().acquireWriteLock();
                MergeManager mergeManager = this.getMergeManager();
                if (mergeManager == null) {
                    mergeManager = new MergeManager(this);
                }
                try {
                    Object object;
                    Object object2;
                    boolean bl = this.isNestedUnitOfWork();
                    if (!bl) {
                        this.preMergeChanges();
                    }
                    this.getParent().getEventManager().preMergeUnitOfWorkChangeSet(unitOfWorkChangeSet);
                    if (!bl && this.getDatasourceLogin().shouldSynchronizeObjectLevelReadWrite()) {
                        this.setMergeManager(mergeManager);
                        this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().acquireRequiredLocks(this.getMergeManager(), (UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet());
                    }
                    Enumeration enumeration = ((UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet()).getObjectChanges().elements();
                    block9: while (enumeration.hasMoreElements()) {
                        Hashtable hashtable = (Hashtable)((Hashtable)enumeration.nextElement()).clone();
                        if (hashtable == null) continue;
                        object2 = hashtable.elements();
                        while (object2.hasMoreElements()) {
                            ObjectChangeSet objectChangeSet = (ObjectChangeSet)object2.nextElement();
                            if (objectChangeSet.hasChanges()) {
                                object = objectChangeSet.getUnitOfWorkClone();
                                ClassDescriptor classDescriptor = this.getDescriptor(object);
                                if (!bl && classDescriptor.shouldIsolateObjectsInUnitOfWork()) continue block9;
                                mergeManager.mergeChanges(object, objectChangeSet);
                                continue;
                            }
                            unitOfWorkChangeSet.removeObjectChangeSet(objectChangeSet);
                        }
                    }
                    if (this.modifyAllQueries != null) {
                        for (int i = 0; i < this.modifyAllQueries.size(); ++i) {
                            object2 = (ModifyAllQuery)this.modifyAllQueries.get(i);
                            ((DatabaseQuery)object2).setSession(this.getParent());
                            ((ModifyAllQuery)object2).mergeChangesIntoSharedCache();
                        }
                    }
                    if (bl) {
                        enumeration = ((UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet()).getNewObjectChangeSets().elements();
                        while (enumeration.hasMoreElements()) {
                            IdentityHashMap identityHashMap = new IdentityHashMap((Map)enumeration.nextElement());
                            if (identityHashMap == null) continue;
                            for (ObjectChangeSet objectChangeSet : identityHashMap.values()) {
                                if (objectChangeSet.hasChanges()) {
                                    object = objectChangeSet.getUnitOfWorkClone();
                                    mergeManager.mergeChanges(object, objectChangeSet);
                                    continue;
                                }
                                unitOfWorkChangeSet.removeObjectChangeSet(objectChangeSet);
                            }
                        }
                    }
                    if (bl) break block27;
                    this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().releaseAllAcquiredLocks(mergeManager);
                    this.setMergeManager(null);
                    this.postMergeChanges();
                    if (!this.getParent().shouldPropagateChanges() || this.getParent().getCommandManager() == null) break block27;
                    if (this.hasDeletedObjects()) {
                        unitOfWorkChangeSet.addDeletedObjects(this.getDeletedObjects(), this);
                    }
                    if (this.hasObjectsDeletedDuringCommit()) {
                        unitOfWorkChangeSet.addDeletedObjects(this.getObjectsDeletedDuringCommit(), this);
                    }
                    boolean bl2 = false;
                    if (!unitOfWorkChangeSet.hasChanges()) break block27;
                    object2 = new MergeChangeSetCommand();
                    ((MergeChangeSetCommand)object2).setChangeSet(unitOfWorkChangeSet);
                    try {
                        bl2 = ((MergeChangeSetCommand)object2).convertChangeSetToByteArray(this);
                    }
                    catch (IOException iOException) {
                        throw CommunicationException.unableToPropagateChanges(((Command)object2).getServiceId().getId(), iOException);
                    }
                    if (bl2) {
                        this.getParent().getCommandManager().propagateCommand(object2);
                    }
                }
                finally {
                    if (!this.isNestedUnitOfWork() && !mergeManager.getAcquiredLocks().isEmpty()) {
                        try {
                            this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().releaseAllAcquiredLocks(mergeManager);
                        }
                        catch (Exception exception) {}
                        this.setMergeManager(null);
                    }
                    this.getParent().getIdentityMapAccessorInstance().releaseWriteLock();
                    this.getParent().getEventManager().postMergeUnitOfWorkChangeSet(unitOfWorkChangeSet);
                    this.endOperationProfile("merge");
                }
            }
        }
    }

    @Override
    public Object mergeClone(Object object) {
        return this.mergeClone(object, 2);
    }

    public Object mergeClone(Object object, int n) {
        if (object == null) {
            return null;
        }
        this.logDebugMessage(object, "merge_clone");
        this.startOperationProfile("merge");
        ObjectBuilder objectBuilder = this.getDescriptor(object).getObjectBuilder();
        Object object2 = objectBuilder.unwrapObject(object, this);
        MergeManager mergeManager = new MergeManager(this);
        mergeManager.mergeCloneIntoWorkingCopy();
        mergeManager.setCascadePolicy(n);
        Object object3 = null;
        try {
            object3 = mergeManager.mergeChanges(object2, null);
        }
        catch (RuntimeException runtimeException) {
            object3 = this.handleException(runtimeException);
        }
        this.endOperationProfile("merge");
        return object3;
    }

    public void mergeClonesAfterCompletion() {
        ArrayList<CacheKey> arrayList;
        Thread thread;
        Thread thread2 = Thread.currentThread();
        if (null != this.getMergeManager() && thread2 != (thread = this.getMergeManager().getLockThread()) && null != (arrayList = this.getMergeManager().getAcquiredLocks())) {
            Iterator<CacheKey> iterator = arrayList.iterator();
            AbstractSessionLog.getLog().log(2, "active_thread_is_different_from_current_thread", thread, this.getMergeManager(), thread2);
            while (iterator.hasNext()) {
                Thread thread3;
                ConcurrencyManager concurrencyManager = iterator.next().getMutex();
                if (null == concurrencyManager || thread2 == (thread3 = concurrencyManager.getActiveThread())) continue;
                concurrencyManager.setActiveThread(thread2);
            }
        }
        this.mergeChangesIntoParent();
        this.getEventManager().postCommitUnitOfWork();
        this.log(2, "transaction", "end_unit_of_work_commit");
    }

    @Override
    public Object mergeCloneWithReferences(Object object) {
        return this.mergeCloneWithReferences(object, 2);
    }

    public Object mergeCloneWithReferences(Object object, int n) {
        return this.mergeCloneWithReferences(object, n, false);
    }

    public Object mergeCloneWithReferences(Object object, int n, boolean bl) {
        MergeManager mergeManager = new MergeManager(this);
        mergeManager.mergeCloneWithReferencesIntoWorkingCopy();
        mergeManager.setCascadePolicy(n);
        mergeManager.setForceCascade(bl);
        return this.mergeCloneWithReferences(object, mergeManager);
    }

    public Object mergeCloneWithReferences(Object object, MergeManager mergeManager) {
        if (object == null) {
            return null;
        }
        ClassDescriptor classDescriptor = this.getDescriptor(object);
        if (classDescriptor == null || classDescriptor.isDescriptorTypeAggregate()) {
            if (mergeManager.getCascadePolicy() == 4) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("not_an_entity", new Object[]{object}));
            }
            return object;
        }
        this.logDebugMessage(object, "merge_clone_with_references");
        ObjectBuilder objectBuilder = classDescriptor.getObjectBuilder();
        Object object2 = objectBuilder.unwrapObject(object, this);
        Object object3 = mergeManager.mergeChanges(object2, null);
        if (UnitOfWorkImpl.isSmartMerge()) {
            return objectBuilder.wrapObject(object3, this);
        }
        return object3;
    }

    @Override
    public Object newInstance(Class clazz) {
        this.logDebugMessage(clazz, "new_instance");
        ClassDescriptor classDescriptor = this.getDescriptor(clazz);
        Object object = classDescriptor.getObjectBuilder().buildNewInstance();
        return this.registerObject(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performRemove(Object object, Map map) {
        try {
            if (object == null) {
                return;
            }
            ClassDescriptor classDescriptor = this.getDescriptor(object);
            if (classDescriptor == null || classDescriptor.isDescriptorTypeAggregate()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("not_an_entity", new Object[]{object}));
            }
            this.logDebugMessage(object, "deleting_object");
            this.startOperationProfile("deleted object");
            if (this.getDeletedObjects().containsKey(object)) {
                return;
            }
            map.put(object, object);
            Object object2 = this.checkIfAlreadyRegistered(object, classDescriptor);
            if (object2 == null) {
                Vector vector = classDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, this);
                DoesExistQuery doesExistQuery = classDescriptor.getQueryManager().getDoesExistQuery();
                doesExistQuery = (DoesExistQuery)doesExistQuery.clone();
                doesExistQuery.setObject(object);
                doesExistQuery.setPrimaryKey(vector);
                doesExistQuery.setDescriptor(classDescriptor);
                doesExistQuery.setIsExecutionClone(true);
                doesExistQuery.setCheckCacheFirst(true);
                if (((Boolean)this.executeQuery(doesExistQuery)).booleanValue()) {
                    throw new IllegalArgumentException(ExceptionLocalization.buildMessage("cannot_remove_detatched_entity", new Object[]{object}));
                }
            } else {
                if (classDescriptor.getEventManager().hasAnyEventListeners()) {
                    DescriptorEvent descriptorEvent = new DescriptorEvent(object);
                    descriptorEvent.setEventCode(16);
                    descriptorEvent.setSession(this);
                    classDescriptor.getEventManager().executeEvent(descriptorEvent);
                }
                if (this.hasNewObjects() && this.getNewObjectsCloneToOriginal().containsKey(object2)) {
                    this.unregisterObject(object2, 1);
                } else {
                    this.getDeletedObjects().put(object, object);
                }
            }
            classDescriptor.getObjectBuilder().cascadePerformRemove(object, this, map);
        }
        finally {
            this.endOperationProfile("deleted object");
        }
    }

    public void performRemovePrivateOwnedObjectFromChangeSet(Object object, Map map) {
        ObjectChangeSet objectChangeSet;
        if (object == null) {
            return;
        }
        map.put(object, object);
        ClassDescriptor classDescriptor = this.getDescriptor(object);
        UnitOfWorkChangeSet unitOfWorkChangeSet = (UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet();
        if (unitOfWorkChangeSet != null && (objectChangeSet = (ObjectChangeSet)unitOfWorkChangeSet.getObjectChangeSetForClone(object)) != null) {
            unitOfWorkChangeSet.removeObjectChangeSet(objectChangeSet);
            unitOfWorkChangeSet.removeObjectChangeSetFromNewList(objectChangeSet, this);
        }
        this.unregisterObject(object, 1);
        classDescriptor.getObjectBuilder().cascadePerformRemovePrivateOwnedObjectFromChangeSet(object, this, map);
    }

    @Override
    public void performFullValidation() {
        this.setValidationLevel(2);
    }

    @Override
    public void performPartialValidation() {
        this.setValidationLevel(1);
    }

    protected void populateAndRegisterObject(Object object, Object object2, CacheKey cacheKey, CacheKey cacheKey2, ClassDescriptor classDescriptor) {
        cacheKey.setObject(object2);
        cacheKey.setReadTime(cacheKey2.getReadTime());
        cacheKey.setWriteLockValue(cacheKey2.getWriteLockValue());
        classDescriptor.getObjectChangePolicy().setChangeListener(object2, this, classDescriptor);
        classDescriptor.getObjectChangePolicy().dissableEventProcessing(object2);
        ObjectBuilder objectBuilder = classDescriptor.getObjectBuilder();
        objectBuilder.populateAttributesForClone(object, object2, this);
        Object object3 = classDescriptor.getObjectChangePolicy().buildBackupClone(object2, objectBuilder, this);
        if (object2 != object3) {
            this.getCloneMapping().put(object2, object3);
        }
        classDescriptor.getObjectChangePolicy().enableEventProcessing(object2);
    }

    protected void postMergeChanges() {
        if (this.unitOfWorkChangeSet.hasDeletedObjects()) {
            Map map = this.unitOfWorkChangeSet.getDeletedObjects();
            for (ObjectChangeSet objectChangeSet : map.keySet()) {
                Vector vector = objectChangeSet.getPrimaryKeys();
                ClassDescriptor classDescriptor = this.getDescriptor(objectChangeSet.getClassType(this));
                if (classDescriptor.shouldIsolateObjectsInUnitOfWork()) continue;
                this.getParent().getIdentityMapAccessorInstance().removeFromIdentityMap(vector, classDescriptor.getJavaClass(), classDescriptor, objectChangeSet.getUnitOfWorkClone());
            }
        }
    }

    protected void preMergeChanges() {
        if (this.hasObjectsDeletedDuringCommit()) {
            for (Object k : this.getObjectsDeletedDuringCommit().keySet()) {
                Object v;
                this.getCloneMapping().remove(k);
                if (!this.hasNewObjects() || (v = this.getNewObjectsCloneToOriginal().get(k)) == null) continue;
                this.getNewObjectsCloneToOriginal().remove(k);
                this.getNewObjectsOriginalToClone().remove(v);
            }
        }
    }

    @Override
    public void printRegisteredObjects() {
        if (this.shouldLog(7, "cache")) {
            this.basicPrintRegisteredObjects();
        }
    }

    public Object processDeleteObjectQuery(DeleteObjectQuery deleteObjectQuery) {
        ObjectBuilder objectBuilder;
        Object object;
        if (deleteObjectQuery.getObject() == null) {
            throw QueryException.objectToModifyNotSpecified(deleteObjectQuery);
        }
        ClassDescriptor classDescriptor = deleteObjectQuery.getDescriptor();
        if (classDescriptor == null) {
            classDescriptor = this.getDescriptor(deleteObjectQuery.getObject());
        }
        if (this.isClassReadOnly((object = (objectBuilder = classDescriptor.getObjectBuilder()).unwrapObject(deleteObjectQuery.getObject(), this)).getClass(), classDescriptor)) {
            throw QueryException.cannotDeleteReadOnlyObject(object);
        }
        if (this.isCloneNewObject(object)) {
            this.unregisterObject(object);
            return object;
        }
        Vector vector = objectBuilder.extractPrimaryKeyFromObject(object, this);
        Object object2 = this.getIdentityMapAccessorInstance().getFromIdentityMap(vector, object.getClass(), classDescriptor);
        if (object2 == null) {
            object2 = object;
        }
        object2 = objectBuilder.unwrapObject(object2, this);
        deleteObjectQuery.setObject(object2);
        if (!this.getCommitManager().isActive()) {
            this.getDeletedObjects().put(object2, vector);
            return object2;
        }
        if (this.hasObjectsDeletedDuringCommit() && this.getObjectsDeletedDuringCommit().containsKey(object2)) {
            return object2;
        }
        return null;
    }

    protected void basicPrintRegisteredObjects() {
        String string = Helper.cr();
        StringWriter stringWriter = new StringWriter();
        stringWriter.write(LoggingLocalization.buildMessage("unitofwork_identity_hashcode", new Object[]{string, String.valueOf(System.identityHashCode(this))}));
        if (this.hasDeletedObjects()) {
            stringWriter.write(string + LoggingLocalization.buildMessage("deleted_objects"));
            for (Object k : this.getDeletedObjects().keySet()) {
                stringWriter.write(LoggingLocalization.buildMessage("key_identity_hash_code_object", new Object[]{string, Helper.printVector(this.getDescriptor(k).getObjectBuilder().extractPrimaryKeyFromObject(k, this)), "\t", String.valueOf(System.identityHashCode(k)), k}));
            }
        }
        stringWriter.write(string + LoggingLocalization.buildMessage("all_registered_clones"));
        for (Object k : this.getCloneMapping().keySet()) {
            stringWriter.write(LoggingLocalization.buildMessage("key_identity_hash_code_object", new Object[]{string, Helper.printVector(this.getDescriptor(k).getObjectBuilder().extractPrimaryKeyFromObject(k, this)), "\t", String.valueOf(System.identityHashCode(k)), k}));
        }
        if (this.hasNewObjectsInParentOriginalToClone()) {
            stringWriter.write(string + LoggingLocalization.buildMessage("new_objects"));
            for (Object k : this.getNewObjectsCloneToOriginal().keySet()) {
                stringWriter.write(LoggingLocalization.buildMessage("key_identity_hash_code_object", new Object[]{string, Helper.printVector(this.getDescriptor(k).getObjectBuilder().extractPrimaryKeyFromObject(k, this)), "\t", String.valueOf(System.identityHashCode(k)), k}));
            }
        }
        this.log(7, "transaction", stringWriter.toString(), null, null, false);
    }

    @Override
    public Vector registerAllObjects(Collection collection) {
        Vector<Object> vector = new Vector<Object>(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            vector.addElement(this.registerObject(iterator.next()));
        }
        return vector;
    }

    public Vector registerAllObjects(Vector vector) throws DatabaseException, OptimisticLockException {
        Vector<Object> vector2 = new Vector<Object>(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            vector2.addElement(this.registerObject(enumeration.nextElement()));
        }
        return vector2;
    }

    @Override
    public Object registerExistingObject(Object object) {
        if (object == null) {
            return null;
        }
        ClassDescriptor classDescriptor = this.getDescriptor(object);
        if (classDescriptor == null) {
            throw DescriptorException.missingDescriptor(object.getClass().toString());
        }
        if (this.isClassReadOnly(classDescriptor.getJavaClass(), classDescriptor)) {
            return object;
        }
        ObjectBuilder objectBuilder = classDescriptor.getObjectBuilder();
        Object object2 = objectBuilder.unwrapObject(object, this);
        Object object3 = this.registerExistingObject(object2, classDescriptor);
        if (object2 != object) {
            return objectBuilder.wrapObject(object3, this);
        }
        return object3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object registerExistingObject(Object object, ClassDescriptor classDescriptor) {
        Object object2;
        if (this.isClassReadOnly(classDescriptor.getJavaClass(), classDescriptor)) {
            return object;
        }
        if (this.isAfterWriteChangesButBeforeCommit()) {
            throw ValidationException.illegalOperationForUnitOfWorkLifecycle(this.getLifecycle(), "registerExistingObject");
        }
        if (classDescriptor.isDescriptorTypeAggregate()) {
            throw ValidationException.cannotRegisterAggregateObjectInUnitOfWork(object.getClass());
        }
        this.logDebugMessage(object, "register_existing");
        try {
            this.startOperationProfile("register");
            object2 = this.checkIfAlreadyRegistered(object, classDescriptor);
            if (object2 == null) {
                Vector vector = classDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, this);
                object2 = this.getIdentityMapAccessorInstance().getFromIdentityMap(vector, object.getClass(), classDescriptor);
                if (object2 == null) {
                    CacheKey cacheKey = new CacheKey(vector);
                    cacheKey.setReadTime(System.currentTimeMillis());
                    object2 = this.cloneAndRegisterObject(object, cacheKey, classDescriptor);
                }
            }
            if (classDescriptor.hasFetchGroupManager() && classDescriptor.getFetchGroupManager().shouldWriteInto(object, object2)) {
                classDescriptor.getFetchGroupManager().writePartialIntoClones(object, object2, this);
            }
        }
        finally {
            this.endOperationProfile("register");
        }
        return object2;
    }

    public synchronized Object registerNewContainerBean(Object object) {
        Object object2;
        Object object3;
        if (object == null) {
            return null;
        }
        this.logDebugMessage(object, "register_new");
        this.startOperationProfile("register");
        this.setShouldNewObjectsBeCached(true);
        ClassDescriptor classDescriptor = this.getDescriptor(object);
        if (classDescriptor == null) {
            throw DescriptorException.missingDescriptor(object.getClass().toString());
        }
        ObjectBuilder objectBuilder = classDescriptor.getObjectBuilder();
        if (this.shouldPerformFullValidation()) {
            object3 = classDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, this);
            object2 = this.getParent().getIdentityMapAccessorInstance().getFromIdentityMap((Vector)object3, classDescriptor.getJavaClass(), classDescriptor);
            if (object2 != null) {
                throw ValidationException.wrongObjectRegistered(object, object2);
            }
        }
        object3 = objectBuilder.buildNewInstance();
        objectBuilder.copyInto(object, object3);
        object2 = this.registerObject(object3);
        this.getContainerBeans().put(object, object2);
        this.endOperationProfile("register");
        return object;
    }

    public synchronized Object registerNewContainerBeanForCMP(Object object) {
        if (object == null) {
            return null;
        }
        this.logDebugMessage(object, "register_new_bean");
        this.startOperationProfile("register");
        Object object2 = this.cloneAndRegisterNewObject(object);
        this.endOperationProfile("register");
        return object2;
    }

    @Override
    public Object registerNewObject(Object object) {
        if (object == null) {
            return null;
        }
        ClassDescriptor classDescriptor = this.getDescriptor(object);
        if (classDescriptor == null) {
            throw DescriptorException.missingDescriptor(object.getClass().toString());
        }
        ObjectBuilder objectBuilder = classDescriptor.getObjectBuilder();
        Object object2 = objectBuilder.unwrapObject(object, this);
        this.registerNewObject(object2, classDescriptor);
        if (object2 == object) {
            return object;
        }
        return objectBuilder.wrapObject(object2, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object registerNewObject(Object object, ClassDescriptor classDescriptor) {
        if (this.isAfterWriteChangesButBeforeCommit()) {
            throw ValidationException.illegalOperationForUnitOfWorkLifecycle(this.getLifecycle(), "registerNewObject");
        }
        if (classDescriptor.isDescriptorTypeAggregate()) {
            throw ValidationException.cannotRegisterAggregateObjectInUnitOfWork(object.getClass());
        }
        try {
            this.logDebugMessage(object, "register_new");
            this.startOperationProfile("register");
            Object object2 = this.checkIfAlreadyRegistered(object, classDescriptor);
            if (object2 == null) {
                Object object3;
                Cloneable cloneable;
                if (this.shouldPerformFullValidation()) {
                    cloneable = classDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, this);
                    object3 = this.getParent().getIdentityMapAccessorInstance().getFromIdentityMap((Vector)cloneable, object.getClass(), classDescriptor);
                    if (object3 != null) {
                        throw ValidationException.wrongObjectRegistered(object, object3);
                    }
                }
                cloneable = classDescriptor.getObjectBuilder();
                object3 = null;
                Object object4 = object;
                if (!classDescriptor.getObjectChangePolicy().isAttributeChangeTrackingPolicy()) {
                    object4 = ((ObjectBuilder)cloneable).buildNewInstance();
                }
                this.getCloneMapping().put(object, object4);
                this.registerNewObjectClone(object, object3, classDescriptor);
            }
        }
        finally {
            this.endOperationProfile("register");
        }
        return object;
    }

    public void discoverAndPersistUnregisteredNewObjects(Object object, boolean bl, Map map, Map map2, Map map3) {
        if (object == null) {
            return;
        }
        if (bl && this.isObjectDeleted(object)) {
            this.undeleteObject(object);
        }
        if (map3.containsKey(object)) {
            return;
        }
        map3.put(object, object);
        if (this.isObjectDeleted(object)) {
            return;
        }
        ClassDescriptor classDescriptor = this.getDescriptor(object);
        if (this.isClassReadOnly(object.getClass(), classDescriptor)) {
            return;
        }
        if (!this.isObjectRegistered(object)) {
            if (bl) {
                this.registerNotRegisteredNewObjectForPersist(object, classDescriptor);
                map.put(object, object);
            } else {
                if (this.checkForUnregisteredExistingObject(object)) {
                    map2.put(object, object);
                    return;
                }
                throw new IllegalStateException(ExceptionLocalization.buildMessage("new_object_found_during_commit", new Object[]{object}));
            }
        }
        classDescriptor.getObjectBuilder().cascadeDiscoverAndPersistUnregisteredNewObjects(object, map, map2, map3, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerNewObjectForPersist(Object object, Map map) {
        if (object == null) {
            return;
        }
        if (map.containsKey(object)) {
            return;
        }
        map.put(object, object);
        ClassDescriptor classDescriptor = this.getDescriptor(object);
        if (classDescriptor == null || classDescriptor.isDescriptorTypeAggregate()) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("not_an_entity", new Object[]{object}));
        }
        this.startOperationProfile("register");
        try {
            Object object2 = this.checkIfAlreadyRegistered(object, classDescriptor);
            if (object2 == null) {
                this.registerNotRegisteredNewObjectForPersist(object, classDescriptor);
            } else if (this.isObjectDeleted(object)) {
                this.undeleteObject(object);
            }
            classDescriptor.getObjectBuilder().cascadeRegisterNewForCreate(object, this, map);
        }
        finally {
            this.endOperationProfile("register");
        }
    }

    public boolean wasDeleted(Object object) {
        return false;
    }

    protected void registerNotRegisteredNewObjectForPersist(Object object, ClassDescriptor classDescriptor) {
        Cloneable cloneable;
        object.getClass();
        if (this.shouldValidateExistence()) {
            cloneable = classDescriptor.getQueryManager().getDoesExistQuery();
            cloneable = (DoesExistQuery)((DatabaseQuery)cloneable).clone();
            ((DoesExistQuery)cloneable).setObject(object);
            ((DatabaseQuery)cloneable).setDescriptor(classDescriptor);
            ((DatabaseQuery)cloneable).setIsExecutionClone(true);
            if (((Boolean)this.executeQuery((DatabaseQuery)cloneable)).booleanValue()) {
                throw ValidationException.cannotPersistExistingObject(object, this);
            }
        }
        this.logDebugMessage(object, "register_new_for_persist");
        cloneable = classDescriptor.getObjectBuilder();
        Object var4_4 = null;
        Object object2 = object;
        if (!classDescriptor.getObjectChangePolicy().isAttributeChangeTrackingPolicy()) {
            object2 = ((ObjectBuilder)cloneable).buildNewInstance();
        }
        this.getCloneMapping().put(object, object2);
        this.assignSequenceNumber(object, classDescriptor);
        this.registerNewObjectClone(object, var4_4, classDescriptor);
    }

    protected void registerNewObjectClone(Object object, Object object2, ClassDescriptor classDescriptor) {
        this.registerNewObjectInIdentityMap(object, object2, classDescriptor);
        this.getNewObjectsCloneToOriginal().put(object, object2);
        this.getNewObjectsOriginalToClone().put(object2, object);
        if (classDescriptor.getEventManager().hasAnyEventListeners()) {
            DescriptorEvent descriptorEvent = new DescriptorEvent(object);
            descriptorEvent.setEventCode(15);
            descriptorEvent.setSession(this);
            classDescriptor.getEventManager().executeEvent(descriptorEvent);
        }
    }

    protected void registerNewObjectInIdentityMap(Object object, Object object2, ClassDescriptor classDescriptor) {
        Vector vector;
        if (this.shouldNewObjectsBeCached() && (vector = classDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, this, true)) != null) {
            this.getIdentityMapAccessorInstance().putInIdentityMap(object, vector, null, 0L, classDescriptor);
        }
    }

    @Override
    public Object registerObject(Object object) {
        if (object == null) {
            return null;
        }
        ClassDescriptor classDescriptor = this.getDescriptor(object);
        if (classDescriptor == null) {
            throw DescriptorException.missingDescriptor(object.getClass().toString());
        }
        if (this.isClassReadOnly(classDescriptor.getJavaClass(), classDescriptor)) {
            return object;
        }
        ObjectBuilder objectBuilder = classDescriptor.getObjectBuilder();
        Object object2 = objectBuilder.unwrapObject(object, this);
        boolean bl = object2 != object;
        Object object3 = this.registerObject(object2, classDescriptor);
        if (bl) {
            return objectBuilder.wrapObject(object3, this);
        }
        return object3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object registerObject(Object object, ClassDescriptor classDescriptor) {
        Object object2;
        if (this.isClassReadOnly(classDescriptor.getJavaClass(), classDescriptor)) {
            return object;
        }
        if (this.isAfterWriteChangesButBeforeCommit()) {
            throw ValidationException.illegalOperationForUnitOfWorkLifecycle(this.getLifecycle(), "registerObject");
        }
        this.logDebugMessage(object, "register");
        try {
            this.startOperationProfile("register");
            object2 = this.internalRegisterObject(object, classDescriptor);
        }
        finally {
            this.endOperationProfile("register");
        }
        return object2;
    }

    public void registerOriginalNewObjectFromNestedUnitOfWork(Object object, Object object2, Object object3, ClassDescriptor classDescriptor) {
        this.getCloneMapping().put(object, object2);
        this.registerNewObjectClone(object, object3, classDescriptor);
    }

    public void registerWithTransactionIfRequired() {
        if (this.getParent().hasExternalTransactionController() && !this.isSynchronized()) {
            boolean bl = this.getParent().wasJTSTransactionInternallyStarted();
            this.getParent().getExternalTransactionController().registerSynchronizationListener(this, this.getParent());
            if (!bl && this.getParent().wasJTSTransactionInternallyStarted()) {
                this.setWasTransactionBegunPrematurely(true);
            }
        }
    }

    @Override
    public void release() {
        this.log(2, "transaction", "release_unit_of_work");
        this.getEventManager().preReleaseUnitOfWork();
        if (this.getLifecycle() == 2) {
            if (this.hasModifications() || this.wasTransactionBegunPrematurely()) {
                this.rollbackTransaction(false);
                this.setWasTransactionBegunPrematurely(false);
            }
        } else if (this.wasTransactionBegunPrematurely() && !this.isNestedUnitOfWork()) {
            this.rollbackTransaction();
            this.setWasTransactionBegunPrematurely(false);
        }
        if (this.getMergeManager() != null && this.getMergeManager().getAcquiredLocks() != null && !this.getMergeManager().getAcquiredLocks().isEmpty()) {
            this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().releaseAllAcquiredLocks(this.getMergeManager());
            this.setMergeManager(null);
        }
        this.setDead();
        if (this.shouldClearForCloseOnRelease()) {
            this.clearForClose(false);
        }
        this.setBatchReadObjects(null);
        this.getParent().releaseUnitOfWork(this);
        this.getEventManager().postReleaseUnitOfWork();
    }

    @Override
    public void removeAllReadOnlyClasses() throws ValidationException {
        if (this.isNestedUnitOfWork()) {
            throw ValidationException.cannotRemoveFromReadOnlyClassesInNestedUnitOfWork();
        }
        this.getReadOnlyClasses().clear();
    }

    @Override
    public void removeForceUpdateToVersionField(Object object) {
        this.getOptimisticReadLockObjects().remove(object);
    }

    public void removePrivateOwnedObject(DatabaseMapping databaseMapping, Object object) {
        Set set;
        if (object != null && (set = this.getPrivateOwnedObjects().get(databaseMapping)) != null) {
            set.remove(object);
            if (set.isEmpty()) {
                set.remove(databaseMapping);
            }
        }
    }

    @Override
    public void removeReadOnlyClass(Class clazz) throws ValidationException {
        if (!this.canChangeReadOnlySet()) {
            throw ValidationException.cannotModifyReadOnlyClassesSetAfterUsingUnitOfWork();
        }
        if (this.isNestedUnitOfWork()) {
            throw ValidationException.cannotRemoveFromReadOnlyClassesInNestedUnitOfWork();
        }
        this.getReadOnlyClasses().remove(clazz);
    }

    @Override
    public void revertAndResume() {
        if (this.isAfterWriteChangesButBeforeCommit()) {
            throw ValidationException.illegalOperationForUnitOfWorkLifecycle(this.getLifecycle(), "revertAndResume");
        }
        this.log(2, "transaction", "revert_unit_of_work");
        MergeManager mergeManager = new MergeManager(this);
        mergeManager.mergeOriginalIntoWorkingCopy();
        mergeManager.cascadeAllParts();
        for (Object k : new IdentityHashMap(this.getCloneMapping()).keySet()) {
            mergeManager.mergeChanges(k, null);
            ClassDescriptor classDescriptor = this.getDescriptor(k);
            classDescriptor.getObjectChangePolicy().revertChanges(k, classDescriptor, this, this.getCloneMapping());
        }
        if (this.hasNewObjects()) {
            for (Object k : this.getNewObjectsCloneToOriginal().keySet()) {
                this.getCloneMapping().remove(k);
            }
            if (this.getUnitOfWorkChangeSet() != null) {
                ((UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet()).getNewObjectChangeSets().clear();
            }
        }
        this.setNewObjectsCloneToOriginal(null);
        this.setNewObjectsOriginalToClone(null);
        this.allClones = null;
        this.setObjectsDeletedDuringCommit(new IdentityHashMap());
        this.setDeletedObjects(new IdentityHashMap());
        this.setRemovedObjects(new IdentityHashMap());
        this.setUnregisteredNewObjects(new IdentityHashMap());
        if (this.isNestedUnitOfWork()) {
            this.discoverAllUnregisteredNewObjectsInParent();
        }
        this.log(2, "transaction", "resume_unit_of_work");
    }

    @Override
    public Object revertObject(Object object) {
        return this.revertObject(object, 2);
    }

    public Object revertObject(Object object, int n) {
        if (object == null) {
            return null;
        }
        this.logDebugMessage(object, "revert");
        ClassDescriptor classDescriptor = this.getDescriptor(object);
        ObjectBuilder objectBuilder = classDescriptor.getObjectBuilder();
        Object object2 = objectBuilder.unwrapObject(object, this);
        MergeManager mergeManager = new MergeManager(this);
        mergeManager.mergeOriginalIntoWorkingCopy();
        mergeManager.setCascadePolicy(n);
        try {
            mergeManager.mergeChanges(object2, null);
        }
        catch (RuntimeException runtimeException) {
            return this.handleException(runtimeException);
        }
        if (n != 1) {
            objectBuilder.instantiateEagerMappings(object, this);
        }
        return object;
    }

    @Override
    public void rollbackTransaction() throws DatabaseException {
        this.incrementProfile("UnitOfWorkRollbacks");
        this.getParent().rollbackTransaction();
    }

    protected void rollbackTransaction(boolean bl) throws DatabaseException {
        if (!bl && this.getParent().hasExternalTransactionController() && !this.getParent().wasJTSTransactionInternallyStarted()) {
            this.getParent().getExternalTransactionController().markTransactionForRollback();
        }
        this.rollbackTransaction();
    }

    public Map scanForConformingInstances(Expression expression, Class clazz, AbstractRecord abstractRecord, ObjectLevelReadQuery objectLevelReadQuery) {
        IdentityHashMap identityHashMap;
        block6: {
            int n = objectLevelReadQuery.getInMemoryQueryIndirectionPolicyState();
            if (n != 1) {
                n = 3;
            }
            identityHashMap = new IdentityHashMap();
            try {
                Enumeration enumeration;
                Object object;
                Vector vector = null;
                if (expression != null) {
                    vector = this.getIdentityMapAccessor().getAllFromIdentityMap(expression, clazz, (Record)abstractRecord, n);
                    object = vector.elements();
                    while (object.hasMoreElements()) {
                        enumeration = object.nextElement();
                        if (this.isObjectDeleted(enumeration)) continue;
                        identityHashMap.put(enumeration, enumeration);
                    }
                }
                object = null;
                object = this.getAllFromNewObjects(expression, clazz, abstractRecord, n);
                enumeration = ((Vector)object).elements();
                while (enumeration.hasMoreElements()) {
                    Object e = enumeration.nextElement();
                    if (this.isObjectDeleted(e)) continue;
                    identityHashMap.put(e, e);
                }
            }
            catch (QueryException queryException) {
                if (this.getShouldThrowConformExceptions() != 1) break block6;
                throw queryException;
            }
        }
        return identityHashMap;
    }

    protected void setAllClonesCollection(Map map) {
        this.allClones = map;
    }

    protected void setCloneMapping(Map map) {
        this.cloneMapping = map;
    }

    protected void setContainerBeans(Map map) {
        this.containerBeans = map;
    }

    protected void setContainerUnitOfWork(UnitOfWorkImpl unitOfWorkImpl) {
        this.containerUnitOfWork = unitOfWorkImpl;
    }

    public void setDead() {
        this.setLifecycle(5);
    }

    protected void setDeletedObjects(Map map) {
        this.deletedObjects = map;
    }

    protected void setLifecycle(int n) {
        this.lifecycle = n;
    }

    public void setMergeManager(MergeManager mergeManager) {
        this.lastUsedMergeManager = mergeManager;
    }

    protected void setNewObjectsCloneToOriginal(Map map) {
        this.newObjectsCloneToOriginal = map;
    }

    protected void setNewObjectsOriginalToClone(Map map) {
        this.newObjectsOriginalToClone = map;
    }

    public void setObjectsDeletedDuringCommit(Map map) {
        this.objectsDeletedDuringCommit = map;
    }

    public void setParent(AbstractSession abstractSession) {
        this.parent = abstractSession;
    }

    public void setPendingMerge() {
        this.setLifecycle(4);
    }

    public void setPreDeleteComplete(boolean bl) {
        this.preDeleteComplete = bl;
    }

    public void setReadOnlyClasses(List list) {
        if (list.isEmpty()) {
            this.readOnlyClasses = null;
            return;
        }
        int n = list.size();
        this.readOnlyClasses = new HashSet(n);
        for (int i = 0; i < n; ++i) {
            this.readOnlyClasses.add(list.get(i));
        }
    }

    protected void setRemovedObjects(Map map) {
        this.removedObjects = map;
    }

    public void setResumeUnitOfWorkOnTransactionCompletion(boolean bl) {
        this.resumeOnTransactionCompletion = bl;
    }

    public boolean shouldDiscoverNewObjects() {
        return this.shouldDiscoverNewObjects;
    }

    public void setShouldDiscoverNewObjects(boolean bl) {
        this.shouldDiscoverNewObjects = bl;
    }

    public void setShouldCascadeCloneToJoinedRelationship(boolean bl) {
        this.shouldCascadeCloneToJoinedRelationship = bl;
    }

    @Override
    public void setShouldNewObjectsBeCached(boolean bl) {
        this.shouldNewObjectsBeCached = bl;
    }

    @Override
    public void setShouldPerformDeletesFirst(boolean bl) {
        this.shouldPerformDeletesFirst = bl;
    }

    @Override
    public void setShouldThrowConformExceptions(int n) {
        this.shouldThrowConformExceptions = n;
    }

    public static void setSmartMerge(boolean bl) {
        SmartMerge = bl;
    }

    @Override
    public void setSynchronized(boolean bl) {
        super.setSynchronized(bl);
        this.getParent().setSynchronized(bl);
    }

    public void setUnitOfWorkChangeSet(UnitOfWorkChangeSet unitOfWorkChangeSet) {
        this.unitOfWorkChangeSet = unitOfWorkChangeSet;
    }

    protected void setUnregisteredExistingObjects(Map map) {
        this.unregisteredExistingObjects = map;
    }

    protected void setUnregisteredNewObjects(Map map) {
        this.unregisteredNewObjects = map;
    }

    protected void setUnregisteredNewObjectsInParent(Map map) {
        this.unregisteredNewObjectsInParent = map;
    }

    @Override
    public void setValidationLevel(int n) {
        this.validationLevel = n;
    }

    public void setWasTransactionBegunPrematurely(boolean bl) {
        if (this.isNestedUnitOfWork()) {
            ((UnitOfWorkImpl)this.getParent()).setWasTransactionBegunPrematurely(bl);
        }
        this.wasTransactionBegunPrematurely = bl;
    }

    @Override
    public Object shallowMergeClone(Object object) {
        return this.mergeClone(object, 1);
    }

    @Override
    public Object shallowRevertObject(Object object) {
        return this.revertObject(object, 1);
    }

    @Override
    public void shallowUnregisterObject(Object object) {
        this.unregisterObject(object, 1);
    }

    public boolean shouldCascadeCloneToJoinedRelationship() {
        return this.shouldCascadeCloneToJoinedRelationship;
    }

    @Override
    public boolean shouldNewObjectsBeCached() {
        return this.shouldNewObjectsBeCached;
    }

    public boolean shouldValidateExistence() {
        return this.shouldValidateExistence;
    }

    public void setShouldValidateExistence(boolean bl) {
        this.shouldValidateExistence = bl;
    }

    @Override
    public boolean shouldPerformDeletesFirst() {
        return this.shouldPerformDeletesFirst;
    }

    @Override
    public boolean shouldPerformFullValidation() {
        return this.getValidationLevel() == 2;
    }

    @Override
    public boolean shouldPerformNoValidation() {
        return this.getValidationLevel() == 0;
    }

    @Override
    public boolean shouldPerformPartialValidation() {
        return this.getValidationLevel() == 1;
    }

    public boolean shouldResumeUnitOfWorkOnTransactionCompletion() {
        return this.resumeOnTransactionCompletion;
    }

    public void storeModifyAllQuery(DatabaseQuery databaseQuery) {
        if (this.modifyAllQueries == null) {
            this.modifyAllQueries = new ArrayList();
        }
        this.modifyAllQueries.add(databaseQuery);
    }

    public void storeDeferredModifyAllQuery(DatabaseQuery databaseQuery, AbstractRecord abstractRecord) {
        if (this.deferredModifyAllQueries == null) {
            this.deferredModifyAllQueries = new ArrayList();
        }
        this.deferredModifyAllQueries.add(new Object[]{databaseQuery, abstractRecord});
    }

    public void synchronizeAndResume() {
        this.pessimisticLockedObjects = null;
        if (this.hasProperties()) {
            this.getProperties().remove(LOCK_QUERIES_PROPERTY);
        }
        this.resumeUnitOfWork();
        this.allClones = null;
        this.removedObjects = null;
        this.lifecycle = 0;
        this.isSynchronized = false;
        this.unregisteredNewObjectsInParent = null;
        if (this.isNestedUnitOfWork()) {
            this.discoverAllUnregisteredNewObjectsInParent();
        }
    }

    public void resumeUnitOfWork() {
        Object object;
        Object object22;
        Object object3;
        Object object4;
        Object object5;
        if (this.hasNewObjects() && !this.isNestedUnitOfWork()) {
            object5 = this.newObjectsCloneToOriginal.entrySet().iterator();
            object4 = this.getCloneToOriginals();
            while (object5.hasNext()) {
                object3 = (Map.Entry)object5.next();
                object22 = object3.getKey();
                object = object3.getValue();
                if (object == null) continue;
                object4.put(object22, object);
            }
            this.newObjectsCloneToOriginal = null;
            this.newObjectsOriginalToClone = null;
        }
        this.unregisteredExistingObjects = null;
        this.unregisteredNewObjects = null;
        object5 = this.getCloneMapping();
        if (this.unitOfWorkChangeSet != null) {
            object4 = this.unitOfWorkChangeSet.getObjectChanges();
            for (Object object22 : object4.keySet()) {
                object = null;
                for (ObjectChangeSet objectChangeSet : ((Map)object4.get(object22)).values()) {
                    object = this.getDescriptor(objectChangeSet.getUnitOfWorkClone());
                    ((ClassDescriptor)object).getObjectChangePolicy().revertChanges(objectChangeSet.getUnitOfWorkClone(), (ClassDescriptor)object, this, (Map)object5);
                }
            }
        }
        this.deletedObjects = null;
        if (this.hasObjectsDeletedDuringCommit()) {
            if (this.unregisteredDeletedObjectsCloneToBackupAndOriginal == null) {
                this.unregisteredDeletedObjectsCloneToBackupAndOriginal = new IdentityHashMap(this.objectsDeletedDuringCommit.size());
            }
            object4 = this.objectsDeletedDuringCommit.keySet().iterator();
            object3 = this.getCloneToOriginals();
            while (object4.hasNext()) {
                object22 = object4.next();
                object = new Object[]{object5.get(object22), object3.get(object22)};
                this.unregisteredDeletedObjectsCloneToBackupAndOriginal.put(object22, object);
                this.getIdentityMapAccessorInstance().removeFromIdentityMap(object22);
                object5.remove(object22);
            }
        }
        this.objectsDeletedDuringCommit = null;
        this.unitOfWorkChangeSet = null;
        this.changeTrackedHardList = null;
    }

    protected void undeleteObject(Object object) {
        this.getDeletedObjects().remove(object);
        if (this.getParent().isUnitOfWork()) {
            ((UnitOfWorkImpl)this.getParent()).undeleteObject(object);
        }
    }

    @Override
    public void unregisterObject(Object object) {
        this.unregisterObject(object, 2);
    }

    public void unregisterObject(Object object, int n) {
        if (object == null) {
            return;
        }
        this.logDebugMessage(object, "unregister");
        Object object2 = this.getDescriptor(object).getObjectBuilder().unwrapObject(object, this);
        DescriptorIterator descriptorIterator = new DescriptorIterator(){

            public void iterate(Object object) {
                Object v;
                if (UnitOfWorkImpl.this.isClassReadOnly(object.getClass(), this.getCurrentDescriptor())) {
                    this.setShouldBreak(true);
                    return;
                }
                Vector vector = this.getCurrentDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(object, UnitOfWorkImpl.this);
                UnitOfWorkImpl.this.getIdentityMapAccessorInstance().removeFromIdentityMap(vector, object.getClass(), this.getCurrentDescriptor(), object);
                UnitOfWorkImpl.this.getCloneMapping().remove(object);
                if (UnitOfWorkImpl.this.hasNewObjects() && (v = UnitOfWorkImpl.this.getNewObjectsCloneToOriginal().remove(object)) != null) {
                    UnitOfWorkImpl.this.getNewObjectsOriginalToClone().remove(v);
                }
            }
        };
        descriptorIterator.setSession(this);
        descriptorIterator.setCascadeDepth(n);
        descriptorIterator.startIterationOn(object2);
    }

    public void updateChangeTrackersIfRequired(Object object, ObjectChangeSet objectChangeSet, UnitOfWorkImpl unitOfWorkImpl, ClassDescriptor classDescriptor) {
    }

    @Override
    public void validateObjectSpace() {
        this.log(2, "transaction", "validate_object_space");
        DescriptorIterator descriptorIterator = new DescriptorIterator(){

            public void iterate(Object object) {
                try {
                    if (UnitOfWorkImpl.this.isClassReadOnly(object.getClass(), this.getCurrentDescriptor())) {
                        this.setShouldBreak(true);
                        return;
                    }
                    UnitOfWorkImpl.this.getBackupClone(object, this.getCurrentDescriptor());
                }
                catch (EclipseLinkException eclipseLinkException) {
                    UnitOfWorkImpl.this.log(1, "transaction", "stack_of_visited_objects_that_refer_to_the_corrupt_object", this.getVisitedStack());
                    UnitOfWorkImpl.this.log(2, "transaction", "corrupt_object_referenced_through_mapping", this.getCurrentMapping());
                    throw eclipseLinkException;
                }
            }
        };
        descriptorIterator.setSession(this);
        Iterator iterator = this.getCloneMapping().keySet().iterator();
        while (iterator.hasNext()) {
            descriptorIterator.startIterationOn(iterator.next());
        }
    }

    public boolean wasTransactionBegunPrematurely() {
        if (this.isNestedUnitOfWork()) {
            return ((UnitOfWorkImpl)this.getParent()).wasTransactionBegunPrematurely();
        }
        return this.wasTransactionBegunPrematurely;
    }

    @Override
    public void writeChanges() {
        if (!this.isActive()) {
            throw ValidationException.inActiveUnitOfWork("writeChanges");
        }
        if (this.isAfterWriteChangesButBeforeCommit()) {
            throw ValidationException.cannotWriteChangesTwice();
        }
        if (this.isNestedUnitOfWork()) {
            throw ValidationException.writeChangesOnNestedUnitOfWork();
        }
        this.mergeBmpAndWsEntities();
        this.log(2, "transaction", "begin_unit_of_work_commit");
        this.getEventManager().preCommitUnitOfWork();
        this.setLifecycle(1);
        try {
            this.commitToDatabaseWithChangeSet(false);
            this.writesCompleted();
        }
        catch (RuntimeException runtimeException) {
            this.setLifecycle(3);
            throw runtimeException;
        }
        this.setLifecycle(2);
    }

    @Override
    public void writesCompleted() {
        this.getParent().writesCompleted();
    }

    private void logDebugMessage(Object object, String string) {
        this.log(1, "transaction", string, object);
    }

    public Object getWorkingCopyFromUnitOfWorkIdentityMap(Object object, Vector vector) {
        ClassDescriptor classDescriptor = this.getDescriptor(object);
        if (classDescriptor == null) {
            throw DescriptorException.missingDescriptor(object.getClass().toString());
        }
        if (classDescriptor.isDescriptorTypeAggregate()) {
            throw ValidationException.cannotRegisterAggregateObjectInUnitOfWork(object.getClass());
        }
        Object v = this.getCloneMapping().get(object);
        if (v != null) {
            return object;
        }
        Object object2 = this.getIdentityMapAccessorInstance().getIdentityMapManager().getFromIdentityMap(vector, object.getClass(), classDescriptor);
        if (object2 != null) {
            return object2;
        }
        return null;
    }

    public Map getBatchReadObjects() {
        if (this.batchReadObjects == null) {
            this.batchReadObjects = this.createMap();
        }
        return this.batchReadObjects;
    }

    public void setBatchReadObjects(Map map) {
        this.batchReadObjects = map;
    }

    public Map getPessimisticLockedObjects() {
        if (this.pessimisticLockedObjects == null) {
            this.pessimisticLockedObjects = new IdentityHashMap();
        }
        return this.pessimisticLockedObjects;
    }

    public void addToChangeTrackedHardList(Object object) {
        if (this.referenceMode != ReferenceMode.HARD) {
            this.getChangeTrackedHardList().add(object);
        }
    }

    public void addPessimisticLockedClone(Object object) {
        this.log(1, "transaction", "tracking_pl_object", object, new Integer(this.hashCode()));
        this.getPessimisticLockedObjects().put(object, object);
    }

    public void addPrivateOwnedObject(DatabaseMapping databaseMapping, Object object) {
        if (object != null && this.getDescriptor(object) != null) {
            Map<DatabaseMapping, Set> map = this.getPrivateOwnedObjects();
            Set set = map.get(databaseMapping);
            if (set == null) {
                set = new IdentityHashSet();
                map.put(databaseMapping, set);
            }
            set.add(object);
        }
    }

    public boolean isPessimisticLocked(Object object) {
        return this.pessimisticLockedObjects != null && this.pessimisticLockedObjects.containsKey(object);
    }

    public boolean isPreDeleteComplete() {
        return this.preDeleteComplete;
    }

    public void setWasNonObjectLevelModifyQueryExecuted(boolean bl) {
        this.wasNonObjectLevelModifyQueryExecuted = bl;
    }

    public boolean wasNonObjectLevelModifyQueryExecuted() {
        return this.wasNonObjectLevelModifyQueryExecuted;
    }

    public boolean shouldReadFromDB() {
        return this.wasNonObjectLevelModifyQueryExecuted();
    }

    @Override
    public void releaseReadConnection(Accessor accessor) {
        this.getParent().releaseReadConnection(accessor);
    }

    public void clear(boolean bl) {
        this.cloneToOriginals = null;
        this.cloneMapping = null;
        this.newObjectsCloneToOriginal = null;
        this.newObjectsOriginalToClone = null;
        this.deletedObjects = null;
        this.allClones = null;
        this.objectsDeletedDuringCommit = null;
        this.removedObjects = null;
        this.unregisteredNewObjects = null;
        this.unregisteredExistingObjects = null;
        this.newAggregates = null;
        this.unitOfWorkChangeSet = null;
        this.pessimisticLockedObjects = null;
        this.optimisticReadLockObjects = null;
        this.batchReadObjects = null;
        this.privateOwnedObjects = null;
        if (bl) {
            this.clearIdentityMapCache();
        }
    }

    private void clearIdentityMapCache() {
        this.getIdentityMapAccessor().initializeIdentityMaps();
        if (this.getParent() instanceof IsolatedClientSession) {
            this.getParent().getIdentityMapAccessor().initializeIdentityMaps();
        }
    }

    public void clearForClose(boolean bl) {
        block6: {
            block5: {
                if (this.getLifecycle() == 1) break block5;
                if (this.getLifecycle() == 2) break block5;
                if (this.getLifecycle() != 4) break block6;
            }
            if (bl) {
                this.clearIdentityMapCache();
            }
            return;
        }
        this.clear(bl);
        if (this.isActive()) {
            this.lifecycle = 0;
            this.isSynchronized = false;
        }
    }

    public boolean shouldClearForCloseOnRelease() {
        return false;
    }

    private void copyStatementsCountIntoProperties() {
        if (this.getAccessor() != null && this.getAccessor() instanceof DatasourceAccessor) {
            this.getProperties().put("Read_Statements_Count_Property", new Integer(((DatasourceAccessor)this.getAccessor()).getReadStatementsCount()));
            this.getProperties().put("Write_Statements_Count_Property", new Integer(((DatasourceAccessor)this.getAccessor()).getWriteStatementsCount()));
            this.getProperties().put("StoredProcedure_Statements_Count_Property", new Integer(((DatasourceAccessor)this.getAccessor()).getStoredProcedureStatementsCount()));
        }
    }

    protected Map createMap() {
        if (this.referenceMode != null && this.referenceMode != ReferenceMode.HARD) {
            return new IdentityWeakHashMap();
        }
        return new IdentityHashMap();
    }

    protected Map createMap(int n) {
        if (this.referenceMode != null && this.referenceMode != ReferenceMode.HARD) {
            return new IdentityWeakHashMap(n);
        }
        return new IdentityHashMap(n);
    }

    protected Map cloneMap(Map map) {
        if (this.referenceMode != null && this.referenceMode != ReferenceMode.HARD) {
            return (IdentityWeakHashMap)((IdentityWeakHashMap)map).clone();
        }
        return (IdentityHashMap)((IdentityHashMap)map).clone();
    }

    public ReferenceMode getReferenceMode() {
        return this.referenceMode;
    }

    public IdentityHashSet getChangeTrackedHardList() {
        if (this.changeTrackedHardList == null) {
            this.changeTrackedHardList = new IdentityHashSet();
        }
        return this.changeTrackedHardList;
    }

    @Override
    public Object getReference(Class clazz, Object object) {
        Object object2;
        Vector vector;
        ClassDescriptor classDescriptor = this.getDescriptor(clazz);
        if (classDescriptor == null || classDescriptor.isDescriptorTypeAggregate()) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("unknown_bean_class", new Object[]{clazz}));
        }
        if (object == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("null_pk"));
        }
        if (object instanceof List) {
            vector = new NonSynchronizedVector((Collection)((List)object));
        } else if (classDescriptor.getCMPPolicy() != null) {
            if (classDescriptor.getCMPPolicy().getPKClass() != null && !classDescriptor.getCMPPolicy().getPKClass().isAssignableFrom(object.getClass())) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("invalid_pk_class", new Object[]{classDescriptor.getCMPPolicy().getPKClass(), object.getClass()}));
            }
            vector = classDescriptor.getCMPPolicy().createPkVectorFromKey(object, this);
        } else if (!object.getClass().equals(clazz)) {
            vector = classDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, this);
        } else {
            vector = new NonSynchronizedVector(1);
            vector.add(object);
        }
        if (ClassConstants.FetchGroupTracker_class.isAssignableFrom(clazz)) {
            object2 = this.getIdentityMapAccessor().getFromIdentityMap(vector, clazz);
            if (object2 == null) {
                Serializable serializable;
                if (object instanceof List) {
                    serializable = classDescriptor.getObjectBuilder().buildRowFromPrimaryKeyValues(vector, this);
                    object2 = classDescriptor.getObjectBuilder().buildNewInstance();
                    classDescriptor.getObjectBuilder().buildPrimaryKeyAttributesIntoObject(object2, (AbstractRecord)serializable, new ReadObjectQuery());
                } else {
                    object2 = classDescriptor.getCMPPolicy().createBeanUsingKey(object, this);
                }
                ((FetchGroupTracker)object2)._persistence_setSession(this);
                serializable = new FetchGroup();
                for (DatabaseMapping databaseMapping : classDescriptor.getObjectBuilder().getPrimaryKeyMappings()) {
                    ((FetchGroup)serializable).addAttribute(databaseMapping.getAttributeName());
                }
                ((FetchGroupTracker)object2)._persistence_setFetchGroup((FetchGroup)serializable);
                object2 = this.registerExistingObject(object2);
            }
        } else {
            ReadObjectQuery readObjectQuery = new ReadObjectQuery(classDescriptor.getJavaClass());
            readObjectQuery.setSelectionKey(vector);
            readObjectQuery.conformResultsInUnitOfWork();
            readObjectQuery.setIsExecutionClone(true);
            object2 = this.executeQuery(readObjectQuery);
        }
        return object2;
    }
}

