/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings;

import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.descriptors.InstanceVariableAttributeAccessor;
import org.eclipse.persistence.internal.descriptors.MethodAttributeAccessor;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.indirection.UnitOfWorkValueHolder;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteSessionController;
import org.eclipse.persistence.internal.sessions.remote.RemoteValueHolder;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.QueryByExamplePolicy;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.ObjectCopyingPolicy;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.changesets.ChangeRecord;
import org.eclipse.persistence.sessions.remote.DistributedSession;
import org.eclipse.persistence.sessions.remote.RemoteSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DatabaseMapping
implements Cloneable,
Serializable {
    protected static final Vector NO_FIELDS = NonSynchronizedVector.newInstance(0);
    protected static final Integer NO_WEIGHT = new Integer(Integer.MAX_VALUE);
    protected static final Integer WEIGHT_1 = new Integer(1);
    protected ClassDescriptor descriptor;
    protected AttributeAccessor attributeAccessor;
    protected boolean isReadOnly = false;
    protected boolean isOptional = true;
    protected Boolean isLazy;
    protected Vector<DatabaseField> fields;
    protected boolean isRemotelyInitialized;
    protected Integer weight = NO_WEIGHT;
    protected Map properties;
    protected boolean isIDMapping = false;
    protected boolean isPrimaryKeyMapping = false;
    protected String attributeName;
    protected boolean isMapKeyMapping = false;

    public DatabaseMapping() {
        this.attributeAccessor = new InstanceVariableAttributeAccessor();
    }

    public abstract void buildBackupClone(Object var1, Object var2, UnitOfWorkImpl var3);

    public Object buildBackupCloneForPartObject(Object object, Object object2, Object object3, UnitOfWorkImpl unitOfWorkImpl) {
        throw DescriptorException.invalidMappingOperation(this, "buildBackupCloneForPartObject");
    }

    public abstract void buildClone(Object var1, Object var2, UnitOfWorkImpl var3);

    public abstract void buildCloneFromRow(AbstractRecord var1, JoinedAttributeManager var2, Object var3, ObjectBuildingQuery var4, UnitOfWorkImpl var5, AbstractSession var6);

    public void buildShallowOriginalFromRow(AbstractRecord abstractRecord, Object object, JoinedAttributeManager joinedAttributeManager, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) {
    }

    public Object buildCloneForPartObject(Object object, Object object2, Object object3, UnitOfWorkImpl unitOfWorkImpl, boolean bl) {
        throw DescriptorException.invalidMappingOperation(this, "buildCloneForPartObject");
    }

    public void buildCopy(Object object, Object object2, ObjectCopyingPolicy objectCopyingPolicy) {
    }

    public Expression buildExpression(Object object, QueryByExamplePolicy queryByExamplePolicy, Expression expression, Map map, AbstractSession abstractSession) {
        return null;
    }

    public Expression buildObjectJoinExpression(Expression expression, Object object, AbstractSession abstractSession) {
        throw QueryException.unsupportedMappingForObjectComparison(this, expression);
    }

    public Expression buildObjectJoinExpression(Expression expression, Expression expression2, AbstractSession abstractSession) {
        throw QueryException.unsupportedMappingForObjectComparison(this, expression);
    }

    public abstract void cascadePerformRemoveIfRequired(Object var1, UnitOfWorkImpl var2, Map var3);

    public void cascadePerformRemovePrivateOwnedObjectFromChangeSetIfRequired(Object object, UnitOfWorkImpl unitOfWorkImpl, Map map) {
    }

    public abstract void cascadeRegisterNewIfRequired(Object var1, UnitOfWorkImpl var2, Map var3);

    public void cascadeDiscoverAndPersistUnregisteredNewObjects(Object object, Map map, Map map2, Map map3, UnitOfWorkImpl unitOfWorkImpl) {
    }

    public void calculateDeferredChanges(org.eclipse.persistence.internal.sessions.ChangeRecord changeRecord, AbstractSession abstractSession) {
        throw DescriptorException.invalidMappingOperation(this, "calculatedDeferredChanges");
    }

    public void cascadeMerge(Object object, MergeManager mergeManager) {
        throw DescriptorException.invalidMappingOperation(this, "cascadeMerge");
    }

    public Object clone() {
        DatabaseMapping databaseMapping = null;
        try {
            databaseMapping = (DatabaseMapping)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        databaseMapping.setAttributeAccessor((AttributeAccessor)this.attributeAccessor.clone());
        return databaseMapping;
    }

    protected Vector cloneFields(Vector vector) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((Vector)nonSynchronizedVector).addElement(((DatabaseField)enumeration.nextElement()).clone());
        }
        return nonSynchronizedVector;
    }

    protected Vector<DatabaseField> collectFields() {
        return NO_FIELDS;
    }

    public abstract org.eclipse.persistence.internal.sessions.ChangeRecord compareForChange(Object var1, Object var2, ObjectChangeSet var3, AbstractSession var4);

    public abstract boolean compareObjects(Object var1, Object var2, AbstractSession var3);

    public void convertClassNamesToClasses(ClassLoader classLoader) {
    }

    public UnitOfWorkValueHolder createUnitOfWorkValueHolder(ValueHolderInterface valueHolderInterface, Object object, Object object2, AbstractRecord abstractRecord, UnitOfWorkImpl unitOfWorkImpl, boolean bl) {
        throw DescriptorException.invalidMappingOperation(this, "createUnitOfWorkValueHolder");
    }

    public void earlyPreDelete(DeleteObjectQuery deleteObjectQuery) {
    }

    protected Vector extractNestedExpressions(List list, ExpressionBuilder expressionBuilder, boolean bl) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(list.size());
        for (Expression expression : list) {
            QueryKeyExpression queryKeyExpression;
            if (!expression.isQueryKeyExpression()) continue;
            QueryKeyExpression queryKeyExpression2 = queryKeyExpression = (QueryKeyExpression)expression;
            boolean bl2 = false;
            while (!queryKeyExpression2.getBaseExpression().isExpressionBuilder()) {
                bl2 = true;
                queryKeyExpression2 = (QueryKeyExpression)queryKeyExpression2.getBaseExpression();
            }
            if (bl2 && queryKeyExpression2.getName().equals(this.getAttributeName())) {
                ((Vector)nonSynchronizedVector).addElement(queryKeyExpression.rebuildOn(queryKeyExpression2, expressionBuilder));
                continue;
            }
            if (!bl || !queryKeyExpression.getBaseExpression().isExpressionBuilder() || !queryKeyExpression.getName().equals(this.getAttributeName())) continue;
            ((Vector)nonSynchronizedVector).addElement(expressionBuilder);
        }
        return nonSynchronizedVector;
    }

    protected boolean hasRootExpressionThatShouldUseOuterJoin(List list) {
        for (Expression expression : list) {
            QueryKeyExpression queryKeyExpression;
            if (!expression.isQueryKeyExpression() || !(queryKeyExpression = (QueryKeyExpression)expression).getBaseExpression().isExpressionBuilder() || !queryKeyExpression.getName().equals(this.getAttributeName())) continue;
            return queryKeyExpression.shouldUseOuterJoin();
        }
        return false;
    }

    public abstract void fixObjectReferences(Object var1, Map var2, Map var3, ObjectLevelReadQuery var4, RemoteSession var5);

    public void fixRealObjectReferences(Object object, Map map, Map map2, ObjectLevelReadQuery objectLevelReadQuery, RemoteSession remoteSession) {
    }

    public AttributeAccessor getAttributeAccessor() {
        return this.attributeAccessor;
    }

    public Class getAttributeClassification() {
        return null;
    }

    public String getAttributeName() {
        if (this.attributeName == null) {
            this.attributeName = this.getAttributeAccessor().getAttributeName();
        }
        return this.attributeName;
    }

    public Object getAttributeValueFromObject(Object object) throws DescriptorException {
        try {
            return this.attributeAccessor.getAttributeValueFromObject(object);
        }
        catch (DescriptorException descriptorException) {
            descriptorException.setMapping(this);
            throw descriptorException;
        }
    }

    public ContainerPolicy getContainerPolicy() {
        throw DescriptorException.invalidMappingOperation(this, "getContainerPolicy");
    }

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public DatabaseField getField() {
        return null;
    }

    public Class getFieldClassification(DatabaseField databaseField) {
        return null;
    }

    public Vector getSelectFields() {
        return this.getFields();
    }

    public Vector getSelectTables() {
        return new NonSynchronizedVector(0);
    }

    public Vector<DatabaseField> getFields() {
        return this.fields;
    }

    public String getGetMethodName() {
        if (!this.getAttributeAccessor().isMethodAttributeAccessor()) {
            return null;
        }
        return ((MethodAttributeAccessor)this.getAttributeAccessor()).getGetMethodName();
    }

    public Object getObjectCorrespondingTo(Object object, RemoteSession remoteSession, Map map, Map map2, ObjectLevelReadQuery objectLevelReadQuery) {
        return object;
    }

    public Map getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap(5);
        }
        return this.properties;
    }

    public Object getProperty(Object object) {
        if (this.properties == null) {
            return null;
        }
        return this.getProperties().get(object);
    }

    public Object getRealAttributeValueFromObject(Object object, AbstractSession abstractSession) throws DescriptorException {
        return this.getRealAttributeValueFromAttribute(this.getAttributeValueFromObject(object), object, abstractSession);
    }

    public Object getRealAttributeValueFromAttribute(Object object, Object object2, AbstractSession abstractSession) throws DescriptorException {
        return object;
    }

    public void instantiateAttribute(Object object, AbstractSession abstractSession) {
    }

    public Object getRealCollectionAttributeValueFromObject(Object object, AbstractSession abstractSession) throws DescriptorException {
        throw DescriptorException.invalidMappingOperation(this, "getRealCollectionAttributeValueFromObject");
    }

    public ClassDescriptor getReferenceDescriptor() {
        return null;
    }

    public DatabaseMapping getRelationshipPartner() {
        return null;
    }

    public String getSetMethodName() {
        if (!this.getAttributeAccessor().isMethodAttributeAccessor()) {
            return null;
        }
        return ((MethodAttributeAccessor)this.getAttributeAccessor()).getSetMethodName();
    }

    public Object getValueFromRemoteValueHolder(RemoteValueHolder remoteValueHolder) {
        throw DescriptorException.invalidMappingOperation(this, "getValueFromRemoteValueHolder");
    }

    public Integer getWeight() {
        return this.weight;
    }

    public boolean hasConstraintDependency() {
        return false;
    }

    public boolean isUsingMethodAccess() {
        return this.getAttributeAccessor().isMethodAttributeAccessor();
    }

    public boolean hasDependency() {
        return this.isPrivateOwned();
    }

    public boolean hasInverseConstraintDependency() {
        return false;
    }

    public void initialize(AbstractSession abstractSession) throws DescriptorException {
    }

    public boolean isAggregateCollectionMapping() {
        return false;
    }

    public boolean isAggregateMapping() {
        return false;
    }

    public boolean isAggregateObjectMapping() {
        return false;
    }

    public boolean isCollectionMapping() {
        return false;
    }

    public boolean isDatabaseMapping() {
        return true;
    }

    public boolean isDirectCollectionMapping() {
        return false;
    }

    public boolean isDirectMapMapping() {
        return false;
    }

    public boolean isDirectToFieldMapping() {
        return false;
    }

    public boolean isForeignReferenceMapping() {
        return false;
    }

    public boolean isLockableMapping() {
        return false;
    }

    public boolean isManyToManyMapping() {
        return false;
    }

    public boolean isMapKeyMapping() {
        return this.isMapKeyMapping;
    }

    public void setIsMapKeyMapping(boolean bl) {
        this.isMapKeyMapping = bl;
    }

    public boolean isNestedTableMapping() {
        return false;
    }

    public boolean isObjectReferenceMapping() {
        return false;
    }

    public boolean isOneToManyMapping() {
        return false;
    }

    public boolean isOneToOneMapping() {
        return false;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public boolean isLazy() {
        if (this.isLazy == null) {
            this.isLazy = Boolean.FALSE;
        }
        return this.isLazy;
    }

    public void setIsLazy(boolean bl) {
        this.isLazy = bl;
    }

    public boolean isEISMapping() {
        return false;
    }

    public boolean isRelationalMapping() {
        return false;
    }

    public boolean isXMLMapping() {
        return false;
    }

    public boolean isAbstractDirectMapping() {
        return false;
    }

    public boolean isAbstractCompositeDirectCollectionMapping() {
        return false;
    }

    public boolean isAbstractCompositeObjectMapping() {
        return false;
    }

    public boolean isAbstractCompositeCollectionMapping() {
        return false;
    }

    public boolean isJoiningSupported() {
        return false;
    }

    public boolean isCloningRequired() {
        return true;
    }

    public boolean isPrimaryKeyMapping() {
        return this.isPrimaryKeyMapping;
    }

    public boolean isIDMapping() {
        return this.isIDMapping;
    }

    public boolean isCandidateForPrivateOwnedRemoval() {
        return this.isPrivateOwned();
    }

    public boolean isCascadedLockingSupported() {
        return false;
    }

    public boolean isChangeTrackingSupported(Project project) {
        return false;
    }

    public boolean isPrivateOwned() {
        return false;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public boolean isReferenceMapping() {
        return false;
    }

    protected boolean isRemotelyInitialized() {
        return this.isRemotelyInitialized;
    }

    public boolean isStructureMapping() {
        return false;
    }

    public boolean isTransformationMapping() {
        return false;
    }

    public boolean isUnidirectionalOneToManyMapping() {
        return false;
    }

    public boolean isVariableOneToOneMapping() {
        return false;
    }

    public boolean isDirectToXMLTypeMapping() {
        return false;
    }

    public boolean isWriteOnly() {
        return false;
    }

    public abstract void iterate(DescriptorIterator var1);

    public void iterateOnRealAttributeValue(DescriptorIterator descriptorIterator, Object object) {
        throw DescriptorException.invalidMappingOperation(this, "iterateOnRealAttributeValue");
    }

    public abstract void mergeChangesIntoObject(Object var1, org.eclipse.persistence.internal.sessions.ChangeRecord var2, Object var3, MergeManager var4);

    public abstract void mergeIntoObject(Object var1, boolean var2, Object var3, MergeManager var4);

    public void performDataModificationEvent(Object[] objectArray, AbstractSession abstractSession) throws DatabaseException, DescriptorException {
        throw DescriptorException.invalidDataModificationEvent(this);
    }

    public void postDelete(DeleteObjectQuery deleteObjectQuery) throws DatabaseException {
    }

    public void postInitialize(AbstractSession abstractSession) throws DescriptorException {
    }

    public void postInsert(WriteObjectQuery writeObjectQuery) throws DatabaseException {
    }

    public void postUpdate(WriteObjectQuery writeObjectQuery) throws DatabaseException {
    }

    public void preDelete(DeleteObjectQuery deleteObjectQuery) throws DatabaseException {
    }

    public void preInitialize(AbstractSession abstractSession) throws DescriptorException {
        try {
            this.getAttributeAccessor().initializeAttributes(this.getDescriptor().getJavaClass());
        }
        catch (DescriptorException descriptorException) {
            descriptorException.setMapping(this);
            abstractSession.getIntegrityChecker().handleError(descriptorException);
        }
    }

    public void preInsert(WriteObjectQuery writeObjectQuery) throws DatabaseException {
    }

    public void prepareCascadeLockingPolicy() {
    }

    public void preUpdate(WriteObjectQuery writeObjectQuery) throws DatabaseException {
    }

    public Object readFromRowIntoObject(AbstractRecord abstractRecord, JoinedAttributeManager joinedAttributeManager, Object object, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) throws DatabaseException {
        Object object2 = this.valueFromRow(abstractRecord, joinedAttributeManager, objectBuildingQuery, abstractSession);
        this.setAttributeValueInObject(object, object2);
        return object2;
    }

    public Object readFromResultSetIntoObject(ResultSet resultSet, Object object, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession, DatabaseAccessor databaseAccessor, ResultSetMetaData resultSetMetaData, int n, DatabasePlatform databasePlatform) throws DatabaseException {
        Object object2 = this.valueFromResultSet(resultSet, objectBuildingQuery, abstractSession, databaseAccessor, resultSetMetaData, n, databasePlatform);
        this.setAttributeValueInObject(object, object2);
        return object2;
    }

    public void readOnly() {
        this.setIsReadOnly(true);
    }

    public void readWrite() {
        this.setIsReadOnly(false);
    }

    public void rehashFieldDependancies(AbstractSession abstractSession) {
    }

    public void remoteInitialization(DistributedSession distributedSession) {
        if (!this.isRemotelyInitialized()) {
            this.getAttributeAccessor().initializeAttributes(this.getDescriptor().getJavaClass());
            this.remotelyInitialized();
        }
    }

    protected void remotelyInitialized() {
        this.isRemotelyInitialized = true;
    }

    public Map replaceValueHoldersIn(Object object, RemoteSessionController remoteSessionController) {
        return null;
    }

    public void setAttributeAccessor(AttributeAccessor attributeAccessor) {
        String string = this.getAttributeName();
        this.attributeAccessor = attributeAccessor;
        if (attributeAccessor.getAttributeName() == null) {
            attributeAccessor.setAttributeName(string);
        }
        this.attributeName = null;
    }

    public void setAttributeName(String string) {
        this.getAttributeAccessor().setAttributeName(string);
        this.attributeName = null;
    }

    public void setAttributeValueInObject(Object object, Object object2) throws DescriptorException {
        try {
            this.attributeAccessor.setAttributeValueInObject(object, object2);
        }
        catch (DescriptorException descriptorException) {
            descriptorException.setMapping(this);
            throw descriptorException;
        }
    }

    public void setRealAttributeValueInObject(Object object, Object object2) throws DescriptorException {
        try {
            this.setAttributeValueInObject(object, object2);
        }
        catch (DescriptorException descriptorException) {
            descriptorException.setMapping(this);
            throw descriptorException;
        }
    }

    public void setDescriptor(ClassDescriptor classDescriptor) {
        this.descriptor = classDescriptor;
    }

    protected void setFields(Vector<DatabaseField> vector) {
        this.fields = vector;
    }

    public void setGetMethodName(String string) {
        if (string == null) {
            return;
        }
        if (this.getAttributeAccessor() instanceof InstanceVariableAttributeAccessor) {
            String string2 = this.attributeAccessor.getAttributeName();
            this.setAttributeAccessor(new MethodAttributeAccessor());
            this.getAttributeAccessor().setAttributeName(string2);
        }
        ((MethodAttributeAccessor)this.getAttributeAccessor()).setGetMethodName(string);
    }

    public void setIsOptional(boolean bl) {
        this.isOptional = bl;
    }

    public void setIsIDMapping(boolean bl) {
        this.isIDMapping = bl;
    }

    public void setIsPrimaryKeyMapping(boolean bl) {
        this.isPrimaryKeyMapping = bl;
    }

    public void setIsReadOnly(boolean bl) {
        this.isReadOnly = bl;
    }

    public void setProperties(Map map) {
        this.properties = map;
    }

    public void setProperty(Object object, Object object2) {
        this.getProperties().put(object, object2);
    }

    public void setSetMethodName(String string) {
        if (string == null) {
            return;
        }
        if (!this.getAttributeAccessor().isMethodAttributeAccessor()) {
            String string2 = this.attributeAccessor.getAttributeName();
            this.setAttributeAccessor(new MethodAttributeAccessor());
            this.getAttributeAccessor().setAttributeName(string2);
        }
        ((MethodAttributeAccessor)this.getAttributeAccessor()).setSetMethodName(string);
    }

    public void setWeight(Integer n) {
        this.weight = n;
    }

    public void simpleAddToCollectionChangeRecord(Object object, Object object2, ObjectChangeSet objectChangeSet, AbstractSession abstractSession) throws DescriptorException {
        throw DescriptorException.invalidMappingOperation(this, "simpleAddToCollectionChangeRecord");
    }

    public void simpleRemoveFromCollectionChangeRecord(Object object, Object object2, ObjectChangeSet objectChangeSet, AbstractSession abstractSession) throws DescriptorException {
        throw DescriptorException.invalidMappingOperation(this, "simpleRemoveFromCollectionChangeRecord");
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getAttributeName() + "]";
    }

    public void validateAfterInitialization(AbstractSession abstractSession) throws DescriptorException {
    }

    public void validateBeforeInitialization(AbstractSession abstractSession) throws DescriptorException {
    }

    public Object valueFromObject(Object object, DatabaseField databaseField, AbstractSession abstractSession) {
        return null;
    }

    public Object valueFromRow(AbstractRecord abstractRecord, JoinedAttributeManager joinedAttributeManager, ObjectBuildingQuery objectBuildingQuery) throws DatabaseException {
        return this.valueFromRow(abstractRecord, joinedAttributeManager, objectBuildingQuery, objectBuildingQuery.getExecutionSession());
    }

    public Object valueFromRow(AbstractRecord abstractRecord, JoinedAttributeManager joinedAttributeManager, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) throws DatabaseException {
        return null;
    }

    public Object valueFromResultSet(ResultSet resultSet, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession, DatabaseAccessor databaseAccessor, ResultSetMetaData resultSetMetaData, int n, DatabasePlatform databasePlatform) throws DatabaseException {
        throw DescriptorException.invalidMappingOperation(this, "valueFromResultSet");
    }

    public boolean verifyDelete(Object object, AbstractSession abstractSession) throws DatabaseException {
        return true;
    }

    public void writeFromAttributeIntoRow(Object object, AbstractRecord abstractRecord, AbstractSession abstractSession) {
    }

    public void writeFromObjectIntoRow(Object object, AbstractRecord abstractRecord, AbstractSession abstractSession) {
    }

    public void writeFromObjectIntoRowForShallowInsert(Object object, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        this.writeFromObjectIntoRow(object, abstractRecord, abstractSession);
    }

    public void writeFromObjectIntoRowWithChangeRecord(org.eclipse.persistence.internal.sessions.ChangeRecord changeRecord, AbstractRecord abstractRecord, AbstractSession abstractSession) {
    }

    public void writeFromObjectIntoRowForShallowInsertWithChangeRecord(org.eclipse.persistence.internal.sessions.ChangeRecord changeRecord, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        this.writeFromObjectIntoRowWithChangeRecord(changeRecord, abstractRecord, abstractSession);
    }

    public void writeFromObjectIntoRowForUpdate(WriteObjectQuery writeObjectQuery, AbstractRecord abstractRecord) {
        this.writeFromObjectIntoRow(writeObjectQuery.getObject(), abstractRecord, writeObjectQuery.getSession());
    }

    public void writeFromObjectIntoRowForWhereClause(ObjectLevelModifyQuery objectLevelModifyQuery, AbstractRecord abstractRecord) {
        Object object = objectLevelModifyQuery.isDeleteObjectQuery() ? objectLevelModifyQuery.getObject() : objectLevelModifyQuery.getBackupClone();
        this.writeFromObjectIntoRow(object, abstractRecord, objectLevelModifyQuery.getSession());
    }

    public void writeInsertFieldsIntoRow(AbstractRecord abstractRecord, AbstractSession abstractSession) {
    }

    public void writeUpdateFieldsIntoRow(AbstractRecord abstractRecord, AbstractSession abstractSession) {
        this.writeInsertFieldsIntoRow(abstractRecord, abstractSession);
    }

    public void updateChangeRecord(Object object, Object object2, Object object3, ObjectChangeSet objectChangeSet, UnitOfWorkImpl unitOfWorkImpl) throws DescriptorException {
        throw DescriptorException.invalidMappingOperation(this, "updateChangeRecord");
    }

    public void updateCollectionChangeRecord(CollectionChangeEvent collectionChangeEvent, ObjectChangeSet objectChangeSet, UnitOfWorkImpl unitOfWorkImpl) throws DescriptorException {
        throw DescriptorException.invalidMappingOperation(this, "updateCollectionChangeRecord");
    }

    public void setChangeListener(Object object, PropertyChangeListener propertyChangeListener, UnitOfWorkImpl unitOfWorkImpl) {
    }

    public void addToCollectionChangeRecord(Object object, Object object2, ObjectChangeSet objectChangeSet, UnitOfWorkImpl unitOfWorkImpl) throws DescriptorException {
        throw DescriptorException.invalidMappingOperation(this, "addToCollectionChangeRecord");
    }

    public void removeFromCollectionChangeRecord(Object object, Object object2, ObjectChangeSet objectChangeSet, UnitOfWorkImpl unitOfWorkImpl) throws DescriptorException {
        throw DescriptorException.invalidMappingOperation(this, "removeFromCollectionChangeRecord");
    }

    public org.eclipse.persistence.internal.sessions.ChangeRecord buildChangeRecord(Object object, ObjectChangeSet objectChangeSet, AbstractSession abstractSession) throws DescriptorException {
        throw DescriptorException.invalidMappingOperation(this, "buildChangeRecord");
    }

    public void postCalculateChanges(ChangeRecord changeRecord, UnitOfWorkImpl unitOfWorkImpl) {
    }

    public void postCalculateChangesOnDeleted(Object object, UnitOfWorkChangeSet unitOfWorkChangeSet, UnitOfWorkImpl unitOfWorkImpl) {
    }

    public void recordPrivateOwnedRemovals(Object object, UnitOfWorkImpl unitOfWorkImpl) {
    }
}

