/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.accessor.OrmAttributeAccessor;
import org.eclipse.persistence.internal.oxm.documentpreservation.DescriptorLevelDocumentPreservationPolicy;
import org.eclipse.persistence.internal.oxm.documentpreservation.NoDocumentPreservationPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.oxm.XMLBinder;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLLogin;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.XMLValidator;
import org.eclipse.persistence.oxm.documentpreservation.DocumentPreservationPolicy;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.platform.SAXPlatform;
import org.eclipse.persistence.oxm.platform.XMLPlatform;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.sessions.factories.XMLSessionConfigLoader;

public class XMLContext {
    private List sessions;
    private Map descriptorsByQName;
    private Map descriptorsByGlobalType;
    private boolean hasDocumentPreservation = false;

    public XMLContext(String string) {
        this(string, PrivilegedAccessHelper.privilegedGetClassLoaderForClass(XMLContext.class));
    }

    public XMLContext(String string, ClassLoader classLoader) {
        this(string, classLoader, null);
    }

    public XMLContext(String string, String string2) {
        this(string, PrivilegedAccessHelper.privilegedGetClassLoaderForClass(XMLContext.class), string2);
    }

    public XMLContext(String string, ClassLoader classLoader, String string2) {
        XMLSessionConfigLoader xMLSessionConfigLoader = null;
        xMLSessionConfigLoader = string2 != null ? new XMLSessionConfigLoader(string2) : new XMLSessionConfigLoader();
        this.descriptorsByQName = new HashMap();
        this.descriptorsByGlobalType = new HashMap();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        this.sessions = new ArrayList(stringTokenizer.countTokens());
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            this.sessions.add(this.buildSession(stringTokenizer.nextToken(), classLoader, xMLSessionConfigLoader));
            ++n;
        }
        for (int i = n - 1; i >= 0; --i) {
            this.storeXMLDescriptorsByQName((DatabaseSession)this.sessions.get(i));
        }
    }

    public XMLContext(Project project) {
        this(project, Thread.currentThread().getContextClassLoader());
    }

    public XMLContext(Project project, ClassLoader classLoader) {
        this(project, classLoader, null);
    }

    public XMLContext(Project project, ClassLoader classLoader, SessionEventListener sessionEventListener) {
        Object object;
        if (project.getDatasourceLogin() == null || !(project.getDatasourceLogin().getDatasourcePlatform() instanceof XMLPlatform)) {
            object = new SAXPlatform();
            ((XMLPlatform)object).getConversionManager().setLoader(classLoader);
            project.setLogin(new XMLLogin((Platform)object));
        }
        this.sessions = new ArrayList(1);
        object = project.createDatabaseSession();
        if (sessionEventListener != null) {
            object.getEventManager().addListener(sessionEventListener);
        }
        object.setLogLevel(8);
        this.setupDocumentPreservationPolicy((DatabaseSession)object);
        object.login();
        this.sessions.add(object);
        this.descriptorsByQName = new HashMap();
        this.descriptorsByGlobalType = new HashMap();
        this.storeXMLDescriptorsByQName((DatabaseSession)object);
    }

    public XMLContext(Collection collection) {
        this(collection, Thread.currentThread().getContextClassLoader());
    }

    public XMLContext(Collection collection, ClassLoader classLoader) {
        Iterator iterator = collection.iterator();
        this.sessions = new ArrayList(collection.size());
        this.descriptorsByQName = new HashMap();
        this.descriptorsByGlobalType = new HashMap();
        while (iterator.hasNext()) {
            Object object;
            Project project = (Project)iterator.next();
            if (project.getDatasourceLogin() == null || !(project.getDatasourceLogin().getDatasourcePlatform() instanceof XMLPlatform)) {
                object = new SAXPlatform();
                ((XMLPlatform)object).getConversionManager().setLoader(classLoader);
                project.setLogin(new XMLLogin((Platform)object));
            }
            object = project.createDatabaseSession();
            object.setLogLevel(8);
            this.setupDocumentPreservationPolicy((DatabaseSession)object);
            object.login();
            this.sessions.add(object);
            this.storeXMLDescriptorsByQName((DatabaseSession)object);
        }
    }

    private DatabaseSession buildSession(String string, ClassLoader classLoader, XMLSessionConfigLoader xMLSessionConfigLoader) throws XMLMarshalException {
        Object object;
        DatabaseSession databaseSession = classLoader != null ? (DatabaseSession)((Object)SessionManager.getManager().getSession(xMLSessionConfigLoader, string, classLoader, false, true)) : (DatabaseSession)((Object)SessionManager.getManager().getSession(xMLSessionConfigLoader, string, PrivilegedAccessHelper.privilegedGetClassLoaderForClass(this.getClass()), false, false, false));
        if (databaseSession.getDatasourceLogin() == null || !(databaseSession.getDatasourceLogin().getDatasourcePlatform() instanceof XMLPlatform)) {
            object = new SAXPlatform();
            databaseSession.setLogin(new XMLLogin((Platform)object));
        }
        object = databaseSession.getProject().createDatabaseSession();
        if (databaseSession.getEventManager().hasListeners()) {
            Vector vector = databaseSession.getEventManager().getListeners();
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                object.getEventManager().addListener((SessionEventListener)vector.get(i));
            }
        }
        object.setExceptionHandler(databaseSession.getExceptionHandler());
        object.setLogLevel(8);
        this.setupDocumentPreservationPolicy((DatabaseSession)object);
        object.login();
        return object;
    }

    public void addSession(DatabaseSession databaseSession) {
        Object object;
        if (databaseSession.getDatasourceLogin() == null || !(databaseSession.getDatasourceLogin().getDatasourcePlatform() instanceof XMLPlatform)) {
            object = new SAXPlatform();
            databaseSession.setLogin(new XMLLogin((Platform)object));
        }
        object = databaseSession.getProject().createDatabaseSession();
        if (databaseSession.getEventManager().hasListeners()) {
            Vector vector = databaseSession.getEventManager().getListeners();
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                object.getEventManager().addListener((SessionEventListener)vector.get(i));
            }
        }
        object.setExceptionHandler(databaseSession.getExceptionHandler());
        object.setLogLevel(8);
        this.setupDocumentPreservationPolicy((DatabaseSession)object);
        object.login();
        this.sessions.add(object);
        this.storeXMLDescriptorsByQName((DatabaseSession)object);
    }

    public XMLUnmarshaller createUnmarshaller() {
        XMLUnmarshaller xMLUnmarshaller = new XMLUnmarshaller(this);
        return xMLUnmarshaller;
    }

    public XMLBinder createBinder() {
        return new XMLBinder(this);
    }

    public XMLMarshaller createMarshaller() {
        XMLMarshaller xMLMarshaller = new XMLMarshaller(this);
        return xMLMarshaller;
    }

    public XMLValidator createValidator() {
        XMLValidator xMLValidator = new XMLValidator(this);
        return xMLValidator;
    }

    public AbstractSession getReadSession(Object object) {
        if (null == object) {
            return null;
        }
        int n = this.sessions.size();
        for (int i = 0; i < n; ++i) {
            AbstractSession abstractSession = (AbstractSession)this.sessions.get(i);
            XMLDescriptor xMLDescriptor = (XMLDescriptor)abstractSession.getDescriptor(object);
            if (xMLDescriptor == null) continue;
            abstractSession = abstractSession.acquireUnitOfWork();
            return abstractSession;
        }
        throw XMLMarshalException.descriptorNotFoundInProject(object.getClass().getName());
    }

    public AbstractSession getReadSession(Class clazz) {
        if (null == clazz) {
            return null;
        }
        int n = this.sessions.size();
        for (int i = 0; i < n; ++i) {
            AbstractSession abstractSession = (AbstractSession)this.sessions.get(i);
            XMLDescriptor xMLDescriptor = (XMLDescriptor)abstractSession.getDescriptor(clazz);
            if (xMLDescriptor == null) continue;
            abstractSession = abstractSession.acquireUnitOfWork();
            return abstractSession;
        }
        throw XMLMarshalException.descriptorNotFoundInProject(clazz.getName());
    }

    public AbstractSession getReadSession(XMLDescriptor xMLDescriptor) {
        if (null == xMLDescriptor) {
            return null;
        }
        int n = this.sessions.size();
        for (int i = 0; i < n; ++i) {
            AbstractSession abstractSession = (AbstractSession)this.sessions.get(i);
            if (!abstractSession.getProject().getOrderedDescriptors().contains(xMLDescriptor)) continue;
            abstractSession = abstractSession.acquireUnitOfWork();
            return abstractSession;
        }
        throw XMLMarshalException.descriptorNotFoundInProject(xMLDescriptor.getJavaClass().getName());
    }

    public List getSessions() {
        return this.sessions;
    }

    public DatabaseSession getSession(int n) {
        if (null == this.sessions) {
            return null;
        }
        return (DatabaseSession)this.sessions.get(n);
    }

    public AbstractSession getSession(Object object) {
        if (null == object) {
            return null;
        }
        int n = this.sessions.size();
        for (int i = 0; i < n; ++i) {
            AbstractSession abstractSession = (AbstractSession)this.sessions.get(i);
            if (abstractSession.getDescriptor(object) == null) continue;
            return abstractSession;
        }
        throw XMLMarshalException.descriptorNotFoundInProject(object.getClass().getName());
    }

    public AbstractSession getSession(Class clazz) {
        if (null == clazz) {
            return null;
        }
        int n = this.sessions.size();
        for (int i = 0; i < n; ++i) {
            AbstractSession abstractSession = (AbstractSession)this.sessions.get(i);
            if (abstractSession.getDescriptor(clazz) == null) continue;
            return abstractSession;
        }
        throw XMLMarshalException.descriptorNotFoundInProject(clazz.getName());
    }

    public AbstractSession getSession(XMLDescriptor xMLDescriptor) {
        if (null == xMLDescriptor) {
            return null;
        }
        int n = this.sessions.size();
        for (int i = 0; i < n; ++i) {
            AbstractSession abstractSession = (AbstractSession)this.sessions.get(i);
            if (!abstractSession.getProject().getOrderedDescriptors().contains(xMLDescriptor)) continue;
            return abstractSession;
        }
        throw XMLMarshalException.descriptorNotFoundInProject(xMLDescriptor.getJavaClass().getName());
    }

    private void storeXMLDescriptorsByQName(DatabaseSession databaseSession) {
        for (XMLDescriptor xMLDescriptor : databaseSession.getProject().getOrderedDescriptors()) {
            this.storeXMLDescriptorByQName(xMLDescriptor);
        }
    }

    public void storeXMLDescriptorByQName(XMLDescriptor xMLDescriptor) {
        Object object;
        Object object2;
        Vector vector = xMLDescriptor.getTableNames();
        for (int i = 0; i < vector.size(); ++i) {
            QName qName;
            String string = (String)vector.get(i);
            if (null == string) continue;
            int n = string.indexOf(58);
            object2 = string.substring(n + 1);
            if (n > -1) {
                object = string.substring(0, n);
                String string2 = xMLDescriptor.getNamespaceResolver().resolveNamespacePrefix((String)object);
                qName = new QName(string2, (String)object2);
            } else {
                qName = xMLDescriptor.getNamespaceResolver() != null ? new QName(xMLDescriptor.getNamespaceResolver().getDefaultNamespaceURI(), (String)object2) : new QName((String)object2);
            }
            if (!xMLDescriptor.hasInheritance() || xMLDescriptor.getInheritancePolicy().isRootParentDescriptor()) {
                this.descriptorsByQName.put(qName, xMLDescriptor);
                continue;
            }
            object = (XMLDescriptor)this.descriptorsByQName.get(qName);
            if (object != null) continue;
            this.descriptorsByQName.put(qName, xMLDescriptor);
        }
        XMLSchemaReference xMLSchemaReference = xMLDescriptor.getSchemaReference();
        if (null != xMLSchemaReference) {
            String string = xMLSchemaReference.getSchemaContext();
            if (xMLSchemaReference.getType() == 1 || xMLSchemaReference.getType() == 2) {
                if (null != string && string.lastIndexOf(47) == 0) {
                    string = string.substring(1, string.length());
                    object2 = new XPathFragment(string);
                    if (null != xMLDescriptor.getNamespaceResolver()) {
                        ((XPathFragment)object2).setNamespaceURI(xMLDescriptor.getNamespaceResolver().resolveNamespacePrefix(((XPathFragment)object2).getPrefix()));
                    }
                    this.descriptorsByGlobalType.put(object2, xMLDescriptor);
                } else {
                    object2 = xMLSchemaReference.getSchemaContextAsQName();
                    if (object2 != null) {
                        if (xMLDescriptor.isWrapper() && xMLDescriptor.getJavaClassName().contains("ObjectWrapper")) {
                            return;
                        }
                        object = new XPathFragment();
                        ((XPathFragment)object).setLocalName(((QName)object2).getLocalPart());
                        ((XPathFragment)object).setNamespaceURI(((QName)object2).getNamespaceURI());
                        this.descriptorsByGlobalType.put(object, xMLDescriptor);
                    }
                }
            }
        }
    }

    public XMLDescriptor getDescriptor(QName qName) {
        return (XMLDescriptor)this.descriptorsByQName.get(qName);
    }

    public void addDescriptorByQName(QName qName, XMLDescriptor xMLDescriptor) {
        this.descriptorsByQName.put(qName, xMLDescriptor);
    }

    public XMLDescriptor getDescriptorByGlobalType(XPathFragment xPathFragment) {
        return (XMLDescriptor)this.descriptorsByGlobalType.get(xPathFragment);
    }

    public DocumentPreservationPolicy getDocumentPreservationPolicy(AbstractSession abstractSession) {
        XMLLogin xMLLogin = (XMLLogin)abstractSession.getDatasourceLogin();
        return xMLLogin.getDocumentPreservationPolicy();
    }

    public void setupDocumentPreservationPolicy(DatabaseSession databaseSession) {
        XMLLogin xMLLogin = (XMLLogin)databaseSession.getDatasourceLogin();
        if (xMLLogin.getDocumentPreservationPolicy() == null) {
            for (XMLDescriptor xMLDescriptor : databaseSession.getProject().getOrderedDescriptors()) {
                if (!xMLDescriptor.shouldPreserveDocument()) continue;
                xMLLogin.setDocumentPreservationPolicy(new DescriptorLevelDocumentPreservationPolicy());
                break;
            }
        }
        if (xMLLogin.getDocumentPreservationPolicy() == null) {
            xMLLogin.setDocumentPreservationPolicy(new NoDocumentPreservationPolicy());
        }
        xMLLogin.getDocumentPreservationPolicy().initialize(this);
        if (xMLLogin.getDocumentPreservationPolicy().shouldPreserveDocument() && !this.hasDocumentPreservation) {
            this.hasDocumentPreservation = true;
        }
    }

    public boolean hasDocumentPreservation() {
        return this.hasDocumentPreservation;
    }

    public void applyORMMetadata(AbstractSession abstractSession) {
        for (ClassDescriptor classDescriptor : abstractSession.getDescriptors().values()) {
            Class clazz = classDescriptor.getJavaClass();
            AbstractSession abstractSession2 = null;
            try {
                abstractSession2 = this.getSession(clazz);
            }
            catch (XMLMarshalException xMLMarshalException) {
                // empty catch block
            }
            if (abstractSession2 == null) continue;
            ClassDescriptor classDescriptor2 = abstractSession2.getDescriptor(clazz);
            for (DatabaseMapping databaseMapping : classDescriptor.getMappings()) {
                DatabaseMapping databaseMapping2;
                ClassDescriptor classDescriptor3;
                DatabaseMapping databaseMapping3 = classDescriptor2.getMappingForAttributeName(databaseMapping.getAttributeName());
                if (databaseMapping3 == null) continue;
                AttributeAccessor attributeAccessor = databaseMapping3.getAttributeAccessor();
                OrmAttributeAccessor ormAttributeAccessor = new OrmAttributeAccessor(databaseMapping.getAttributeAccessor(), attributeAccessor);
                if (databaseMapping.isOneToOneMapping() && ((OneToOneMapping)databaseMapping).usesIndirection()) {
                    ormAttributeAccessor.setValueHolderProperty(true);
                }
                ormAttributeAccessor.setChangeTracking(classDescriptor.getObjectChangePolicy().isAttributeChangeTrackingPolicy());
                databaseMapping3.setAttributeAccessor(ormAttributeAccessor);
                AttributeAccessor attributeAccessor2 = null;
                Class clazz2 = null;
                if (databaseMapping3 instanceof XMLCompositeObjectMapping) {
                    attributeAccessor2 = ((XMLCompositeObjectMapping)databaseMapping3).getContainerAccessor();
                    clazz2 = ((XMLCompositeObjectMapping)databaseMapping3).getReferenceClass();
                } else if (databaseMapping3 instanceof XMLCompositeCollectionMapping) {
                    attributeAccessor2 = ((XMLCompositeCollectionMapping)databaseMapping3).getContainerAccessor();
                    clazz2 = ((XMLCompositeCollectionMapping)databaseMapping3).getReferenceClass();
                }
                if (attributeAccessor2 == null || (classDescriptor3 = abstractSession.getDescriptor(clazz2)) == null || (databaseMapping2 = classDescriptor3.getMappingForAttributeName(attributeAccessor2.getAttributeName())) == null) continue;
                OrmAttributeAccessor ormAttributeAccessor2 = new OrmAttributeAccessor(databaseMapping2.getAttributeAccessor(), attributeAccessor2);
                ormAttributeAccessor2.setChangeTracking(classDescriptor3.getObjectChangePolicy().isAttributeChangeTrackingPolicy());
                ormAttributeAccessor2.setValueHolderProperty(databaseMapping2 instanceof OneToOneMapping && ((OneToOneMapping)databaseMapping2).usesIndirection());
                if (databaseMapping3 instanceof XMLCompositeObjectMapping) {
                    ((XMLCompositeObjectMapping)databaseMapping3).setContainerAccessor(ormAttributeAccessor2);
                    continue;
                }
                if (!(databaseMapping3 instanceof XMLCompositeCollectionMapping)) continue;
                ((XMLCompositeCollectionMapping)databaseMapping3).setContainerAccessor(ormAttributeAccessor2);
            }
        }
    }
}

