/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.interceptors;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.IdentityMap;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.interceptors.CacheKeyInterceptor;

public abstract class CacheInterceptor
implements IdentityMap {
    protected IdentityMap targetIdentityMap;
    protected AbstractSession interceptedSession;

    public CacheInterceptor(IdentityMap identityMap, AbstractSession abstractSession) {
        this.targetIdentityMap = identityMap;
        this.interceptedSession = abstractSession;
    }

    public CacheKey acquireDeferredLock(Vector vector) {
        return this.createCacheKeyInterceptor(this.targetIdentityMap.acquireDeferredLock(vector));
    }

    public CacheKey acquireLock(Vector vector, boolean bl) {
        return this.createCacheKeyInterceptor(this.targetIdentityMap.acquireLock(vector, bl));
    }

    public CacheKey acquireLockNoWait(Vector vector, boolean bl) {
        CacheKey cacheKey = this.targetIdentityMap.acquireLockNoWait(vector, bl);
        if (cacheKey != null) {
            return this.createCacheKeyInterceptor(cacheKey);
        }
        return null;
    }

    public CacheKey acquireLockWithWait(Vector vector, boolean bl, int n) {
        CacheKey cacheKey = this.targetIdentityMap.acquireLockWithWait(vector, bl, n);
        if (cacheKey != null) {
            return this.createCacheKeyInterceptor(cacheKey);
        }
        return null;
    }

    public CacheKey acquireReadLockOnCacheKey(Vector vector) {
        return this.createCacheKeyInterceptor(this.targetIdentityMap.acquireReadLockOnCacheKey(vector));
    }

    public CacheKey acquireReadLockOnCacheKeyNoWait(Vector vector) {
        CacheKey cacheKey = this.targetIdentityMap.acquireReadLockOnCacheKeyNoWait(vector);
        if (cacheKey != null) {
            return this.createCacheKeyInterceptor(cacheKey);
        }
        return null;
    }

    public void collectLocks(HashMap hashMap) {
        this.targetIdentityMap.collectLocks(hashMap);
    }

    public abstract Object clone();

    public boolean containsKey(Vector vector) {
        return this.targetIdentityMap.containsKey(vector);
    }

    protected abstract CacheKeyInterceptor createCacheKeyInterceptor(CacheKey var1);

    public Enumeration elements() {
        return this.targetIdentityMap.elements();
    }

    public Object get(Vector vector) {
        return this.targetIdentityMap.get(vector);
    }

    public CacheKey getCacheKey(Vector vector) {
        return this.targetIdentityMap.getCacheKey(vector);
    }

    public CacheKey getCacheKeyForLock(Vector vector) {
        return this.targetIdentityMap.getCacheKeyForLock(vector);
    }

    public ClassDescriptor getDescriptor() {
        return this.targetIdentityMap.getDescriptor();
    }

    public Class getDescriptorClass() {
        return this.targetIdentityMap.getDescriptorClass();
    }

    public int getMaxSize() {
        return this.targetIdentityMap.getMaxSize();
    }

    public int getSize() {
        return this.targetIdentityMap.getSize();
    }

    public int getSize(Class clazz, boolean bl) {
        return this.targetIdentityMap.getSize(clazz, bl);
    }

    public IdentityMap getTargetIdenttyMap() {
        return this.targetIdentityMap;
    }

    public Object getWrapper(Vector vector) {
        return this.targetIdentityMap.getWrapper(vector);
    }

    public Object getWriteLockValue(Vector vector) {
        return this.targetIdentityMap.getWriteLockValue(vector);
    }

    public Enumeration keys() {
        return this.targetIdentityMap.keys();
    }

    public CacheKey put(Vector vector, Object object, Object object2, long l) {
        return this.targetIdentityMap.put(vector, object, object2, l);
    }

    public Object remove(Vector vector, Object object) {
        return this.targetIdentityMap.remove(vector, object);
    }

    public Object remove(CacheKey cacheKey) {
        if (cacheKey.isWrapper()) {
            return this.targetIdentityMap.remove(cacheKey.getWrappedCacheKey());
        }
        return this.targetIdentityMap.remove(cacheKey);
    }

    public void updateMaxSize(int n) {
        this.targetIdentityMap.updateMaxSize(n);
    }

    public void setDescriptor(ClassDescriptor classDescriptor) {
        this.targetIdentityMap.setDescriptor(classDescriptor);
    }

    public void setWrapper(Vector vector, Object object) {
        this.targetIdentityMap.setWrapper(vector, object);
    }

    public void setWriteLockValue(Vector vector, Object object) {
        this.targetIdentityMap.setWriteLockValue(vector, object);
    }

    public String toString() {
        return Helper.getShortClassName("Intercepted " + this.targetIdentityMap.getClass()) + "[" + this.getSize() + "]";
    }
}

