/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.server;

import org.eclipse.persistence.exceptions.ConcurrencyException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.server.ConnectionPool;
import org.eclipse.persistence.sessions.server.ServerSession;

public class ReadConnectionPool
extends ConnectionPool {
    public ReadConnectionPool() {
    }

    public ReadConnectionPool(String string, Login login, ServerSession serverSession) {
        super(string, login, serverSession);
    }

    public ReadConnectionPool(String string, Login login, int n, int n2, ServerSession serverSession) {
        super(string, login, n, n2, serverSession);
    }

    public ReadConnectionPool(String string, Login login, int n, int n2, int n3, ServerSession serverSession) {
        super(string, login, n, n2, n3, serverSession);
    }

    public synchronized Accessor acquireConnection() throws ConcurrencyException {
        Accessor accessor = null;
        int n = this.connectionsAvailable.size();
        for (int i = 0; i < n; ++i) {
            Accessor accessor2 = (Accessor)this.connectionsAvailable.get(i);
            if (this.checkConnections) {
                if (this.getOwner().getLogin().isConnectionHealthValidatedOnError() && this.getOwner().getServerPlatform().wasFailureCommunicationBased(null, accessor2, this.getOwner())) {
                    this.connectionsAvailable.remove(i);
                    --i;
                    --n;
                    continue;
                }
                this.checkConnections = false;
            }
            if (accessor2.getCallCount() == 0) {
                accessor2.incrementCallCount(this.getOwner());
                return accessor2;
            }
            if (accessor != null && accessor.getCallCount() <= accessor2.getCallCount()) continue;
            accessor = accessor2;
        }
        if (this.connectionsAvailable.size() + this.connectionsUsed.size() < this.maxNumberOfConnections) {
            Accessor accessor3 = this.buildConnection();
            this.connectionsAvailable.add(accessor3);
            accessor3.incrementCallCount(this.getOwner());
            return accessor3;
        }
        accessor.incrementCallCount(this.getOwner());
        return accessor;
    }

    public boolean hasConnectionAvailable() {
        return true;
    }

    public synchronized void releaseConnection(Accessor accessor) throws DatabaseException {
        accessor.decrementCallCount();
        if (!accessor.isValid()) {
            this.getOwner().setCheckConnections();
            this.connectionsAvailable.remove(accessor);
            try {
                accessor.disconnect(this.getOwner());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

