/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import java.io.File;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.jaxb.WrappedValue;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.jaxb.JAXBIntrospector;
import org.eclipse.persistence.jaxb.JAXBMarshalListener;
import org.eclipse.persistence.jaxb.attachment.AttachmentMarshallerAdapter;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLMarshalListener;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.attachment.XMLAttachmentMarshaller;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBMarshaller
implements Marshaller {
    private ValidationEventHandler validationEventHandler = new DefaultValidationEventHandler();
    private XMLMarshaller xmlMarshaller;
    public static final String XML_JAVATYPE_ADAPTERS = "xml-javatype-adapters";
    private static String STAX_RESULT_CLASS_NAME = "javax.xml.transform.stax.StAXResult";
    private HashMap<QName, Class> qNameToGeneratedClasses;

    public JAXBMarshaller(XMLMarshaller xMLMarshaller, JAXBIntrospector jAXBIntrospector) {
        this.xmlMarshaller = xMLMarshaller;
        this.xmlMarshaller.setEncoding("UTF-8");
        this.xmlMarshaller.setFormattedOutput(false);
        JAXBMarshalListener jAXBMarshalListener = new JAXBMarshalListener(this);
        this.xmlMarshaller.setMarshalListener((XMLMarshalListener)jAXBMarshalListener);
    }

    private XMLRoot createXMLRootFromJAXBElement(JAXBElement jAXBElement) {
        Class clazz;
        XMLRoot xMLRoot = new XMLRoot();
        xMLRoot.setObject(jAXBElement.getValue());
        QName qName = jAXBElement.getName();
        xMLRoot.setLocalName(qName.getLocalPart());
        xMLRoot.setNamespaceURI(qName.getNamespaceURI());
        if (jAXBElement.getDeclaredType() == ClassConstants.ABYTE || jAXBElement.getDeclaredType() == ClassConstants.APBYTE) {
            xMLRoot.setSchemaType(XMLConstants.BASE_64_BINARY_QNAME);
        } else {
            xMLRoot.setSchemaType((QName)XMLConversionManager.getDefaultJavaTypes().get(jAXBElement.getDeclaredType()));
        }
        if (this.qNameToGeneratedClasses != null && (clazz = this.qNameToGeneratedClasses.get(qName)) != null && WrappedValue.class.isAssignableFrom(clazz)) {
            ClassDescriptor classDescriptor = this.xmlMarshaller.getXMLContext().getSession(clazz).getDescriptor(clazz);
            Object object = classDescriptor.getInstantiationPolicy().buildNewInstance();
            ((WrappedValue)object).setWrappedValue(jAXBElement.getValue());
            xMLRoot.setObject(object);
        }
        return xMLRoot;
    }

    public XmlAdapter getAdapter(Class clazz) {
        HashMap hashMap = (HashMap)this.xmlMarshaller.getProperty((Object)XML_JAVATYPE_ADAPTERS);
        if (hashMap == null) {
            return null;
        }
        return (XmlAdapter)hashMap.get(clazz);
    }

    public AttachmentMarshaller getAttachmentMarshaller() {
        return ((AttachmentMarshallerAdapter)this.xmlMarshaller.getAttachmentMarshaller()).getAttachmentMarshaller();
    }

    public ValidationEventHandler getEventHandler() throws JAXBException {
        return this.validationEventHandler;
    }

    public Marshaller.Listener getListener() {
        return ((JAXBMarshalListener)this.xmlMarshaller.getMarshalListener()).getListener();
    }

    public Node getNode(Object object) throws JAXBException {
        throw new UnsupportedOperationException();
    }

    public Object getProperty(String string) throws PropertyException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if ("jaxb.formatted.output".equals(string)) {
            return new Boolean(this.xmlMarshaller.isFormattedOutput());
        }
        if ("jaxb.encoding".equals(string)) {
            return this.xmlMarshaller.getEncoding();
        }
        if ("jaxb.schemaLocation".equals(string)) {
            return this.xmlMarshaller.getSchemaLocation();
        }
        if ("jaxb.noNamespaceSchemaLocation".equals(string)) {
            return this.xmlMarshaller.getNoNamespaceSchemaLocation();
        }
        if ("jaxb.fragment".equals(string)) {
            return new Boolean(this.xmlMarshaller.isFragment());
        }
        throw new PropertyException("Unsupported Property");
    }

    public Schema getSchema() {
        try {
            return SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema();
        }
        catch (SAXException sAXException) {
            return null;
        }
    }

    public void marshal(Object object, ContentHandler contentHandler) throws JAXBException {
        if (object == null || contentHandler == null) {
            throw new IllegalArgumentException();
        }
        if (object instanceof JAXBElement) {
            object = this.createXMLRootFromJAXBElement((JAXBElement)object);
        }
        try {
            this.xmlMarshaller.marshal(object, contentHandler);
        }
        catch (Exception exception) {
            throw new MarshalException((Throwable)exception);
        }
    }

    public void marshal(Object object, XMLEventWriter xMLEventWriter) throws JAXBException {
        try {
            Class clazz = PrivilegedAccessHelper.getClassForName((String)STAX_RESULT_CLASS_NAME);
            Constructor constructor = PrivilegedAccessHelper.getDeclaredConstructorFor((Class)clazz, (Class[])new Class[]{XMLEventWriter.class}, (boolean)false);
            Result result = (Result)PrivilegedAccessHelper.invokeConstructor((Constructor)constructor, (Object[])new Object[]{xMLEventWriter});
            this.marshal(object, result);
        }
        catch (Exception exception) {
            throw new MarshalException((Throwable)exception);
        }
    }

    public void marshal(Object object, Node node) throws JAXBException {
        if (object == null || node == null) {
            throw new IllegalArgumentException();
        }
        if (object instanceof JAXBElement) {
            object = this.createXMLRootFromJAXBElement((JAXBElement)object);
        }
        try {
            this.xmlMarshaller.marshal(object, node);
        }
        catch (Exception exception) {
            throw new MarshalException((Throwable)exception);
        }
    }

    public void marshal(Object object, OutputStream outputStream) throws JAXBException {
        if (object == null || outputStream == null) {
            throw new IllegalArgumentException();
        }
        if (object instanceof JAXBElement) {
            object = this.createXMLRootFromJAXBElement((JAXBElement)object);
        }
        try {
            this.xmlMarshaller.marshal(object, outputStream);
        }
        catch (Exception exception) {
            throw new MarshalException((Throwable)exception);
        }
    }

    public void marshal(Object object, File file) throws JAXBException {
        try {
            FileWriter fileWriter = new FileWriter(file);
            this.marshal(object, fileWriter);
        }
        catch (Exception exception) {
            throw new MarshalException((Throwable)exception);
        }
    }

    public void marshal(Object object, Result result) throws JAXBException {
        if (object == null || result == null) {
            throw new IllegalArgumentException();
        }
        if (object instanceof JAXBElement) {
            object = this.createXMLRootFromJAXBElement((JAXBElement)object);
        }
        try {
            this.xmlMarshaller.marshal(object, result);
        }
        catch (Exception exception) {
            throw new MarshalException((Throwable)exception);
        }
    }

    public void marshal(Object object, XMLStreamWriter xMLStreamWriter) throws JAXBException {
        try {
            Class clazz = PrivilegedAccessHelper.getClassForName((String)STAX_RESULT_CLASS_NAME);
            Constructor constructor = PrivilegedAccessHelper.getDeclaredConstructorFor((Class)clazz, (Class[])new Class[]{XMLStreamWriter.class}, (boolean)false);
            Result result = (Result)PrivilegedAccessHelper.invokeConstructor((Constructor)constructor, (Object[])new Object[]{xMLStreamWriter});
            this.marshal(object, result);
        }
        catch (Exception exception) {
            throw new MarshalException((Throwable)exception);
        }
    }

    public void marshal(Object object, Writer writer) throws JAXBException {
        if (object == null || writer == null) {
            throw new IllegalArgumentException();
        }
        if (object instanceof JAXBElement) {
            object = this.createXMLRootFromJAXBElement((JAXBElement)object);
        }
        try {
            this.xmlMarshaller.marshal(object, writer);
        }
        catch (Exception exception) {
            throw new MarshalException((Throwable)exception);
        }
    }

    public void setAdapter(Class clazz, XmlAdapter xmlAdapter) {
        HashMap<Class, XmlAdapter> hashMap = (HashMap<Class, XmlAdapter>)this.xmlMarshaller.getProperty((Object)XML_JAVATYPE_ADAPTERS);
        if (hashMap == null) {
            hashMap = new HashMap<Class, XmlAdapter>();
            this.xmlMarshaller.getProperties().put(XML_JAVATYPE_ADAPTERS, hashMap);
        }
        hashMap.put(clazz, xmlAdapter);
    }

    public void setAdapter(XmlAdapter xmlAdapter) {
        this.setAdapter(xmlAdapter.getClass(), xmlAdapter);
    }

    public void setAttachmentMarshaller(AttachmentMarshaller attachmentMarshaller) {
        this.xmlMarshaller.setAttachmentMarshaller((XMLAttachmentMarshaller)new AttachmentMarshallerAdapter(attachmentMarshaller));
    }

    public void setEventHandler(ValidationEventHandler validationEventHandler) throws JAXBException {
        this.validationEventHandler = null == validationEventHandler ? new DefaultValidationEventHandler() : validationEventHandler;
    }

    public void setListener(Marshaller.Listener listener) {
        ((JAXBMarshalListener)this.xmlMarshaller.getMarshalListener()).setListener(listener);
    }

    public void setMarshalCallbacks(HashMap hashMap) {
        ((JAXBMarshalListener)this.xmlMarshaller.getMarshalListener()).setClassBasedMarshalEvents(hashMap);
    }

    public void setProperty(String string, Object object) throws PropertyException {
        block8: {
            try {
                if (string == null) {
                    throw new IllegalArgumentException();
                }
                if ("jaxb.formatted.output".equals(string)) {
                    Boolean bl = (Boolean)object;
                    this.xmlMarshaller.setFormattedOutput(bl.booleanValue());
                    break block8;
                }
                if ("jaxb.encoding".equals(string)) {
                    this.xmlMarshaller.setEncoding((String)object);
                    break block8;
                }
                if ("jaxb.schemaLocation".equals(string)) {
                    this.xmlMarshaller.setSchemaLocation((String)object);
                    break block8;
                }
                if ("jaxb.noNamespaceSchemaLocation".equals(string)) {
                    this.xmlMarshaller.setNoNamespaceSchemaLocation((String)object);
                    break block8;
                }
                if ("jaxb.fragment".equals(string)) {
                    Boolean bl = (Boolean)object;
                    this.xmlMarshaller.setFragment(bl.booleanValue());
                    break block8;
                }
                throw new PropertyException(string, object);
            }
            catch (ClassCastException classCastException) {
                throw new PropertyException(string, (Throwable)classCastException);
            }
        }
    }

    public void setSchema(Schema schema) {
    }

    public void setQNameToGeneratedClasses(HashMap<QName, Class> hashMap) {
        this.qNameToGeneratedClasses = hashMap;
    }
}

