/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.descriptors.Namespace;
import org.eclipse.persistence.internal.oxm.schema.model.All;
import org.eclipse.persistence.internal.oxm.schema.model.Any;
import org.eclipse.persistence.internal.oxm.schema.model.AnyAttribute;
import org.eclipse.persistence.internal.oxm.schema.model.Attribute;
import org.eclipse.persistence.internal.oxm.schema.model.Choice;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexContent;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexType;
import org.eclipse.persistence.internal.oxm.schema.model.Element;
import org.eclipse.persistence.internal.oxm.schema.model.Extension;
import org.eclipse.persistence.internal.oxm.schema.model.Import;
import org.eclipse.persistence.internal.oxm.schema.model.List;
import org.eclipse.persistence.internal.oxm.schema.model.Restriction;
import org.eclipse.persistence.internal.oxm.schema.model.Schema;
import org.eclipse.persistence.internal.oxm.schema.model.Sequence;
import org.eclipse.persistence.internal.oxm.schema.model.SimpleContent;
import org.eclipse.persistence.internal.oxm.schema.model.SimpleType;
import org.eclipse.persistence.internal.oxm.schema.model.TypeDefParticle;
import org.eclipse.persistence.jaxb.compiler.AnyProperty;
import org.eclipse.persistence.jaxb.compiler.ChoiceProperty;
import org.eclipse.persistence.jaxb.compiler.ElementDeclaration;
import org.eclipse.persistence.jaxb.compiler.EnumTypeInfo;
import org.eclipse.persistence.jaxb.compiler.NamespaceInfo;
import org.eclipse.persistence.jaxb.compiler.Property;
import org.eclipse.persistence.jaxb.compiler.ReferenceProperty;
import org.eclipse.persistence.jaxb.compiler.SchemaTypeInfo;
import org.eclipse.persistence.jaxb.compiler.TypeInfo;
import org.eclipse.persistence.jaxb.javamodel.Helper;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaGenerator {
    private HashMap<String, Schema> schemaForNamespace;
    private Schema schema;
    private int schemaCount;
    private Helper helper;
    private HashMap<String, TypeInfo> typeInfo;
    private HashMap<String, NamespaceInfo> packageToNamespaceMappings;
    private HashMap<String, SchemaTypeInfo> schemaTypeInfo;
    private HashMap<String, QName> userDefinedSchemaTypes;

    public SchemaGenerator(Helper helper) {
        this.helper = helper;
    }

    public Schema generateSchema(ArrayList<JavaClass> arrayList, HashMap<String, TypeInfo> hashMap, HashMap<String, QName> hashMap2, HashMap<String, NamespaceInfo> hashMap3, HashMap<QName, ElementDeclaration> hashMap4) {
        this.typeInfo = hashMap;
        this.userDefinedSchemaTypes = hashMap2;
        this.packageToNamespaceMappings = hashMap3;
        this.schemaCount = 0;
        this.schemaTypeInfo = new HashMap(hashMap.size());
        for (JavaClass javaClass : arrayList) {
            this.addSchemaComponents(javaClass);
        }
        this.populateSchemaTypes();
        if (hashMap4 != null) {
            this.addGlobalElements(hashMap4);
        }
        return this.schema;
    }

    public void addSchemaComponents(JavaClass javaClass) {
        Object object;
        Object object2;
        Object object3;
        XmlRootElement xmlRootElement;
        String string = javaClass.getQualifiedName();
        Element element = null;
        TypeInfo typeInfo = this.typeInfo.get(string);
        if (typeInfo.isTransient()) {
            return;
        }
        SchemaTypeInfo schemaTypeInfo = new SchemaTypeInfo();
        schemaTypeInfo.setSchemaTypeName(new QName(typeInfo.getClassNamespace(), typeInfo.getSchemaTypeName()));
        this.schemaTypeInfo.put(javaClass.getQualifiedName(), schemaTypeInfo);
        NamespaceInfo namespaceInfo = this.packageToNamespaceMappings.get(javaClass.getPackage().getQualifiedName());
        if (namespaceInfo.getLocation() != null) {
            return;
        }
        Schema schema = this.getSchemaForNamespace(typeInfo.getClassNamespace());
        typeInfo.setSchema(schema);
        String string2 = typeInfo.getSchemaTypeName();
        String[] stringArray = typeInfo.getPropOrder();
        String string3 = "";
        Property property = null;
        if (this.helper.isAnnotationPresent(javaClass, XmlRootElement.class)) {
            int n;
            char c;
            xmlRootElement = (XmlRootElement)this.helper.getAnnotation(javaClass, XmlRootElement.class);
            element = new Element();
            object3 = xmlRootElement.name();
            if ((((String)object3).equals("##default") || ((String)object3).equals("")) && ((String)(object3 = string.indexOf("$") != -1 ? Introspector.decapitalize(string.substring(string.lastIndexOf(36) + 1)) : Introspector.decapitalize(string.substring(string.lastIndexOf(46) + 1)))).length() >= 3 && Character.isDigit(c = ((String)object3).charAt((n = ((String)object3).length() - 1) - 1))) {
                char c2 = Character.toUpperCase(((String)object3).charAt(n));
                object3 = ((String)object3).substring(0, n) + c2;
            }
            element.setName((String)object3);
            object2 = xmlRootElement.namespace();
            if (((String)object2).equals("##default")) {
                object = this.getSchemaForNamespace(namespaceInfo.getNamespace());
                if (object != null) {
                    object.addTopLevelElement(element);
                }
                schemaTypeInfo.getGlobalElementDeclarations().add(new QName(namespaceInfo.getNamespace(), (String)object2));
                object2 = namespaceInfo.getNamespace();
            } else {
                object = this.getSchemaForNamespace((String)object2);
                if (object != null) {
                    object.addTopLevelElement(element);
                }
                schemaTypeInfo.getGlobalElementDeclarations().add(new QName((String)object2, (String)object3));
            }
            object = this.getSchemaForNamespace((String)object2);
            this.addImportIfRequired((Schema)object, schema, schema.getTargetNamespace());
            if (object != null && !typeInfo.getClassNamespace().equals("")) {
                string3 = this.getPrefixForNamespace(typeInfo.getClassNamespace(), object.getNamespaceResolver());
                if (string3 == null) {
                    string3 = object.getNamespaceResolver().generatePrefix();
                    object.getNamespaceResolver().put(string3, typeInfo.getClassNamespace());
                }
                string3 = string3 + ":";
            }
        }
        xmlRootElement = typeInfo.getPropertyNames();
        if (typeInfo.isEnumerationType() || xmlRootElement.size() == 1 && this.helper.isAnnotationPresent(typeInfo.getProperties().get(xmlRootElement.get(0)).getElement(), XmlValue.class)) {
            object3 = new SimpleType();
            if (string2.equals("")) {
                if (element != null) {
                    element.setSimpleType((SimpleType)object3);
                }
            } else {
                object3.setName(string2);
                schema.addTopLevelSimpleTypes((SimpleType)object3);
                if (element != null) {
                    element.setType(string3 + object3.getName());
                }
            }
            object2 = null;
            object = new Restriction();
            if (typeInfo.isEnumerationType()) {
                object2 = ((EnumTypeInfo)typeInfo).getRestrictionBase();
                object.setEnumerationFacets(this.getEnumerationFacetsFor((EnumTypeInfo)typeInfo));
                object.setBaseType("xsd:" + ((QName)object2).getLocalPart());
                object3.setRestriction((Restriction)object);
            } else {
                property = typeInfo.getProperties().get(xmlRootElement.get(0));
                QName qName = null;
                qName = property.getType().isArray() ? this.getSchemaTypeFor(property.getType().getComponentType()) : (property.getGenericType() != null ? this.getSchemaTypeFor(property.getGenericType()) : this.getSchemaTypeFor(property.getType()));
                String string4 = null;
                if (qName.getNamespaceURI() != null && !qName.getNamespaceURI().equals("")) {
                    string4 = qName.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") ? "xsd" : this.getPrefixForNamespace(qName.getNamespaceURI(), schema.getNamespaceResolver());
                }
                String string5 = qName.getLocalPart();
                if (string4 != null) {
                    string5 = string4 + ":" + string5;
                }
                if (this.helper.isAnnotationPresent(property.getElement(), XmlList.class) || this.isCollectionType(property)) {
                    List list = new List();
                    list.setItemType(string5);
                    object3.setList(list);
                } else {
                    if (this.helper.isAnnotationPresent(property.getElement(), XmlSchemaType.class)) {
                        XmlSchemaType xmlSchemaType = (XmlSchemaType)this.helper.getAnnotation(property.getElement(), XmlSchemaType.class);
                        qName = new QName(xmlSchemaType.namespace(), xmlSchemaType.name());
                    }
                    object.setBaseType(string5);
                    object3.setRestriction((Restriction)object);
                }
            }
            typeInfo.setSimpleType((SimpleType)object3);
        } else {
            property = this.getXmlValueFieldForSimpleContent(typeInfo.getPropertyList());
            if (property != null) {
                object3 = new ComplexType();
                object2 = new SimpleContent();
                if (string2.equals("")) {
                    if (element != null) {
                        element.setComplexType((ComplexType)object3);
                    }
                    typeInfo.setComplexType((ComplexType)object3);
                } else {
                    object3.setName(string2);
                    schema.addTopLevelComplexTypes((ComplexType)object3);
                    if (element != null) {
                        element.setType(string3 + object3.getName());
                    }
                }
                object = this.getSchemaTypeFor(property.getType());
                if (this.helper.isAnnotationPresent(property.getElement(), XmlSchemaType.class)) {
                    XmlSchemaType xmlSchemaType = (XmlSchemaType)this.helper.getAnnotation(property.getElement(), XmlSchemaType.class);
                    object = new QName(xmlSchemaType.namespace(), xmlSchemaType.name());
                }
                String string6 = null;
                if (((QName)object).getNamespaceURI() != null && !((QName)object).getNamespaceURI().equals("")) {
                    string6 = ((QName)object).getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") ? "xsd" : this.getPrefixForNamespace(((QName)object).getNamespaceURI(), schema.getNamespaceResolver());
                }
                String string7 = ((QName)object).getLocalPart();
                if (string6 != null) {
                    string7 = string6 + ":" + string7;
                }
                Extension extension = new Extension();
                extension.setBaseType(string7);
                object2.setExtension(extension);
                object3.setSimpleContent((SimpleContent)object2);
                typeInfo.setComplexType((ComplexType)object3);
            } else {
                Object object4;
                object3 = new ComplexType();
                object2 = javaClass.getSuperclass();
                if (typeInfo.isMixed()) {
                    object3.setMixed(true);
                }
                if (javaClass.isAbstract()) {
                    object3.setAbstractValue(true);
                }
                object = this.typeInfo.get(object2.getQualifiedName());
                Extension extension = null;
                if (object != null) {
                    extension = new Extension();
                    object4 = this.getPrefixForNamespace(((TypeInfo)object).getClassNamespace(), schema.getNamespaceResolver());
                    if (object4 != null) {
                        extension.setBaseType((String)object4 + ":" + ((TypeInfo)object).getSchemaTypeName());
                    } else {
                        extension.setBaseType(((TypeInfo)object).getSchemaTypeName());
                    }
                    ComplexContent complexContent = new ComplexContent();
                    complexContent.setExtension(extension);
                    object3.setComplexContent(complexContent);
                }
                object4 = null;
                if (stringArray.length == 0) {
                    if (typeInfo.hasElementRefs()) {
                        object4 = new Sequence();
                        if (extension != null) {
                            extension.setSequence(object4);
                        } else {
                            object3.setSequence(object4);
                        }
                    } else if (extension != null) {
                        object4 = new All();
                        extension.setAll((All)object4);
                    } else {
                        object4 = new All();
                        object3.setAll((All)object4);
                    }
                } else {
                    object4 = new Sequence();
                    if (extension != null) {
                        extension.setSequence(object4);
                    } else {
                        object3.setSequence(object4);
                    }
                }
                if (string2.equals("")) {
                    if (element != null) {
                        element.setComplexType((ComplexType)object3);
                    }
                    typeInfo.setComplexType((ComplexType)object3);
                    typeInfo.setCompositor((TypeDefParticle)object4);
                } else {
                    object3.setName(string2);
                    if (element != null) {
                        element.setType(string3 + object3.getName());
                    }
                    schema.addTopLevelComplexTypes((ComplexType)object3);
                    typeInfo.setComplexType((ComplexType)object3);
                    typeInfo.setCompositor((TypeDefParticle)object4);
                }
                typeInfo.setPropOrder(stringArray);
            }
        }
    }

    public void addToSchemaType(ArrayList<Property> arrayList, TypeDefParticle typeDefParticle, ComplexType complexType, Schema schema) {
        for (Property property : arrayList) {
            String string;
            JavaClass javaClass;
            String string2;
            Object object;
            Object object2;
            Object object4;
            Object object5;
            java.util.List<ElementDeclaration> list;
            Object object6;
            if (property == null) continue;
            TypeDefParticle object7 = typeDefParticle;
            boolean bl = object7 instanceof Choice;
            Object object8 = complexType;
            if (this.helper.isAnnotationPresent(property.getElement(), XmlTransient.class)) continue;
            if (!bl && this.helper.isAnnotationPresent(property.getElement(), XmlElementWrapper.class)) {
                object6 = (XmlElementWrapper)this.helper.getAnnotation(property.getElement(), XmlElementWrapper.class);
                list = new Element();
                object5 = object6.name();
                if (((String)object5).equals("##default")) {
                    object5 = property.getPropertyName();
                }
                list.setName((String)object5);
                list.setMinOccurs("0");
                typeDefParticle.addElement((Element)list);
                object4 = new ComplexType();
                Sequence sequence = new Sequence();
                object4.setSequence(sequence);
                list.setComplexType((ComplexType)object4);
                object8 = object4;
                object7 = sequence;
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlAttribute.class)) {
                Object object3;
                object6 = new Attribute();
                list = property.getSchemaName();
                object6.setName(((QName)((Object)list)).getLocalPart());
                if (property.isRequired()) {
                    object6.setUse("required");
                }
                object5 = property.getType();
                if (property.getGenericType() != null) {
                    object5 = property.getGenericType();
                }
                object4 = null;
                TypeInfo typeInfo = this.typeInfo.get(property.getType().getQualifiedName());
                if (typeInfo != null) {
                    if (!typeInfo.isComplexType()) {
                        object4 = typeInfo.getSimpleType().getName();
                    }
                } else if (this.helper.isAnnotationPresent(property.getElement(), XmlID.class)) {
                    object4 = "xsd:ID";
                } else if (this.helper.isAnnotationPresent(property.getElement(), XmlIDREF.class)) {
                    object4 = "xsd:IDREF";
                } else {
                    object2 = property.getSchemaType();
                    if (object2 == null) {
                        object2 = this.getSchemaTypeFor((JavaClass)object5);
                    }
                    object4 = object2 != null ? "xsd:" + ((QName)object2).getLocalPart() : "xsd:anySimpleType";
                }
                if (this.isCollectionType(property)) {
                    object2 = new SimpleType();
                    object3 = new List();
                    object3.setItemType((String)object4);
                    object2.setList((List)object3);
                    object6.setSimpleType((SimpleType)object2);
                } else {
                    if (object4 != null && !((String)object4).contains(":") && typeInfo.getSchema() == schema && (object2 = this.getPrefixForNamespace(schema.getTargetNamespace(), schema.getNamespaceResolver())) != null) {
                        object4 = (String)object2 + ":" + (String)object4;
                    }
                    object6.setType((String)object4);
                }
                object2 = schema.getTargetNamespace();
                if (object2 == null) {
                    object2 = "";
                }
                object3 = this.getNamespaceInfoForNamespace((String)object2);
                boolean bl2 = true;
                if (object3 != null) {
                    bl2 = ((NamespaceInfo)object3).isAttributeFormQualified();
                }
                if (bl2 && !((QName)((Object)list)).getNamespaceURI().equals(object2) || !((NamespaceInfo)object3).isAttributeFormQualified() && !((QName)((Object)list)).getNamespaceURI().equals("")) {
                    object = this.getSchemaForNamespace(((QName)((Object)list)).getNamespaceURI());
                    if (object != null && object.getTopLevelAttributes().get(object6.getName()) == null) {
                        object.getTopLevelAttributes().put(object6.getName(), object6);
                    }
                    this.addImportIfRequired(schema, (Schema)object, ((QName)((Object)list)).getNamespaceURI());
                    Attribute attribute = new Attribute();
                    string2 = this.getPrefixForNamespace(((QName)((Object)list)).getNamespaceURI(), schema.getNamespaceResolver());
                    if (string2 == null) {
                        attribute.setRef(object6.getName());
                    } else {
                        attribute.setRef(string2 + ":" + object6.getName());
                    }
                    if (object8.getSimpleContent() != null) {
                        object8.getSimpleContent().getExtension().getOrderedAttributes().add(attribute);
                        continue;
                    }
                    object8.getOrderedAttributes().add(attribute);
                    continue;
                }
                if (object8.getSimpleContent() != null) {
                    object8.getSimpleContent().getExtension().getOrderedAttributes().add(object6);
                    continue;
                }
                if (object8.getComplexContent() != null) {
                    object8.getComplexContent().getExtension().getOrderedAttributes().add(object6);
                    continue;
                }
                object8.getOrderedAttributes().add(object6);
                continue;
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlAnyAttribute.class)) {
                object6 = new AnyAttribute();
                object6.setProcessContents("lax");
                if (complexType.getSimpleContent() != null) {
                    list = complexType.getSimpleContent();
                    list.getRestriction().setAnyAttribute((AnyAttribute)object6);
                    continue;
                }
                complexType.setAnyAttribute((AnyAttribute)object6);
                continue;
            }
            if (property.isChoice()) {
                object6 = new Choice();
                list = (ArrayList)((ChoiceProperty)property).getChoiceProperties();
                this.addToSchemaType((ArrayList<Property>)list, (TypeDefParticle)object6, (ComplexType)object8, schema);
                if (this.isCollectionType(property)) {
                    object6.setMaxOccurs("unbounded");
                }
                if (object7 instanceof Sequence) {
                    ((Sequence)object7).addChoice((Choice)object6);
                    continue;
                }
                if (!(object7 instanceof Choice)) continue;
                ((Choice)object7).addChoice((Choice)object6);
                continue;
            }
            if (property.isAny()) {
                object6 = new Any();
                object6.setNamespace("##other");
                list = (AnyProperty)property;
                if (((AnyProperty)((Object)list)).isLax()) {
                    object6.setProcessContents("lax");
                } else {
                    object6.setProcessContents("skip");
                }
                if (object7 instanceof Sequence) {
                    ((Sequence)object7).addAny((Any)object6);
                    continue;
                }
                if (!(object7 instanceof Choice)) continue;
                ((Choice)object7).addAny((Any)object6);
                continue;
            }
            if (property.isReference()) {
                object6 = (ReferenceProperty)property;
                list = ((ReferenceProperty)object6).getReferencedElements();
                if (list.size() == 1) {
                    object5 = new Element();
                    object4 = (ElementDeclaration)list.get(0);
                    String string3 = ((ElementDeclaration)object4).getElementName().getLocalPart();
                    object2 = this.getSchemaForNamespace(((ElementDeclaration)object4).getElementName().getNamespaceURI());
                    this.addImportIfRequired(schema, (Schema)object2, ((ElementDeclaration)object4).getElementName().getNamespaceURI());
                    String string4 = this.getPrefixForNamespace(((ElementDeclaration)object4).getElementName().getNamespaceURI(), schema.getNamespaceResolver());
                    if (string4 == null || string4.equals("")) {
                        object5.setRef(string3);
                    } else {
                        object5.setRef(string4 + ":" + string3);
                    }
                    if (this.isCollectionType(property)) {
                        object5.setMaxOccurs("unbounded");
                    }
                    object7.addElement((Element)object5);
                    continue;
                }
                object5 = new Choice();
                if (this.isCollectionType(property)) {
                    object5.setMaxOccurs("unbounded");
                }
                for (ElementDeclaration elementDeclaration : list) {
                    object2 = new Element();
                    String string5 = elementDeclaration.getElementName().getLocalPart();
                    Schema schema2 = this.getSchemaForNamespace(elementDeclaration.getElementName().getNamespaceURI());
                    this.addImportIfRequired(schema, schema2, elementDeclaration.getElementName().getNamespaceURI());
                    object = this.getPrefixForNamespace(elementDeclaration.getElementName().getNamespaceURI(), schema.getNamespaceResolver());
                    if (object == null || ((String)object).equals("")) {
                        object2.setRef(string5);
                    } else {
                        object2.setRef((String)object + ":" + string5);
                    }
                    object5.addElement((Element)object2);
                }
                if (object7 instanceof Sequence) {
                    ((Sequence)object7).addChoice((Choice)object5);
                    continue;
                }
                if (!(object7 instanceof Choice)) continue;
                ((Choice)object7).addChoice((Choice)object5);
                continue;
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlValue.class)) continue;
            object6 = new Element();
            if (!(object7 instanceof All)) {
                object6.setMinOccurs(property.isRequired() ? "1" : "0");
            }
            list = property.getSchemaName();
            object5 = property.getType();
            boolean bl3 = this.isCollectionType(property);
            if (bl3 && (javaClass = property.getGenericType()) != null && object5.hasActualTypeArguments()) {
                object2 = object5.getActualTypeArguments().toArray();
                object5 = (JavaClass)object2[0];
            }
            object6.setName(((QName)((Object)list)).getLocalPart());
            TypeInfo typeInfo = this.typeInfo.get(object5.getQualifiedName());
            object2 = null;
            boolean bl4 = false;
            if (typeInfo != null) {
                String string6;
                if (this.helper.isAnnotationPresent(property.getElement(), XmlID.class)) {
                    object2 = "xsd:ID";
                } else if (this.helper.isAnnotationPresent(property.getElement(), XmlIDREF.class)) {
                    object2 = "xsd:IDREF";
                } else {
                    bl4 = typeInfo.isComplexType();
                    object2 = typeInfo.isComplexType() ? typeInfo.getComplexType().getName() : (typeInfo.getSimpleType() != null ? typeInfo.getSimpleType().getName() : typeInfo.getSchemaTypeName());
                }
                if (object2 == null && !typeInfo.hasRootElement()) {
                    if (typeInfo.isComplexType()) {
                        object6.setComplexType(typeInfo.getComplexType());
                    } else {
                        object6.setSimpleType(typeInfo.getSimpleType());
                    }
                }
                if (this.addImportIfRequired(schema, typeInfo.getSchema(), typeInfo.getClassNamespace()) && (string6 = schema.getNamespaceResolver().resolveNamespaceURI(typeInfo.getClassNamespace())) != null && !((String)object2).equals("")) {
                    object2 = string6 + ":" + (String)object2;
                }
            } else if (this.helper.isAnnotationPresent(property.getElement(), XmlID.class)) {
                object2 = "xsd:ID";
            } else {
                QName qName = property.getSchemaType();
                if (qName == null) {
                    qName = this.getSchemaTypeFor((JavaClass)object5);
                }
                if (qName != null) {
                    object2 = "xsd:" + qName.getLocalPart();
                }
            }
            if (object2 != null && !((String)object2).contains(":") && typeInfo.getSchema() == schema && (string = this.getPrefixForNamespace(schema.getTargetNamespace(), schema.getNamespaceResolver())) != null) {
                object2 = string + ":" + (String)object2;
            }
            if (bl3) {
                if (this.helper.isAnnotationPresent(property.getElement(), XmlList.class)) {
                    if (bl4) {
                        // empty if block
                    }
                    SimpleType simpleType = new SimpleType();
                    object = new List();
                    object.setItemType((String)object2);
                    simpleType.setList((List)object);
                    object6.setSimpleType(simpleType);
                } else {
                    object6.setMaxOccurs("unbounded");
                    object6.setType((String)object2);
                }
            } else {
                object6.setType((String)object2);
            }
            String string7 = schema.getTargetNamespace();
            if (string7 == null) {
                string7 = "";
            }
            object = this.getNamespaceInfoForNamespace(string7);
            boolean bl5 = false;
            if (object != null) {
                bl5 = ((NamespaceInfo)object).isElementFormQualified();
            }
            if (bl5 && !((QName)((Object)list)).getNamespaceURI().equals(string7) || !bl5 && !((QName)((Object)list)).getNamespaceURI().equals("")) {
                string2 = new Element();
                string2.setMinOccurs(object6.getMinOccurs());
                string2.setMaxOccurs(object6.getMaxOccurs());
                Schema schema3 = this.getSchemaForNamespace(((QName)((Object)list)).getNamespaceURI());
                if (schema3 != null && schema3.getTopLevelElements().get(object6.getName()) == null) {
                    object6.setMinOccurs(null);
                    object6.setMaxOccurs(null);
                    schema3.getTopLevelElements().put(object6.getName(), object6);
                }
                this.addImportIfRequired(schema, schema3, ((QName)((Object)list)).getNamespaceURI());
                String string8 = this.getPrefixForNamespace(((QName)((Object)list)).getNamespaceURI(), schema.getNamespaceResolver());
                if (string8 == null) {
                    string2.setRef(object6.getName());
                } else {
                    string2.setRef(string8 + ":" + object6.getName());
                }
                object7.addElement((Element)string2);
                continue;
            }
            object7.addElement((Element)object6);
        }
    }

    public QName getSchemaTypeFor(JavaClass javaClass) {
        TypeInfo typeInfo;
        QName qName = this.userDefinedSchemaTypes.get(javaClass.getQualifiedName());
        if (qName == null) {
            qName = (QName)this.helper.getXMLToJavaTypeMap().get(javaClass.getRawName());
        }
        if (qName == null && (typeInfo = this.typeInfo.get(javaClass.getQualifiedName())) != null) {
            qName = new QName(typeInfo.getClassNamespace(), typeInfo.getSchemaTypeName());
        }
        if (qName == null) {
            return XMLConstants.ANY_SIMPLE_TYPE_QNAME;
        }
        return qName;
    }

    public void populateSchemaTypes() {
        for (String string : this.typeInfo.keySet()) {
            TypeInfo typeInfo = this.typeInfo.get(string);
            if (!typeInfo.isComplexType() || typeInfo.getSchema() == null) continue;
            ComplexType complexType = typeInfo.getComplexType();
            TypeDefParticle typeDefParticle = typeInfo.getCompositor();
            String[] stringArray = typeInfo.getPropOrder();
            if (stringArray.length == 0 || stringArray[0].equals("")) {
                stringArray = typeInfo.getPropertyNames().toArray(new String[typeInfo.getPropertyNames().size()]);
            }
            ArrayList<Property> arrayList = new ArrayList<Property>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                Property property = typeInfo.getProperties().get(stringArray[i]);
                arrayList.add(property);
            }
            this.addToSchemaType(arrayList, typeDefParticle, complexType, typeInfo.getSchema());
        }
    }

    public String getSchemaTypeNameForClassName(String string) {
        String string2 = Introspector.decapitalize(string.substring(string.lastIndexOf(46) + 1));
        return string2;
    }

    public ArrayList<String> getEnumerationFacetsFor(EnumTypeInfo enumTypeInfo) {
        return (ArrayList)enumTypeInfo.getFieldValues();
    }

    public Property getXmlValueFieldForSimpleContent(ArrayList<Property> arrayList) {
        boolean bl = false;
        boolean bl2 = false;
        Property property = null;
        for (Property property2 : arrayList) {
            if (this.helper.isAnnotationPresent(property2.getElement(), XmlValue.class)) {
                bl = true;
                property = property2;
                continue;
            }
            if (this.helper.isAnnotationPresent(property2.getElement(), XmlAttribute.class) || this.helper.isAnnotationPresent(property2.getElement(), XmlTransient.class) || this.helper.isAnnotationPresent(property2.getElement(), XmlAnyAttribute.class)) continue;
            bl2 = true;
        }
        if (bl && !bl2) {
            return property;
        }
        return null;
    }

    public boolean isCollectionType(Property property) {
        JavaClass javaClass = property.getType();
        return this.helper.getJavaClass(Collection.class).isAssignableFrom(javaClass) || this.helper.getJavaClass(java.util.List.class).isAssignableFrom(javaClass) || this.helper.getJavaClass(Set.class).isAssignableFrom(javaClass) || javaClass.isArray();
    }

    private Schema getSchemaForNamespace(String string) {
        Schema schema;
        if (this.schemaForNamespace == null) {
            this.schemaForNamespace = new HashMap();
        }
        if ((schema = this.schemaForNamespace.get(string)) == null) {
            Object object;
            NamespaceInfo namespaceInfo = this.getNamespaceInfoForNamespace(string);
            schema = new Schema();
            schema.setName("schema" + this.schemaCount + ".xsd");
            if (namespaceInfo != null) {
                if (namespaceInfo.getLocation() != null) {
                    return null;
                }
                object = namespaceInfo.getNamespaceResolver().getNamespaces();
                for (int i = 0; i < ((Vector)object).size(); ++i) {
                    Namespace namespace = (Namespace)((Vector)object).get(i);
                    schema.getNamespaceResolver().put(namespace.getPrefix(), namespace.getNamespaceURI());
                }
            }
            ++this.schemaCount;
            if (!string.equals("")) {
                schema.setTargetNamespace(string);
                object = null;
                if (namespaceInfo != null) {
                    object = namespaceInfo.getNamespaceResolver().resolveNamespaceURI(string);
                }
                if (object == null) {
                    object = schema.getNamespaceResolver().generatePrefix();
                }
                schema.getNamespaceResolver().put((String)object, string);
            }
            if (namespaceInfo != null) {
                schema.setAttributeFormDefault(namespaceInfo.isAttributeFormQualified());
                schema.setElementFormDefault(namespaceInfo.isElementFormQualified());
            }
            this.schemaForNamespace.put(string, schema);
        }
        return schema;
    }

    public Collection<Schema> getAllSchemas() {
        if (this.schemaForNamespace == null) {
            this.schemaForNamespace = new HashMap();
        }
        return this.schemaForNamespace.values();
    }

    public NamespaceInfo getNamespaceInfoForNamespace(String string) {
        Collection<NamespaceInfo> collection = this.packageToNamespaceMappings.values();
        for (NamespaceInfo namespaceInfo : collection) {
            if (!namespaceInfo.getNamespace().equals(string)) continue;
            return namespaceInfo;
        }
        return null;
    }

    public String getPrefixForNamespace(String string, NamespaceResolver namespaceResolver) {
        Enumeration enumeration = namespaceResolver.getPrefixes();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = namespaceResolver.resolveNamespacePrefix(string2);
            if (!string3.equals(string)) continue;
            return string2;
        }
        return null;
    }

    public void addGlobalElements(HashMap<QName, ElementDeclaration> hashMap) {
        QName qName;
        String string;
        Schema schema;
        Iterator<QName> iterator = hashMap.keySet().iterator();
        while (iterator.hasNext() && (schema = this.getSchemaForNamespace(string = (qName = iterator.next()).getNamespaceURI())) != null) {
            String string2;
            String string3;
            Object object;
            if (schema.getTopLevelElements().get(qName.getLocalPart()) != null) continue;
            Element element = new Element();
            element.setName(qName.getLocalPart());
            ElementDeclaration elementDeclaration = hashMap.get(qName);
            JavaClass javaClass = this.helper.getJavaClass(elementDeclaration.getJavaTypeName());
            QName qName2 = (QName)this.helper.getXMLToJavaTypeMap().get(javaClass.getRawName());
            if (qName2 != null) {
                element.setType("xsd:" + qName2.getLocalPart());
            } else {
                object = this.typeInfo.get(javaClass.getQualifiedName());
                if (object != null) {
                    string3 = null;
                    string3 = ((TypeInfo)object).isComplexType() ? ((TypeInfo)object).getComplexType().getName() : ((TypeInfo)object).getSimpleType().getName();
                    if (((TypeInfo)object).getClassNamespace().equals(string)) {
                        element.setType(string3);
                    } else {
                        string2 = this.getSchemaForNamespace(((TypeInfo)object).getClassNamespace());
                        String string4 = ((TypeInfo)object).getClassNamespace();
                        if (string4 == null) {
                            string4 = "";
                        }
                        this.addImportIfRequired(schema, (Schema)string2, ((TypeInfo)object).getClassNamespace());
                        String string5 = schema.getNamespaceResolver().resolveNamespaceURI(string4);
                        if (string5 != null) {
                            element.setType(string5 + ":" + string3);
                        } else {
                            element.setType(string3);
                        }
                    }
                }
            }
            if (elementDeclaration.getSubstitutionHead() != null) {
                object = elementDeclaration.getSubstitutionHead().getLocalPart();
                string3 = elementDeclaration.getSubstitutionHead().getNamespaceURI();
                string2 = this.getPrefixForNamespace(string3, schema.getNamespaceResolver());
                if (string2 == null || string2.equals("")) {
                    element.setSubstitutionGroup((String)object);
                } else {
                    element.setSubstitutionGroup(string2 + ":" + (String)object);
                }
            }
            schema.addTopLevelElement(element);
            object = this.schemaTypeInfo.get(javaClass.getQualifiedName());
            if (object == null) {
                object = new SchemaTypeInfo();
                ((SchemaTypeInfo)object).setSchemaTypeName(qName2);
                this.schemaTypeInfo.put(javaClass.getQualifiedName(), (SchemaTypeInfo)object);
            }
            ((SchemaTypeInfo)object).getGlobalElementDeclarations().add(qName);
        }
    }

    public HashMap<String, SchemaTypeInfo> getSchemaTypeInfo() {
        return this.schemaTypeInfo;
    }

    private boolean importExists(Schema schema, String string) {
        java.util.List list = schema.getImports();
        for (int i = 0; i < list.size(); ++i) {
            Import import_ = (Import)list.get(i);
            if (import_.getSchemaLocation() == null || !import_.getSchemaLocation().equals(string)) continue;
            return true;
        }
        return false;
    }

    private boolean addImportIfRequired(Schema schema, Schema schema2, String string) {
        if (schema2 != schema) {
            NamespaceInfo namespaceInfo;
            String string2 = null;
            if (schema2 != null) {
                string2 = schema2.getName();
            } else if (string != null) {
                namespaceInfo = this.getNamespaceInfoForNamespace(string);
                string2 = namespaceInfo.getLocation();
            }
            if (string2 != null && !this.importExists(schema, string2)) {
                String string3;
                namespaceInfo = new Import();
                namespaceInfo.setSchemaLocation(string2);
                namespaceInfo.setNamespace(string);
                schema.getImports().add(namespaceInfo);
                if (namespaceInfo.getNamespace() != null && (string3 = schema.getNamespaceResolver().resolveNamespaceURI(string)) == null && !string.equals("")) {
                    schema.getNamespaceResolver().put(schema.getNamespaceResolver().generatePrefix(), string);
                }
                return true;
            }
        }
        return false;
    }
}

