/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.javamodel.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.persistence.jaxb.javamodel.JavaAnnotation;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaConstructor;
import org.eclipse.persistence.jaxb.javamodel.JavaField;
import org.eclipse.persistence.jaxb.javamodel.JavaMethod;
import org.eclipse.persistence.jaxb.javamodel.JavaPackage;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaAnnotationImpl;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaConstructorImpl;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaFieldImpl;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaMethodImpl;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaPackageImpl;

public class JavaClassImpl
implements JavaClass {
    protected ParameterizedType jType;
    protected Class jClass;

    public JavaClassImpl(Class clazz) {
        this.jClass = clazz;
    }

    public JavaClassImpl(ParameterizedType parameterizedType, Class clazz) {
        this.jType = parameterizedType;
        this.jClass = clazz;
    }

    public Collection getActualTypeArguments() {
        ArrayList<JavaClassImpl> arrayList = new ArrayList<JavaClassImpl>();
        if (this.jType instanceof ParameterizedType) {
            Type[] typeArray;
            ParameterizedType parameterizedType = this.jType;
            for (Type type : typeArray = parameterizedType.getActualTypeArguments()) {
                Object object;
                if (type instanceof ParameterizedType) {
                    object = (Type[])type;
                    arrayList.add(new JavaClassImpl((ParameterizedType)object, (Class)object.getRawType()));
                    continue;
                }
                if (type instanceof WildcardType) {
                    Type type2;
                    object = ((WildcardType)type).getUpperBounds();
                    if (((Type[])object).length <= 0 || !((type2 = object[0]) instanceof Class)) continue;
                    arrayList.add(new JavaClassImpl((Class)type2));
                    continue;
                }
                if (type instanceof Class) {
                    arrayList.add(new JavaClassImpl((Class)type));
                    continue;
                }
                if (!(type instanceof GenericArrayType)) continue;
                object = (Class)((GenericArrayType)type).getGenericComponentType();
                object = Array.newInstance(object, 0).getClass();
                arrayList.add(new JavaClassImpl((Class)object));
            }
        }
        return arrayList;
    }

    public String toString() {
        return this.getName();
    }

    public JavaAnnotation getAnnotation(JavaClass javaClass) {
        Class clazz;
        if (javaClass != null && this.jClass.isAnnotationPresent(clazz = ((JavaClassImpl)javaClass).getJavaClass())) {
            return new JavaAnnotationImpl((Annotation)this.jClass.getAnnotation(clazz));
        }
        return null;
    }

    public Collection getAnnotations() {
        Annotation[] annotationArray;
        ArrayList<JavaAnnotationImpl> arrayList = new ArrayList<JavaAnnotationImpl>();
        for (Annotation annotation : annotationArray = this.jClass.getAnnotations()) {
            arrayList.add(new JavaAnnotationImpl(annotation));
        }
        return arrayList;
    }

    public Collection getDeclaredClasses() {
        Class<?>[] classArray;
        ArrayList<JavaClassImpl> arrayList = new ArrayList<JavaClassImpl>();
        for (Class<?> clazz : classArray = this.jClass.getDeclaredClasses()) {
            arrayList.add(new JavaClassImpl(clazz));
        }
        return arrayList;
    }

    public JavaField getDeclaredField(String string) {
        try {
            return new JavaFieldImpl(this.jClass.getDeclaredField(string));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    public Collection getDeclaredFields() {
        Field[] fieldArray;
        ArrayList<JavaFieldImpl> arrayList = new ArrayList<JavaFieldImpl>();
        for (Field field : fieldArray = this.jClass.getDeclaredFields()) {
            arrayList.add(new JavaFieldImpl(field));
        }
        return arrayList;
    }

    public JavaMethod getDeclaredMethod(String string, JavaClass[] javaClassArray) {
        if (javaClassArray == null) {
            javaClassArray = new JavaClass[]{};
        }
        Class[] classArray = new Class[javaClassArray.length];
        for (int i = 0; i < javaClassArray.length; ++i) {
            JavaClass javaClass = javaClassArray[i];
            if (javaClass == null) continue;
            classArray[i] = ((JavaClassImpl)javaClass).getJavaClass();
        }
        try {
            return new JavaMethodImpl(this.jClass.getDeclaredMethod(string, classArray));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public Collection getDeclaredMethods() {
        Method[] methodArray;
        ArrayList<JavaMethodImpl> arrayList = new ArrayList<JavaMethodImpl>();
        for (Method method : methodArray = this.jClass.getDeclaredMethods()) {
            arrayList.add(new JavaMethodImpl(method));
        }
        return arrayList;
    }

    public JavaConstructor getConstructor(JavaClass[] javaClassArray) {
        if (javaClassArray == null) {
            javaClassArray = new JavaClass[]{};
        }
        Class[] classArray = new Class[javaClassArray.length];
        for (int i = 0; i < javaClassArray.length; ++i) {
            JavaClass javaClass = javaClassArray[i];
            if (javaClass == null) continue;
            classArray[i] = ((JavaClassImpl)javaClass).getJavaClass();
        }
        try {
            return new JavaConstructorImpl(this.jClass.getConstructor(classArray));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public JavaConstructor getDeclaredConstructor(JavaClass[] javaClassArray) {
        if (javaClassArray == null) {
            javaClassArray = new JavaClass[]{};
        }
        Class[] classArray = new Class[javaClassArray.length];
        for (int i = 0; i < javaClassArray.length; ++i) {
            JavaClass javaClass = javaClassArray[i];
            if (javaClass == null) continue;
            classArray[i] = ((JavaClassImpl)javaClass).getJavaClass();
        }
        try {
            return new JavaConstructorImpl(this.jClass.getDeclaredConstructor(classArray));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public Collection getConstructors() {
        Constructor<?>[] constructorArray = this.jClass.getConstructors();
        ArrayList<JavaConstructorImpl> arrayList = new ArrayList<JavaConstructorImpl>(constructorArray.length);
        for (Constructor<?> constructor : constructorArray) {
            arrayList.add(new JavaConstructorImpl(constructor));
        }
        return arrayList;
    }

    public Collection getDeclaredConstructors() {
        Constructor<?>[] constructorArray = this.jClass.getDeclaredConstructors();
        ArrayList<JavaConstructorImpl> arrayList = new ArrayList<JavaConstructorImpl>(constructorArray.length);
        for (Constructor<?> constructor : constructorArray) {
            arrayList.add(new JavaConstructorImpl(constructor));
        }
        return arrayList;
    }

    public JavaField getField(String string) {
        try {
            return new JavaFieldImpl(this.jClass.getField(string));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    public Collection getFields() {
        Field[] fieldArray;
        ArrayList<JavaFieldImpl> arrayList = new ArrayList<JavaFieldImpl>();
        for (Field field : fieldArray = this.jClass.getFields()) {
            arrayList.add(new JavaFieldImpl(field));
        }
        return arrayList;
    }

    public Class getJavaClass() {
        return this.jClass;
    }

    public JavaMethod getMethod(String string, JavaClass[] javaClassArray) {
        if (javaClassArray == null) {
            javaClassArray = new JavaClass[]{};
        }
        Class[] classArray = new Class[javaClassArray.length];
        for (int i = 0; i < javaClassArray.length; ++i) {
            JavaClass javaClass = javaClassArray[i];
            if (javaClass == null) continue;
            classArray[i] = ((JavaClassImpl)javaClass).getJavaClass();
        }
        try {
            return new JavaMethodImpl(this.jClass.getMethod(string, classArray));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public Collection getMethods() {
        Method[] methodArray;
        ArrayList<JavaMethodImpl> arrayList = new ArrayList<JavaMethodImpl>();
        for (Method method : methodArray = this.jClass.getMethods()) {
            arrayList.add(new JavaMethodImpl(method));
        }
        return arrayList;
    }

    public String getName() {
        return this.jClass.getName();
    }

    public JavaPackage getPackage() {
        return new JavaPackageImpl(this.jClass.getPackage());
    }

    public String getPackageName() {
        if (this.jClass.getPackage() != null) {
            return this.jClass.getPackage().getName();
        }
        return null;
    }

    public String getQualifiedName() {
        return this.jClass.getName();
    }

    public String getRawName() {
        return this.jClass.getCanonicalName();
    }

    public JavaClass getSuperclass() {
        return new JavaClassImpl(this.jClass.getSuperclass());
    }

    public boolean hasActualTypeArguments() {
        ParameterizedType parameterizedType;
        return this.jType instanceof ParameterizedType && (parameterizedType = this.jType).getActualTypeArguments() != null && parameterizedType.getActualTypeArguments().length > 0;
    }

    public JavaClass getOwningClass() {
        return new JavaClassImpl(this.jClass.getEnclosingClass());
    }

    public boolean isAnnotation() {
        return this.jClass.isAnnotation();
    }

    public boolean isArray() {
        return this.jClass.isArray();
    }

    public boolean isAssignableFrom(JavaClass javaClass) {
        return this.jClass.isAssignableFrom(((JavaClassImpl)javaClass).getJavaClass());
    }

    public boolean isEnum() {
        return this.jClass.isEnum();
    }

    public boolean isInterface() {
        return this.jClass.isInterface();
    }

    public boolean isMemberClass() {
        return this.jClass.isMemberClass();
    }

    public boolean isPrimitive() {
        return this.jClass.isPrimitive();
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.getModifiers());
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.getModifiers());
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    public int getModifiers() {
        return this.jClass.getModifiers();
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.getModifiers());
    }

    public boolean isSynthetic() {
        return this.jClass.isSynthetic();
    }

    public JavaClass getComponentType() {
        if (!this.isArray()) {
            return null;
        }
        return new JavaClassImpl(this.jClass.getComponentType());
    }

    public JavaAnnotation getDeclaredAnnotation(JavaClass javaClass) {
        return null;
    }

    public Collection getDeclaredAnnotations() {
        return null;
    }
}

