/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.equinox.weaving;

import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.hooks.ClassLoadingHook;
import org.eclipse.osgi.baseadaptor.loader.BaseClassLoader;
import org.eclipse.osgi.baseadaptor.loader.ClasspathEntry;
import org.eclipse.osgi.baseadaptor.loader.ClasspathManager;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.persistence.jpa.equinox.weaving.IWeaver;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class WeaverRegistry
implements ClassLoadingHook,
ServiceTrackerCustomizer {
    private static WeaverRegistry instance = new WeaverRegistry();
    private List<ServiceReference> weaverServices = new ArrayList<ServiceReference>();
    private BundleContext ctx;
    private ServiceTracker serviceTracker;

    private WeaverRegistry() {
    }

    public static WeaverRegistry getInstance() {
        return instance;
    }

    public boolean addClassPathEntry(ArrayList arrayList, String string, ClasspathManager classpathManager, BaseData baseData, ProtectionDomain protectionDomain) {
        return false;
    }

    public BaseClassLoader createClassLoader(ClassLoader classLoader, ClassLoaderDelegate classLoaderDelegate, BundleProtectionDomain bundleProtectionDomain, BaseData baseData, String[] stringArray) {
        return null;
    }

    public String findLibrary(BaseData baseData, String string) {
        return null;
    }

    public ClassLoader getBundleClassLoaderParent() {
        return null;
    }

    public void initializedClassLoader(BaseClassLoader baseClassLoader, BaseData baseData) {
    }

    public byte[] processClass(String string, byte[] byArray, ClasspathEntry classpathEntry, BundleEntry bundleEntry, ClasspathManager classpathManager) {
        if (this.weaverServices.isEmpty()) {
            return null;
        }
        for (ServiceReference serviceReference : this.weaverServices) {
            byte[] byArray2;
            IWeaver iWeaver = (IWeaver)this.ctx.getService(serviceReference);
            if (iWeaver == null || (byArray2 = iWeaver.transform(string, byArray)) == null) continue;
            System.out.println(string + " woven");
            return byArray2;
        }
        return null;
    }

    public void start(BundleContext bundleContext) {
        this.ctx = bundleContext;
        this.serviceTracker = new ServiceTracker(bundleContext, IWeaver.class.getName(), (ServiceTrackerCustomizer)this);
        this.serviceTracker.open();
    }

    public void stop(BundleContext bundleContext) {
        this.serviceTracker.close();
        this.serviceTracker = null;
        this.weaverServices = new ArrayList<ServiceReference>();
    }

    public Object addingService(ServiceReference serviceReference) {
        System.out.println("Registering Service " + serviceReference);
        this.weaverServices.add(serviceReference);
        return serviceReference;
    }

    public void modifiedService(ServiceReference serviceReference, Object object) {
        this.removedService(serviceReference, object);
    }

    public void removedService(ServiceReference serviceReference, Object object) {
        this.weaverServices.remove(serviceReference);
    }
}

