/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import commonj.sdo.helper.HelperContext;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.persistence.internal.libraries.asm.ClassWriter;
import org.eclipse.persistence.internal.libraries.asm.CodeVisitor;
import org.eclipse.persistence.internal.libraries.asm.Type;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.helper.SDOXMLHelper;
import org.eclipse.persistence.sdo.helper.extension.SDOUtil;

public class DynamicClassWriter {
    private static final String START_PROPERTY_INDEX = "START_PROPERTY_INDEX";
    private static final String END_PROPERTY_INDEX = "END_PROPERTY_INDEX";
    private static final String GET = "get";
    private static final String SET = "set";
    private static final String LIST = "List";
    private static final String WRITE_REPLACE = "writeReplace";
    private Class parentClass;
    private String typeImplClassDescriptor;
    private SDOType type;
    private Integer startPropertyIndex;
    private HelperContext aHelperContext;

    public DynamicClassWriter(String string, SDOType sDOType, HelperContext helperContext) {
        this.aHelperContext = helperContext;
        this.parentClass = SDODataObject.class;
        this.typeImplClassDescriptor = string.replace('.', '/');
        this.type = sDOType;
        this.initializeParentClass();
        if (sDOType.isSubType()) {
            try {
                Field field = PrivilegedAccessHelper.getField((Class)this.parentClass, (String)END_PROPERTY_INDEX, (boolean)true);
                Integer n = (Integer)PrivilegedAccessHelper.getValueFromField((Field)field, (Object)this.parentClass);
                this.startPropertyIndex = n + 1;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                this.startPropertyIndex = new Integer(0);
            }
            catch (IllegalAccessException illegalAccessException) {
                this.startPropertyIndex = new Integer(0);
            }
        } else {
            this.startPropertyIndex = new Integer(0);
        }
    }

    private void initializeParentClass() {
        if (this.type.isSubType()) {
            SDOType sDOType = (SDOType)this.type.getBaseTypes().get(0);
            String string = sDOType.getInstanceClassName() + "Impl";
            try {
                this.parentClass = ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).getLoader().loadClass(string, sDOType);
            }
            catch (Exception exception) {
                this.parentClass = null;
            }
            if (this.parentClass == null) {
                this.parentClass = SDODataObject.class;
            }
        } else {
            this.parentClass = SDODataObject.class;
        }
    }

    public Class getParentClass() {
        return this.parentClass;
    }

    public byte[] createClass() {
        ClassWriter classWriter = new ClassWriter(false);
        if (null == this.type.getInstanceClass()) {
            classWriter.visit(49, 33, this.typeImplClassDescriptor, Type.getType((Class)this.parentClass).getInternalName(), null, null);
        } else {
            String[] stringArray = new String[]{this.type.getInstanceClassName().replace('.', '/')};
            classWriter.visit(49, 33, this.typeImplClassDescriptor, Type.getType((Class)this.parentClass).getInternalName(), stringArray, null);
            this.addPropertyIndices(classWriter);
            for (Object e : this.type.getDeclaredProperties()) {
                SDOProperty sDOProperty = (SDOProperty)e;
                this.addPropertyGetMethod(classWriter, sDOProperty);
                this.addPropertySetMethod(classWriter, sDOProperty);
            }
        }
        this.addConstructors(classWriter);
        this.addWriteReplace(classWriter);
        classWriter.visitEnd();
        return classWriter.toByteArray();
    }

    private void addPropertyIndices(ClassWriter classWriter) {
        classWriter.visitField(25, START_PROPERTY_INDEX, "I", (Object)this.startPropertyIndex, null);
        int n = this.type.getDeclaredProperties().size();
        Integer n2 = n > 0 ? Integer.valueOf(this.startPropertyIndex + n - 2) : Integer.valueOf(this.startPropertyIndex - 1);
        classWriter.visitField(25, END_PROPERTY_INDEX, "I", (Object)n2, null);
    }

    private void addConstructors(ClassWriter classWriter) {
        CodeVisitor codeVisitor = classWriter.visitMethod(1, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), new String[]{Type.getInternalName(Serializable.class)}, null);
        codeVisitor.visitVarInsn(25, 0);
        codeVisitor.visitMethodInsn(183, Type.getType((Class)this.parentClass).getInternalName(), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]));
        codeVisitor.visitInsn(177);
        codeVisitor.visitMaxs(1, 1);
    }

    private void addPropertyGetMethod(ClassWriter classWriter, SDOProperty sDOProperty) {
        String string = SDOUtil.getJavaTypeForProperty(sDOProperty);
        String string2 = SDOUtil.getMethodName(sDOProperty.getName(), string);
        String string3 = sDOProperty.isMany() ? Type.getDescriptor(List.class) : (sDOProperty.getType().isDataType() ? Type.getDescriptor((Class)sDOProperty.getType().getInstanceClass()) : "L" + string.replace('.', '/') + ";");
        CodeVisitor codeVisitor = classWriter.visitMethod(1, string2, "()" + string3, null, null);
        codeVisitor.visitVarInsn(25, 0);
        codeVisitor.visitIntInsn(16, this.startPropertyIndex + sDOProperty.getIndexInType());
        String string4 = SDOUtil.getBuiltInType(string);
        if (null != string4) {
            if (sDOProperty.getType().isDataType() && !string4.equals(LIST)) {
                codeVisitor.visitMethodInsn(182, this.typeImplClassDescriptor, GET + string4, "(I)" + string3);
                int n = Type.getType((Class)sDOProperty.getType().getInstanceClass()).getOpcode(172);
                codeVisitor.visitInsn(n);
            } else {
                codeVisitor.visitMethodInsn(182, this.typeImplClassDescriptor, GET, "(I)Ljava/lang/Object;");
                codeVisitor.visitInsn(176);
            }
        } else {
            codeVisitor.visitMethodInsn(182, this.typeImplClassDescriptor, GET, "(I)Ljava/lang/Object;");
            codeVisitor.visitInsn(176);
        }
        codeVisitor.visitMaxs(2, 1);
    }

    private void addPropertySetMethod(ClassWriter classWriter, SDOProperty sDOProperty) {
        String string = SDOUtil.getJavaTypeForProperty(sDOProperty);
        String string2 = SDOUtil.setMethodName(sDOProperty.getName());
        String string3 = sDOProperty.isMany() ? Type.getDescriptor(List.class) : (sDOProperty.getType().isDataType() ? Type.getDescriptor((Class)sDOProperty.getType().getInstanceClass()) : "L" + string.replace('.', '/') + ";");
        CodeVisitor codeVisitor = classWriter.visitMethod(1, string2, "(" + string3 + ")V", null, null);
        codeVisitor.visitVarInsn(25, 0);
        codeVisitor.visitIntInsn(16, this.startPropertyIndex + sDOProperty.getIndexInType());
        String string4 = SDOUtil.getBuiltInType(string);
        int n = 25;
        if (null != string4) {
            if (sDOProperty.getType().isDataType() && !string4.equals(LIST)) {
                n = Type.getType((Class)sDOProperty.getType().getInstanceClass()).getOpcode(21);
                codeVisitor.visitVarInsn(n, 1);
                codeVisitor.visitMethodInsn(182, this.typeImplClassDescriptor, SET + string4, "(I" + string3 + ")V");
            } else {
                codeVisitor.visitVarInsn(n, 1);
                codeVisitor.visitMethodInsn(182, this.typeImplClassDescriptor, SET, "(ILjava/lang/Object;)V");
            }
        } else {
            codeVisitor.visitVarInsn(n, 1);
            codeVisitor.visitMethodInsn(182, this.typeImplClassDescriptor, SET, "(ILjava/lang/Object;)V");
        }
        codeVisitor.visitInsn(177);
        if (n == 24 || n == 22) {
            codeVisitor.visitMaxs(4, 3);
        } else {
            codeVisitor.visitMaxs(3, 2);
        }
    }

    private void addWriteReplace(ClassWriter classWriter) {
        Method method;
        try {
            method = this.parentClass.getDeclaredMethod(WRITE_REPLACE, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return;
        }
        CodeVisitor codeVisitor = classWriter.visitMethod(4, method.getName(), Type.getMethodDescriptor((Method)method), new String[]{Type.getInternalName(ObjectStreamException.class)}, null);
        codeVisitor.visitVarInsn(25, 0);
        codeVisitor.visitMethodInsn(183, Type.getInternalName((Class)this.parentClass), method.getName(), Type.getMethodDescriptor((Method)method));
        codeVisitor.visitInsn(176);
        codeVisitor.visitMaxs(1, 1);
    }
}

