/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper.delegates;

import commonj.sdo.DataObject;
import commonj.sdo.Type;
import commonj.sdo.helper.HelperContext;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.helper.SDOClassLoader;
import org.eclipse.persistence.sdo.helper.SDODataFactory;
import org.eclipse.persistence.sdo.helper.SDOTypeHelper;
import org.eclipse.persistence.sdo.helper.SDOXMLHelper;

public class SDODataFactoryDelegate
implements SDODataFactory {
    private HelperContext aHelperContext;

    public SDODataFactoryDelegate(HelperContext helperContext) {
        this.aHelperContext = helperContext;
    }

    public DataObject create(String string, String string2) {
        Type type = this.getHelperContext().getTypeHelper().getType(string, string2);
        if (type != null) {
            return this.create(type);
        }
        throw new IllegalArgumentException((Throwable)SDOException.typeNotFound((String)string, (String)string2));
    }

    public DataObject create(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException((Throwable)SDOException.cannotPerformOperationWithNullInputParameter((String)"create", (String)"interfaceClass"));
        }
        Type type = this.getHelperContext().getTypeHelper().getType(clazz);
        if (type != null) {
            return this.create(type);
        }
        SDOXMLHelper sDOXMLHelper = (SDOXMLHelper)this.getHelperContext().getXMLHelper();
        SDOClassLoader sDOClassLoader = sDOXMLHelper.getLoader();
        ClassLoader classLoader = clazz.getClassLoader();
        ClassLoader classLoader2 = sDOClassLoader;
        boolean bl = false;
        while (classLoader2 != null && !bl) {
            if (classLoader2 == classLoader) {
                bl = true;
            }
            classLoader2 = sDOClassLoader.getParent();
        }
        throw new IllegalArgumentException((Throwable)SDOException.typeNotFoundForInterface((String)clazz.getName(), (boolean)bl));
    }

    public DataObject create(Type type) {
        Object object;
        if (type == null) {
            throw new IllegalArgumentException((Throwable)SDOException.cannotPerformOperationWithNullInputParameter((String)"create", (String)"type"));
        }
        if (type.isAbstract()) {
            throw new IllegalArgumentException((Throwable)SDOException.errorCreatingDataObjectForType((String)type.getURI(), (String)type.getName()));
        }
        if (type.isDataType()) {
            object = (SDOTypeHelper)this.getHelperContext().getTypeHelper();
            type = (SDOType)object.getWrappersHashMap().get(((SDOType)type).getQName());
        }
        try {
            object = ((SDOType)type).getImplClass();
            if (object != null) {
                SDODataObject sDODataObject = (SDODataObject)((Class)object).newInstance();
                sDODataObject._setType(type);
                sDODataObject._setHelperContext(this.getHelperContext());
                return sDODataObject;
            }
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException((Throwable)SDOException.errorCreatingDataObjectForClass((Exception)instantiationException, (String)((SDOType)type).getInstanceClassName(), (String)type.getURI(), (String)type.getName()));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException((Throwable)SDOException.errorCreatingDataObjectForClass((Exception)illegalAccessException, (String)((SDOType)type).getInstanceClassName(), (String)type.getURI(), (String)type.getName()));
        }
        SDODataObject sDODataObject = new SDODataObject();
        sDODataObject._setType(type);
        sDODataObject._setHelperContext(this.getHelperContext());
        return sDODataObject;
    }

    public HelperContext getHelperContext() {
        return this.aHelperContext;
    }

    public void setHelperContext(HelperContext helperContext) {
        this.aHelperContext = helperContext;
    }
}

