/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper.jaxb;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.helper.jaxb.JAXBHelperContext;
import org.eclipse.persistence.sdo.helper.jaxb.JAXBValueStore;

public class JAXBList
implements List {
    private JAXBValueStore jaxbValueStore;
    private SDOProperty property;
    private ContainerPolicy containerPolicy;
    private AbstractSession session;

    public JAXBList(JAXBValueStore jAXBValueStore, SDOProperty sDOProperty) {
        this.jaxbValueStore = jAXBValueStore;
        this.property = sDOProperty;
        JAXBContext jAXBContext = (JAXBContext)this.jaxbValueStore.getJAXBHelperContext().getJAXBContext();
        this.session = jAXBContext.getXMLContext().getSession(jAXBValueStore.getEntity().getClass());
        DatabaseMapping databaseMapping = jAXBValueStore.getJAXBMappingForProperty(this.property);
        this.containerPolicy = databaseMapping.getContainerPolicy();
    }

    void setValueStore(JAXBValueStore jAXBValueStore) {
        this.jaxbValueStore = jAXBValueStore;
    }

    public void add(int n, Object object) {
        Object object2 = this.getContainer();
        if (object2 instanceof List) {
            List list = (List)object2;
            if (!this.property.getType().isDataType()) {
                JAXBHelperContext jAXBHelperContext = this.jaxbValueStore.getJAXBHelperContext();
                Object object3 = jAXBHelperContext.unwrap((DataObject)object);
                jAXBHelperContext.putWrapperDataObject(object3, (SDODataObject)object);
                list.add(n, object3);
            } else {
                list.add(n, object);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public boolean add(Object object) {
        if (!this.property.getType().isDataType()) {
            object = this.jaxbValueStore.getJAXBHelperContext().unwrap((DataObject)object);
        }
        return this.containerPolicy.addInto(object, this.getContainer(), this.session);
    }

    public boolean addAll(Collection collection) {
        boolean bl = false;
        for (Object e : collection) {
            bl = this.add(e) || bl;
        }
        return bl;
    }

    public boolean addAll(int n, Collection list) {
        Object object = this.getContainer();
        if (object instanceof List) {
            List list2 = (List)object;
            if (!this.property.getType().isDataType()) {
                list = this.jaxbValueStore.getJAXBHelperContext().unwrap((Collection<DataObject>)list);
            }
            return list2.addAll(n, list);
        }
        throw new UnsupportedOperationException();
    }

    public void clear() {
        this.containerPolicy.clear(this.getContainer());
    }

    public boolean contains(Object object) {
        if (!this.property.getType().isDataType()) {
            object = this.jaxbValueStore.getJAXBHelperContext().unwrap((DataObject)object);
        }
        return this.containerPolicy.contains(object, this.getContainer(), this.session);
    }

    public boolean containsAll(Collection collection) {
        for (Object object : collection) {
            if (!this.property.getType().isDataType()) {
                object = this.jaxbValueStore.getJAXBHelperContext().unwrap((DataObject)object);
            }
            if (this.contains(object)) continue;
            return false;
        }
        return true;
    }

    public Object get(int n) {
        return this.getList().get(n);
    }

    public int indexOf(Object object) {
        return this.getList().indexOf(object);
    }

    public boolean isEmpty() {
        return this.containerPolicy.isEmpty(this.getContainer());
    }

    public Iterator iterator() {
        return this.getList().iterator();
    }

    public int lastIndexOf(Object object) {
        return this.getList().lastIndexOf(object);
    }

    public ListIterator listIterator() {
        return this.getList().listIterator();
    }

    public ListIterator listIterator(int n) {
        return this.getList().listIterator(n);
    }

    public Object remove(int n) {
        Object object = this.getContainer();
        if (object instanceof List) {
            List list = (List)object;
            return list.remove(n);
        }
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object object) {
        if (!this.property.getType().isDataType()) {
            object = this.jaxbValueStore.getJAXBHelperContext().unwrap((DataObject)object);
        }
        return this.containerPolicy.removeFrom(object, this.getContainer(), this.session);
    }

    public boolean removeAll(Collection collection) {
        boolean bl = false;
        for (Object e : collection) {
            bl = this.remove(e) || bl;
        }
        return bl;
    }

    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public Object set(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    public int size() {
        return this.containerPolicy.sizeFor(this.getContainer());
    }

    public List subList(int n, int n2) {
        return this.getList().subList(n, n2);
    }

    public Object[] toArray() {
        return this.getList().toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.getList().toArray(objectArray);
    }

    private Object getContainer() {
        DatabaseMapping databaseMapping = this.jaxbValueStore.getJAXBMappingForProperty(this.property);
        Object object = databaseMapping.getAttributeValueFromObject(this.jaxbValueStore.getEntity());
        if (null == object) {
            object = this.containerPolicy.containerInstance();
            databaseMapping.setAttributeValueInObject(this.jaxbValueStore.getEntity(), object);
        }
        return object;
    }

    private List getList() {
        List list = this.containerPolicy.isListPolicy() ? (List)this.getContainer() : this.containerPolicy.vectorFor(this.getContainer(), this.session);
        if (this.property.getType().isDataType()) {
            return list;
        }
        if (this.property.isContainment()) {
            return this.jaxbValueStore.getJAXBHelperContext().wrap(list, (Property)this.property, (DataObject)this.jaxbValueStore.getDataObject());
        }
        return this.jaxbValueStore.getJAXBHelperContext().wrap(list);
    }
}

