/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper.metadata;

import org.eclipse.persistence.mappings.foundation.AbstractTransformationMapping;
import org.eclipse.persistence.mappings.transformers.AttributeTransformer;
import org.eclipse.persistence.mappings.transformers.FieldTransformer;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.sessions.Record;
import org.eclipse.persistence.sessions.Session;

public class QNameTransformer
implements AttributeTransformer,
FieldTransformer {
    private static final char COLON = ':';
    private static final char HASH = '#';
    public static final String QNAME_NAMESPACE_PREFIX = "qns";
    private static final String DEFAULT_NAMESPACE_PREFIX = "";
    AbstractTransformationMapping transformationMapping;
    private NamespaceResolver namespaceResolver;
    private String xPath;

    public QNameTransformer(String string) {
        this.xPath = string;
    }

    public void initialize(AbstractTransformationMapping abstractTransformationMapping) {
        this.transformationMapping = abstractTransformationMapping;
        this.namespaceResolver = ((XMLDescriptor)abstractTransformationMapping.getDescriptor()).getNamespaceResolver();
    }

    public Object buildAttributeValue(Record record, Object object, Session session) {
        if (null == record) {
            return null;
        }
        String string = (String)record.get((Object)this.xPath);
        if (null == string) {
            return null;
        }
        int n = string.lastIndexOf(58);
        if (n > -1) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            String string4 = ((XMLRecord)record).resolveNamespacePrefix(string2);
            if (string4 != null) {
                return string4 + '#' + string3;
            }
            return string3;
        }
        String string5 = ((XMLRecord)record).resolveNamespacePrefix(DEFAULT_NAMESPACE_PREFIX);
        if (string5 != null) {
            return string5 + '#' + string;
        }
        return string;
    }

    public Object buildFieldValue(Object object, String string, Session session) {
        if (null == object) {
            return null;
        }
        String string2 = (String)this.transformationMapping.getAttributeValueFromObject(object);
        int n = string2.lastIndexOf(35);
        if (n > -1) {
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            String string5 = this.namespaceResolver.resolveNamespaceURI(string3);
            if (string5 == null) {
                if (string3.equals(this.namespaceResolver.getDefaultNamespaceURI())) {
                    return string4;
                }
                string5 = QNAME_NAMESPACE_PREFIX;
            }
            return string5 + ':' + string4;
        }
        return string2;
    }
}

