/*******************************************************************************
 * Copyright (c) 1998, 2009 Oracle. All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the 
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0 
 * which accompanies this distribution. 
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at 
 * http://www.eclipse.org/org/documents/edl-v10.php.
 * 
 * The API for this class and its comments are derived from the JPA 2.0 specification 
 * which is developed under the Java Community Process (JSR 317) and is copyright 
 * Sun Microsystems, Inc. 
 *
 * Contributors:
 *     dclarke - Java Persistence 2.0 - Proposed Final Draft (March 13, 2009)
 *               Specification and licensing terms available from
 *               http://jcp.org/en/jsr/detail?id=317
 *
 * EARLY ACCESS - PUBLIC DRAFT
 * This is an implementation of an early-draft specification developed under the 
 * Java Community Process (JCP) and is made available for testing and evaluation 
 * purposes only. The code is not compatible with any specification of the JCP.
 ******************************************************************************/

package javax.persistence;

import java.lang.annotation.Target;
import java.lang.annotation.Retention;
import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * The MapKeyJoinColumn annotation is used to specify a mapping to an entity
 * that is a map key. The map key join column is in the collection table, join
 * table, or table of the target entity that is used to represent the map.
 */
@Target( { METHOD, FIELD })
@Retention(RUNTIME)
public @interface MapKeyJoinColumn {
	/**
	 * (Optional) The name of the foreign key column for the map key. The table
	 * in which it is found depends upon the context. If the join is for a map
	 * key for an element collection, the foreign key column is in the
	 * collection table for the map value. If the join is for a map key for a
	 * ManyToMany entity relationship or for a OneToMany entity relationship
	 * using a join table, the foreign key column is in a join table. If the
	 * join is for a OneToMany entity relationship using a foreign key mapping
	 * strategy, the foreign key column for the map key is in the table of the
	 * entity that is the value of the map.
	 */
	String name() default "";

	/**
	 * (Optional) The name of the column referenced by this foreign key column.
	 * The referenced column is in the table of the target entity.
	 */
	String referencedColumnName() default "";

	/**
	 * (Optional) The name of the column referenced by this foreign key column.
	 * The referenced column is in the table of the target entity.
	 */
	boolean unique() default false;

	/**
	 * (Optional) Whether the foreign key column is nullable.
	 */
	boolean nullable() default false;

	/**
	 * (Optional) Whether the column is included in SQL INSERT statements
	 * generated by the persistence provider.
	 */
	boolean insertable() default true;

	/**
	 * (Optional) Whether the column is included in SQL UPDATE statements
	 * generated by the persistence provider.
	 */
	boolean updatable() default true;

	/**
	 * (Optional) The SQL fragment that is used when generating the DDL for the
	 * column.
	 */
	String columnDefinition() default "";

	/**
	 * (Optional) The name of the table that contains the foreign key column. If
	 * the join is for a map key for an element collection, the foreign key
	 * column is in the collection table for the map value. If the join is for a
	 * map key for a ManyToMany entity relationship or for a OneToMany entity
	 * relationship using a join table, the foreign key column is in a join
	 * table. If the join is for a OneToMany entity relationship using a foreign
	 * key mapping strategy, the foreign key column for the map key is in the
	 * table of the entity that is the value of the map.
	 */
	String table() default "";
}