/*******************************************************************************
 * Copyright (c) 1998, 2009 Oracle. All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the 
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0 
 * which accompanies this distribution. 
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at 
 * http://www.eclipse.org/org/documents/edl-v10.php.
 * 
 * The API for this class and its comments are derived from the JPA 2.0 specification 
 * which is developed under the Java Community Process (JSR 317) and is copyright 
 * Sun Microsystems, Inc. 
 *
 * Contributors:
 *     dclarke - Java Persistence 2.0 - Proposed Final Draft (March 13, 2009)
 *     			 Specification and licensing terms available from
 *     		   	 http://jcp.org/en/jsr/detail?id=317
 *
 * EARLY ACCESS - PUBLIC DRAFT
 * This is an implementation of an early-draft specification developed under the 
 * Java Community Process (JCP) and is made available for testing and evaluation 
 * purposes only. The code is not compatible with any specification of the JCP.
 ******************************************************************************/
package javax.persistence.criteria;
import javax.persistence.metamodel.AbstractCollection;
/**
* The interface AbstractCollectionJoin defines functionality
* that is common to joins to all collection types. It is
* not intended to be used directly in query construction.
*
* @param <Z> The source type
* @param <C> The collection type
* @param <E> The element type of the collection
*/
public interface AbstractCollectionJoin<Z, C, E>
extends Join<Z, E> {
/**
* Return the metamodel representation for the collection.
* @return metamodel type representing the collection that is
* the target of the join
*/
AbstractCollection<? super Z, C, E> getModel();
}