/*******************************************************************************
 * Copyright (c) 1998, 2009 Oracle. All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the 
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0 
 * which accompanies this distribution. 
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at 
 * http://www.eclipse.org/org/documents/edl-v10.php.
 * 
 * The API for this class and its comments are derived from the JPA 2.0 specification 
 * which is developed under the Java Community Process (JSR 317) and is copyright 
 * Sun Microsystems, Inc. 
 *
 * Contributors:
 *     dclarke - Java Persistence 2.0 - Proposed Final Draft (March 13, 2009)
 *     			 Specification and licensing terms available from
 *     		   	 http://jcp.org/en/jsr/detail?id=317
 *
 * EARLY ACCESS - PUBLIC DRAFT
 * This is an implementation of an early-draft specification developed under the 
 * Java Community Process (JCP) and is made available for testing and evaluation 
 * purposes only. The code is not compatible with any specification of the JCP.
 ******************************************************************************/

package javax.persistence.metamodel;


/**
 * Instances of the type IdentifiableType represent entity or mapped superclass
 * types.
 * 
 * @param <X>
 *            The represented entity or mapped superclass type.
 */
public interface IdentifiableType<X> extends ManagedType<X> {
    /**
     * Return the attribute that corresponds to the id attribute of the entity
     * or mapped superclass.
     * 
     * @param type
     *            the type of the represented id attribute
     * @return id attribute
     * @throws IllegalArgumentException
     *             if id attribute of the given name and type is not present in
     *             the identifiable type
     */
    <Y> Attribute<? super X, Y> getId(Class<Y> type);

    /**
     * Return the attribute that corresponds to the version attribute of the
     * entity or mapped superclass.
     * 
     * @param type
     *            the type of the represented version attribute
     * @return version attribute
     * @throws IllegalArgumentException
     *             if version attribute of the given name and type is not
     *             present in the identifiable type
     */
    <Y> Attribute<? super X, Y> getVersion(Class<Y> type);

    /**
     * Return the attribute that corresponds to the id attribute declared by the
     * entity or mapped superclass.
     * 
     * @param type
     *            the type of the represented declared id attribute
     * @return declared id attribute
     * @throws IllegalArgumentException
     *             if id attribute of the given name and type is not present in
     *             the identifiable type
     */
    <Y> Attribute<X, Y> getDeclaredId(Class<Y> type);

    /**
     * Return the attribute that corresponds to the version attribute declared
     * by the entity or mapped superclass.
     * 
     * @param type
     *            the type of the represented declared version attribute
     * @return declared version attribute
     * @throws IllegalArgumentException
     *             if version attribute of the given name and type is not
     *             present in the identifiable type
     */
    <Y> Attribute<X, Y> getDeclaredVersion(Class<Y> type);

    /**
     * Return the identifiable type that corresponds to the most specific mapped
     * superclass or entity extended by the entity or mapped superclass.
     * 
     * @return supertype of identifiable type
     */
    IdentifiableType<? super X> getSupertype();

    /**
     * Whether or not the identifiable type has an id attribute. Returns true
     * for a simple id or embedded id; returns false for an idclass.
     * 
     * @return boolean indicating whether or not the identifiable type has an id
     *         attribute
     */
    boolean hasIdAttribute();

    /**
     * Return the type that represents the type of the id.
     * 
     * @return type of id
     */
    Type<?> getIdType();
}