/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;

public abstract class FieldsLockingPolicy
implements OptimisticLockingPolicy {
    protected ClassDescriptor descriptor;
    protected Vector allNonPrimaryKeyFields;

    public void addLockFieldsToUpdateRow(AbstractRecord Record2, AbstractSession session) {
    }

    public abstract void addLockValuesToTranslationRow(ObjectLevelModifyQuery var1);

    protected Vector buildAllNonPrimaryKeyFields() {
        Vector<DatabaseField> fields = new Vector<DatabaseField>();
        Enumeration<DatabaseField> enumtr = this.descriptor.getFields().elements();
        while (enumtr.hasMoreElements()) {
            DatabaseField dbField = enumtr.nextElement();
            if (this.isPrimaryKey(dbField)) continue;
            if (this.descriptor.hasInheritance()) {
                DatabaseField classField = this.descriptor.getInheritancePolicy().getClassIndicatorField();
                if (classField == null || dbField.equals(classField)) continue;
                fields.addElement(dbField);
                continue;
            }
            fields.addElement(dbField);
        }
        return fields;
    }

    public Expression buildDeleteExpression(DatabaseTable table, Expression mainExpression, AbstractRecord row) {
        return mainExpression.and(this.buildExpression(table, row, null, mainExpression.getBuilder()));
    }

    protected Expression buildExpression(DatabaseTable table, AbstractRecord transRow, AbstractRecord modifyRow, ExpressionBuilder builder) {
        DatabaseField field;
        Expression exp = null;
        Enumeration enumtr = this.getFieldsToCompare(table, transRow, modifyRow).elements();
        if (enumtr.hasMoreElements()) {
            field = (DatabaseField)enumtr.nextElement();
            exp = builder.getField(field).equal(builder.getParameter(field));
        }
        while (enumtr.hasMoreElements()) {
            field = (DatabaseField)enumtr.nextElement();
            exp = exp.and(builder.getField(field).equal(builder.getParameter(field)));
        }
        return exp;
    }

    public Expression buildUpdateExpression(DatabaseTable table, Expression mainExpression, AbstractRecord transRow, AbstractRecord modifyRow) {
        return mainExpression.and(this.buildExpression(table, transRow, modifyRow, mainExpression.getBuilder()));
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean supportsWriteLockValuesComparison() {
        return false;
    }

    public int compareWriteLockValues(Object value1, Object value2) {
        return -1;
    }

    protected Vector getAllNonPrimaryKeyFields() {
        if (this.allNonPrimaryKeyFields == null) {
            this.allNonPrimaryKeyFields = this.buildAllNonPrimaryKeyFields();
        }
        return this.allNonPrimaryKeyFields;
    }

    protected Vector getAllNonPrimaryKeyFields(DatabaseTable table) {
        Vector<DatabaseField> filteredFields = new Vector<DatabaseField>();
        Enumeration enumtr = this.getAllNonPrimaryKeyFields().elements();
        while (enumtr.hasMoreElements()) {
            DatabaseField dbField = (DatabaseField)enumtr.nextElement();
            if (!dbField.getTableName().equals(table.getName())) continue;
            filteredFields.addElement(dbField);
        }
        return filteredFields;
    }

    public Object getBaseValue() {
        return null;
    }

    protected abstract Vector getFieldsToCompare(DatabaseTable var1, AbstractRecord var2, AbstractRecord var3);

    public DatabaseField getWriteLockField() {
        return null;
    }

    public Expression getWriteLockUpdateExpression(ExpressionBuilder builder, AbstractSession session) {
        return null;
    }

    public Object getValueToPutInCache(AbstractRecord row, AbstractSession session) {
        return null;
    }

    public int getVersionDifference(Object currentValue, Object domainObject, Vector primaryKeys, AbstractSession session) {
        return 1;
    }

    public Object getWriteLockValue(Object domainObject, Vector primaryKey, AbstractSession session) {
        return null;
    }

    public void initialize(AbstractSession session) {
    }

    public void initializeProperties() {
    }

    public boolean isStoredInCache() {
        return false;
    }

    public boolean isCascaded() {
        return false;
    }

    public boolean isChildWriteLockValueGreater(AbstractSession session, Vector primaryKey, Class original, ObjectChangeSet changeSet) {
        return false;
    }

    public boolean isNewerVersion(Object currentValue, Object domainObject, Vector primaryKey, AbstractSession session) {
        return true;
    }

    public boolean isNewerVersion(AbstractRecord Record2, Object domainObject, Vector primaryKey, AbstractSession session) {
        return true;
    }

    protected boolean isPrimaryKey(DatabaseField dbField) {
        if (this.descriptor.getPrimaryKeyFields().contains(dbField)) {
            return true;
        }
        if (this.descriptor.isMultipleTableDescriptor()) {
            Iterator<Map<DatabaseField, DatabaseField>> enumtr = this.descriptor.getAdditionalTablePrimaryKeyFields().values().iterator();
            while (enumtr.hasNext()) {
                if (!enumtr.next().containsKey(dbField)) continue;
                return true;
            }
        }
        return false;
    }

    public void mergeIntoParentCache(UnitOfWorkImpl uow, Vector primaryKey, Object object) {
    }

    protected void setAllNonPrimaryKeyFields(Vector allNonPrimaryKeyFields) {
        this.allNonPrimaryKeyFields = allNonPrimaryKeyFields;
    }

    public void setDescriptor(ClassDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void setupWriteFieldsForInsert(ObjectLevelModifyQuery query) {
    }

    public void updateRowAndObjectForUpdate(ObjectLevelModifyQuery query, Object domainObject) {
    }

    public void validateDelete(int rowCount, Object object, DeleteObjectQuery query) {
        if (rowCount <= 0) {
            query.getSession().getParentIdentityMapSession(query, true, true).getIdentityMapAccessor().invalidateObject(object);
            throw OptimisticLockException.objectChangedSinceLastReadWhenDeleting(object, query);
        }
    }

    public void validateUpdate(int rowCount, Object object, WriteObjectQuery query) {
        if (rowCount <= 0) {
            query.getSession().getParentIdentityMapSession(query, true, true).getIdentityMapAccessor().invalidateObject(object);
            throw OptimisticLockException.objectChangedSinceLastReadWhenUpdating(object, query);
        }
    }

    protected void verifyUsage(AbstractSession session) {
        if (!session.isUnitOfWork()) {
            throw ValidationException.fieldLevelLockingNotSupportedWithoutUnitOfWork();
        }
    }
}

