/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import java.util.Map;
import java.util.Set;
import javax.persistence.Cache;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.FlushModeType;
import javax.persistence.PersistenceException;
import javax.persistence.criteria.QueryBuilder;
import javax.persistence.metamodel.Metamodel;
import org.eclipse.persistence.internal.jpa.CacheImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerSetupImpl;
import org.eclipse.persistence.internal.jpa.metamodel.MetamodelImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.sessions.PropertiesHandler;
import org.eclipse.persistence.sessions.factories.ReferenceMode;
import org.eclipse.persistence.sessions.server.ServerSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityManagerFactoryImpl
implements EntityManagerFactory {
    protected Cache myCache;
    protected volatile ServerSession serverSession;
    protected EntityManagerSetupImpl setupImpl;
    protected boolean isOpen = true;
    protected Map properties;
    protected Metamodel metaModel;
    protected QueryBuilder queryBuilder;
    protected boolean beginEarlyTransaction;
    protected FlushModeType flushMode = FlushModeType.AUTO;
    protected ReferenceMode referenceMode = ReferenceMode.HARD;
    protected boolean closeOnCommit;
    protected boolean persistOnCommit = true;
    protected String flushClearCache = "DropInvalidate";
    protected boolean shouldValidateExistence;

    public EntityManagerFactoryImpl(ServerSession serverSession) {
        this.serverSession = serverSession;
        this.processProperties(serverSession.getProperties());
    }

    public EntityManagerFactoryImpl(EntityManagerSetupImpl setupImpl, Map properties) {
        this.setupImpl = setupImpl;
        this.properties = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerSession getServerSession() {
        if (this.serverSession == null) {
            EntityManagerFactoryImpl entityManagerFactoryImpl = this;
            synchronized (entityManagerFactoryImpl) {
                if (this.serverSession == null) {
                    ClassLoader realLoader = this.setupImpl.getPersistenceUnitInfo().getClassLoader();
                    ServerSession tempServerSession = this.setupImpl.deploy(realLoader, this.properties);
                    this.processProperties(tempServerSession.getProperties());
                    this.serverSession = tempServerSession;
                }
            }
        }
        return this.serverSession;
    }

    public synchronized void close() {
        this.verifyOpen();
        this.isOpen = false;
        if (this.setupImpl != null) {
            this.setupImpl.undeploy();
        }
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public EntityManager createEntityManager() {
        return this.createEntityManagerImpl(null);
    }

    public EntityManager createEntityManager(Map properties) {
        return this.createEntityManagerImpl(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EntityManagerImpl createEntityManagerImpl(Map properties) {
        this.verifyOpen();
        ServerSession session = this.getServerSession();
        if (!session.isLoggedIn()) {
            ServerSession serverSession = session;
            synchronized (serverSession) {
                if (!session.isLoggedIn()) {
                    session.login();
                }
            }
        }
        return new EntityManagerImpl(this, properties);
    }

    protected void verifyOpen() {
        if (!this.isOpen) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage("operation_on_closed_entity_manager_factory"));
        }
    }

    protected void finalize() throws Throwable {
        if (this.isOpen()) {
            this.close();
        }
    }

    public Object getProperty(String name) {
        if (name == null) {
            return null;
        }
        return this.getServerSession().getProperty(name);
    }

    protected void processProperties(Map properties) {
        String flushClearCache;
        String shouldValidateExistence;
        String persistOnCommit;
        String closeOnCommit;
        String flushMode;
        String referenceMode;
        String beginEarlyTransactionProperty = PropertiesHandler.getPropertyValueLogDebug("eclipselink.transaction.join-existing", properties, this.serverSession, true);
        if (beginEarlyTransactionProperty != null) {
            this.beginEarlyTransaction = "true".equalsIgnoreCase(beginEarlyTransactionProperty);
        }
        if ((referenceMode = PropertiesHandler.getPropertyValueLogDebug("eclipselink.persistence-context.reference-mode", properties, this.serverSession, true)) != null) {
            this.referenceMode = ReferenceMode.valueOf(referenceMode);
        }
        if ((flushMode = PropertiesHandler.getPropertyValueLogDebug("eclipselink.persistence-context.flush-mode", properties, this.serverSession, true)) != null) {
            this.flushMode = FlushModeType.valueOf((String)flushMode);
        }
        if ((closeOnCommit = PropertiesHandler.getPropertyValueLogDebug("eclipselink.persistence-context.close-on-commit", properties, this.serverSession, true)) != null) {
            this.closeOnCommit = "true".equalsIgnoreCase(closeOnCommit);
        }
        if ((persistOnCommit = PropertiesHandler.getPropertyValueLogDebug("eclipselink.persistence-context.persist-on-commit", properties, this.serverSession, true)) != null) {
            this.persistOnCommit = "true".equalsIgnoreCase(persistOnCommit);
        }
        if ((shouldValidateExistence = PropertiesHandler.getPropertyValueLogDebug("eclipselink.validate-existence", properties, this.serverSession, true)) != null) {
            this.shouldValidateExistence = "true".equalsIgnoreCase(shouldValidateExistence);
        }
        if ((flushClearCache = PropertiesHandler.getPropertyValueLogDebug("eclipselink.flush-clear.cache", properties, this.serverSession, true)) != null) {
            this.flushClearCache = flushClearCache;
        }
    }

    public boolean getBeginEarlyTransaction() {
        return this.beginEarlyTransaction;
    }

    public void setBeginEarlyTransaction(boolean beginEarlyTransaction) {
        this.beginEarlyTransaction = beginEarlyTransaction;
    }

    public FlushModeType getFlushMode() {
        return this.flushMode;
    }

    public void setFlushMode(FlushModeType flushMode) {
        this.flushMode = flushMode;
    }

    public ReferenceMode getReferenceMode() {
        return this.referenceMode;
    }

    public void setReferenceMode(ReferenceMode referenceMode) {
        this.referenceMode = referenceMode;
    }

    public boolean getCloseOnCommit() {
        return this.closeOnCommit;
    }

    public void setCloseOnCommit(boolean closeOnCommit) {
        this.closeOnCommit = closeOnCommit;
    }

    public boolean getPersistOnCommit() {
        return this.persistOnCommit;
    }

    public void setPersistOnCommit(boolean persistOnCommit) {
        this.persistOnCommit = persistOnCommit;
    }

    public String getFlushClearCache() {
        return this.flushClearCache;
    }

    public void setFlushClearCache(String flushClearCache) {
        this.flushClearCache = flushClearCache;
    }

    public boolean shouldValidateExistence() {
        return this.shouldValidateExistence;
    }

    public void setShouldValidateExistence(boolean shouldValidateExistence) {
        this.shouldValidateExistence = shouldValidateExistence;
    }

    public Cache getCache() {
        this.verifyOpen();
        if (this.myCache == null) {
            ServerSession session = this.getServerSession();
            this.myCache = new CacheImpl(this, session.getIdentityMapAccessor());
        }
        return this.myCache;
    }

    public Map getProperties() {
        throw new PersistenceException("Not Yet Implemented");
    }

    public QueryBuilder getQueryBuilder() {
        throw new PersistenceException("Not Yet Implemented");
    }

    public Metamodel getMetamodel() {
        if (!this.isOpen()) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage("operation_on_closed_entity_manager_factory"));
        }
        if (null == this.metaModel) {
            this.metaModel = new MetamodelImpl(this);
        }
        return this.metaModel;
    }

    public Set<String> getSupportedProperties() {
        throw new PersistenceException("Not Yet Implemented");
    }
}

