/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import java.sql.Connection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityNotFoundException;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.LockTimeoutException;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceException;
import javax.persistence.PessimisticLockException;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.QueryBuilder;
import javax.persistence.metamodel.Metamodel;
import javax.sql.DataSource;
import org.eclipse.persistence.config.EntityManagerProperties;
import org.eclipse.persistence.descriptors.CMPPolicy;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.JPQLException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.jpa.EJBQueryImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryProvider;
import org.eclipse.persistence.internal.jpa.EntityManagerSetupImpl;
import org.eclipse.persistence.internal.jpa.QueryHintsHandler;
import org.eclipse.persistence.internal.jpa.transaction.EntityTransactionWrapper;
import org.eclipse.persistence.internal.jpa.transaction.JTATransactionWrapper;
import org.eclipse.persistence.internal.jpa.transaction.TransactionWrapper;
import org.eclipse.persistence.internal.jpa.transaction.TransactionWrapperImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.PropertiesHandler;
import org.eclipse.persistence.internal.sessions.RepeatableWriteUnitOfWork;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ResultSetMappingQuery;
import org.eclipse.persistence.sessions.DatasourceLogin;
import org.eclipse.persistence.sessions.DefaultConnector;
import org.eclipse.persistence.sessions.JNDIConnector;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.factories.ReferenceMode;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.sessions.server.ConnectionPolicy;
import org.eclipse.persistence.sessions.server.ServerSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityManagerImpl
implements JpaEntityManager {
    protected TransactionWrapperImpl transaction;
    protected boolean isOpen;
    protected RepeatableWriteUnitOfWork extendedPersistenceContext;
    protected ServerSession serverSession;
    protected EntityManagerFactoryImpl factory;
    protected boolean beginEarlyTransaction;
    protected Map properties;
    protected FlushModeType flushMode;
    protected ReferenceMode referenceMode;
    protected ConnectionPolicy connectionPolicy;
    protected boolean closeOnCommit;
    protected boolean persistOnCommit;
    protected String flushClearCache;
    protected boolean shouldValidateExistence;

    public EntityManagerImpl(String sessionName) {
        this((ServerSession)SessionManager.getManager().getSession(sessionName), null);
    }

    public EntityManagerImpl(ServerSession serverSession) {
        this(serverSession, null);
    }

    public EntityManagerImpl(ServerSession serverSession, Map properties) {
        this.serverSession = serverSession;
        this.referenceMode = ReferenceMode.HARD;
        this.flushMode = FlushModeType.AUTO;
        this.flushClearCache = "DropInvalidate";
        this.persistOnCommit = true;
        this.isOpen = true;
        this.initialize(properties);
    }

    public EntityManagerImpl(EntityManagerFactoryImpl factory, Map properties) {
        this.factory = factory;
        this.serverSession = factory.getServerSession();
        this.beginEarlyTransaction = factory.getBeginEarlyTransaction();
        this.closeOnCommit = factory.getCloseOnCommit();
        this.flushMode = factory.getFlushMode();
        this.persistOnCommit = factory.getPersistOnCommit();
        this.referenceMode = factory.getReferenceMode();
        this.flushClearCache = factory.getFlushClearCache();
        this.shouldValidateExistence = factory.shouldValidateExistence();
        this.isOpen = true;
        this.initialize(properties);
    }

    protected void initialize(Map properties) {
        this.detectTransactionWrapper();
        if (properties != null) {
            this.properties = new HashMap(properties);
        }
        this.processProperties();
    }

    public void clear() {
        try {
            this.verifyOpen();
            if (this.extendedPersistenceContext != null) {
                if (this.checkForTransaction(false) == null) {
                    this.extendedPersistenceContext.clearForClose(true);
                    this.extendedPersistenceContext = null;
                } else {
                    this.extendedPersistenceContext.clear(true);
                }
            }
        }
        catch (RuntimeException exception) {
            this.setRollbackOnly();
            throw exception;
        }
    }

    public void removeExtendedPersistenceContext() {
        this.extendedPersistenceContext = null;
    }

    public void persist(Object entity) {
        try {
            this.verifyOpen();
            if (entity == null) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("not_an_entity", new Object[]{entity}));
            }
            try {
                this.getActivePersistenceContext(this.checkForTransaction(false)).registerNewObjectForPersist(entity, new IdentityHashMap());
            }
            catch (RuntimeException exception) {
                if (exception instanceof ValidationException) {
                    throw new EntityExistsException(exception.getLocalizedMessage(), (Throwable)exception);
                }
                throw exception;
            }
        }
        catch (RuntimeException exception) {
            this.setRollbackOnly();
            throw exception;
        }
    }

    public <T> T merge(T entity) {
        try {
            this.verifyOpen();
            return (T)this.mergeInternal(entity);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    protected Object mergeInternal(Object entity) {
        if (entity == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("not_an_entity", new Object[]{entity}));
        }
        Object merged = null;
        RepeatableWriteUnitOfWork context = this.getActivePersistenceContext(this.checkForTransaction(false));
        try {
            merged = context.mergeCloneWithReferences(entity, 4, true);
        }
        catch (org.eclipse.persistence.exceptions.OptimisticLockException ole) {
            throw new OptimisticLockException((Throwable)ole);
        }
        return merged;
    }

    public void remove(Object entity) {
        try {
            this.verifyOpen();
            if (entity == null) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("not_an_entity", new Object[]{entity}));
            }
            this.getActivePersistenceContext(this.checkForTransaction(false)).performRemove(entity, new IdentityHashMap());
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) {
        return this.find(entityClass, primaryKey, null, null);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) {
        return this.find(entityClass, primaryKey, null, properties);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode) {
        HashMap queryHints = null;
        if (this.properties != null && this.properties.containsKey("javax.persistence.lock.timeout")) {
            queryHints = new HashMap();
            queryHints.put("javax.persistence.lock.timeout", this.properties.get("javax.persistence.lock.timeout"));
        }
        return this.find(entityClass, primaryKey, lockMode, queryHints);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode, Map<String, Object> properties) {
        try {
            this.verifyOpen();
            AbstractSession session = (AbstractSession)this.getActiveSession();
            ClassDescriptor descriptor = session.getDescriptor(entityClass);
            if (descriptor == null || descriptor.isAggregateDescriptor() || descriptor.isAggregateCollectionDescriptor()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("unknown_bean_class", new Object[]{entityClass}));
            }
            return (T)this.findInternal(descriptor, session, primaryKey, lockMode, properties);
        }
        catch (LockTimeoutException e) {
            throw e;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Object find(String entityName, Object primaryKey) {
        try {
            this.verifyOpen();
            AbstractSession session = (AbstractSession)this.getActiveSession();
            ClassDescriptor descriptor = session.getDescriptorForAlias(entityName);
            if (descriptor == null || descriptor.isAggregateDescriptor() || descriptor.isAggregateCollectionDescriptor()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("unknown_entitybean_name", new Object[]{entityName}));
            }
            return this.findInternal(descriptor, session, primaryKey, null, null);
        }
        catch (LockTimeoutException e) {
            throw e;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    protected Object findInternal(ClassDescriptor descriptor, AbstractSession session, Object primaryKey, LockModeType lockMode, Map<String, Object> properties) {
        List primaryKeyValues;
        if (primaryKey == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("null_pk"));
        }
        if (primaryKey instanceof List) {
            primaryKeyValues = (List)primaryKey;
        } else {
            CMPPolicy policy = descriptor.getCMPPolicy();
            Class pkClass = policy.getPKClass();
            if (pkClass != null && pkClass != primaryKey.getClass() && !pkClass.isAssignableFrom(primaryKey.getClass())) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("invalid_pk_class", new Object[]{descriptor.getCMPPolicy().getPKClass(), primaryKey.getClass()}));
            }
            primaryKeyValues = policy.createPkVectorFromKey(primaryKey, session);
        }
        ReadObjectQuery query = descriptor.getQueryManager().getReadObjectQuery();
        if (query == null) {
            query = this.getReadObjectQuery(descriptor.getJavaClass(), primaryKeyValues, properties);
        } else {
            query.checkPrepare(session, null);
            query = (ReadObjectQuery)query.clone();
            QueryHintsHandler.apply(properties, query, session.getLoader());
            query.setIsExecutionClone(true);
            query.setSelectionKey(primaryKeyValues);
        }
        if (properties == null || !properties.containsKey("eclipselink.cache-usage")) {
            query.conformResultsInUnitOfWork();
        }
        return this.executeQuery(query, lockMode, (UnitOfWork)((Object)session));
    }

    public void flush() {
        try {
            this.verifyOpen();
            try {
                this.getActivePersistenceContext(this.checkForTransaction(true)).writeChanges();
            }
            catch (RuntimeException e) {
                if (EclipseLinkException.class.isAssignableFrom(e.getClass())) {
                    throw new PersistenceException((Throwable)e);
                }
                throw e;
            }
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    protected void detectTransactionWrapper() {
        if (this.serverSession.hasExternalTransactionController()) {
            this.setJTATransactionWrapper();
        } else {
            this.setEntityTransactionWrapper();
        }
    }

    private Object executeQuery(ReadObjectQuery query, LockModeType lockMode, UnitOfWork uow) {
        if (lockMode != null && query.setLockModeType(lockMode.name(), (AbstractSession)this.getActiveSession())) {
            throw new PersistenceException(ExceptionLocalization.buildMessage("ejb30-wrong-lock_called_without_version_locking-index", null));
        }
        Object result = null;
        try {
            result = uow.executeQuery(query);
        }
        catch (DatabaseException e) {
            if (lockMode != null && lockMode.name().contains("PESSIMISTIC_")) {
                if (uow.getPlatform().isLockTimeoutException(e)) {
                    throw new LockTimeoutException(e);
                }
                throw new PessimisticLockException(e);
            }
            throw e;
        }
        return result;
    }

    public void refresh(Object entity) {
        this.refresh(entity, null, null);
    }

    public void refresh(Object entity, Map<String, Object> properties) {
        this.refresh(entity, null, properties);
    }

    public void refresh(Object entity, LockModeType lockMode) {
        HashMap queryHints = null;
        if (this.properties != null && this.properties.containsKey("javax.persistence.lock.timeout")) {
            queryHints = new HashMap();
            queryHints.put("javax.persistence.lock.timeout", this.properties.get("javax.persistence.lock.timeout"));
        }
        this.refresh(entity, lockMode, queryHints);
    }

    public void refresh(Object entity, LockModeType lockMode, Map properties) {
        try {
            Object refreshedEntity;
            this.verifyOpen();
            RepeatableWriteUnitOfWork uow = this.getActivePersistenceContext(this.checkForTransaction(false));
            if (!this.contains(entity, uow)) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("cant_refresh_not_managed_object", new Object[]{entity}));
            }
            ReadObjectQuery query = this.getReadObjectQuery(entity, properties);
            if (properties == null || !properties.containsKey("eclipselink.refresh")) {
                query.refreshIdentityMapResult();
            }
            if (properties == null || !properties.containsKey("eclipselink.refresh.cascade")) {
                query.cascadeByMapping();
            }
            if ((refreshedEntity = this.executeQuery(query, lockMode, uow)) == null) {
                throw new EntityNotFoundException(ExceptionLocalization.buildMessage("entity_no_longer_exists_in_db", new Object[]{entity}));
            }
        }
        catch (LockTimeoutException e) {
            throw e;
        }
        catch (RuntimeException exception) {
            this.setRollbackOnly();
            throw exception;
        }
    }

    public boolean contains(Object entity) {
        try {
            this.verifyOpen();
            if (entity == null) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("not_an_entity", new Object[]{entity}));
            }
            ClassDescriptor descriptor = (ClassDescriptor)this.serverSession.getDescriptors().get(entity.getClass());
            if (descriptor == null || descriptor.isAggregateDescriptor() || descriptor.isAggregateCollectionDescriptor()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("not_an_entity", new Object[]{entity}));
            }
            if (!this.hasActivePersistenceContext()) {
                return false;
            }
            return this.contains(entity, this.getActivePersistenceContext(this.checkForTransaction(false)));
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    protected boolean contains(Object entity, UnitOfWork uow) {
        return ((UnitOfWorkImpl)uow).isObjectRegistered(entity) && !((UnitOfWorkImpl)uow).isObjectDeleted(entity);
    }

    @Override
    public Query createDescriptorNamedQuery(String queryName, Class descriptorClass) {
        return this.createDescriptorNamedQuery(queryName, descriptorClass, null);
    }

    @Override
    public Query createDescriptorNamedQuery(String queryName, Class descriptorClass, List argumentTypes) {
        try {
            DatabaseQuery query;
            this.verifyOpen();
            ClassDescriptor descriptor = this.serverSession.getDescriptor(descriptorClass);
            if (descriptor != null && (query = descriptor.getQueryManager().getLocalQueryByArgumentTypes(queryName, argumentTypes)) != null) {
                return new EJBQueryImpl(query, this);
            }
            return null;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Query createNamedQuery(String name) {
        try {
            this.verifyOpen();
            return new EJBQueryImpl(name, this, true);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Query createNativeQuery(String sqlString) {
        try {
            this.verifyOpen();
            return new EJBQueryImpl(EJBQueryImpl.buildSQLDatabaseQuery(sqlString, this.serverSession.getLoader()), this);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Query createNativeQuery(String sqlString, Class resultType) {
        try {
            this.verifyOpen();
            DatabaseQuery query = this.createNativeQueryInternal(sqlString, resultType);
            return new EJBQueryImpl(query, this);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        try {
            this.verifyOpen();
            ResultSetMappingQuery query = new ResultSetMappingQuery();
            query.setSQLResultSetMappingName(resultSetMapping);
            query.setSQLString(sqlString);
            query.setIsUserDefined(true);
            return new EJBQueryImpl(query, this);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public Session getActiveSession() {
        return this.getActivePersistenceContext(this.checkForTransaction(false));
    }

    public Object getDelegate() {
        try {
            this.verifyOpen();
            return this;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public FlushModeType getFlushMode() {
        try {
            this.verifyOpen();
            return this.flushMode;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public UnitOfWork getUnitOfWork() {
        return this.getActivePersistenceContext(this.checkForTransaction(false));
    }

    @Override
    public Session getSession() {
        if (this.checkForTransaction(false) == null) {
            return this.serverSession.acquireNonSynchronizedUnitOfWork(this.referenceMode);
        }
        return null;
    }

    public EntityTransaction getTransaction() {
        try {
            return ((TransactionWrapper)((Object)this.transaction)).getTransaction();
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Object getProperty(String name) {
        Object propertyValue = null;
        if (name == null) {
            return null;
        }
        if (this.properties != null) {
            propertyValue = this.properties.get(name);
        }
        if (propertyValue == null) {
            propertyValue = this.factory.getServerSession().getProperty(name);
        }
        return propertyValue;
    }

    protected ReadObjectQuery getReadObjectQuery(Class referenceClass, List primaryKeyValues, Map properties) {
        ReadObjectQuery query = this.getReadObjectQuery(properties);
        query.setReferenceClass(referenceClass);
        query.setSelectionKey(primaryKeyValues);
        return query;
    }

    protected ReadObjectQuery getReadObjectQuery(Map properties) {
        ReadObjectQuery query = new ReadObjectQuery();
        QueryHintsHandler.apply(properties, query, this.serverSession.getDatasourcePlatform().getConversionManager().getLoader());
        query.setIsExecutionClone(true);
        return query;
    }

    protected ReadObjectQuery getReadObjectQuery(Object entity, Map properties) {
        ReadObjectQuery query = this.getReadObjectQuery(properties);
        query.setSelectionObject(entity);
        return query;
    }

    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        try {
            this.verifyOpen();
            UnitOfWork session = (UnitOfWork)this.getActiveSession();
            Object reference = session.getReference(entityClass, primaryKey);
            if (reference == null) {
                Object[] args = new Object[]{primaryKey};
                String message = ExceptionLocalization.buildMessage("no_entities_retrieved_for_get_reference", args);
                throw new EntityNotFoundException(message);
            }
            return (T)reference;
        }
        catch (RuntimeException exception) {
            this.setRollbackOnly();
            throw exception;
        }
    }

    public Session getReadOnlySession() {
        if (this.extendedPersistenceContext != null && this.extendedPersistenceContext.isActive()) {
            return this.extendedPersistenceContext.getParent();
        }
        return this.serverSession.acquireClientSession(this.connectionPolicy, this.properties);
    }

    @Override
    public ServerSession getServerSession() {
        return this.serverSession;
    }

    protected DatabaseQuery createNativeQueryInternal(String sqlString, Class resultType) {
        ReadAllQuery query = new ReadAllQuery(resultType);
        query.setSQLString(sqlString);
        query.setIsUserDefined(true);
        return query;
    }

    @Override
    public Query createQuery(Expression expression, Class resultType) {
        try {
            this.verifyOpen();
            DatabaseQuery query = this.createQueryInternal(expression, resultType);
            return new EJBQueryImpl(query, this);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public Query createQuery(DatabaseQuery databaseQuery) {
        try {
            this.verifyOpen();
            return new EJBQueryImpl(databaseQuery, this);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Query createQuery(CriteriaQuery criteriaQuery) {
        throw new PersistenceException("Not Yet Implemented");
    }

    @Override
    public Query createQueryByExample(Object exampleObject) {
        try {
            this.verifyOpen();
            ReadAllQuery query = new ReadAllQuery(exampleObject.getClass());
            query.setExampleObject(exampleObject);
            return new EJBQueryImpl(query, this);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public Query createQuery(Call call) {
        try {
            this.verifyOpen();
            DataReadQuery query = new DataReadQuery(call);
            return new EJBQueryImpl(query, this);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public Query createQuery(Call call, Class entityClass) {
        try {
            this.verifyOpen();
            ReadAllQuery query = new ReadAllQuery(entityClass, call);
            return new EJBQueryImpl(query, this);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Query createQuery(String jpqlString) {
        try {
            EJBQueryImpl ejbqImpl;
            this.verifyOpen();
            try {
                ejbqImpl = new EJBQueryImpl(jpqlString, this);
            }
            catch (JPQLException exception) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("wrap_ejbql_exception") + ": " + exception.getLocalizedMessage(), exception);
            }
            return ejbqImpl;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    protected DatabaseQuery createQueryInternal(Expression expression, Class resultType) {
        ReadAllQuery query = new ReadAllQuery(resultType);
        query.setSelectionCriteria(expression);
        return query;
    }

    public void close() {
        try {
            this.verifyOpen();
            this.isOpen = false;
            this.factory = null;
            this.serverSession = null;
            if (this.extendedPersistenceContext != null) {
                if (this.checkForTransaction(false) == null && !this.extendedPersistenceContext.isSynchronized()) {
                    this.extendedPersistenceContext.release();
                    this.extendedPersistenceContext.getParent().release();
                } else {
                    this.extendedPersistenceContext.setResumeUnitOfWorkOnTransactionCompletion(false);
                }
                this.extendedPersistenceContext = null;
            }
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public boolean isFlushModeAUTO() {
        return this.flushMode == FlushModeType.AUTO;
    }

    public boolean isOpen() {
        return this.isOpen && this.factory.isOpen();
    }

    public void lock(Object entity, LockModeType lockMode) {
        HashMap queryHints = null;
        if (this.properties != null && this.properties.containsKey("javax.persistence.lock.timeout")) {
            queryHints = new HashMap();
            queryHints.put("javax.persistence.lock.timeout", this.properties.get("javax.persistence.lock.timeout"));
        }
        this.lock(entity, lockMode, queryHints);
    }

    public void lock(Object entity, LockModeType lockMode, Map properties) {
        try {
            this.verifyOpen();
            if (entity == null) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("not_an_entity", new Object[]{entity}));
            }
            RepeatableWriteUnitOfWork uow = this.getActivePersistenceContext(this.checkForTransaction(true));
            if (!this.contains(entity, uow)) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("cant_lock_not_managed_object", new Object[]{entity}));
            }
            if (lockMode == null || lockMode == LockModeType.NONE) {
                return;
            }
            if (lockMode == LockModeType.PESSIMISTIC_READ || lockMode == LockModeType.PESSIMISTIC_WRITE || lockMode == LockModeType.PESSIMISTIC_FORCE_INCREMENT) {
                ReadObjectQuery query = this.getReadObjectQuery(entity, properties);
                if (properties == null || !properties.containsKey("eclipselink.refresh")) {
                    query.refreshIdentityMapResult();
                }
                if (properties == null || !properties.containsKey("eclipselink.refresh.cascade")) {
                    query.cascadePrivateParts();
                }
                this.executeQuery(query, lockMode, this.getActivePersistenceContext(this.checkForTransaction(false)));
            } else {
                RepeatableWriteUnitOfWork context = this.getActivePersistenceContext(this.checkForTransaction(false));
                ClassDescriptor descriptor = context.getDescriptor(entity);
                OptimisticLockingPolicy lockingPolicy = descriptor.getOptimisticLockingPolicy();
                if (lockingPolicy == null || !(lockingPolicy instanceof VersionLockingPolicy)) {
                    throw new PersistenceException(ExceptionLocalization.buildMessage("ejb30-wrong-lock_called_without_version_locking-index", null));
                }
                context.forceUpdateToVersionField(entity, lockMode == LockModeType.WRITE || lockMode.name().equals("OPTIMISTIC_FORCE_INCREMENT"));
            }
        }
        catch (LockTimeoutException e) {
            throw e;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public void verifyOpen() {
        if (!this.isOpen()) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage("operation_on_closed_entity_manager"));
        }
    }

    public RepeatableWriteUnitOfWork getActivePersistenceContext(Object txn) {
        if (this.extendedPersistenceContext == null || !this.extendedPersistenceContext.isActive()) {
            this.extendedPersistenceContext = new RepeatableWriteUnitOfWork(this.serverSession.acquireClientSession(this.connectionPolicy, this.properties), this.referenceMode);
            this.extendedPersistenceContext.setResumeUnitOfWorkOnTransactionCompletion(!this.closeOnCommit);
            this.extendedPersistenceContext.setShouldDiscoverNewObjects(this.persistOnCommit);
            this.extendedPersistenceContext.setFlushClearCache(this.flushClearCache);
            this.extendedPersistenceContext.setShouldValidateExistence(this.shouldValidateExistence);
            this.extendedPersistenceContext.setShouldCascadeCloneToJoinedRelationship(true);
            if (txn != null) {
                this.transaction.registerUnitOfWorkWithTxn(this.extendedPersistenceContext);
            }
        }
        if (this.beginEarlyTransaction && txn != null && !this.extendedPersistenceContext.isInTransaction()) {
            this.extendedPersistenceContext.beginEarlyTransaction();
        }
        return this.extendedPersistenceContext;
    }

    public void setProperties(Map properties) {
        if (this.hasActivePersistenceContext()) {
            this.extendedPersistenceContext.log(6, "properties", "entity_manager_sets_properties_while_context_is_active");
        }
        this.properties = properties;
        this.processProperties();
    }

    public void setProperty(String propertyName, Object value) {
        throw new PersistenceException("Not Yet Implemented");
    }

    private boolean hasActivePersistenceContext() {
        return this.extendedPersistenceContext != null && this.extendedPersistenceContext.isActive();
    }

    protected Object checkForTransaction(boolean validateExistence) {
        return this.transaction.checkForTransaction(validateExistence);
    }

    public boolean shouldFlushBeforeQuery() {
        Object foundTransaction = this.checkForTransaction(false);
        return foundTransaction != null && this.transaction.shouldFlushBeforeQuery(this.getActivePersistenceContext(foundTransaction));
    }

    public boolean shouldBeginEarlyTransaction() {
        return this.beginEarlyTransaction;
    }

    public void joinTransaction() {
        try {
            this.verifyOpen();
            this.transaction.registerUnitOfWorkWithTxn(this.getActivePersistenceContext(this.checkForTransaction(true)));
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    protected void setRollbackOnly() {
        this.transaction.setRollbackOnlyInternal();
    }

    private void processProperties() {
        if (this.properties != null && !this.properties.isEmpty()) {
            String flushClearCache;
            String shouldValidateExistence;
            String persistOnCommit;
            String closeOnCommit;
            String flushMode;
            String referenceMode;
            String beginEarlyTransactionProperty = this.getPropertiesHandlerProperty("eclipselink.transaction.join-existing");
            if (beginEarlyTransactionProperty != null) {
                this.beginEarlyTransaction = "true".equalsIgnoreCase(beginEarlyTransactionProperty);
            }
            if ((referenceMode = this.getPropertiesHandlerProperty("eclipselink.persistence-context.reference-mode")) != null) {
                this.referenceMode = ReferenceMode.valueOf(referenceMode);
            }
            if ((flushMode = this.getPropertiesHandlerProperty("eclipselink.persistence-context.flush-mode")) != null) {
                this.flushMode = FlushModeType.valueOf((String)flushMode);
            }
            if ((closeOnCommit = this.getPropertiesHandlerProperty("eclipselink.persistence-context.close-on-commit")) != null) {
                this.closeOnCommit = "true".equalsIgnoreCase(closeOnCommit);
            }
            if ((persistOnCommit = this.getPropertiesHandlerProperty("eclipselink.persistence-context.persist-on-commit")) != null) {
                this.persistOnCommit = "true".equalsIgnoreCase(persistOnCommit);
            }
            if ((shouldValidateExistence = this.getPropertiesHandlerProperty("eclipselink.validate-existence")) != null) {
                this.shouldValidateExistence = "true".equalsIgnoreCase(shouldValidateExistence);
            }
            if ((flushClearCache = this.getPropertiesHandlerProperty("eclipselink.flush-clear.cache")) != null) {
                this.flushClearCache = flushClearCache;
            }
        }
        this.connectionPolicy = this.processConnectionPolicyProperties();
    }

    protected String getPropertiesHandlerProperty(String name) {
        return PropertiesHandler.getPropertyValue(name, this.properties, false);
    }

    protected void setEntityTransactionWrapper() {
        this.transaction = new EntityTransactionWrapper(this);
    }

    public void setFlushMode(FlushModeType flushMode) {
        try {
            this.verifyOpen();
            this.flushMode = flushMode;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    protected void setJTATransactionWrapper() {
        this.transaction = new JTATransactionWrapper(this);
    }

    protected ConnectionPolicy processConnectionPolicyProperties() {
        ConnectionPolicy.ExclusiveMode exclusiveMode;
        ConnectionPolicy policy = this.serverSession.getDefaultConnectionPolicy();
        if (this.properties == null || this.properties.isEmpty()) {
            return policy;
        }
        ConnectionPolicy policyFromProperties = (ConnectionPolicy)this.properties.get("eclipselink.jdbc.connection-policy");
        if (policyFromProperties != null) {
            policy = policyFromProperties;
        }
        ConnectionPolicy newPolicy = null;
        String isLazyString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.exclusive-connection.is-lazy", this.properties, this.serverSession, false);
        if (isLazyString != null) {
            boolean isLazy = Boolean.parseBoolean(isLazyString);
            if (policy.isLazy() != isLazy) {
                if (newPolicy == null) {
                    newPolicy = (ConnectionPolicy)policy.clone();
                }
                newPolicy.setIsLazy(isLazy);
            }
        }
        if ((exclusiveMode = EntityManagerSetupImpl.getConnectionPolicyExclusiveModeFromProperties(this.properties, this.serverSession, false)) != null && !exclusiveMode.equals((Object)policy.getExclusiveMode())) {
            if (newPolicy == null) {
                newPolicy = (ConnectionPolicy)policy.clone();
            }
            newPolicy.setExclusiveMode(exclusiveMode);
        }
        String user = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("javax.persistence.jdbc.user", this.properties, this.serverSession, false);
        String password = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("javax.persistence.jdbc.password", this.properties, this.serverSession, false);
        String driver = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("javax.persistence.jdbc.driver", this.properties, this.serverSession, false);
        String connectionString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("javax.persistence.jdbc.url", this.properties, this.serverSession, false);
        Object jtaDataSourceObj = EntityManagerFactoryProvider.getConfigPropertyLogDebug("javax.persistence.jtaDataSource", this.properties, this.serverSession, false);
        DataSource jtaDataSource = null;
        String jtaDataSourceName = null;
        if (jtaDataSourceObj != null) {
            if (jtaDataSourceObj instanceof DataSource) {
                jtaDataSource = (DataSource)jtaDataSourceObj;
            } else if (jtaDataSourceObj instanceof String) {
                jtaDataSourceName = (String)jtaDataSourceObj;
            }
        }
        Object nonjtaDataSourceObj = EntityManagerFactoryProvider.getConfigPropertyLogDebug("javax.persistence.nonJtaDataSource", this.properties, this.serverSession, false);
        DataSource nonjtaDataSource = null;
        String nonjtaDataSourceName = null;
        if (nonjtaDataSourceObj != null) {
            if (nonjtaDataSourceObj instanceof DataSource) {
                nonjtaDataSource = (DataSource)nonjtaDataSourceObj;
            } else if (nonjtaDataSourceObj instanceof String) {
                nonjtaDataSourceName = (String)nonjtaDataSourceObj;
            }
        }
        if (user != null || password != null || driver != null || connectionString != null || jtaDataSourceObj != null || nonjtaDataSourceObj != null) {
            Boolean isNewUserRequired;
            boolean isJNDIConnectorRequired;
            boolean isDefaultConnectorRequired = EntityManagerImpl.isPropertyToBeAdded(driver) || EntityManagerImpl.isPropertyToBeAdded(connectionString);
            boolean bl = isJNDIConnectorRequired = EntityManagerImpl.isPropertyToBeAdded(jtaDataSource, jtaDataSourceName) || EntityManagerImpl.isPropertyToBeAdded(nonjtaDataSource, nonjtaDataSourceName);
            if (isDefaultConnectorRequired && isJNDIConnectorRequired) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("entity_manager_properties_conflict_default_connector_vs_jndi_connector", new Object[0]));
            }
            DatasourceLogin login = (DatasourceLogin)policy.getLogin();
            if (login == null) {
                login = policy.getPoolName() != null ? (DatasourceLogin)this.serverSession.getConnectionPool(policy.getPoolName()).getLogin() : (DatasourceLogin)this.serverSession.getDatasourceLogin();
            }
            if (login.shouldUseExternalTransactionController() && isDefaultConnectorRequired) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("entity_manager_properties_conflict_default_connector_vs_external_transaction_controller", new Object[0]));
            }
            DataSource dataSource = null;
            String dataSourceName = null;
            if (isJNDIConnectorRequired) {
                if (login.shouldUseExternalTransactionController()) {
                    if (EntityManagerImpl.isPropertyToBeAdded(jtaDataSource, jtaDataSourceName)) {
                        dataSource = jtaDataSource;
                        dataSourceName = jtaDataSourceName;
                    }
                    if (EntityManagerImpl.isPropertyToBeAdded(nonjtaDataSource, nonjtaDataSourceName)) {
                        this.serverSession.log(6, "properties", "entity_manager_ignores_nonjta_data_source");
                    }
                } else {
                    if (EntityManagerImpl.isPropertyToBeAdded(nonjtaDataSource, nonjtaDataSourceName)) {
                        dataSource = nonjtaDataSource;
                        dataSourceName = nonjtaDataSourceName;
                    }
                    if (EntityManagerImpl.isPropertyToBeAdded(jtaDataSource, jtaDataSourceName)) {
                        this.serverSession.log(6, "properties", "entity_manager_ignores_jta_data_source");
                    }
                }
            }
            Boolean isNewPasswordRequired = (isNewUserRequired = this.isPropertyValueToBeUpdated(login.getUserName(), user)) != null && isNewUserRequired == false ? Boolean.FALSE : this.isPropertyValueToBeUpdated(login.getPassword(), password);
            DefaultConnector oldDefaultConnector = null;
            if (login.getConnector() instanceof DefaultConnector) {
                oldDefaultConnector = (DefaultConnector)login.getConnector();
            }
            boolean isNewDefaultConnectorRequired = oldDefaultConnector == null && isDefaultConnectorRequired;
            JNDIConnector oldJNDIConnector = null;
            if (login.getConnector() instanceof JNDIConnector) {
                oldJNDIConnector = (JNDIConnector)login.getConnector();
            }
            boolean isNewJNDIConnectorRequired = oldJNDIConnector == null && isJNDIConnectorRequired;
            Boolean isNewDriverRequired = null;
            Boolean isNewConnectionStringRequired = null;
            if (isNewDefaultConnectorRequired) {
                isNewDriverRequired = this.isPropertyValueToBeUpdated(null, driver);
                isNewConnectionStringRequired = this.isPropertyValueToBeUpdated(null, connectionString);
            } else if (oldDefaultConnector != null) {
                isNewDriverRequired = this.isPropertyValueToBeUpdated(oldDefaultConnector.getDriverClassName(), driver);
                isNewConnectionStringRequired = this.isPropertyValueToBeUpdated(oldDefaultConnector.getConnectionString(), connectionString);
            }
            Boolean isNewDataSourceRequired = null;
            if (isNewJNDIConnectorRequired) {
                isNewDataSourceRequired = Boolean.TRUE;
            } else if (oldJNDIConnector != null) {
                if (dataSource != null) {
                    if (!dataSource.equals(oldJNDIConnector.getDataSource())) {
                        isNewDataSourceRequired = Boolean.TRUE;
                    }
                } else if (dataSourceName != null && !dataSourceName.equals(oldJNDIConnector.getName())) {
                    isNewDataSourceRequired = Boolean.TRUE;
                }
            }
            if (isNewUserRequired != null || isNewPasswordRequired != null || isNewDriverRequired != null || isNewConnectionStringRequired != null || isNewDataSourceRequired.booleanValue()) {
                if (newPolicy == null) {
                    newPolicy = (ConnectionPolicy)policy.clone();
                }
                DatasourceLogin newLogin = (DatasourceLogin)newPolicy.getLogin();
                if (newPolicy.getLogin() == null || newPolicy.getLogin() == policy.getLogin()) {
                    newLogin = (DatasourceLogin)login.clone();
                    newPolicy.setLogin(newLogin);
                }
                newPolicy.setPoolName(null);
                if (isNewUserRequired != null) {
                    if (isNewUserRequired.booleanValue()) {
                        newLogin.setProperty("user", user);
                    } else {
                        newLogin.getProperties().remove("user");
                    }
                }
                if (isNewPasswordRequired != null) {
                    if (isNewPasswordRequired.booleanValue()) {
                        newLogin.setProperty("password", password);
                    } else {
                        newLogin.getProperties().remove("password");
                    }
                }
                if (isNewDefaultConnectorRequired) {
                    newLogin.setConnector(new DefaultConnector());
                    newLogin.setUsesExternalConnectionPooling(false);
                } else if (isNewJNDIConnectorRequired) {
                    newLogin.setConnector(new JNDIConnector());
                    newLogin.setUsesExternalConnectionPooling(true);
                }
                if (isDefaultConnectorRequired) {
                    DefaultConnector defaultConnector = (DefaultConnector)newLogin.getConnector();
                    if (isNewDriverRequired != null) {
                        if (isNewDriverRequired.booleanValue()) {
                            defaultConnector.setDriverClassName(driver);
                        } else {
                            defaultConnector.setDriverClassName(null);
                        }
                    }
                    if (isNewConnectionStringRequired != null) {
                        if (isNewConnectionStringRequired.booleanValue()) {
                            defaultConnector.setDatabaseURL(connectionString);
                        } else {
                            defaultConnector.setDatabaseURL(null);
                        }
                    }
                } else if (isNewDataSourceRequired != null) {
                    JNDIConnector jndiConnector = (JNDIConnector)newLogin.getConnector();
                    if (isNewDataSourceRequired.booleanValue()) {
                        if (dataSource != null) {
                            jndiConnector.setDataSource(dataSource);
                        } else {
                            jndiConnector.setName(dataSourceName);
                        }
                    }
                }
            }
        }
        if (newPolicy != null) {
            return newPolicy;
        }
        return policy;
    }

    protected static boolean isPropertyToBeAdded(String value) {
        return value != null && value.length() > 0;
    }

    protected static boolean isPropertyToBeAdded(DataSource ds, String dsName) {
        return ds != null || dsName != null && dsName.length() > 0;
    }

    protected static boolean isPropertyToBeRemoved(String value) {
        return value != null && value.length() == 0;
    }

    protected Boolean isPropertyValueToBeUpdated(String oldValue, String newValue) {
        if (newValue == null) {
            return null;
        }
        if (newValue.length() > 0) {
            if (oldValue != null) {
                if (newValue.equals(oldValue)) {
                    return null;
                }
                return Boolean.TRUE;
            }
            return Boolean.TRUE;
        }
        if (oldValue != null) {
            return Boolean.FALSE;
        }
        return null;
    }

    public void detach(Object entity) {
        try {
            this.verifyOpen();
            if (entity == null) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("not_an_entity", new Object[]{entity}));
            }
            ClassDescriptor descriptor = (ClassDescriptor)this.serverSession.getDescriptors().get(entity.getClass());
            if (descriptor == null || descriptor.isAggregateDescriptor() || descriptor.isAggregateCollectionDescriptor()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("not_an_entity", new Object[]{entity}));
            }
            UnitOfWorkImpl uowImpl = (UnitOfWorkImpl)this.getUnitOfWork();
            uowImpl.getDeletedObjects().remove(entity);
            uowImpl.unregisterObject(entity);
        }
        catch (RuntimeException exception) {
            this.setRollbackOnly();
            throw exception;
        }
    }

    public QueryBuilder getQueryBuilder() {
        return this.factory.getQueryBuilder();
    }

    public Metamodel getMetamodel() {
        return this.factory.getMetamodel();
    }

    public EntityManagerFactory getEntityManagerFactory() {
        try {
            this.verifyOpen();
            return this.factory;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public LockModeType getLockMode(Object entity) {
        try {
            this.verifyOpen();
            RepeatableWriteUnitOfWork uowImpl = this.getActivePersistenceContext(this.checkForTransaction(false));
            LockModeType lockMode = LockModeType.NONE;
            if (!this.contains(entity, uowImpl)) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("cant_getLockMode_of_not_managed_object", new Object[]{entity}));
            }
            Boolean optimistickLock = (Boolean)uowImpl.getOptimisticReadLockObjects().get(entity);
            if (optimistickLock != null) {
                lockMode = optimistickLock.equals(Boolean.FALSE) ? LockModeType.OPTIMISTIC : (uowImpl.getPessimisticLockedObjects().get(entity) != null ? LockModeType.PESSIMISTIC_FORCE_INCREMENT : LockModeType.OPTIMISTIC_FORCE_INCREMENT);
            } else if (uowImpl.getPessimisticLockedObjects().get(entity) != null) {
                lockMode = LockModeType.PESSIMISTIC_WRITE;
            }
            return lockMode;
        }
        catch (RuntimeException exception) {
            this.setRollbackOnly();
            throw exception;
        }
    }

    public Map<String, Object> getProperties() {
        HashMap sessionMap = new HashMap(this.getServerSession().getProperties());
        if (this.properties != null) {
            sessionMap.putAll(this.properties);
        }
        return Collections.unmodifiableMap(sessionMap);
    }

    public Set<String> getSupportedProperties() {
        return EntityManagerProperties.getSupportedProperties();
    }

    public <T> T unwrap(Class<T> cls) {
        UnitOfWorkImpl unitOfWork;
        if (cls.equals(UnitOfWork.class)) {
            return (T)this.getUnitOfWork();
        }
        if (cls.equals(JpaEntityManager.class)) {
            return (T)this;
        }
        if (cls.equals(Session.class)) {
            return (T)this.getServerSession();
        }
        if (cls.equals(Connection.class) && !(unitOfWork = (UnitOfWorkImpl)this.getUnitOfWork()).isInTransaction()) {
            unitOfWork.beginEarlyTransaction();
            return (T)unitOfWork.getAccessor().getConnection();
        }
        throw new PersistenceException(ExceptionLocalization.buildMessage("Provider-does-not-support-the-call", null));
    }
}

