/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.MappedById;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.PrimaryKeyJoinColumns;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.indirection.WeavedObjectBasicIndirectionPolicy;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.DerivedIdClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.RelationshipAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.columns.AssociationOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnsMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.mappings.EmbeddableMapping;
import org.eclipse.persistence.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectAccessor
extends RelationshipAccessor {
    private Boolean m_id;
    private Boolean m_isOptional;
    private List<PrimaryKeyJoinColumnMetadata> m_primaryKeyJoinColumns = new ArrayList<PrimaryKeyJoinColumnMetadata>();
    private String m_mappedById;

    protected ObjectAccessor(String xmlElement) {
        super(xmlElement);
    }

    protected ObjectAccessor(MetadataAnnotation annotation, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(annotation, accessibleObject, classAccessor);
        MetadataAnnotation primaryKeyJoinColumn;
        MetadataAnnotation primaryKeyJoinColumns;
        if (annotation != null) {
            this.m_isOptional = (Boolean)annotation.getAttribute("optional");
        }
        if ((primaryKeyJoinColumns = this.getAnnotation(PrimaryKeyJoinColumns.class)) != null) {
            for (Object primaryKeyJoinColumn2 : (Object[])primaryKeyJoinColumns.getAttributeArray("value")) {
                this.m_primaryKeyJoinColumns.add(new PrimaryKeyJoinColumnMetadata((MetadataAnnotation)primaryKeyJoinColumn2, accessibleObject));
            }
        }
        if ((primaryKeyJoinColumn = this.getAnnotation(PrimaryKeyJoinColumn.class)) != null) {
            this.m_primaryKeyJoinColumns.add(new PrimaryKeyJoinColumnMetadata(primaryKeyJoinColumn, accessibleObject));
        }
        if (this.isAnnotationPresent(MappedById.class)) {
            this.m_mappedById = (String)this.getAnnotation(MappedById.class).getAttribute("value");
            if (this.m_mappedById == null) {
                this.m_mappedById = "";
            }
        }
        this.m_id = this.isAnnotationPresent(Id.class);
    }

    @Override
    public String getDefaultFetchType() {
        return FetchType.EAGER.name();
    }

    public Boolean getId() {
        return this.m_id;
    }

    public String getMappedById() {
        return this.m_mappedById;
    }

    public Boolean getOptional() {
        return this.m_isOptional;
    }

    public List<PrimaryKeyJoinColumnMetadata> getPrimaryKeyJoinColumns() {
        return this.m_primaryKeyJoinColumns;
    }

    @Override
    public MetadataClass getReferenceClass() {
        if (this.m_referenceClass == null) {
            this.m_referenceClass = this.getTargetEntity();
            if (this.m_referenceClass.isVoid()) {
                this.m_referenceClass = super.getReferenceClass();
                this.getLogger().logConfigMessage(this.getLoggingContext(), this.getAnnotatedElement(), (Object)this.m_referenceClass);
            }
        }
        return this.m_referenceClass;
    }

    protected MetadataClass getSimplePKType() {
        MetadataDescriptor referenceDescriptor = this.getReferenceDescriptor();
        ClassAccessor referenceAccessor = referenceDescriptor.getClassAccessor();
        if (referenceAccessor.hasDerivedId()) {
            return ((ObjectAccessor)referenceDescriptor.getAccessorFor(referenceDescriptor.getIdAttributeName())).getSimplePKType();
        }
        return referenceDescriptor.getAccessorFor(referenceDescriptor.getIdAttributeName()).getRawClass();
    }

    protected boolean hasMappedById() {
        return this.m_mappedById != null;
    }

    protected OneToOneMapping initOneToOneMapping() {
        OneToOneMapping mapping = new OneToOneMapping();
        mapping.setIsReadOnly(false);
        mapping.setJoinFetch(this.getMappingJoinFetchType(this.getJoinFetch()));
        mapping.setIsOptional(this.isOptional());
        mapping.setAttributeName(this.getAttributeName());
        mapping.setReferenceClassName(this.getReferenceClassName());
        mapping.setIsDerivedIdMapping(this.isDerivedId());
        this.processOrphanRemoval(mapping);
        this.processIndirection(mapping);
        this.setAccessorMethods(mapping);
        this.processCascadeTypes(mapping);
        this.processReturnInsertAndUpdate();
        return mapping;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObjects(this.m_primaryKeyJoinColumns, accessibleObject);
    }

    @Override
    public boolean isDerivedId() {
        return this.m_id != null && this.m_id != false;
    }

    public boolean isOneToOnePrimaryKeyRelationship() {
        return this.isOneToOne() && !this.m_primaryKeyJoinColumns.isEmpty();
    }

    public boolean isOptional() {
        return this.m_isOptional != null && this.m_isOptional != false;
    }

    @Override
    protected void processAssociationOverride(AssociationOverrideMetadata associationOverride, EmbeddableMapping embeddableMapping, MetadataDescriptor owningDescriptor) {
        if (this.getMapping().isOneToOneMapping()) {
            this.processAssociationOverride(associationOverride, embeddableMapping, owningDescriptor.getPrimaryTable());
        } else {
            super.processAssociationOverride(associationOverride, embeddableMapping, owningDescriptor);
        }
    }

    protected void processAssociationOverride(AssociationOverrideMetadata associationOverride, EmbeddableMapping embeddableMapping, DatabaseTable defaultTable) {
        for (JoinColumnMetadata joinColumn : this.getJoinColumnsAndValidate(associationOverride.getJoinColumns(), this.getReferenceDescriptor())) {
            DatabaseField pkField = joinColumn.getPrimaryKeyField();
            pkField.setTable(this.getReferenceDescriptor().getPrimaryKeyTable());
            DatabaseField fkField = ((OneToOneMapping)this.getMapping()).getTargetToSourceKeyFields().get(pkField);
            if (fkField == null) continue;
            DatabaseField translationFKField = joinColumn.getForeignKeyField();
            if (!translationFKField.hasTableName()) {
                translationFKField.setTable(defaultTable);
            }
            embeddableMapping.addFieldNameTranslation(translationFKField.getQualifiedName(), fkField.getName());
        }
    }

    protected void processIndirection(ObjectReferenceMapping mapping) {
        boolean usesIndirection = this.usesIndirection();
        if (usesIndirection && !this.getProject().isWeavingEnabled() && !ClassConstants.PersistenceWeavedLazy_Class.isAssignableFrom(this.getJavaClass(this.getDescriptor().getJavaClass()))) {
            usesIndirection = false;
        }
        if (usesIndirection && this.usesPropertyAccess(this.getDescriptor())) {
            mapping.setIndirectionPolicy(new WeavedObjectBasicIndirectionPolicy(this.getSetMethodName()));
        } else {
            mapping.setUsesIndirection(usesIndirection);
        }
        mapping.setIsLazy(this.isLazy());
    }

    public void processKey(HashSet<ClassAccessor> processing, HashSet<ClassAccessor> processed) {
        MetadataDescriptor referenceDescriptor = this.getReferenceDescriptor();
        ClassAccessor referenceAccessor = referenceDescriptor.getClassAccessor();
        if (!processed.contains(referenceAccessor)) {
            referenceAccessor.processDerivedIDs(processing, processed);
        }
        this.processRelationship();
        String attributeName = this.getAttributeName();
        String keyname = referenceDescriptor.getPKClassName();
        if (keyname != null) {
            String ourpkname = this.getDescriptor().getPKClassName();
            if (ourpkname == null) {
                throw ValidationException.invalidCompositePKSpecification(this.getJavaClass(), ourpkname);
            }
            if (!ourpkname.equals(keyname)) {
                this.getOwningDescriptor().validatePKClassId(attributeName, referenceDescriptor.getPKClass());
            } else {
                this.getOwningDescriptor().getPKClassIDs().clear();
            }
        } else {
            MetadataClass type = null;
            type = referenceAccessor.hasDerivedId() ? ((ObjectAccessor)referenceDescriptor.getAccessorFor(referenceDescriptor.getIdAttributeName())).getSimplePKType() : referenceDescriptor.getAccessorFor(referenceDescriptor.getIdAttributeName()).getRawClass();
            this.getOwningDescriptor().validatePKClassId(attributeName, type);
        }
        this.getOwningDescriptor().addIdAttributeName(attributeName);
        ObjectReferenceMapping mapping = (ObjectReferenceMapping)this.getMapping();
        for (DatabaseField pkField : mapping.getForeignKeyFields()) {
            this.getOwningDescriptor().addPrimaryKeyField(pkField, null);
        }
    }

    protected void processMappedByIdKeys(OneToOneMapping mapping) {
        if (this.m_mappedById.equals("")) {
            if (this.getReferenceDescriptor().hasCompositePrimaryKey()) {
                this.getDescriptor().getEmbeddedIdAccessor().processDerivedIdFields(mapping, this.getReferenceDescriptor());
            } else {
                DatabaseField dependentField = this.getDescriptor().getPrimaryKeyField();
                DatabaseField parentField = this.getReferenceDescriptor().getPrimaryKeyField();
                mapping.addForeignKeyField(dependentField, parentField);
            }
        } else {
            MappingAccessor mappingAccessor = this.getDescriptor().getAccessorFor(this.m_mappedById);
            if (mappingAccessor == null) {
                throw ValidationException.invalidMappedByIdValue(this.m_mappedById, this.getAnnotatedElementName(), this.getDescriptor().getEmbeddedIdAccessor().getReferenceClass());
            }
            if (mappingAccessor.isBasic()) {
                DatabaseField dependentField = mappingAccessor.getMapping().getField();
                DatabaseField parentField = this.getReferenceDescriptor().getPrimaryKeyField();
                mapping.addForeignKeyField(dependentField, parentField);
            } else if (mappingAccessor.isDerivedIdClass()) {
                ((DerivedIdClassAccessor)mappingAccessor).processDerivedIdFields(mapping, this.getReferenceDescriptor());
            }
            mapping.setMappedByIdValue(this.m_mappedById);
        }
        mapping.setIsReadOnly(true);
    }

    protected void processOneToOneForeignKeyRelationship(OneToOneMapping mapping) {
        String defaultPKFieldName = this.getReferenceDescriptor().getPrimaryKeyFieldName();
        String defaultFKFieldName = this.getUpperCaseAttributeName() + "_" + defaultPKFieldName;
        this.processOneToOneForeignKeyRelationship(mapping, this.getJoinColumns(this.getJoinColumns(), this.getReferenceDescriptor()), defaultPKFieldName, this.getReferenceDatabaseTable(), defaultFKFieldName, this.getDescriptor().getPrimaryTable());
    }

    protected void processOneToOnePrimaryKeyRelationship(OneToOneMapping mapping) {
        MetadataDescriptor referenceDescriptor = this.getReferenceDescriptor();
        List<PrimaryKeyJoinColumnMetadata> pkJoinColumns = this.processPrimaryKeyJoinColumns(new PrimaryKeyJoinColumnsMetadata(this.getPrimaryKeyJoinColumns()));
        for (PrimaryKeyJoinColumnMetadata primaryKeyJoinColumn : pkJoinColumns) {
            DatabaseField pkField = primaryKeyJoinColumn.getPrimaryKeyField();
            pkField.setName(this.getName(pkField, referenceDescriptor.getPrimaryKeyFieldName(), "metadata_default_pk_column"));
            pkField.setTable(referenceDescriptor.getPrimaryTable());
            DatabaseField fkField = primaryKeyJoinColumn.getForeignKeyField();
            fkField.setName(this.getName(fkField, this.getDescriptor().getPrimaryKeyFieldName(), "metadata_default_fk_column"));
            fkField.setTable(this.getDescriptor().getPrimaryTable());
            mapping.addForeignKeyField(fkField, pkField);
            mapping.setIsReadOnly(true);
        }
    }

    protected void processOwningMappingKeys(OneToOneMapping mapping) {
        if (this.isOneToOnePrimaryKeyRelationship()) {
            this.processOneToOnePrimaryKeyRelationship(mapping);
        } else {
            this.processOneToOneForeignKeyRelationship(mapping);
        }
    }

    public void setId(Boolean id) {
        this.m_id = id;
    }

    public void setMappedById(String mappedById) {
        this.m_mappedById = mappedById;
    }

    public void setOptional(Boolean isOptional) {
        this.m_isOptional = isOptional;
    }

    public void setPrimaryKeyJoinColumns(List<PrimaryKeyJoinColumnMetadata> primaryKeyJoinColumns) {
        this.m_primaryKeyJoinColumns = primaryKeyJoinColumns;
    }
}

