/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.objects;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataField;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataMethod;
import org.eclipse.persistence.internal.libraries.asm.Attribute;
import org.eclipse.persistence.internal.libraries.asm.ClassReader;
import org.eclipse.persistence.internal.libraries.asm.ClassVisitor;
import org.eclipse.persistence.internal.libraries.asm.CodeVisitor;
import org.eclipse.persistence.internal.libraries.asm.Type;
import org.eclipse.persistence.internal.libraries.asm.attrs.Annotation;
import org.eclipse.persistence.internal.libraries.asm.attrs.RuntimeVisibleAnnotations;
import org.eclipse.persistence.internal.libraries.asm.attrs.RuntimeVisibleParameterAnnotations;
import org.eclipse.persistence.internal.libraries.asm.attrs.SignatureAttribute;

public class MetadataFactory {
    public static final String PRIMITIVES = "VJIBZCSFD";
    public static final String TOKENS = "()<>;";
    protected static Map<String, MetadataClass> metadata;
    public static MetadataLogger logger;
    public static ClassLoader loader;

    public static void main(String[] args) {
        loader = MetadataFactory.class.getClassLoader();
        MetadataFactory.getClassMetadata("org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass");
    }

    public static void clear() {
        metadata = new HashMap<String, MetadataClass>();
        metadata.put("void", new MetadataClass(Void.TYPE));
        metadata.put("", new MetadataClass(Void.TYPE));
        metadata.put(null, new MetadataClass(Void.TYPE));
        metadata.put("int", new MetadataClass(Integer.TYPE));
        metadata.put("long", new MetadataClass(Long.TYPE));
        metadata.put("short", new MetadataClass(Short.TYPE));
        metadata.put("boolean", new MetadataClass(Boolean.TYPE));
        metadata.put("float", new MetadataClass(Float.TYPE));
        metadata.put("double", new MetadataClass(Double.TYPE));
        metadata.put("char", new MetadataClass(Character.TYPE));
        metadata.put("byte", new MetadataClass(Byte.TYPE));
        metadata.put("V", new MetadataClass(Void.TYPE));
        metadata.put("I", new MetadataClass(Integer.TYPE));
        metadata.put("J", new MetadataClass(Long.TYPE));
        metadata.put("S", new MetadataClass(Short.TYPE));
        metadata.put("Z", new MetadataClass(Boolean.TYPE));
        metadata.put("F", new MetadataClass(Float.TYPE));
        metadata.put("D", new MetadataClass(Double.TYPE));
        metadata.put("C", new MetadataClass(Character.TYPE));
        metadata.put("B", new MetadataClass(Byte.TYPE));
    }

    public static String toClassName(String classDescription) {
        if (classDescription == null) {
            return "void";
        }
        return classDescription.replace('/', '.');
    }

    public static MetadataClass getClassMetadata(String className) {
        if (className == null) {
            return null;
        }
        MetadataClass metadataClass = metadata.get(className);
        if (metadataClass == null) {
            MetadataFactory.buildClassMetadata(className);
            metadataClass = metadata.get(className);
        }
        return metadataClass;
    }

    public static void buildClassMetadata(String className) {
        ClassMetadataVisitor visitor = new ClassMetadataVisitor();
        try {
            ClassReader reader = new ClassReader(loader.getResourceAsStream(className.replace('.', '/') + ".class"));
            Attribute[] attributes = new Attribute[]{new RuntimeVisibleAnnotations(), new RuntimeVisibleParameterAnnotations(), new SignatureAttribute()};
            reader.accept(visitor, attributes, false);
        }
        catch (Exception exception) {
            metadata.put(className, new MetadataClass(className));
        }
    }

    static {
        MetadataFactory.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassMetadataVisitor
    implements ClassVisitor {
        MetadataClass classMetadata;

        ClassMetadataVisitor() {
        }

        @Override
        public void visit(int version, int access, String name, String superName, String[] interfaces, String sourceFile) {
            this.classMetadata = new MetadataClass(MetadataFactory.toClassName(name));
            metadata.put(MetadataFactory.toClassName(name), this.classMetadata);
            this.classMetadata.setName(MetadataFactory.toClassName(name));
            this.classMetadata.setSuperclassName(MetadataFactory.toClassName(superName));
            this.classMetadata.setModifiers(access);
            ArrayList<String> interfacesNames = new ArrayList<String>();
            for (String interfaceName : interfaces) {
                interfacesNames.add(MetadataFactory.toClassName(interfaceName));
            }
            this.classMetadata.setInterfaces(interfacesNames);
        }

        @Override
        public void visitInnerClass(String name, String outerName, String innerName, int access) {
        }

        @Override
        public void visitField(int access, String name, String desc, Object value, Attribute attrs) {
            MetadataField field = new MetadataField(logger);
            field.setName(name);
            field.setAttributeName(name);
            field.setGenericType(this.getGenericType(attrs));
            field.setType(this.processDescription(desc, false).get(0));
            field.setModifiers(access);
            this.addAnnotations(attrs, field.getAnnotations());
            this.classMetadata.getFields().put(name, field);
        }

        public List<String> getGenericType(Attribute attrs) {
            if (attrs == null) {
                return null;
            }
            if (attrs instanceof SignatureAttribute) {
                return this.processDescription(((SignatureAttribute)attrs).signature, true);
            }
            return this.getGenericType(attrs.next);
        }

        public String getPrimitiveName(char primitive) {
            if (primitive == 'V') {
                return "void";
            }
            if (primitive == 'I') {
                return "int";
            }
            if (primitive == 'Z') {
                return "boolean";
            }
            if (primitive == 'J') {
                return "long";
            }
            if (primitive == 'F') {
                return "float";
            }
            if (primitive == 'D') {
                return "double";
            }
            if (primitive == 'B') {
                return "byte";
            }
            if (primitive == 'C') {
                return "char";
            }
            if (primitive == 'S') {
                return "short";
            }
            return new String(new char[]{primitive});
        }

        public List<String> processDescription(String desc, boolean isGeneric) {
            ArrayList<String> arguments = new ArrayList<String>();
            for (int index = 0; index < desc.length(); ++index) {
                int start;
                char next = desc.charAt(index);
                if (MetadataFactory.TOKENS.indexOf(next) != -1) continue;
                if (next == 'L') {
                    start = ++index;
                    next = desc.charAt(index);
                    while (MetadataFactory.TOKENS.indexOf(next) == -1) {
                        next = desc.charAt(++index);
                    }
                    arguments.add(MetadataFactory.toClassName(desc.substring(start, index)));
                    continue;
                }
                if (!isGeneric && MetadataFactory.PRIMITIVES.indexOf(next) != -1) {
                    arguments.add(this.getPrimitiveName(next));
                    continue;
                }
                if (next == '[') {
                    start = index++;
                    next = desc.charAt(index);
                    while (next == '[') {
                        next = desc.charAt(++index);
                    }
                    if (MetadataFactory.PRIMITIVES.indexOf(next) == -1) {
                        while (next != ';') {
                            next = desc.charAt(++index);
                        }
                        arguments.add(MetadataFactory.toClassName(desc.substring(start, index + 1)));
                        continue;
                    }
                    arguments.add(desc.substring(start, index + 1));
                    continue;
                }
                arguments.add(new String(new char[]{next}));
            }
            return arguments;
        }

        @Override
        public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
            MetadataMethod method = null;
            if (name.indexOf("init>") != -1) {
                return null;
            }
            List<String> argumentNames = this.processDescription(desc, false);
            method = new MetadataMethod(this.classMetadata, logger);
            method.setName(name);
            method.setAttributeName(Helper.getAttributeNameFromMethodName(name));
            method.setModifiers(access);
            method.setGenericType(this.getGenericType(attrs));
            method.setReturnType(argumentNames.get(argumentNames.size() - 1));
            argumentNames.remove(argumentNames.size() - 1);
            method.setParameters(argumentNames);
            this.addAnnotations(attrs, method.getAnnotations());
            MetadataMethod existing = this.classMetadata.getMethods().get(name);
            if (existing == null) {
                this.classMetadata.getMethods().put(name, method);
            } else {
                while (existing.getNext() != null) {
                    existing = existing.getNext();
                }
                existing.setNext(method);
            }
            return null;
        }

        @Override
        public void visitAttribute(Attribute attr) {
            if (attr instanceof SignatureAttribute) {
                this.classMetadata.setGenericType(this.getGenericType(attr));
            } else {
                this.addAnnotations(attr, this.classMetadata.getAnnotations());
            }
        }

        public void addAnnotations(Attribute attr, Map<String, MetadataAnnotation> annotations) {
            if (!(attr instanceof RuntimeVisibleAnnotations)) {
                return;
            }
            RuntimeVisibleAnnotations visibleAnnotations = (RuntimeVisibleAnnotations)attr;
            for (Annotation visibleAnnotation : visibleAnnotations.annotations) {
                if (visibleAnnotation.type.indexOf("javax/persistence") == -1 && visibleAnnotation.type.indexOf("org/eclipse/persistence") == -1) continue;
                MetadataAnnotation annotation = this.buildAnnotation(visibleAnnotation);
                annotations.put(annotation.getName(), annotation);
            }
        }

        public MetadataAnnotation buildAnnotation(Annotation visibleAnnotation) {
            MetadataAnnotation annotation = new MetadataAnnotation();
            annotation.setName(this.processDescription(visibleAnnotation.type, false).get(0));
            for (Object[] attribute : visibleAnnotation.elementValues) {
                String attributeName = (String)attribute[0];
                Object attributeValue = this.buildAnnotationValue(attribute[1]);
                annotation.getAttributes().put(attributeName, attributeValue);
            }
            return annotation;
        }

        public Object buildAnnotationValue(Object value) {
            if (value instanceof Annotation) {
                return this.buildAnnotation((Annotation)value);
            }
            if (value instanceof Object[]) {
                Object[] values = (Object[])value;
                for (int index = 0; index < values.length; ++index) {
                    values[index] = this.buildAnnotationValue(values[index]);
                }
                return values;
            }
            if (value instanceof Type) {
                return ((Type)value).getClassName();
            }
            if (value instanceof Annotation.EnumConstValue) {
                return ((Annotation.EnumConstValue)value).constName;
            }
            return value;
        }

        @Override
        public void visitEnd() {
        }
    }
}

