/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.columns;

import javax.persistence.DiscriminatorType;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.columns.MetadataHelper;

public class DiscriminatorColumnMetadata
extends ORMetadata {
    private String m_discriminatorType;
    private Integer m_length;
    private String m_columnDefinition;
    private String m_name;

    public DiscriminatorColumnMetadata() {
        super("<discriminator-column>");
    }

    public DiscriminatorColumnMetadata(MetadataAnnotation discriminatorColumn, MetadataAccessibleObject accessibleObject) {
        super(discriminatorColumn, accessibleObject);
        if (discriminatorColumn != null) {
            this.m_columnDefinition = (String)discriminatorColumn.getAttribute("columnDefinition");
            this.m_discriminatorType = (String)discriminatorColumn.getAttribute("discriminatorType");
            this.m_length = (Integer)discriminatorColumn.getAttribute("length");
            this.m_name = (String)discriminatorColumn.getAttribute("name");
        }
    }

    public String getColumnDefinition() {
        return this.m_columnDefinition;
    }

    public String getDiscriminatorType() {
        return this.m_discriminatorType;
    }

    public Integer getLength() {
        return this.m_length;
    }

    public String getName() {
        return this.m_name;
    }

    public DatabaseField process(MetadataDescriptor descriptor, String annotatedElementName, String loggingCtx) {
        DatabaseField field = new DatabaseField();
        field.setName(MetadataHelper.getName(this.m_name, "DTYPE", loggingCtx, descriptor.getLogger(), annotatedElementName));
        field.setLength(MetadataHelper.getValue(this.m_length, 31));
        field.setColumnDefinition(MetadataHelper.getValue(this.m_columnDefinition, ""));
        if (this.m_discriminatorType == null || this.m_discriminatorType.equals(DiscriminatorType.STRING.name())) {
            field.setType(String.class);
        } else if (this.m_discriminatorType.equals(DiscriminatorType.CHAR.name())) {
            field.setType(Character.class);
        } else {
            field.setType(Integer.class);
        }
        field.setTable(descriptor.getPrimaryTable());
        return field;
    }

    public void setColumnDefinition(String columnDefinition) {
        this.m_columnDefinition = columnDefinition;
    }

    public void setDiscriminatorType(String descriminatorType) {
        this.m_discriminatorType = descriminatorType;
    }

    public void setLength(Integer length) {
        this.m_length = length;
    }

    public void setName(String name) {
        this.m_name = name;
    }
}

