/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.columns;

import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;

public class PrimaryKeyJoinColumnMetadata
extends ORMetadata {
    private String m_name;
    private String m_columnDefinition;
    private String m_referencedColumnName;

    public PrimaryKeyJoinColumnMetadata() {
        super("<primary-key-join-column>");
    }

    public PrimaryKeyJoinColumnMetadata(MetadataAnnotation primaryKeyJoinColumn, MetadataAccessibleObject accessibleObject) {
        super(primaryKeyJoinColumn, accessibleObject);
        if (primaryKeyJoinColumn != null) {
            this.m_name = (String)primaryKeyJoinColumn.getAttribute("name");
            this.m_columnDefinition = (String)primaryKeyJoinColumn.getAttribute("columnDefinition");
            this.m_referencedColumnName = (String)primaryKeyJoinColumn.getAttribute("referencedColumnName");
        }
    }

    protected PrimaryKeyJoinColumnMetadata(String xmlElement) {
        super(xmlElement);
    }

    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof PrimaryKeyJoinColumnMetadata) {
            PrimaryKeyJoinColumnMetadata joinColumn = (PrimaryKeyJoinColumnMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_name, joinColumn.getName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_columnDefinition, joinColumn.getColumnDefinition())) {
                return false;
            }
            return this.valuesMatch(this.m_referencedColumnName, joinColumn.getReferencedColumnName());
        }
        return false;
    }

    public String getColumnDefinition() {
        return this.m_columnDefinition;
    }

    public DatabaseField getForeignKeyField() {
        DatabaseField fkField = new DatabaseField();
        fkField.setName(this.m_name == null ? "" : this.m_name);
        fkField.setColumnDefinition(this.m_columnDefinition == null ? "" : this.m_columnDefinition);
        return fkField;
    }

    public String getName() {
        return this.m_name;
    }

    public DatabaseField getPrimaryKeyField() {
        DatabaseField pkField = new DatabaseField();
        pkField.setName(this.m_referencedColumnName == null ? "" : this.m_referencedColumnName);
        return pkField;
    }

    public String getReferencedColumnName() {
        return this.m_referencedColumnName;
    }

    public boolean isForeignKeyFieldNotSpecified() {
        return this.m_name == null || this.m_name.equals("");
    }

    public boolean isPrimaryKeyFieldNotSpecified() {
        return this.m_referencedColumnName == null || this.m_referencedColumnName.equals("");
    }

    public void setColumnDefinition(String columnDefinition) {
        this.m_columnDefinition = columnDefinition;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setReferencedColumnName(String referencedColumnName) {
        this.m_referencedColumnName = referencedColumnName;
    }
}

