/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.converters;

import javax.persistence.EnumType;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.converters.MetadataConverter;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.EnumTypeConverter;

public class EnumeratedMetadata
extends MetadataConverter {
    private String m_enumerated;

    public EnumeratedMetadata() {
        this.m_enumerated = EnumType.ORDINAL.name();
    }

    public EnumeratedMetadata(String xmlElement) {
        super(xmlElement);
    }

    public EnumeratedMetadata(MetadataAnnotation enumerated, MetadataAccessibleObject accessibleObject) {
        super(enumerated, accessibleObject);
        this.m_enumerated = (String)enumerated.getAttribute("value");
    }

    public String getEnumerated() {
        return this.m_enumerated;
    }

    public static boolean isValidEnumeratedType(MetadataClass cls) {
        return cls.isEnum();
    }

    public void process(DatabaseMapping mapping, MappingAccessor accessor, MetadataClass referenceClass, boolean isForMapKey) {
        if (!EnumeratedMetadata.isValidEnumeratedType(referenceClass)) {
            throw ValidationException.invalidTypeForEnumeratedAttribute(mapping.getAttributeName(), referenceClass, accessor.getJavaClass());
        }
        boolean isOrdinal = true;
        if (this.m_enumerated != null) {
            isOrdinal = this.m_enumerated.equals(EnumType.ORDINAL.name());
        }
        this.setConverter(mapping, new EnumTypeConverter(mapping, this.getJavaClass(referenceClass), isOrdinal), isForMapKey);
    }

    public void setEnumerated(String enumerated) {
        this.m_enumerated = enumerated;
    }
}

