/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metamodel;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.CollectionAttribute;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.ListAttribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SetAttribute;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.internal.jpa.metamodel.AttributeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.CollectionAttributeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.EmbeddableTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.EntityTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.ListAttributeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.MapAttributeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.MetamodelImpl;
import org.eclipse.persistence.internal.jpa.metamodel.SetAttributeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.SingularAttributeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.TypeImpl;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedTypeImpl<X>
extends TypeImpl<X>
implements ManagedType<X> {
    private RelationalDescriptor descriptor;
    protected IdentifiableType<? super X> supertype;
    protected Map<String, AttributeImpl> members;
    protected MetamodelImpl metamodel;

    protected ManagedTypeImpl(MetamodelImpl metamodel, RelationalDescriptor descriptor) {
        super(descriptor.getJavaClass());
        this.metamodel = metamodel;
        this.descriptor = descriptor;
        descriptor.setProperty(this.getClass().getName(), this);
        this.initialize();
    }

    public Map<String, AttributeImpl> getMembers() {
        return this.members;
    }

    public MetamodelImpl getMetamodel() {
        return this.metamodel;
    }

    public RelationalDescriptor getDescriptor() {
        return this.descriptor;
    }

    public IdentifiableType<? super X> getSupertype() {
        return this.supertype;
    }

    protected void setSupertype(IdentifiableType<? super X> supertype) {
        this.supertype = supertype;
    }

    private void initialize() {
        this.members = new HashMap<String, AttributeImpl>();
        for (DatabaseMapping mapping : this.getDescriptor().getMappings()) {
            CollectionMapping colMapping;
            AttributeImpl member = null;
            member = mapping.isCollectionMapping() ? ((colMapping = (CollectionMapping)mapping).getContainerPolicy().isMapPolicy() ? new MapAttributeImpl(this, colMapping) : (colMapping.getContainerPolicy().isListPolicy() ? new ListAttributeImpl(this, colMapping) : (colMapping.getContainerPolicy().getContainerClass().isAssignableFrom(Set.class) ? new SetAttributeImpl(this, colMapping) : new CollectionAttributeImpl(this, colMapping)))) : new SingularAttributeImpl(this, mapping);
            this.members.put(mapping.getAttributeName(), member);
        }
    }

    public static ManagedTypeImpl<?> create(MetamodelImpl metamodel, RelationalDescriptor descriptor) {
        ManagedTypeImpl managedType = (EmbeddableTypeImpl)descriptor.getProperty(ManagedTypeImpl.class.getName());
        if (managedType == null) {
            if (descriptor.isAggregateDescriptor()) {
                managedType = new EmbeddableTypeImpl(metamodel, descriptor);
            }
            managedType = new EntityTypeImpl(metamodel, descriptor);
        }
        return managedType;
    }

    public String toString() {
        return "ManagedType[" + this.getDescriptor() + "]";
    }

    @Override
    public Type.PersistenceType getPersistenceType() {
        return null;
    }

    @Override
    public Set<Attribute<? super X, ?>> getAttributes() {
        return new HashSet(this.members.values());
    }

    @Override
    public <E> CollectionAttribute<? super X, E> getCollection(String name, Class<E> elementType) {
        return null;
    }

    @Override
    public CollectionAttribute<? super X, ?> getCollection(String name) {
        return null;
    }

    @Override
    public Set<PluralAttribute<? super X, ?, ?>> getCollections() {
        return null;
    }

    @Override
    public Set<Attribute<X, ?>> getDeclaredAttributes() {
        return new HashSet(this.members.values());
    }

    @Override
    public <E> CollectionAttribute<X, E> getDeclaredCollection(String name, Class<E> elementType) {
        return null;
    }

    @Override
    public CollectionAttribute<X, ?> getDeclaredCollection(String name) {
        return null;
    }

    @Override
    public Set<PluralAttribute<X, ?, ?>> getDeclaredCollections() {
        return null;
    }

    @Override
    public <E> ListAttribute<X, E> getDeclaredList(String name, Class<E> elementType) {
        return null;
    }

    @Override
    public ListAttribute<X, ?> getDeclaredList(String name) {
        return null;
    }

    @Override
    public <K, V> MapAttribute<X, K, V> getDeclaredMap(String name, Class<K> keyType, Class<V> valueType) {
        return null;
    }

    @Override
    public MapAttribute<X, ?, ?> getDeclaredMap(String name) {
        return null;
    }

    @Override
    public <E> SetAttribute<X, E> getDeclaredSet(String name, Class<E> elementType) {
        return null;
    }

    @Override
    public SetAttribute<X, ?> getDeclaredSet(String name) {
        return null;
    }

    @Override
    public <Y> SingularAttribute<X, Y> getDeclaredSingularAttribute(String name, Class<Y> type) {
        return null;
    }

    @Override
    public SingularAttribute<X, ?> getDeclaredSingularAttribute(String name) {
        return null;
    }

    @Override
    public Set<SingularAttribute<X, ?>> getDeclaredSingularAttributes() {
        return null;
    }

    @Override
    public <E> ListAttribute<? super X, E> getList(String name, Class<E> elementType) {
        return null;
    }

    @Override
    public ListAttribute<? super X, ?> getList(String name) {
        return null;
    }

    @Override
    public <K, V> MapAttribute<? super X, K, V> getMap(String name, Class<K> keyType, Class<V> valueType) {
        return null;
    }

    @Override
    public MapAttribute<? super X, ?, ?> getMap(String name) {
        return null;
    }

    @Override
    public <E> SetAttribute<? super X, E> getSet(String name, Class<E> elementType) {
        return null;
    }

    @Override
    public SetAttribute<? super X, ?> getSet(String name) {
        return null;
    }

    @Override
    public <Y> SingularAttribute<? super X, Y> getSingularAttribute(String name, Class<Y> type) {
        AttributeImpl member = this.getMembers().get(name);
        if (member != null && member.isAttribute()) {
            return (SingularAttribute)((Object)member);
        }
        return null;
    }

    @Override
    public SingularAttribute<? super X, ?> getSingularAttribute(String name) {
        AttributeImpl member = this.getMembers().get(name);
        if (member != null && !member.isAttribute()) {
            return (SingularAttribute)((Object)member);
        }
        return null;
    }

    @Override
    public Set<SingularAttribute<? super X, ?>> getSingularAttributes() {
        return null;
    }
}

