/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metamodel;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.Type;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.internal.jpa.metamodel.BasicImpl;
import org.eclipse.persistence.internal.jpa.metamodel.EmbeddableTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.EntityTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.ManagedTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.MappedSuperclassTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.TypeImpl;
import org.eclipse.persistence.jpa.JpaHelper;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetamodelImpl
implements Metamodel {
    protected DatabaseSession session;
    protected Map<Class, EntityTypeImpl<?>> entities;
    protected Map<Class, EmbeddableTypeImpl<?>> embeddables;
    protected Map<Class, ManagedTypeImpl<?>> managedTypes;
    private Map<Class, TypeImpl<?>> types;
    private Set<MappedSuperclassTypeImpl<?>> mappedSuperclasses;

    public MetamodelImpl(DatabaseSession session) {
        this.session = session;
        this.initialize();
    }

    public MetamodelImpl(EntityManagerFactory emf) {
        this(JpaHelper.getServerSession(emf));
    }

    public MetamodelImpl(EntityManager em) {
        this(JpaHelper.getEntityManager(em).getServerSession());
    }

    public DatabaseSession getSession() {
        return this.session;
    }

    @Override
    public <X> EmbeddableType<X> embeddable(Class<X> clazz) {
        return this.embeddables.get(clazz);
    }

    @Override
    public <X> EntityType<X> entity(Class<X> clazz) {
        return this.entities.get(clazz);
    }

    @Override
    public <X> ManagedType<X> type(Class<X> clazz) {
        return this.managedTypes.get(clazz);
    }

    @Override
    public Set<EmbeddableType<?>> getEmbeddables() {
        return new LinkedHashSet(this.embeddables.values());
    }

    @Override
    public Set<EntityType<?>> getEntities() {
        return new LinkedHashSet(this.entities.values());
    }

    @Override
    public Set<ManagedType<?>> getManagedTypes() {
        return new LinkedHashSet(this.managedTypes.values());
    }

    private void initialize() {
        this.types = new LinkedHashMap();
        this.entities = new LinkedHashMap();
        this.embeddables = new LinkedHashMap();
        this.managedTypes = new LinkedHashMap();
        this.mappedSuperclasses = new HashSet();
        for (RelationalDescriptor descriptor : this.session.getDescriptors().values()) {
            ManagedTypeImpl<?> managedType = ManagedTypeImpl.create(this, descriptor);
            this.types.put(managedType.getJavaType(), managedType);
            this.managedTypes.put(managedType.getJavaType(), managedType);
            if (managedType.getPersistenceType().equals((Object)Type.PersistenceType.ENTITY)) {
                this.entities.put(managedType.getJavaType(), (EntityTypeImpl)managedType);
            }
            if (!managedType.getPersistenceType().equals((Object)Type.PersistenceType.EMBEDDABLE)) continue;
            this.embeddables.put(managedType.getJavaType(), (EmbeddableTypeImpl)managedType);
        }
        try {
            Project project = this.session.getProject();
            Set<RelationalDescriptor> descriptors = project.getMappedSuperclassDescriptors();
            for (RelationalDescriptor descriptor : descriptors) {
                MappedSuperclassTypeImpl mappedSuperclassType = new MappedSuperclassTypeImpl(descriptor);
                this.mappedSuperclasses.add(mappedSuperclassType);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (ManagedTypeImpl<?> managedType : this.managedTypes.values()) {
            Class aClass = managedType.getJavaType();
            Class superclass = aClass.getSuperclass();
            ManagedType managedTypeSuperclass = this.managedTypes.get(superclass);
            if (null == managedTypeSuperclass || !(managedTypeSuperclass instanceof IdentifiableType)) continue;
            managedType.setSupertype((IdentifiableType)managedTypeSuperclass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeImpl<?> getType(Class javaClass) {
        TypeImpl<?> type = this.types.get(javaClass);
        if (type == null) {
            Map<Class, TypeImpl<?>> map = this.types;
            synchronized (map) {
                type = this.types.get(javaClass);
                type = new BasicImpl(javaClass);
                this.types.put(javaClass, type);
            }
        }
        return type;
    }

    public Set<MappedSuperclassTypeImpl<?>> getMappedSuperclasses() {
        return this.mappedSuperclasses;
    }

    public void setMappedSuperclasses(Set<MappedSuperclassTypeImpl<?>> mappedSuperclasses) {
        this.mappedSuperclasses = mappedSuperclasses;
    }
}

