/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.bind.Binder;
import javax.xml.bind.Marshaller;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.Validator;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.JAXBException;
import org.eclipse.persistence.internal.jaxb.JAXBSchemaOutputResolver;
import org.eclipse.persistence.internal.oxm.schema.SchemaModelGenerator;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jaxb.JAXBBinder;
import org.eclipse.persistence.jaxb.JAXBIntrospector;
import org.eclipse.persistence.jaxb.JAXBMarshaller;
import org.eclipse.persistence.jaxb.JAXBUnmarshaller;
import org.eclipse.persistence.jaxb.JAXBValidator;
import org.eclipse.persistence.jaxb.compiler.Generator;
import org.eclipse.persistence.jaxb.compiler.MarshalCallback;
import org.eclipse.persistence.jaxb.compiler.UnmarshalCallback;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.sessions.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBContext
extends javax.xml.bind.JAXBContext {
    private XMLContext xmlContext;
    private Generator generator;
    private HashMap<QName, Class> qNameToGeneratedClasses;
    private HashMap<QName, Class> qNamesToDeclaredClasses;

    public JAXBContext(XMLContext context) {
        this.xmlContext = context;
    }

    public JAXBContext(XMLContext context, Generator generator) {
        this.xmlContext = context;
        this.generator = generator;
        this.qNameToGeneratedClasses = generator.getMappingsGenerator().getQNamesToGeneratedClasses();
        this.qNamesToDeclaredClasses = generator.getMappingsGenerator().getQNamesToDeclaredClasses();
    }

    public XMLContext getXMLContext() {
        return this.xmlContext;
    }

    public void generateSchema(SchemaOutputResolver outputResolver) {
        if (this.generator == null) {
            ArrayList<XMLDescriptor> descriptorsToProcess = new ArrayList<XMLDescriptor>();
            List sessions = this.xmlContext.getSessions();
            for (Session session : sessions) {
                Vector descriptors = session.getProject().getOrderedDescriptors();
                for (XMLDescriptor xDesc : descriptors) {
                    descriptorsToProcess.add(xDesc);
                }
            }
            SchemaModelGenerator smGen = new SchemaModelGenerator();
            smGen.generateSchemas(descriptorsToProcess, null, new JAXBSchemaOutputResolver(outputResolver));
        } else {
            this.generator.generateSchemaFiles(outputResolver, null);
        }
    }

    public Marshaller createMarshaller() {
        JAXBMarshaller marshaller = new JAXBMarshaller(this.xmlContext.createMarshaller(), new JAXBIntrospector(this.xmlContext));
        if (this.generator != null && this.generator.hasMarshalCallbacks()) {
            Iterator callIt = this.generator.getMarshalCallbacks().keySet().iterator();
            while (callIt.hasNext()) {
                MarshalCallback cb = (MarshalCallback)this.generator.getMarshalCallbacks().get(callIt.next());
                cb.initialize(this.generator.getClass().getClassLoader());
            }
            marshaller.setMarshalCallbacks(this.generator.getMarshalCallbacks());
        }
        marshaller.setQNameToGeneratedClasses(this.qNameToGeneratedClasses);
        return marshaller;
    }

    public Unmarshaller createUnmarshaller() {
        JAXBUnmarshaller unmarshaller = new JAXBUnmarshaller(this.xmlContext.createUnmarshaller());
        if (this.generator != null && this.generator.hasUnmarshalCallbacks()) {
            Iterator callIt = this.generator.getUnmarshalCallbacks().keySet().iterator();
            while (callIt.hasNext()) {
                UnmarshalCallback cb = (UnmarshalCallback)this.generator.getUnmarshalCallbacks().get(callIt.next());
                cb.initialize(this.generator.getClass().getClassLoader());
            }
            unmarshaller.setUnmarshalCallbacks(this.generator.getUnmarshalCallbacks());
        }
        unmarshaller.setQNamesToDeclaredClasses(this.qNamesToDeclaredClasses);
        return unmarshaller;
    }

    public Validator createValidator() {
        return new JAXBValidator(this.xmlContext.createValidator());
    }

    public Binder createBinder() {
        return new JAXBBinder(this.xmlContext);
    }

    public Binder createBinder(Class nodeClass) {
        if (nodeClass.getName().equals("org.w3c.dom.Node")) {
            return new JAXBBinder(this.xmlContext);
        }
        throw new UnsupportedOperationException(JAXBException.unsupportedNodeClass(nodeClass.getName()));
    }

    public JAXBIntrospector createJAXBIntrospector() {
        return new JAXBIntrospector(this.xmlContext);
    }

    public void setQNameToGeneratedClasses(HashMap<QName, Class> qNameToClass) {
        this.qNameToGeneratedClasses = qNameToClass;
    }

    public void applyORMMetadata(AbstractSession ormSession) {
        this.xmlContext.applyORMMetadata(ormSession);
    }

    public HashMap<QName, Class> getQNamesToDeclaredClasses() {
        return this.qNamesToDeclaredClasses;
    }

    public void setQNamesToDeclaredClasses(HashMap<QName, Class> nameToDeclaredClasses) {
        this.qNamesToDeclaredClasses = nameToDeclaredClasses;
    }
}

