/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBException;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.SessionLoaderException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.jaxb.JaxbClassLoader;
import org.eclipse.persistence.internal.jaxb.SessionEventListener;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.jaxb.compiler.Generator;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaModelImpl;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaModelInputImpl;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.sessions.Project;

public class JAXBContextFactory {
    public static javax.xml.bind.JAXBContext createContext(Class[] classesToBeBound, Map properties) throws JAXBException {
        ClassLoader loader = null;
        if (classesToBeBound.length > 0 && null == (loader = classesToBeBound[0].getClassLoader())) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        return JAXBContextFactory.createContext(classesToBeBound, properties, loader);
    }

    public static javax.xml.bind.JAXBContext createContext(Class[] classesToBeBound, Map properties, ClassLoader classLoader) throws JAXBException {
        JAXBContext jaxbContext = null;
        XMLContext xmlContext = null;
        JaxbClassLoader loader = new JaxbClassLoader(classLoader);
        try {
            Generator generator = new Generator(new JavaModelInputImpl(classesToBeBound, new JavaModelImpl(loader)));
            Project proj = generator.generateProject();
            ConversionManager conversionManager = null;
            if (classLoader != null) {
                conversionManager = new ConversionManager();
                conversionManager.setLoader(loader);
            } else {
                conversionManager = ConversionManager.getDefaultManager();
            }
            proj.convertClassNamesToClasses(conversionManager.getLoader());
            for (ClassDescriptor descriptor : proj.getOrderedDescriptors()) {
                if (descriptor.getJavaClass() != null) continue;
                descriptor.setJavaClass(conversionManager.convertClassNameToClass(descriptor.getJavaClassName()));
            }
            SessionEventListener eventListener = new SessionEventListener();
            eventListener.setShouldValidateInstantiationPolicy(false);
            xmlContext = new XMLContext(proj, (ClassLoader)loader, eventListener);
            jaxbContext = new JAXBContext(xmlContext, generator);
        }
        catch (Exception ex) {
            throw new JAXBException(ex.getMessage(), (Throwable)ex);
        }
        return jaxbContext;
    }

    public static javax.xml.bind.JAXBContext createContext(String contextPath, ClassLoader classLoader) throws JAXBException {
        EclipseLinkException sessionLoadingException = null;
        try {
            XMLContext xmlContext = new XMLContext(contextPath, classLoader);
            return new JAXBContext(xmlContext);
        }
        catch (ValidationException vex) {
            if (vex.getErrorCode() != 7095) {
                sessionLoadingException = vex;
            }
        }
        catch (SessionLoaderException ex) {
            sessionLoadingException = ex;
        }
        catch (Exception ex) {
            throw new JAXBException((Throwable)ex);
        }
        ArrayList classes = new ArrayList();
        StringTokenizer tokenizer = new StringTokenizer(contextPath, ":");
        while (tokenizer.hasMoreElements()) {
            InputStream jaxbIndex;
            String path = tokenizer.nextToken();
            try {
                Class<?> objectFactory = classLoader.loadClass(path + ".ObjectFactory");
                if (JAXBContextFactory.isJAXB2ObjectFactory(objectFactory)) {
                    classes.add(objectFactory);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                classLoader.loadClass(path + ".package-info");
            }
            catch (Exception ex) {
                // empty catch block
            }
            if ((jaxbIndex = classLoader.getResourceAsStream(path.replace('.', '/') + "/jaxb.index")) == null) continue;
            BufferedReader reader = new BufferedReader(new InputStreamReader(jaxbIndex));
            try {
                String line = reader.readLine();
                while (line != null) {
                    String className = path + "." + line.trim();
                    try {
                        classes.add(classLoader.loadClass(className));
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    line = reader.readLine();
                }
            }
            catch (Exception ex) {
            }
        }
        if (classes.size() == 0) {
            org.eclipse.persistence.exceptions.JAXBException jaxbException = org.eclipse.persistence.exceptions.JAXBException.noObjectFactoryOrJaxbIndexInPath(contextPath);
            if (sessionLoadingException != null) {
                jaxbException.setInternalException(sessionLoadingException);
            }
            throw new JAXBException((Throwable)jaxbException);
        }
        Class[] classArray = new Class[classes.size()];
        for (int i = 0; i < classes.size(); ++i) {
            classArray[i] = (Class)classes.get(i);
        }
        return JAXBContextFactory.createContext(classArray, null, classLoader);
    }

    private static boolean isJAXB2ObjectFactory(Class objectFactoryClass) {
        try {
            Class xmlRegistry = PrivilegedAccessHelper.getClassForName("javax.xml.bind.annotation.XmlRegistry");
            return objectFactoryClass.isAnnotationPresent(xmlRegistry);
        }
        catch (Exception ex) {
            return false;
        }
    }
}

