/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import java.awt.Image;
import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorOrder;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttachmentRef;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementDecl;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlMimeType;
import javax.xml.bind.annotation.XmlMixed;
import javax.xml.bind.annotation.XmlNs;
import javax.xml.bind.annotation.XmlNsForm;
import javax.xml.bind.annotation.XmlRegistry;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlSchemaTypes;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapters;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.eclipse.persistence.exceptions.JAXBException;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.jaxb.compiler.AnyProperty;
import org.eclipse.persistence.jaxb.compiler.ChoiceProperty;
import org.eclipse.persistence.jaxb.compiler.ElementDeclaration;
import org.eclipse.persistence.jaxb.compiler.EnumTypeInfo;
import org.eclipse.persistence.jaxb.compiler.MarshalCallback;
import org.eclipse.persistence.jaxb.compiler.NamespaceInfo;
import org.eclipse.persistence.jaxb.compiler.Property;
import org.eclipse.persistence.jaxb.compiler.ReferenceProperty;
import org.eclipse.persistence.jaxb.compiler.SchemaTypeInfo;
import org.eclipse.persistence.jaxb.compiler.TypeInfo;
import org.eclipse.persistence.jaxb.compiler.UnmarshalCallback;
import org.eclipse.persistence.jaxb.javamodel.Helper;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaConstructor;
import org.eclipse.persistence.jaxb.javamodel.JavaField;
import org.eclipse.persistence.jaxb.javamodel.JavaHasAnnotations;
import org.eclipse.persistence.jaxb.javamodel.JavaMethod;
import org.eclipse.persistence.jaxb.javamodel.JavaPackage;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationsProcessor {
    private static final String JAVAX_ACTIVATION_DATAHANDLER = "javax.activation.DataHandler";
    private static final String JAVAX_MAIL_INTERNET_MIMEMULTIPART = "javax.mail.internet.MimeMultipart";
    private ArrayList<JavaClass> typeInfoClasses;
    private HashMap<String, NamespaceInfo> packageToNamespaceMappings;
    private HashMap<String, MarshalCallback> marshalCallbacks;
    private HashMap<String, QName> userDefinedSchemaTypes;
    private HashMap<String, TypeInfo> typeInfo;
    private ArrayList<QName> typeQNames;
    private HashMap<String, UnmarshalCallback> unmarshalCallbacks;
    private HashMap<QName, ElementDeclaration> globalElements;
    private HashMap<String, ElementDeclaration> xmlRootElements;
    private HashMap<String, JavaMethod> factoryMethods;
    private NamespaceResolver namespaceResolver;
    private Helper helper;
    private ArrayList<Property> xmlIdRefProps;

    public AnnotationsProcessor(Helper helper) {
        this.helper = helper;
    }

    public void processClassesAndProperties(JavaClass[] classes) {
        this.typeInfoClasses = new ArrayList();
        this.typeInfo = new HashMap();
        this.typeQNames = new ArrayList();
        this.userDefinedSchemaTypes = new HashMap();
        this.packageToNamespaceMappings = new HashMap();
        this.factoryMethods = new HashMap();
        this.namespaceResolver = new NamespaceResolver();
        this.xmlRootElements = new HashMap();
        this.xmlIdRefProps = new ArrayList();
        ArrayList<JavaClass> classesToProcess = new ArrayList<JavaClass>();
        for (JavaClass javaClass : classes) {
            if (!this.shouldGenerateTypeInfo(javaClass)) continue;
            if (this.helper.isAnnotationPresent(javaClass, XmlRegistry.class)) {
                this.processObjectFactory(javaClass, classesToProcess);
                continue;
            }
            classesToProcess.add(javaClass);
            Class xmlSeeAlsoClass = null;
            Method valueMethod = null;
            try {
                xmlSeeAlsoClass = PrivilegedAccessHelper.getClassForName("javax.xml.bind.annotation.XmlSeeAlso");
                valueMethod = PrivilegedAccessHelper.getDeclaredMethod(xmlSeeAlsoClass, "value", new Class[0]);
            }
            catch (ClassNotFoundException ex) {
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
            if (xmlSeeAlsoClass != null && this.helper.isAnnotationPresent(javaClass, xmlSeeAlsoClass)) {
                Annotation seeAlso = this.helper.getAnnotation(javaClass, xmlSeeAlsoClass);
                Class[] values = null;
                try {
                    values = (Class[])PrivilegedAccessHelper.invokeMethod(valueMethod, seeAlso, new Object[0]);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                for (Class next : values) {
                    classesToProcess.add(this.helper.getJavaClass(next));
                }
            }
            for (JavaClass innerClass : javaClass.getDeclaredClasses()) {
                if (!this.shouldGenerateTypeInfo(innerClass) || this.helper.isAnnotationPresent(innerClass, XmlTransient.class)) continue;
                classesToProcess.add(innerClass);
            }
        }
        this.updateGlobalElements(classesToProcess);
        for (JavaClass javaClass : classesToProcess) {
            if (javaClass == null) continue;
            this.createTypeInfoFor(javaClass);
            JavaClass superClass = javaClass.getSuperclass();
            if (!this.shouldGenerateTypeInfo(superClass)) continue;
            this.createTypeInfoFor(superClass);
        }
        this.checkForCallbackMethods();
        for (Property property : this.xmlIdRefProps) {
            TypeInfo tInfo;
            JavaClass typeClass = property.getType();
            if (typeClass.isArray()) {
                typeClass = typeClass.getComponentType();
            } else if (this.isCollectionType(typeClass)) {
                typeClass = property.getGenericType();
            }
            if ((tInfo = this.typeInfo.get(typeClass.getQualifiedName())) == null || tInfo.getIDProperty() != null) continue;
            throw JAXBException.invalidIdRef(property.getPropertyName(), typeClass.getQualifiedName());
        }
    }

    public SchemaTypeInfo addClass(JavaClass javaClass) {
        if (javaClass == null) {
            return null;
        }
        if (this.helper.isAnnotationPresent(javaClass, XmlTransient.class)) {
            return null;
        }
        if (this.typeInfo == null) {
            this.typeInfoClasses = new ArrayList();
            this.typeInfo = new HashMap();
            this.typeQNames = new ArrayList();
            this.userDefinedSchemaTypes = new HashMap();
            this.packageToNamespaceMappings = new HashMap();
            this.namespaceResolver = new NamespaceResolver();
        }
        TypeInfo info = this.createTypeInfoFor(javaClass);
        JavaPackage pack = javaClass.getPackage();
        NamespaceInfo namespaceInfo = this.packageToNamespaceMappings.get(pack.getQualifiedName());
        SchemaTypeInfo schemaInfo = new SchemaTypeInfo();
        schemaInfo.setSchemaTypeName(new QName(info.getClassNamespace(), info.getSchemaTypeName()));
        if (this.helper.isAnnotationPresent(javaClass, XmlRootElement.class)) {
            int idx;
            char ch;
            XmlRootElement rootElemAnnotation = (XmlRootElement)this.helper.getAnnotation(javaClass, XmlRootElement.class);
            String elementName = rootElemAnnotation.name();
            if ((elementName.equals("##default") || elementName.equals("")) && (elementName = javaClass.getName().indexOf("$") != -1 ? Introspector.decapitalize(javaClass.getName().substring(javaClass.getName().lastIndexOf(36) + 1)) : Introspector.decapitalize(javaClass.getName().substring(javaClass.getName().lastIndexOf(46) + 1))).length() >= 3 && Character.isDigit(ch = elementName.charAt((idx = elementName.length() - 1) - 1))) {
                char lastCh = Character.toUpperCase(elementName.charAt(idx));
                elementName = elementName.substring(0, idx) + lastCh;
            }
            String rootNamespace = rootElemAnnotation.namespace();
            QName rootElemName = null;
            rootElemName = rootNamespace.equals("##default") ? new QName(namespaceInfo.getNamespace(), elementName) : new QName(rootNamespace, elementName);
            schemaInfo.getGlobalElementDeclarations().add(rootElemName);
            ElementDeclaration declaration = new ElementDeclaration(rootElemName, javaClass, javaClass.getRawName(), false);
            this.globalElements.put(rootElemName, declaration);
        }
        return schemaInfo;
    }

    public TypeInfo createTypeInfoFor(JavaClass javaClass) {
        JavaConstructor zeroArgConstructor;
        JavaClass superClass;
        JavaClass boundType;
        JavaClass adapterClass;
        XmlJavaTypeAdapters adapters;
        JavaPackage pack;
        JavaMethod factoryMethod;
        if (javaClass == null) {
            return null;
        }
        if (this.typeInfo.containsKey(javaClass.getQualifiedName())) {
            return this.typeInfo.get(javaClass.getQualifiedName());
        }
        TypeInfo info = null;
        info = javaClass.isEnum() ? new EnumTypeInfo(this.helper) : new TypeInfo(this.helper);
        if (this.helper.isAnnotationPresent(javaClass, XmlTransient.class)) {
            info.setTransient(true);
        }
        if ((factoryMethod = this.factoryMethods.get(javaClass.getRawName())) != null) {
            info.setFactoryMethodName(factoryMethod.getName());
            info.setObjectFactoryClassName(factoryMethod.getOwningClass().getRawName());
            JavaClass[] paramTypes = factoryMethod.getParameterTypes();
            if (paramTypes != null && paramTypes.length > 0) {
                String[] paramTypeNames = new String[paramTypes.length];
                for (int i = 0; i < paramTypes.length; ++i) {
                    paramTypeNames[i] = paramTypes[i].getRawName();
                }
                info.setFactoryMethodParamTypes(paramTypeNames);
            }
        }
        if (this.helper.isAnnotationPresent(pack = javaClass.getPackage(), XmlJavaTypeAdapters.class)) {
            XmlJavaTypeAdapter[] adapterArray;
            adapters = (XmlJavaTypeAdapters)this.helper.getAnnotation(pack, XmlJavaTypeAdapters.class);
            for (XmlJavaTypeAdapter next : adapterArray = adapters.value()) {
                adapterClass = this.helper.getJavaClass(next.value());
                boundType = this.helper.getJavaClass(next.type());
                if (boundType == null) continue;
                info.addAdapterClass(adapterClass, boundType);
            }
        }
        if (this.helper.isAnnotationPresent(javaClass, XmlJavaTypeAdapters.class)) {
            XmlJavaTypeAdapter[] adapterArray;
            adapters = (XmlJavaTypeAdapters)this.helper.getAnnotation(javaClass, XmlJavaTypeAdapters.class);
            for (XmlJavaTypeAdapter next : adapterArray = adapters.value()) {
                adapterClass = this.helper.getJavaClass(next.value());
                boundType = this.helper.getJavaClass(next.type());
                if (boundType == null) continue;
                info.addAdapterClass(adapterClass, boundType);
            }
        }
        NamespaceInfo packageNamespace = this.getNamespaceInfoForPackage(pack);
        if (this.helper.isAnnotationPresent(pack, XmlSchemaTypes.class)) {
            XmlSchemaType[] typeArray;
            XmlSchemaTypes types = (XmlSchemaTypes)this.helper.getAnnotation(pack, XmlSchemaTypes.class);
            for (XmlSchemaType next : typeArray = types.value()) {
                this.processSchemaType(next);
            }
        } else if (this.helper.isAnnotationPresent(pack, XmlSchemaType.class)) {
            this.processSchemaType((XmlSchemaType)this.helper.getAnnotation(pack, XmlSchemaType.class));
        }
        String[] propOrder = new String[]{""};
        String typeName = "";
        if (this.helper.isAnnotationPresent(javaClass, XmlType.class)) {
            String factoryMethodName;
            XmlType typeAnnotation = (XmlType)this.helper.getAnnotation(javaClass, XmlType.class);
            typeName = typeAnnotation.name();
            if (typeName.equals("##default")) {
                typeName = this.getSchemaTypeNameForClassName(javaClass.getName());
            }
            propOrder = typeAnnotation.propOrder();
            if (!typeAnnotation.namespace().equals("##default")) {
                info.setClassNamespace(typeAnnotation.namespace());
            } else {
                info.setClassNamespace(packageNamespace.getNamespace());
            }
            Class factoryClass = typeAnnotation.factoryClass();
            if (factoryClass != XmlType.DEFAULT.class) {
                factoryMethodName = typeAnnotation.factoryMethod();
                if (factoryMethodName == null || factoryMethodName.equals("")) {
                    throw JAXBException.factoryClassWithoutFactoryMethod(javaClass.getName());
                }
                info.setFactoryMethodName(factoryMethodName);
                info.setObjectFactoryClassName(factoryClass.getCanonicalName());
            } else {
                factoryMethodName = typeAnnotation.factoryMethod();
                if (factoryMethodName != null && !factoryMethodName.equals("")) {
                    JavaMethod method = javaClass.getDeclaredMethod(factoryMethodName, new JavaClass[0]);
                    if (method == null) {
                        throw JAXBException.factoryMethodNotDeclared(factoryMethodName, javaClass.getName());
                    }
                    info.setFactoryMethodName(factoryMethodName);
                    info.setObjectFactoryClassName(javaClass.getRawName());
                }
            }
        } else {
            typeName = this.getSchemaTypeNameForClassName(javaClass.getName());
            info.setClassNamespace(packageNamespace.getNamespace());
        }
        info.setPropOrder(propOrder);
        info.setSchemaTypeName(typeName);
        if (info.isEnumerationType()) {
            this.addEnumTypeInfo(javaClass, (EnumTypeInfo)info);
            return info;
        }
        this.typeInfoClasses.add(javaClass);
        this.typeInfo.put(javaClass.getQualifiedName(), info);
        if (typeName != null && !"".equals(typeName)) {
            QName typeQName = new QName(packageNamespace.getNamespace(), typeName);
            boolean containsQName = this.typeQNames.contains(typeQName);
            if (containsQName) {
                throw JAXBException.nameCollision(typeQName.getNamespaceURI(), typeQName.getLocalPart());
            }
            this.typeQNames.add(typeQName);
        }
        if (this.helper.isAnnotationPresent(javaClass, XmlAccessorType.class)) {
            XmlAccessorType accessorType = (XmlAccessorType)this.helper.getAnnotation(javaClass, XmlAccessorType.class);
            info.setAccessType(accessorType.value());
        } else {
            info.setAccessType(packageNamespace.getAccessType());
        }
        info.setProperties(this.getPropertiesForClass(javaClass, info));
        XmlAccessorOrder order = null;
        if (this.helper.isAnnotationPresent(pack, XmlAccessorOrder.class)) {
            order = (XmlAccessorOrder)this.helper.getAnnotation(pack, XmlAccessorOrder.class);
        }
        if (this.helper.isAnnotationPresent(javaClass, XmlAccessorOrder.class)) {
            order = (XmlAccessorOrder)this.helper.getAnnotation(javaClass, XmlAccessorOrder.class);
        }
        if (order != null) {
            info.orderProperties(order.value());
        }
        if (this.shouldGenerateTypeInfo(superClass = javaClass.getSuperclass())) {
            this.createTypeInfoFor(superClass);
        }
        ArrayList<Property> properties = info.getPropertyList();
        for (Property property : properties) {
            JavaClass propertyType = property.getType();
            if (this.isCollectionType(property)) {
                JavaClass gType = property.getGenericType();
                if (gType != null) {
                    if (gType.hasActualTypeArguments()) {
                        propertyType = this.helper.getJavaClass(gType.getRawName());
                    } else if (gType instanceof JavaClass) {
                        propertyType = gType;
                    }
                }
            } else if (propertyType.isArray()) {
                propertyType = propertyType.getComponentType();
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlElement.class)) {
                XmlElement element = (XmlElement)this.helper.getAnnotation(property.getElement(), XmlElement.class);
                if (element.type() != XmlElement.DEFAULT.class) {
                    propertyType = this.helper.getJavaClass(element.type());
                    property.setType(propertyType);
                }
                if (!element.defaultValue().equals("\u0000")) {
                    property.setDefaultValue(element.defaultValue());
                }
                this.validateElementIsInPropOrder(info, property.getPropertyName());
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlID.class)) {
                if (!this.areEquals(property.getType(), String.class)) {
                    throw JAXBException.invalidId(property.getPropertyName());
                }
                if (info.isIDSet()) {
                    // empty if block
                }
                info.setIDProperty(property);
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlIDREF.class)) {
                this.xmlIdRefProps.add(property);
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlJavaTypeAdapter.class)) {
                property.setAdapterClass(((XmlJavaTypeAdapter)this.helper.getAnnotation(property.getElement(), XmlJavaTypeAdapter.class)).value());
            }
            if (!this.shouldGenerateTypeInfo(propertyType)) continue;
            this.createTypeInfoFor(propertyType);
        }
        if (info.getFactoryMethodName() == null && info.getObjectFactoryClassName() == null && (zeroArgConstructor = javaClass.getDeclaredConstructor(new JavaClass[0])) == null) {
            throw JAXBException.factoryMethodOrConstructorRequired(javaClass.getName());
        }
        this.validatePropOrderForInfo(info);
        return info;
    }

    public boolean shouldGenerateTypeInfo(JavaClass javaClass) {
        if (javaClass == null || javaClass.isPrimitive() || javaClass.isAnnotation() || javaClass.isInterface() || javaClass.isArray()) {
            return false;
        }
        if (this.userDefinedSchemaTypes.get(javaClass.getQualifiedName()) != null) {
            return false;
        }
        return !this.helper.isBuiltInJavaType(javaClass);
    }

    public ArrayList<Property> getPropertiesForClass(JavaClass cls, TypeInfo info) {
        ArrayList<Property> returnList = info.isTransient() ? this.getNoAccessTypePropertiesForClass(cls, info) : (info.getAccessType() == XmlAccessType.FIELD ? this.getFieldPropertiesForClass(cls, info, false) : (info.getAccessType() == XmlAccessType.PROPERTY ? this.getPropertyPropertiesForClass(cls, info, false) : (info.getAccessType() == XmlAccessType.PUBLIC_MEMBER ? this.getPublicMemberPropertiesForClass(cls, info) : this.getNoAccessTypePropertiesForClass(cls, info))));
        if (info.getXmlValueProperty() != null) {
            for (Property nextProp : returnList) {
                if (nextProp.equals(info.getXmlValueProperty()) || nextProp.isAttribute()) continue;
                throw JAXBException.propertyOrFieldShouldBeAnAttribute(nextProp.getPropertyName());
            }
        }
        return returnList;
    }

    public ArrayList<Property> getFieldPropertiesForClass(JavaClass cls, TypeInfo info, boolean onlyPublic) {
        ArrayList<Property> properties = new ArrayList<Property>();
        if (cls == null) {
            return properties;
        }
        boolean hasAnyAttribteProperty = false;
        for (JavaField nextField : cls.getDeclaredFields()) {
            if (!this.helper.isAnnotationPresent(nextField, XmlTransient.class)) {
                JavaClass ptype;
                int modifiers = nextField.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers) || (!Modifier.isPublic(nextField.getModifiers()) || !onlyPublic) && onlyPublic) continue;
                Property property = null;
                if (this.helper.isAnnotationPresent(nextField, XmlElements.class)) {
                    property = new ChoiceProperty(this.helper);
                    property.setElement(nextField);
                    XmlElements xmlElements = (XmlElements)this.helper.getAnnotation(property.getElement(), XmlElements.class);
                    XmlElement[] elements = xmlElements.value();
                    ArrayList<Property> choiceProperties = new ArrayList<Property>(elements.length);
                    this.validateElementIsInPropOrder(info, nextField.getName());
                    for (int i = 0; i < elements.length; ++i) {
                        NamespaceInfo namespaceInfo;
                        XmlElement next = elements[i];
                        Property choiceProp = new Property();
                        String name = next.name();
                        String namespace = next.namespace();
                        QName qName = null;
                        if (name.equals("##default")) {
                            name = nextField.getName();
                        }
                        qName = !namespace.equals("##default") ? new QName(namespace, name) : ((namespaceInfo = this.getNamespaceInfoForPackage(cls.getPackage())).isElementFormQualified() ? new QName(namespaceInfo.getNamespace(), name) : new QName(name));
                        choiceProp.setPropertyName(property.getPropertyName());
                        Class typeClass = next.type();
                        if (typeClass.equals(XmlElement.DEFAULT.class)) {
                            JavaClass type = nextField.getResolvedType();
                            if (this.isCollectionType(type)) {
                                if (type.hasActualTypeArguments()) {
                                    JavaClass itemType = (JavaClass)type.getActualTypeArguments().toArray()[0];
                                    choiceProp.setType(itemType);
                                } else {
                                    choiceProp.setType(this.helper.getJavaClass("java.lang.Object"));
                                }
                            } else {
                                choiceProp.setType(type);
                            }
                        } else {
                            choiceProp.setType(this.helper.getJavaClass(next.type()));
                        }
                        choiceProp.setSchemaName(qName);
                        choiceProp.setSchemaType(this.getSchemaTypeFor(this.helper.getJavaClass(next.type())));
                        choiceProp.setElement(property.getElement());
                        choiceProperties.add(choiceProp);
                    }
                    ((ChoiceProperty)property).setChoiceProperties(choiceProperties);
                } else if (this.helper.isAnnotationPresent(nextField, XmlAnyElement.class)) {
                    property = new AnyProperty(this.helper);
                    property.setElement(nextField);
                    XmlAnyElement anyElement = (XmlAnyElement)this.helper.getAnnotation(nextField, XmlAnyElement.class);
                    ((AnyProperty)property).setLax(anyElement.lax());
                    ((AnyProperty)property).setDomHandlerClass(anyElement.value());
                } else if (this.helper.isAnnotationPresent(nextField, XmlElementRef.class) || this.helper.isAnnotationPresent(nextField, XmlElementRefs.class)) {
                    XmlElementRef[] elementRefs;
                    property = new ReferenceProperty(this.helper);
                    property.setElement(nextField);
                    XmlElementRef ref = (XmlElementRef)this.helper.getAnnotation(nextField, XmlElementRef.class);
                    if (ref != null) {
                        elementRefs = new XmlElementRef[]{ref};
                    } else {
                        XmlElementRefs refs = (XmlElementRefs)this.helper.getAnnotation(nextField, XmlElementRefs.class);
                        elementRefs = refs.value();
                        info.setHasElementRefs(true);
                    }
                    this.validateElementIsInPropOrder(info, nextField.getName());
                    for (XmlElementRef nextRef : elementRefs) {
                        QName qname;
                        ElementDeclaration referencedElement;
                        JavaClass type = nextField.getResolvedType();
                        String typeName = type.getQualifiedName();
                        property.setType(type);
                        if (this.isCollectionType(property) && type.hasActualTypeArguments()) {
                            type = (JavaClass)type.getActualTypeArguments().toArray()[0];
                            typeName = type.getQualifiedName();
                        }
                        if (nextRef.type() != XmlElementRef.DEFAULT.class) {
                            typeName = this.helper.getJavaClass(nextRef.type()).getQualifiedName();
                        }
                        if ((referencedElement = this.xmlRootElements.get(typeName)) != null) {
                            this.addReferencedElement((ReferenceProperty)property, referencedElement);
                            continue;
                        }
                        String name = nextRef.name();
                        String namespace = nextRef.namespace();
                        if (namespace.equals("##default")) {
                            namespace = "";
                        }
                        if ((referencedElement = this.globalElements.get(qname = new QName(namespace, name))) != null) {
                            this.addReferencedElement((ReferenceProperty)property, referencedElement);
                            continue;
                        }
                        throw JAXBException.invalidElementRef(property.getPropertyName(), cls.getName());
                    }
                } else {
                    property = new Property(this.helper);
                    property.setElement(nextField);
                }
                if (this.helper.isAnnotationPresent(nextField, XmlMixed.class)) {
                    info.setMixed(true);
                    property.setMixedContent(true);
                }
                if (!this.helper.isAnnotationPresent(ptype = nextField.getResolvedType(), XmlTransient.class)) {
                    property.setType(ptype);
                } else {
                    for (JavaClass parent = ptype.getSuperclass(); parent != null; parent = parent.getSuperclass()) {
                        if (parent.getName().equals("java.lang.Object")) {
                            property.setType(parent);
                            break;
                        }
                        if (this.helper.isAnnotationPresent(parent, XmlTransient.class)) continue;
                        property.setType(parent);
                        break;
                    }
                }
                if (this.helper.isAnnotationPresent(property.getElement(), XmlJavaTypeAdapter.class)) {
                    XmlJavaTypeAdapter adapter = (XmlJavaTypeAdapter)this.helper.getAnnotation(property.getElement(), XmlJavaTypeAdapter.class);
                    property.setAdapterClass(adapter.value());
                } else if (info.getAdaptersByClass().get(ptype) != null) {
                    property.setAdapterClass(info.getAdapterClass(ptype));
                }
                if (property.hasAdapterClass()) {
                    ptype = property.getValueType();
                }
                property.setGenericType(this.helper.getGenericType(nextField));
                property.setPropertyName(nextField.getName());
                if (this.helper.isAnnotationPresent(property.getElement(), XmlAttachmentRef.class) && this.areEquals(ptype, JAVAX_ACTIVATION_DATAHANDLER)) {
                    property.setIsSwaAttachmentRef(true);
                    property.setSchemaType(XMLConstants.SWA_REF_QNAME);
                } else if (this.areEquals(ptype, JAVAX_ACTIVATION_DATAHANDLER) || this.areEquals(ptype, byte[].class) || this.areEquals(ptype, Byte[].class) || this.areEquals(ptype, Image.class) || this.areEquals(ptype, Source.class) || this.areEquals(ptype, JAVAX_MAIL_INTERNET_MIMEMULTIPART)) {
                    property.setIsMtomAttachment(true);
                    property.setSchemaType(XMLConstants.BASE_64_BINARY_QNAME);
                }
                if (this.helper.isAnnotationPresent(property.getElement(), XmlMimeType.class)) {
                    property.setMimeType(((XmlMimeType)this.helper.getAnnotation(property.getElement(), XmlMimeType.class)).value());
                }
                if (this.helper.isAnnotationPresent(property.getElement(), XmlSchemaType.class)) {
                    XmlSchemaType schemaType = (XmlSchemaType)this.helper.getAnnotation(property.getElement(), XmlSchemaType.class);
                    QName schemaTypeQname = new QName(schemaType.namespace(), schemaType.name());
                    property.setSchemaType(schemaTypeQname);
                }
                if (this.helper.isAnnotationPresent(property.getElement(), XmlAttribute.class)) {
                    property.setIsAttribute(true);
                    property.setIsRequired(((XmlAttribute)this.helper.getAnnotation(property.getElement(), XmlAttribute.class)).required());
                }
                if (this.helper.isAnnotationPresent(property.getElement(), XmlAnyAttribute.class)) {
                    if (hasAnyAttribteProperty) {
                        throw JAXBException.multipleAnyAttributeMapping(cls.getName());
                    }
                    if (!ptype.getName().equals("java.util.Map")) {
                        throw JAXBException.anyAttributeOnNonMap(property.getPropertyName());
                    }
                    property.setIsAttribute(true);
                    hasAnyAttribteProperty = true;
                }
                if (ptype.isPrimitive()) {
                    property.setIsRequired(true);
                } else if (this.helper.isAnnotationPresent(property.getElement(), XmlElement.class)) {
                    XmlElement xmlElement = (XmlElement)this.helper.getAnnotation(property.getElement(), XmlElement.class);
                    property.setIsRequired(xmlElement.required());
                    property.setNillable(xmlElement.nillable());
                    this.validateElementIsInPropOrder(info, property.getPropertyName());
                }
                if (this.helper.isAnnotationPresent(property.getElement(), XmlElementWrapper.class) && !this.isCollectionType(property) && !property.getType().isArray()) {
                    throw JAXBException.invalidElementWrapper(nextField.getName());
                }
                if (this.helper.isAnnotationPresent(property.getElement(), XmlList.class) && !this.isCollectionType(property) && !property.getType().isArray()) {
                    throw JAXBException.invalidList(nextField.getName());
                }
                if (this.helper.isAnnotationPresent(property.getElement(), XmlValue.class)) {
                    info.setXmlValueProperty(property);
                    this.validateXmlValueFieldOrProperty(cls, property, ptype, nextField.getName());
                }
                property.setSchemaName(this.getQNameForProperty(Introspector.decapitalize(nextField.getName()), nextField, this.getNamespaceInfoForPackage(cls.getPackage())));
                properties.add(property);
                continue;
            }
            List<String> propOrderList = Arrays.asList(info.getPropOrder());
            if (!propOrderList.contains(nextField.getName())) continue;
            throw JAXBException.transientInProporder(nextField.getName());
        }
        return properties;
    }

    protected boolean areEquals(JavaClass src, Class tgt) {
        if (src == null || tgt == null) {
            return false;
        }
        return src.getRawName().equals(tgt.getCanonicalName());
    }

    protected boolean areEquals(JavaClass src, String tgtCanonicalName) {
        if (src == null || tgtCanonicalName == null) {
            return false;
        }
        return src.getRawName().equals(tgtCanonicalName);
    }

    public ArrayList<Property> getPropertyPropertiesForClass(JavaClass cls, TypeInfo info, boolean onlyPublic) {
        ArrayList<Property> properties = new ArrayList<Property>();
        if (cls == null) {
            return properties;
        }
        ArrayList<JavaMethod> propertyMethods = new ArrayList<JavaMethod>();
        for (JavaMethod next : new ArrayList(cls.getDeclaredMethods())) {
            int modifiers;
            if (next.getName().startsWith("get") && next.getName().length() > 3 || next.getName().startsWith("is") && next.getName().length() > 2) {
                modifiers = next.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers) || (!onlyPublic || !Modifier.isPublic(next.getModifiers())) && onlyPublic) continue;
                propertyMethods.add(next);
                continue;
            }
            if (!next.getName().startsWith("set") || next.getName().length() <= 3 || Modifier.isStatic(modifiers = next.getModifiers()) || Modifier.isTransient(modifiers) || (!onlyPublic || !Modifier.isPublic(next.getModifiers())) && onlyPublic) continue;
            propertyMethods.add(next);
        }
        boolean hasAnyAttribteProperty = false;
        ArrayList<String> propertyNames = new ArrayList<String>();
        for (int i = 0; i < propertyMethods.size(); ++i) {
            XmlJavaTypeAdapter adapter;
            JavaMethod setMethod;
            JavaMethod getMethod;
            boolean isPropertyTransient = false;
            JavaMethod nextMethod = (JavaMethod)propertyMethods.get(i);
            String propertyName = "";
            JavaMethod propertyMethod = null;
            if (!nextMethod.getName().startsWith("set")) {
                if (nextMethod.getName().startsWith("get")) {
                    propertyName = nextMethod.getName().substring(3);
                } else if (nextMethod.getName().startsWith("is")) {
                    propertyName = nextMethod.getName().substring(2);
                }
                getMethod = nextMethod;
                String setMethodName = "set" + propertyName;
                propertyName = Introspector.decapitalize(propertyName);
                JavaClass[] paramTypes = new JavaClass[]{getMethod.getReturnType()};
                setMethod = cls.getDeclaredMethod(setMethodName, paramTypes);
                if (setMethod != null && !setMethod.getAnnotations().isEmpty()) {
                    if (!this.helper.isAnnotationPresent(setMethod, XmlTransient.class)) {
                        propertyMethod = setMethod;
                    } else {
                        isPropertyTransient = true;
                    }
                } else if (!this.helper.isAnnotationPresent(getMethod, XmlTransient.class)) {
                    propertyMethod = getMethod;
                } else {
                    isPropertyTransient = true;
                }
            } else {
                propertyName = nextMethod.getName().substring(3);
                setMethod = nextMethod;
                String getMethodName = "get" + propertyName;
                getMethod = cls.getDeclaredMethod(getMethodName, new JavaClass[0]);
                if (getMethod == null) {
                    getMethodName = "is" + propertyName;
                    getMethod = cls.getDeclaredMethod(getMethodName, new JavaClass[0]);
                }
                if (getMethod != null && !getMethod.getAnnotations().isEmpty()) {
                    if (!this.helper.isAnnotationPresent(getMethod, XmlTransient.class)) {
                        propertyMethod = getMethod;
                    } else {
                        isPropertyTransient = true;
                    }
                } else if (!this.helper.isAnnotationPresent(setMethod, XmlTransient.class)) {
                    propertyMethod = setMethod;
                } else {
                    isPropertyTransient = true;
                }
                propertyName = Introspector.decapitalize(propertyName);
            }
            if (propertyNames.contains(propertyName)) continue;
            propertyNames.add(propertyName);
            Property property = null;
            if (this.helper.isAnnotationPresent(propertyMethod, XmlElements.class)) {
                property = new ChoiceProperty(this.helper);
                this.validateElementIsInPropOrder(info, propertyName);
            } else if (this.helper.isAnnotationPresent(propertyMethod, XmlAnyElement.class)) {
                property = new AnyProperty(this.helper);
            } else if (this.helper.isAnnotationPresent(propertyMethod, XmlElementRef.class) || this.helper.isAnnotationPresent(propertyMethod, XmlElementRefs.class)) {
                property = new ReferenceProperty(this.helper);
                this.validateElementIsInPropOrder(info, propertyName);
            } else {
                property = new Property(this.helper);
            }
            property.setTransient(isPropertyTransient);
            if (this.helper.isAnnotationPresent(propertyMethod, XmlMixed.class)) {
                info.setMixed(true);
                property.setMixedContent(true);
            }
            property.setElement(propertyMethod);
            property.setSchemaName(this.getQNameForProperty(propertyName, propertyMethod, this.getNamespaceInfoForPackage(cls.getPackage())));
            property.setPropertyName(propertyName);
            JavaClass returnClass = null;
            returnClass = getMethod != null ? getMethod.getReturnType() : setMethod.getParameterTypes()[0];
            if (!this.helper.isAnnotationPresent(returnClass, XmlTransient.class)) {
                property.setType(returnClass);
            } else {
                for (JavaClass parent = returnClass.getSuperclass(); parent != null; parent = parent.getSuperclass()) {
                    if (parent.getName().equals("java.lang.Object")) {
                        property.setType(parent);
                        break;
                    }
                    if (this.helper.isAnnotationPresent(parent, XmlTransient.class)) continue;
                    property.setType(parent);
                    break;
                }
            }
            if (returnClass != null) {
                if (returnClass.hasActualTypeArguments()) {
                    ArrayList typeArgs = (ArrayList)returnClass.getActualTypeArguments();
                    JavaClass genericType = (JavaClass)typeArgs.get(0);
                    property.setGenericType(genericType);
                } else {
                    property.setGenericType(returnClass);
                }
            }
            if (getMethod != null) {
                property.setGetMethodName(getMethod.getName());
            }
            if (setMethod != null) {
                property.setSetMethodName(setMethod.getName());
            }
            property.setMethodProperty(true);
            JavaClass ptype = property.getType();
            if (this.helper.isAnnotationPresent(property.getElement(), XmlJavaTypeAdapter.class)) {
                adapter = (XmlJavaTypeAdapter)this.helper.getAnnotation(property.getElement(), XmlJavaTypeAdapter.class);
                property.setAdapterClass(adapter.value());
            } else if (info.getAdaptersByClass().get(ptype) != null) {
                property.setAdapterClass(info.getAdaptersByClass().get(ptype));
            }
            if (property.hasAdapterClass()) {
                ptype = property.getValueType();
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlSchemaType.class)) {
                XmlSchemaType schemaType = (XmlSchemaType)this.helper.getAnnotation(property.getElement(), XmlSchemaType.class);
                QName schemaTypeQname = new QName(schemaType.namespace(), schemaType.name());
                property.setSchemaType(schemaTypeQname);
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlAttachmentRef.class) && this.areEquals(ptype, JAVAX_ACTIVATION_DATAHANDLER)) {
                property.setIsSwaAttachmentRef(true);
                property.setSchemaType(XMLConstants.SWA_REF_QNAME);
            } else if (this.areEquals(ptype, JAVAX_ACTIVATION_DATAHANDLER) || this.areEquals(ptype, byte[].class) || this.areEquals(ptype, Byte[].class) || this.areEquals(ptype, Image.class) || this.areEquals(ptype, Source.class) || this.areEquals(ptype, JAVAX_MAIL_INTERNET_MIMEMULTIPART)) {
                property.setIsMtomAttachment(true);
                property.setSchemaType(XMLConstants.BASE_64_BINARY_QNAME);
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlMimeType.class)) {
                property.setMimeType(((XmlMimeType)this.helper.getAnnotation(property.getElement(), XmlMimeType.class)).value());
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlJavaTypeAdapter.class)) {
                adapter = (XmlJavaTypeAdapter)this.helper.getAnnotation(property.getElement(), XmlJavaTypeAdapter.class);
                property.setAdapterClass(adapter.value());
            } else if (info.getAdaptersByClass().get(ptype) != null) {
                property.setAdapterClass(info.getAdaptersByClass().get(ptype));
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlAttribute.class)) {
                property.setIsAttribute(true);
                property.setIsRequired(((XmlAttribute)this.helper.getAnnotation(property.getElement(), XmlAttribute.class)).required());
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlAnyAttribute.class)) {
                if (hasAnyAttribteProperty) {
                    throw JAXBException.multipleAnyAttributeMapping(cls.getName());
                }
                if (!ptype.getName().equals("java.util.Map")) {
                    throw JAXBException.anyAttributeOnNonMap(property.getPropertyName());
                }
                property.setIsAttribute(true);
                hasAnyAttribteProperty = true;
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlElements.class)) {
                XmlElements xmlElements = (XmlElements)this.helper.getAnnotation(property.getElement(), XmlElements.class);
                XmlElement[] elements = xmlElements.value();
                ArrayList<Property> choiceProperties = new ArrayList<Property>(elements.length);
                this.validateElementIsInPropOrder(info, propertyName);
                for (int j = 0; j < elements.length; ++j) {
                    XmlElement next = elements[j];
                    Property choiceProp = new Property();
                    String name = next.name();
                    String namespace = next.namespace();
                    QName qName = null;
                    if (name.equals("##defualt")) {
                        name = propertyName;
                    }
                    qName = !namespace.equals("##default") ? new QName(namespace, name) : new QName(name);
                    choiceProp.setPropertyName(property.getPropertyName());
                    choiceProp.setType(this.helper.getJavaClass(next.type()));
                    choiceProp.setSchemaName(qName);
                    choiceProp.setSchemaType(this.getSchemaTypeFor(this.helper.getJavaClass(next.type())));
                    choiceProp.setElement(property.getElement());
                    choiceProperties.add(choiceProp);
                }
                ((ChoiceProperty)property).setChoiceProperties(choiceProperties);
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlAnyElement.class)) {
                XmlAnyElement anyElement = (XmlAnyElement)this.helper.getAnnotation(property.getElement(), XmlAnyElement.class);
                ((AnyProperty)property).setDomHandlerClass(anyElement.value());
                ((AnyProperty)property).setLax(anyElement.lax());
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlElementRef.class) || this.helper.isAnnotationPresent(property.getElement(), XmlElementRefs.class)) {
                XmlElementRef[] elementRefs;
                XmlElementRef ref = (XmlElementRef)this.helper.getAnnotation(property.getElement(), XmlElementRef.class);
                if (ref != null) {
                    elementRefs = new XmlElementRef[]{ref};
                } else {
                    XmlElementRefs refs = (XmlElementRefs)this.helper.getAnnotation(property.getElement(), XmlElementRefs.class);
                    elementRefs = refs.value();
                    info.setHasElementRefs(true);
                }
                this.validateElementIsInPropOrder(info, propertyName);
                for (XmlElementRef nextRef : elementRefs) {
                    QName qname;
                    ElementDeclaration referencedElement;
                    JavaClass type = ptype;
                    String typeName = type.getQualifiedName();
                    property.setType(type);
                    if (this.isCollectionType(property) && type.hasActualTypeArguments()) {
                        type = (JavaClass)type.getActualTypeArguments().toArray()[0];
                        typeName = type.getQualifiedName();
                    }
                    if (nextRef.type() != XmlElementRef.DEFAULT.class) {
                        typeName = this.helper.getJavaClass(nextRef.type()).getQualifiedName();
                    }
                    if ((referencedElement = this.xmlRootElements.get(typeName)) != null) {
                        this.addReferencedElement((ReferenceProperty)property, referencedElement);
                        continue;
                    }
                    String name = nextRef.name();
                    String namespace = nextRef.namespace();
                    if (namespace.equals("##default")) {
                        namespace = "";
                    }
                    if ((referencedElement = this.globalElements.get(qname = new QName(namespace, name))) != null) {
                        this.addReferencedElement((ReferenceProperty)property, referencedElement);
                        continue;
                    }
                    throw JAXBException.invalidElementRef(property.getPropertyName(), cls.getName());
                }
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlElementWrapper.class) && !this.isCollectionType(property) && !property.getType().isArray()) {
                throw JAXBException.invalidElementWrapper(propertyName);
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlList.class) && !this.isCollectionType(property) && !property.getType().isArray()) {
                throw JAXBException.invalidList(propertyName);
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlValue.class)) {
                info.setXmlValueProperty(property);
                this.validateXmlValueFieldOrProperty(cls, property, ptype, propertyName);
            }
            if (!this.helper.isAnnotationPresent(property.getElement(), XmlTransient.class)) {
                properties.add(property);
            } else {
                List<String> propOrderList = Arrays.asList(info.getPropOrder());
                if (propOrderList.contains(propertyName)) {
                    throw JAXBException.transientInProporder(propertyName);
                }
                property.setTransient(true);
            }
            if (ptype.isPrimitive()) {
                property.setIsRequired(true);
                continue;
            }
            if (!this.helper.isAnnotationPresent(property.getElement(), XmlElement.class)) continue;
            XmlElement element = (XmlElement)this.helper.getAnnotation(property.getElement(), XmlElement.class);
            property.setIsRequired(element.required());
            property.setNillable(element.nillable());
            this.validateElementIsInPropOrder(info, propertyName);
        }
        Collections.sort(properties, new PropertyComparitor());
        return properties;
    }

    public ArrayList getPublicMemberPropertiesForClass(JavaClass cls, TypeInfo info) {
        ArrayList<Property> fieldProperties = this.getFieldPropertiesForClass(cls, info, false);
        ArrayList<Property> methodProperties = this.getPropertyPropertiesForClass(cls, info, false);
        ArrayList<Property> publicFieldProperties = new ArrayList<Property>();
        ArrayList<Property> publicMethodProperties = new ArrayList<Property>();
        for (Property next : fieldProperties) {
            if (Modifier.isPublic(((JavaField)next.getElement()).getModifiers())) {
                publicFieldProperties.add(next);
                continue;
            }
            if (!this.hasJAXBAnnotations(next.getElement())) continue;
            publicFieldProperties.add(next);
        }
        for (Property next : methodProperties) {
            if (next.getElement() == null) continue;
            if (Modifier.isPublic(((JavaMethod)next.getElement()).getModifiers())) {
                publicMethodProperties.add(next);
                continue;
            }
            if (!this.hasJAXBAnnotations(next.getElement())) continue;
            publicMethodProperties.add(next);
        }
        if (publicFieldProperties.size() >= 0 && publicMethodProperties.size() == 0) {
            return publicFieldProperties;
        }
        if (publicMethodProperties.size() > 0 && publicFieldProperties.size() == 0) {
            return publicMethodProperties;
        }
        HashMap fieldPropertyMap = this.getPropertyMapFromArrayList(publicFieldProperties);
        for (int i = 0; i < publicMethodProperties.size(); ++i) {
            Property next = (Property)publicMethodProperties.get(i);
            if (fieldPropertyMap.get(next.getPropertyName()) != null) continue;
            publicFieldProperties.add(next);
        }
        return publicFieldProperties;
    }

    public HashMap getPropertyMapFromArrayList(ArrayList<Property> props) {
        HashMap<String, Property> propMap = new HashMap<String, Property>(props.size());
        for (Property next : props) {
            propMap.put(next.getPropertyName(), next);
        }
        return propMap;
    }

    public ArrayList getNoAccessTypePropertiesForClass(JavaClass cls, TypeInfo info) {
        JavaHasAnnotations elem;
        Property next;
        int i;
        ArrayList<Property> list = new ArrayList<Property>();
        if (cls == null) {
            return list;
        }
        ArrayList<Property> fieldProperties = this.getFieldPropertiesForClass(cls, info, false);
        ArrayList<Property> methodProperties = this.getPropertyPropertiesForClass(cls, info, false);
        for (i = 0; i < fieldProperties.size(); ++i) {
            next = fieldProperties.get(i);
            elem = next.getElement();
            if (!this.hasJAXBAnnotations(elem)) continue;
            list.add(next);
        }
        for (i = 0; i < methodProperties.size(); ++i) {
            next = methodProperties.get(i);
            elem = next.getElement();
            if (!this.hasJAXBAnnotations(elem)) continue;
            list.add(next);
        }
        return list;
    }

    public void processSchemaType(XmlSchemaType type) {
        String schemaTypeName = type.name();
        Class javaType = type.type();
        if (javaType == null) {
            return;
        }
        JavaClass jClass = this.helper.getJavaClass(javaType);
        if (jClass == null) {
            return;
        }
        QName typeQName = new QName(type.namespace(), schemaTypeName);
        this.userDefinedSchemaTypes.put(jClass.getQualifiedName(), typeQName);
    }

    public void addEnumTypeInfo(JavaClass javaClass, EnumTypeInfo info) {
        if (javaClass == null) {
            return;
        }
        info.setClassName(javaClass.getQualifiedName());
        Class restrictionClass = String.class;
        if (this.helper.isAnnotationPresent(javaClass, XmlEnum.class)) {
            XmlEnum xmlEnum = (XmlEnum)this.helper.getAnnotation(javaClass, XmlEnum.class);
            restrictionClass = xmlEnum.value();
        }
        QName restrictionBase = this.getSchemaTypeFor(this.helper.getJavaClass(restrictionClass));
        info.setRestrictionBase(restrictionBase);
        this.typeInfoClasses.add(javaClass);
        this.typeInfo.put(javaClass.getQualifiedName(), info);
        for (JavaField field : javaClass.getDeclaredFields()) {
            if (!field.isEnumConstant()) continue;
            String fieldValue = field.getName();
            if (this.helper.isAnnotationPresent(field, XmlEnumValue.class)) {
                XmlEnumValue xmlEnumValue = (XmlEnumValue)this.helper.getAnnotation(field, XmlEnumValue.class);
                fieldValue = xmlEnumValue.value();
            }
            info.addObjectToFieldValuePair(field.getName(), fieldValue);
        }
    }

    private String decapitalize(String javaName) {
        int i;
        char[] name = javaName.toCharArray();
        for (i = 0; i < name.length && Character.isUpperCase(name[i]); ++i) {
        }
        if (i > 0) {
            name[0] = Character.toLowerCase(name[0]);
            for (int j = 1; j < i - 1; ++j) {
                name[j] = Character.toLowerCase(name[j]);
            }
            return new String(name);
        }
        return javaName;
    }

    public String getSchemaTypeNameForClassName(String className) {
        String typeName = "";
        typeName = className.indexOf(36) != -1 ? this.decapitalize(className.substring(className.lastIndexOf(36) + 1)) : this.decapitalize(className.substring(className.lastIndexOf(46) + 1));
        boolean inBreak = false;
        StringBuffer toReturn = new StringBuffer(typeName.length());
        for (int i = 0; i < typeName.length(); ++i) {
            char next = typeName.charAt(i);
            if (Character.isDigit(next)) {
                if (!inBreak) {
                    inBreak = true;
                }
                toReturn.append(next);
                continue;
            }
            if (inBreak) {
                toReturn.append(Character.toUpperCase(next));
                continue;
            }
            toReturn.append(next);
        }
        return toReturn.toString();
    }

    public QName getSchemaTypeOrNullFor(JavaClass javaClass) {
        if (javaClass == null) {
            return null;
        }
        QName schemaType = this.userDefinedSchemaTypes.get(javaClass.getQualifiedName());
        if (schemaType == null) {
            schemaType = (QName)this.helper.getXMLToJavaTypeMap().get(javaClass.getRawName());
        }
        return schemaType;
    }

    public QName getSchemaTypeFor(JavaClass javaClass) {
        QName schemaType = this.getSchemaTypeOrNullFor(javaClass);
        if (schemaType == null) {
            return XMLConstants.ANY_SIMPLE_TYPE_QNAME;
        }
        return schemaType;
    }

    public boolean isCollectionType(Property field) {
        return this.isCollectionType(field.getType());
    }

    public boolean isCollectionType(JavaClass type) {
        return this.helper.getJavaClass(Collection.class).isAssignableFrom(type) || this.helper.getJavaClass(List.class).isAssignableFrom(type) || this.helper.getJavaClass(Set.class).isAssignableFrom(type);
    }

    public NamespaceInfo processNamespaceInformation(XmlSchema xmlSchema) {
        NamespaceInfo info = new NamespaceInfo();
        info.setNamespaceResolver(new NamespaceResolver());
        String packageNamespace = null;
        if (xmlSchema != null) {
            String namespaceMapping = xmlSchema.namespace();
            if (!namespaceMapping.equals("") && !namespaceMapping.equals("##default")) {
                packageNamespace = namespaceMapping;
            }
            info.setNamespace(packageNamespace);
            XmlNs[] xmlns = xmlSchema.xmlns();
            for (int i = 0; i < xmlns.length; ++i) {
                XmlNs next = xmlns[i];
                info.getNamespaceResolver().put(next.prefix(), next.namespaceURI());
            }
            info.setAttributeFormQualified(xmlSchema.attributeFormDefault() == XmlNsForm.QUALIFIED);
            info.setElementFormQualified(xmlSchema.elementFormDefault() == XmlNsForm.QUALIFIED);
            try {
                Method locationMethod = PrivilegedAccessHelper.getDeclaredMethod(XmlSchema.class, "location", new Class[0]);
                String location = (String)PrivilegedAccessHelper.invokeMethod(locationMethod, xmlSchema, new Object[0]);
                if (location != null) {
                    if (location.equals("##generate")) {
                        location = null;
                    } else if (location.equals("")) {
                        location = null;
                    }
                }
                info.setLocation(location);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return info;
    }

    public HashMap<String, TypeInfo> getTypeInfo() {
        return this.typeInfo;
    }

    public ArrayList<JavaClass> getTypeInfoClasses() {
        return this.typeInfoClasses;
    }

    public HashMap getUserDefinedSchemaTypes() {
        return this.userDefinedSchemaTypes;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.namespaceResolver;
    }

    public String getSchemaTypeNameFor(JavaClass javaClass, XmlType xmlType) {
        String typeName = "";
        if (javaClass == null) {
            return typeName;
        }
        if (this.helper.isAnnotationPresent(javaClass, XmlType.class)) {
            XmlType typeAnnotation = (XmlType)this.helper.getAnnotation(javaClass, XmlType.class);
            typeName = typeAnnotation.name();
            if (typeName.equals("#default")) {
                typeName = this.getSchemaTypeNameForClassName(javaClass.getName());
            }
        } else {
            typeName = this.getSchemaTypeNameForClassName(javaClass.getName());
        }
        return typeName;
    }

    public QName getQNameForProperty(String defaultName, JavaHasAnnotations element, NamespaceInfo namespaceInfo) {
        String name = "##default";
        String namespace = "##default";
        QName qName = null;
        if (this.helper.isAnnotationPresent(element, XmlAttribute.class)) {
            XmlAttribute xmlAttribute = (XmlAttribute)this.helper.getAnnotation(element, XmlAttribute.class);
            name = xmlAttribute.name();
            namespace = xmlAttribute.namespace();
            if (name.equals("##default")) {
                name = defaultName;
            }
            qName = !namespace.equals("##default") ? new QName(namespace, name) : (namespaceInfo.isAttributeFormQualified() ? new QName(namespaceInfo.getNamespace(), name) : new QName(name));
        } else {
            if (this.helper.isAnnotationPresent(element, XmlElement.class)) {
                XmlElement xmlElement = (XmlElement)this.helper.getAnnotation(element, XmlElement.class);
                name = xmlElement.name();
                namespace = xmlElement.namespace();
            }
            if (name.equals("##default")) {
                name = defaultName;
            }
            qName = !namespace.equals("##default") ? new QName(namespace, name) : (namespaceInfo.isElementFormQualified() ? new QName(namespaceInfo.getNamespace(), name) : new QName(name));
        }
        return qName;
    }

    public HashMap<String, NamespaceInfo> getPackageToNamespaceMappings() {
        return this.packageToNamespaceMappings;
    }

    public NamespaceInfo getNamespaceInfoForPackage(JavaPackage pack) {
        NamespaceInfo packageNamespace = this.packageToNamespaceMappings.get(pack.getQualifiedName());
        if (packageNamespace == null) {
            XmlSchema xmlSchema = (XmlSchema)this.helper.getAnnotation(pack, XmlSchema.class);
            packageNamespace = this.processNamespaceInformation(xmlSchema);
            if (packageNamespace.getNamespace() == null) {
                packageNamespace.setNamespace("");
            }
            if (this.helper.isAnnotationPresent(pack, XmlAccessorType.class)) {
                XmlAccessorType xmlAccessorType = (XmlAccessorType)this.helper.getAnnotation(pack, XmlAccessorType.class);
                packageNamespace.setAccessType(xmlAccessorType.value());
            }
            this.packageToNamespaceMappings.put(pack.getQualifiedName(), packageNamespace);
        }
        return packageNamespace;
    }

    private void checkForCallbackMethods() {
        for (JavaClass next : this.typeInfoClasses) {
            if (next == null) continue;
            JavaClass unmarshallerCls = this.helper.getJavaClass(Unmarshaller.class);
            JavaClass marshallerCls = this.helper.getJavaClass(Marshaller.class);
            JavaClass objectCls = this.helper.getJavaClass(Object.class);
            JavaClass[] unmarshalParams = new JavaClass[]{unmarshallerCls, objectCls};
            JavaClass[] marshalParams = new JavaClass[]{marshallerCls};
            UnmarshalCallback unmarshalCallback = null;
            MarshalCallback marshalCallback = null;
            if (next.getMethod("beforeUnmarshal", unmarshalParams) != null) {
                unmarshalCallback = new UnmarshalCallback();
                unmarshalCallback.setDomainClassName(next.getQualifiedName());
                unmarshalCallback.setHasBeforeUnmarshalCallback();
            }
            if (next.getMethod("afterUnmarshal", unmarshalParams) != null) {
                if (unmarshalCallback == null) {
                    unmarshalCallback = new UnmarshalCallback();
                    unmarshalCallback.setDomainClassName(next.getQualifiedName());
                }
                unmarshalCallback.setHasAfterUnmarshalCallback();
            }
            if (unmarshalCallback != null) {
                if (this.unmarshalCallbacks == null) {
                    this.unmarshalCallbacks = new HashMap();
                }
                this.unmarshalCallbacks.put(next.getQualifiedName(), unmarshalCallback);
            }
            if (next.getMethod("beforeMarshal", marshalParams) != null) {
                marshalCallback = new MarshalCallback();
                marshalCallback.setDomainClassName(next.getQualifiedName());
                marshalCallback.setHasBeforeMarshalCallback();
            }
            if (next.getMethod("afterMarshal", marshalParams) != null) {
                if (marshalCallback == null) {
                    marshalCallback = new MarshalCallback();
                    marshalCallback.setDomainClassName(next.getQualifiedName());
                }
                marshalCallback.setHasAfterMarshalCallback();
            }
            if (marshalCallback == null) continue;
            if (this.marshalCallbacks == null) {
                this.marshalCallbacks = new HashMap();
            }
            this.marshalCallbacks.put(next.getQualifiedName(), marshalCallback);
        }
    }

    public HashMap<String, MarshalCallback> getMarshalCallbacks() {
        return this.marshalCallbacks;
    }

    public HashMap<String, UnmarshalCallback> getUnmarshalCallbacks() {
        return this.unmarshalCallbacks;
    }

    public JavaClass[] processObjectFactory(JavaClass objectFactoryClass, ArrayList<JavaClass> classes) {
        Collection methods = objectFactoryClass.getDeclaredMethods();
        Iterator methodsIter = methods.iterator();
        NamespaceInfo namespaceInfo = this.getNamespaceInfoForPackage(objectFactoryClass.getPackage());
        while (methodsIter.hasNext()) {
            JavaMethod next = (JavaMethod)methodsIter.next();
            if (!next.getName().startsWith("create")) continue;
            JavaClass type = next.getReturnType();
            if (type.getName().equals("javax.xml.bind.JAXBElement")) {
                type = (JavaClass)next.getReturnType().getActualTypeArguments().toArray()[0];
            } else {
                this.factoryMethods.put(next.getReturnType().getRawName(), next);
            }
            if (this.helper.isAnnotationPresent(next, XmlElementDecl.class)) {
                XmlElementDecl elementDecl = (XmlElementDecl)this.helper.getAnnotation(next, XmlElementDecl.class);
                String url = elementDecl.namespace();
                if ("##default".equals(url)) {
                    url = namespaceInfo.getNamespace();
                }
                String localName = elementDecl.name();
                QName qname = new QName(url, localName);
                if (this.globalElements == null) {
                    this.globalElements = new HashMap();
                }
                boolean isList = false;
                if ("java.util.List".equals(type.getName())) {
                    isList = true;
                    if (type.hasActualTypeArguments()) {
                        type = (JavaClass)type.getActualTypeArguments().toArray()[0];
                    }
                }
                ElementDeclaration declaration = new ElementDeclaration(qname, type, type.getQualifiedName(), isList, elementDecl.scope());
                if (!elementDecl.substitutionHeadName().equals("")) {
                    String subHeadLocal = elementDecl.substitutionHeadName();
                    String subHeadNamespace = elementDecl.substitutionHeadNamespace();
                    if (subHeadNamespace.equals("##default")) {
                        subHeadNamespace = namespaceInfo.getNamespace();
                    }
                    declaration.setSubstitutionHead(new QName(subHeadNamespace, subHeadLocal));
                }
                if (this.helper.isAnnotationPresent(next, XmlJavaTypeAdapter.class)) {
                    XmlJavaTypeAdapter typeAdapter = (XmlJavaTypeAdapter)this.helper.getAnnotation(next, XmlJavaTypeAdapter.class);
                    Class typeAdapterClass = typeAdapter.value();
                    declaration.setJavaTypeAdapterClass(typeAdapterClass);
                    Method[] tacMethods = typeAdapterClass.getMethods();
                    Class<?> declJavaType = null;
                    for (int i = 0; i < tacMethods.length; ++i) {
                        Method method = tacMethods[i];
                        if (!method.getName().equals("marshal")) continue;
                        declJavaType = method.getReturnType();
                        break;
                    }
                    declaration.setJavaType(this.helper.getJavaClass(declJavaType));
                    declaration.setAdaptedJavaType(type);
                }
                this.globalElements.put(qname, declaration);
            }
            if (this.helper.isBuiltInJavaType(type) || classes.contains(type)) continue;
            classes.add(type);
        }
        if (classes.size() > 0) {
            return classes.toArray(new JavaClass[classes.size()]);
        }
        return new JavaClass[0];
    }

    public HashMap<QName, ElementDeclaration> getGlobalElements() {
        return this.globalElements;
    }

    public void updateGlobalElements(ArrayList<JavaClass> classesToProcess) {
        for (JavaClass javaClass : classesToProcess) {
            int idx;
            char ch;
            if (this.helper.isAnnotationPresent(javaClass, XmlTransient.class) || !this.helper.isAnnotationPresent(javaClass, XmlRootElement.class)) continue;
            XmlRootElement rootElemAnnotation = (XmlRootElement)this.helper.getAnnotation(javaClass, XmlRootElement.class);
            JavaPackage pack = javaClass.getPackage();
            NamespaceInfo namespaceInfo = this.getNamespaceInfoForPackage(pack);
            String elementName = rootElemAnnotation.name();
            if ((elementName.equals("##default") || elementName.equals("")) && (elementName = javaClass.getName().indexOf("$") != -1 ? Introspector.decapitalize(javaClass.getName().substring(javaClass.getName().lastIndexOf(36) + 1)) : Introspector.decapitalize(javaClass.getName().substring(javaClass.getName().lastIndexOf(46) + 1))).length() >= 3 && Character.isDigit(ch = elementName.charAt((idx = elementName.length() - 1) - 1))) {
                char lastCh = Character.toUpperCase(elementName.charAt(idx));
                elementName = elementName.substring(0, idx) + lastCh;
            }
            String rootNamespace = rootElemAnnotation.namespace();
            QName rootElemName = null;
            rootElemName = rootNamespace.equals("##default") ? (namespaceInfo == null ? new QName(elementName) : new QName(namespaceInfo.getNamespace(), elementName)) : new QName(rootNamespace, elementName);
            ElementDeclaration declaration = new ElementDeclaration(rootElemName, javaClass, javaClass.getQualifiedName(), false);
            declaration.setIsXmlRootElement(true);
            if (this.globalElements == null) {
                this.globalElements = new HashMap();
            }
            this.globalElements.put(rootElemName, declaration);
            this.xmlRootElements.put(javaClass.getQualifiedName(), declaration);
        }
        if (this.globalElements == null) {
            return;
        }
        for (QName next : this.globalElements.keySet()) {
            ElementDeclaration nextDeclaration = this.globalElements.get(next);
            if (nextDeclaration.getSubstitutionHead() == null) continue;
            ElementDeclaration rootDeclaration = this.globalElements.get(nextDeclaration.getSubstitutionHead());
            rootDeclaration.addSubstitutableElement(nextDeclaration);
        }
    }

    private void addReferencedElement(ReferenceProperty property, ElementDeclaration referencedElement) {
        property.addReferencedElement(referencedElement);
        if (referencedElement.getSubstitutableElements() != null && referencedElement.getSubstitutableElements().size() > 0) {
            for (ElementDeclaration substitutable : referencedElement.getSubstitutableElements()) {
                this.addReferencedElement(property, substitutable);
            }
        }
    }

    private boolean hasJAXBAnnotations(JavaHasAnnotations elem) {
        return this.helper.isAnnotationPresent(elem, XmlElement.class) || this.helper.isAnnotationPresent(elem, XmlAttribute.class) || this.helper.isAnnotationPresent(elem, XmlAnyElement.class) || this.helper.isAnnotationPresent(elem, XmlAnyAttribute.class) || this.helper.isAnnotationPresent(elem, XmlValue.class) || this.helper.isAnnotationPresent(elem, XmlElements.class) || this.helper.isAnnotationPresent(elem, XmlElementRef.class) || this.helper.isAnnotationPresent(elem, XmlElementRefs.class) || this.helper.isAnnotationPresent(elem, XmlID.class) || this.helper.isAnnotationPresent(elem, XmlSchemaType.class) || this.helper.isAnnotationPresent(elem, XmlElementWrapper.class) || this.helper.isAnnotationPresent(elem, XmlID.class) || this.helper.isAnnotationPresent(elem, XmlList.class) || this.helper.isAnnotationPresent(elem, XmlMimeType.class) || this.helper.isAnnotationPresent(elem, XmlIDREF.class);
    }

    private void validateElementIsInPropOrder(TypeInfo info, String name) {
        if (info.isTransient()) {
            return;
        }
        String[] propOrder = info.getPropOrder();
        if (propOrder.length > 0) {
            if (propOrder.length == 1 && propOrder[0].equals("")) {
                return;
            }
            List<String> propOrderList = Arrays.asList(info.getPropOrder());
            if (!propOrderList.contains(name)) {
                throw JAXBException.missingPropertyInPropOrder(name);
            }
        }
    }

    private void validatePropOrderForInfo(TypeInfo info) {
        if (info.isTransient()) {
            return;
        }
        String[] propOrder = info.getPropOrder();
        int propOrderLength = propOrder.length;
        if (propOrderLength > 0) {
            for (int i = 1; i < propOrderLength; ++i) {
                String nextPropName = propOrder[i];
                if (nextPropName.equals("") || info.getPropertyNames().contains(nextPropName)) continue;
                throw JAXBException.nonExistentPropertyInPropOrder(nextPropName);
            }
        }
    }

    private void validateXmlValueFieldOrProperty(JavaClass cls, Property property, JavaClass ptype, String propName) {
        for (JavaClass parent = cls.getSuperclass(); parent != null && !parent.getQualifiedName().equals("java.lang.Object"); parent = parent.getSuperclass()) {
            TypeInfo parentTypeInfo = this.typeInfo.get(parent.getQualifiedName());
            if (parentTypeInfo == null && this.shouldGenerateTypeInfo(parent)) {
                parentTypeInfo = this.createTypeInfoFor(parent);
            }
            if (parentTypeInfo == null) continue;
            throw JAXBException.propertyOrFieldCannotBeXmlValue(propName);
        }
        JavaClass theClass = this.isCollectionType(property) ? property.getGenericType() : (ptype.isArray() ? ptype.getComponentType() : ptype);
        QName schemaQName = this.getSchemaTypeOrNullFor(theClass);
        if (schemaQName == null) {
            String rawName = theClass.getRawName();
            TypeInfo refInfo = this.typeInfo.get(rawName);
            if (refInfo == null && this.shouldGenerateTypeInfo(theClass)) {
                refInfo = this.createTypeInfoFor(theClass);
            }
            if (refInfo != null && refInfo.getXmlValueProperty() == null) {
                throw JAXBException.invalidTypeForXmlValueField(propName);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PropertyComparitor
    implements Comparator<Property> {
        PropertyComparitor() {
        }

        @Override
        public int compare(Property p1, Property p2) {
            return p1.getPropertyName().compareTo(p2.getPropertyName());
        }
    }
}

